<?php
/* @var $this ClaimController */
/* @var $model Claim */
/* @var $form CActiveForm */
?>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'claim-form',
	'enableAjaxValidation'=>false,
        'enableClientValidation'=>true,
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>
       
	<?php echo $form->errorSummary($model); ?>
 <div class="first-tab">
     <div class="left">
          <h2>General Information</h2>
	<div class="row">
		<?php echo $form->labelEx($model,'file_no'); ?>
		<?php 
                    if(isset($model->file_no))
                        echo $form->textField($model,'file_no',array('size'=>30,'maxlength'=>30,'readonly'=>'readonly')); 
                    else
                        echo $form->textField($model,'file_no',array('size'=>30,'maxlength'=>30,'value'=>"Pending Claim Submission",'readonly'=>'readonly')); ?>
		<?php echo $form->error($model,'file_no'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'claim_no'); ?>
		<?php echo $form->textField($model,'claim_no',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'claim_no'); ?>
	</div>

	
	
	<div class="row">
		<?php //echo $form->labelEx($model,'created_by'); ?>
		<?php echo $form->hiddenField($model,'created_by',array('value'=>Yii::app()->user->id)); ?>
		<?php echo $form->error($model,'created_by'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'policy_no'); ?>
		<?php echo $form->textField($model,'policy_no',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'policy_no'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'policy_limit'); ?>
		<?php echo $form->textField($model,'policy_limit',array('size'=>30,'maxlength'=>16,'class'=>'deconly')); ?>
		<?php echo $form->error($model,'policy_limit'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'deducitible_waived'); ?>
		<?php echo $form->checkbox($model,'deducitible_waived'); ?>
		<?php echo $form->error($model,'deducitible_waived'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'deducitible'); ?>
		<?php echo $form->textField($model,'deducitible',array('size'=>30)); ?>
		<?php echo $form->error($model,'deducitible'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'claim_creation_date'); ?>
		<?php echo $form->textField($model,'claim_creation_date',array('class'=>'date-pick','value'=>date('Y-m-d'),'size'=>30)); ?>
		<?php echo $form->error($model,'claim_creation_date'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'date_of_loss'); ?>
		<?php echo $form->textField($model,'date_of_loss',array('class'=>'date-pick','size'=>30)); ?>
		<?php echo $form->error($model,'date_of_loss'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'assignment_type'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'assignment_type',array('empty'=>'Select','onchange'=>'showother(this.id,"other_assignment_type","Claim_other_assignment_type")')) ?>
		<?php echo $form->error($model,'assignment_type'); ?>
	</div>

	<div class="row" id="other_assignment_type" style="display:none;">
		<?php echo $form->labelEx($model,'other_assignment_type'); ?>
		<?php echo $form->textField($model,'other_assignment_type',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'other_assignment_type'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'loss_type'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'loss_type',array('empty'=>'Select','onchange'=>'showother(this.id,"other_loss_type","Claim_other_loss_type")')); ?>
		<?php echo $form->error($model,'loss_type'); ?>
	</div>

        <div class="row" id="other_loss_type" style="display:none;">
		<?php echo $form->labelEx($model,'other_loss_type'); ?>
		<?php echo $form->textField($model,'other_loss_type',array('size'=>30,'maxlength'=>500)); ?>
		<?php echo $form->error($model,'other_loss_type'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'claim_report_date'); ?>
		<?php echo $form->textField($model,'claim_report_date',array('class'=>'date-pick','size'=>30)); ?>
		<?php echo $form->error($model,'claim_report_date'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'whoose_claim'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'whoose_claim',array('empty'=>'Select')); ?>
		<?php echo $form->error($model,'whoose_claim'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'coverage_verified'); ?>
		<?php echo $form->checkBox($model,'coverage_verified', array('value'=>1, 'uncheckValue'=>0)) ?>
		<?php echo $form->error($model,'coverage_verified'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'type_of_coverage'); ?>
		<?php echo $form->textField($model,'type_of_coverage',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'type_of_coverage'); ?>
	</div>
	 <h2>Delivery Method and Status</h2>
		<div class="row">
		<?php echo $form->labelEx($model,'delivery_method'); ?>
		<?php echo ZHtml::enumDropDownList($model,'delivery_method',array('maxlength'=>60,'empty'=>'select')); ?>
		<?php echo $form->error($model,' 	delivery_method'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'status_interval'); ?>
		<?php echo ZHtml::enumDropDownList($model,'status_interval',array('maxlength'=>60,'empty'=>'select')); ?>
		<?php echo $form->error($model,'status_interval'); ?>
	</div>
       <div id="owner-tab">
       <h2>Owner Information</h2>   
          <div class="row">
		<?php echo $form->labelEx($model,'o_first_name'); ?>
		<?php echo $form->textField($model,'o_first_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'o_first_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_last_name'); ?>
		<?php echo $form->textField($model,'o_last_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'o_last_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_address1'); ?>
		<?php echo $form->textArea($model,'o_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'o_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_address2'); ?>
		<?php echo $form->textArea($model,'o_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'o_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_city'); ?>
		<?php echo $form->textField($model,'o_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'o_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'o_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                     ?>
		<?php echo $form->error($model,'o_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_zip'); ?>
		<?php echo $form->textField($model,'o_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'o_zip'); ?>
            <div id="Claim_o_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_home'); ?>
		<?php echo $form->textField($model,'o_home',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'o_home'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_work'); ?>
		<?php echo $form->textField($model,'o_work',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'o_work'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_cell'); ?>
		<?php echo $form->textField($model,'o_cell',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'o_cell'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_fax'); ?>
		<?php echo $form->textField($model,'o_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'o_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'o_email'); ?>
		<?php echo $form->textField($model,'o_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'o_email'); ?>
	</div>
       </div>
     </div>
     <div class="right">
         
          <h2>Ordered By</h2>
        <div class="row">
		<?php //echo $form->labelEx($cmp,'id'); ?>
            <?php echo $form->hiddenField($cmp,'type_id',array('value'=>1)); ?>
		<label class="required" >Insurance Company <span class="required">*</span></label>
		<?php //
                $ty=CHtml::listData($cmpp,'id','name');
                echo $form->dropdownList($model,'insurance_company',$ty,array('class'=>'span2','empty'=>'Select','onblur'=>'resetdropdown(this.id,"Claim_branch_id")',
                    'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Company/getBranch'),
				  
                                  //
                                'update'=>'#Claim_branch_id', 
			)
                    ));  ?>
		<?php echo $form->error($model,'insurance_company'); ?>
	</div>
          <div class="row">
		<?php //echo $form->labelEx($model,'branch_id'); ?>
            <label class="required" >Company Branches <span class="required">*</span></label>
		<?php //echo $form->textField($model,'branch_id');
			
                if(isset($model->branch_id))
                {
                    $br=CHtml::listData($branch,'id','branch_name');
                    echo $form->dropDownList($model,'branch_id',$br,array('empty'=>'Select','onchange'=>'getbranchdetail(this.id),showother(this.id,"other_loss_type","Claim_other_loss_type")'));
                }
                else {
                        echo $form->dropDownList($model,'branch_id',array(),array('empty'=>'Select','onchange'=>'getbranchdetail(this.id),showother(this.id,"other_branch","Claim_other_branch")'));
                }
			
		 ?>
		<?php echo $form->error($model,'branch_id'); ?>
	</div>

	  <div class="row" id="other_branch" style="display:none;">
		<?php echo $form->labelEx($model,'other_branch'); ?>
		<?php echo $form->textField($model,'other_branch',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'other_branch'); ?>
	</div>
          <div class="row">
		<?php echo $form->labelEx($model,'ob_address1'); ?>
		<?php echo $form->textArea($model,'ob_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'ob_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_address2'); ?>
		<?php echo $form->textArea($model,'ob_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'ob_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_city'); ?>
		<?php echo $form->textField($model,'ob_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'ob_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'ob_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                 
                ?>
		<?php echo $form->error($model,'ob_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_zip'); ?>
		<?php echo $form->textField($model,'ob_zip'); ?>
		<?php echo $form->error($model,'ob_zip'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adjustor_id'); ?>
		<?php //echo $form->textField($model,'adjustor_id'); 
                $ty=array();//CHtml::listData($usr,'id','first_name');
                echo $form->dropdownList($model,'adjustor_id',$ty,array('class'=>'span2','empty'=>'Select','onchange'=>'Getadjusterdetail(this.id),showother(this.id,"other_adjuster","Claim_other_adjuster")'));
                   
                    
                
                ?>
		<?php echo $form->error($model,'adjustor_id'); ?>
	</div>

          <div class="row" id="other_adjuster" style="display:none;">
		<?php echo $form->labelEx($model,'other_adjuster'); ?>
		<?php echo $form->textField($model,'other_adjuster',array('size'=>30,'maxlength'=>500)); ?>
		<?php echo $form->error($model,'other_adjuster'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_phone'); ?>
		<?php echo $form->textField($model,'ob_phone',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'ob_phone'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_fax'); ?>
		<?php echo $form->textField($model,'ob_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'ob_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ob_email'); ?>
		<?php echo $form->textField($model,'ob_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ob_email'); ?>
	</div>
          <div class="row">
		<?php //echo $form->labelEx($cmp,'id'); ?>
           
		<label class="required" >TPA Company <span class="required">*</span></label>
		<?php 
                $ty=CHtml::listData($tpacmpp,'id','name');
                //'onchange'=>'resetdropdown("Claim_tpa_branch")'
                echo $form->dropdownList($model,'tpa_company',$ty,array('class'=>'span2','empty'=>'Select','onblur'=>'resetdropdown(this.id,"Claim_tpa_branch")',
                    'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Company/gettpaBranch'),
				  'update'=>'#Claim_tpa_branch', 
                                  
			)
                    ));  ?>
		<?php echo $form->error($model,'tpa_company'); ?>
	</div>
          <div class="row">
		<?php echo $form->labelEx($model,'tpa_branch'); ?>
		<?php 
                //$arr=array("74"=>"Other");
                echo $form->dropDownList($model,'tpa_branch',array(),array('empty'=>'Select','onchange'=>'getbranchdetail(this.id)')); ?>
		<?php echo $form->error($model,'tpa_branch'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_address1'); ?>
		<?php echo $form->textArea($model,'tpa_address1',array('rows'=>2, 'cols'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'tpa_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_address2'); ?>
		<?php echo $form->textArea($model,'tpa_address2',array('rows'=>2, 'cols'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'tpa_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_city'); ?>
		<?php echo $form->textField($model,'tpa_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'tpa_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_state'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'tpa_state',$ty,array('class'=>'span2','empty'=>'Select'));
                  ?>
		<?php echo $form->error($model,'tpa_state'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_zip'); ?>
		<?php echo $form->textField($model,'tpa_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'tpa_zip'); ?>
            <div id="Claim_tpa_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_adjuster'); ?>
		<?php //echo $form->textField($model,'tpa_adjuster'); 
                    $ty=array();//CHtml::listData($usr,'id','first_name');
                echo $form->dropdownList($model,'tpa_adjuster',$ty,array('class'=>'span2','empty'=>'Select','onchange'=>'Getadjusterdetail(this.id),showother(this.id,"other_adjuster","Claim_other_adjuster")'));
                
                ?>
		<?php echo $form->error($model,'tpa_adjuster'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_phone'); ?>
		<?php echo $form->textField($model,'tpa_phone',array('size'=>30,'maxlength'=>20,'class'=>'phone')); ?>
		<?php echo $form->error($model,'tpa_phone'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_fax'); ?>
		<?php echo $form->textField($model,'tpa_fax',array('size'=>30,'maxlength'=>20,'class'=>'phone')); ?>
		<?php echo $form->error($model,'tpa_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tpa_email'); ?>
		<?php echo $form->textField($model,'tpa_email',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'tpa_email'); ?>
	</div>
	  
	</div>
</div>
	
<div class="sec-tab">
    <div class="left" id="claimant-tab">
        <h2>Claimant Information</h2>
         <div><input type="radio" name="claimant" value="insured-tab" id="claim_insured" class="cpyradio">Copy from Insured Information</div>
        <div><input type="radio" name="claimant" value="owner-tab" id="claim_owner" class="cpyradio">Copy from Owner Information</div>
	
	<div class="row">
		<?php echo $form->labelEx($model,'c_first_name'); ?>
		<?php echo $form->textField($model,'c_first_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'c_first_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_last_name'); ?>
		<?php echo $form->textField($model,'c_last_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'c_last_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_address1'); ?>
		<?php echo $form->textArea($model,'c_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'c_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_address2'); ?>
		<?php echo $form->textArea($model,'c_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'c_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_city'); ?>
		<?php echo $form->textField($model,'c_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'c_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'c_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                   ?>
		<?php echo $form->error($model,'c_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_zip'); ?>
		<?php echo $form->textField($model,'c_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'c_zip'); ?>
            <div id="Claim_c_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_cell'); ?>
		<?php echo $form->textField($model,'c_cell',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'c_cell'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_home'); ?>
		<?php echo $form->textField($model,'c_home',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'c_home'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_work'); ?>
		<?php echo $form->textField($model,'c_work',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'c_work'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_fax'); ?>
		<?php echo $form->textField($model,'c_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'c_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'c_email'); ?>
		<?php echo $form->textField($model,'c_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'c_email'); ?>
	</div>
    </div>
    <div class="right" id="insured-tab">
        <h2>Insured Information</h2>
        <div><input type="radio" name="insured" value="claimant-tab" id="ins_claimant" class="cpyradio">Copy from Claimant Information</div>
        <div><input type="radio" name="insured" value="owner-tab" id="ins_owner" class="cpyradio">Copy from Owner Information</div>
	
        <div class="row">
		<?php echo $form->labelEx($model,'i_first_name'); ?>
		<?php echo $form->textField($model,'i_first_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'i_first_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_last_name'); ?>
		<?php echo $form->textField($model,'i_last_name',array('size'=>30,'maxlength'=>35)); ?>
		<?php echo $form->error($model,'i_last_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_address1'); ?>
		<?php echo $form->textArea($model,'i_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'i_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_address2'); ?>
		<?php echo $form->textArea($model,'i_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'i_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_city'); ?>
		<?php echo $form->textField($model,'i_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'i_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'i_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                    ?>
		<?php echo $form->error($model,'i_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_zip'); ?>
		<?php echo $form->textField($model,'i_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'i_zip'); ?>
            <div id="Claim_i_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_home'); ?>
		<?php echo $form->textField($model,'i_home',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'i_home'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_work'); ?>
		<?php echo $form->textField($model,'i_work',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'i_work'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_cell'); ?>
		<?php echo $form->textField($model,'i_cell',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'i_cell'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_fax'); ?>
		<?php echo $form->textField($model,'i_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'i_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'i_email'); ?>
		<?php echo $form->textField($model,'i_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'i_email'); ?>
	</div>
    </div>
</div>
	
<div class="third-tab">
    <div class="left">
        <h2>Vehicle Information</h2>
        <div class="row">
		<?php echo $form->labelEx($model,'v_year'); ?>
		<?php echo $form->textField($model,'v_year',array('size'=>30,'maxlength'=>4)); ?>
		<?php echo $form->error($model,'v_year'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_make_id'); ?>
		<?php 
                       $ty=CHtml::listData($makes,'id','make_name');
                  echo $form->dropdownList($model,'v_make_id',$ty,array('class'=>'span2','empty'=>'Select'));
                
//echo $form->textField($model,'v_make_id'); ?>
		<?php echo $form->error($model,'v_make_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_model_id'); ?>
		<?php  $ty=CHtml::listData($models,'id','model');
                  echo $form->dropdownList($model,'v_model_id',$ty,array('class'=>'span2','empty'=>'Select'));
                 ?>
		<?php echo $form->error($model,'v_model_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_submodel'); ?>
		<?php echo $form->textField($model,'v_submodel',array('size'=>30,'maxlength'=>50)); ?>
		<?php echo $form->error($model,'v_submodel'); ?>
	</div>
        <div class="row">
		<?php echo $form->labelEx($model,'v_vin'); ?>
		<?php echo $form->textField($model,'v_vin',array('size'=>30,'maxlength'=>26)); ?>
		<?php echo $form->error($model,'v_vin'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_lien_holder'); ?>
		<?php echo $form->textField($model,'v_lien_holder',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'v_lien_holder'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_color'); ?>
		<?php echo $form->textField($model,'v_color',array('size'=>30,'maxlength'=>12)); ?>
		<?php echo $form->error($model,'v_color'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_plate_no'); ?>
		<?php echo $form->textField($model,'v_plate_no',array('size'=>30,'maxlength'=>9)); ?>
		<?php echo $form->error($model,'v_plate_no'); ?>
	</div>
       
	<div class="row">
		<?php echo $form->labelEx($model,'v_plate_country'); ?>
		<?php $ty=CHtml::listData($countries,'id','name');
                  echo $form->dropdownList($model,'v_plate_country',$ty,array('class'=>'span2','empty'=>'Select',
                        'options'=>array('1'=>array('selected'=>true)),
                      'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Country/getState'),
				  'update'=>'#Claim_v_plate_state_id', 
			)));
                    ?>
		<?php echo $form->error($model,'v_plate_country'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_plate_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'v_plate_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                     ?>
		<?php echo $form->error($model,'v_plate_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_milege'); ?>
		<?php echo $form->textField($model,'v_milege',array('size'=>30)); ?>
		<?php echo $form->error($model,'v_milege'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_style'); ?>
		<?php echo $form->textField($model,'v_style',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'v_style'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_drivable'); 
                    $model->v_drivable='Unknown';
                ?>
		  <?php echo $form->radioButtonList($model, 'v_drivable', array(
                'Yes'=>"Yes","No"=>"No","Unknown"=>"Unknown",
                
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline')));?>
           
		<?php echo $form->error($model,'v_drivable'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_condition'); ?>
		<?php echo $form->textField($model,'v_condition',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'v_condition'); ?>
	</div>

	
	

    </div>
    <div class="right">
        <div class="row" id="vehicle-tab">
            <h2>Vehicle Location</h2>
              <div><input type="radio" name="vehicle" value="claimant-tab" id="veh_claimant" class="cpyradio">Copy from Claimant Information</div>
            <div><input type="radio" name="vehicle" value="owner-tab" id="veh_owner" class="cpyradio">Copy from Owner Information</div>
	     <div><input type="radio" name="vehicle" value="insured-tab" id="veh_insured" class="cpyradio">Copy from Insured Information</div>
             <div class="row">
                 <input type="checkbox" name="diffcheck" id="differentloc"/><strong>Different Location</strong>
                <?php //echo $form->labelEx($model,'v_different_location'); ?>
                 <div id="v_diff" style="display: none;">
		<?php echo ZHtml::enumDropDownList($model, 'v_different_location',array('empty'=>'Select')); ?>
		<?php echo $form->error($model,'v_different_location'); ?>
                 </div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_location_name'); ?>
		<?php echo $form->textField($model,'v_location_name',array('size'=>30,'maxlength'=>50)); ?>
		<?php echo $form->error($model,'v_location_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_address1'); ?>
		<?php echo $form->textArea($model,'v_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'v_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_address2'); ?>
		<?php echo $form->textArea($model,'v_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'v_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_city'); ?>
		<?php echo $form->textField($model,'v_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'v_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'v_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                     ?>
		<?php echo $form->error($model,'v_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_zip'); ?>
		<?php echo $form->textField($model,'v_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'v_zip'); ?>
            <div id="Claim_v_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_phone'); ?>
		<?php echo $form->textField($model,'v_phone',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'v_phone'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'v_email'); ?>
		<?php echo $form->textField($model,'v_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'v_email'); ?>
	</div>
    </div>
</div>
    <div class="four-tab">
        
        <div class="left">
            <h2>Additional Information</h2>
            
            <div class="row">
		<?php echo $form->labelEx($model,'ad_primary_poi'); ?>
		<?php echo $form->textField($model,'ad_primary_poi',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ad_primary_poi'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_secondary_poi'); ?>
		<?php echo $form->textField($model,'ad_secondary_poi',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ad_secondary_poi'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_vehicle_condition'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'ad_vehicle_condition',array('empty'=>'Select'));?>
		<?php echo $form->error($model,'ad_vehicle_condition'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_interior_condition'); ?>
		<?php echo $form->textField($model,'ad_interior_condition',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ad_interior_condition'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_paint_condition'); ?>
		<?php echo $form->textField($model,'ad_paint_condition',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ad_paint_condition'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_engine_condition'); ?>
		<?php echo $form->textField($model,'ad_engine_condition',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ad_engine_condition'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_pay_code'); ?>
		<?php echo $form->textField($model,'ad_pay_code',array('size'=>30,'maxlength'=>20)); ?>
		<?php echo $form->error($model,'ad_pay_code'); ?>
	</div>

	

	<div class="row">
		<?php echo $form->labelEx($model,'ad_storage'); ?>
		<?php $model->ad_storage="Unknown";?>
		<?php echo $form->radioButtonList($model, 'ad_storage', array(
                'Yes'=>"Yes","No"=>"No","Unknown"=>"Unknown",
                 
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline')));?>
           
		<?php echo $form->error($model,'ad_storage'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ad_permission_to_move'); ?>
                <?php $model->ad_permission_to_move="Unknown";?>
		<?php echo $form->radioButtonList($model, 'ad_permission_to_move', array(
                'Yes'=>"Yes","No"=>"No","Unknown"=>"Unknown",
                 
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline')));?>
           
		<?php echo $form->error($model,'ad_permission_to_move'); ?>
	</div>
        <div class="row">
		<?php echo $form->labelEx($model,'ad_rental_vehicle'); ?>
		<?php //echo $form->textField($model,'ad_rental_vehicle',array('size'=>7,'maxlength'=>7)); ?>
		<?php //echo $form->error($model,'ad_rental_vehicle'); ?>
          	<?php //echo $form->error($model,'ad_rental_vehicle'); ?>
            <?php $model->ad_rental_vehicle="Unknown";?>
           <?php echo $form->radioButtonList($model, 'ad_rental_vehicle', array(
                'Yes'=>"Yes","No"=>"No","Unknown"=>"Unknown",
                 
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline'),'class'=>'isrental'));?>
           
        </div>
            <div id="rental" style="display: none;">
                    <div class="row">
                            <?php echo $form->labelEx($model,'ad_rental_max_days'); ?>
                            <?php echo $form->textField($model,'ad_rental_max_days',array('size'=>30)); ?>
                            <?php echo $form->error($model,'ad_rental_max_days'); ?>
                    </div>

                    <div class="row">
                            <?php echo $form->labelEx($model,'ad_rental_max_aount'); ?>
                            <?php echo $form->textField($model,'ad_rental_max_aount',array('size'=>30)); ?>
                            <?php echo $form->error($model,'ad_rental_max_aount'); ?>
                    </div>
            </div>
        </div>
        <div class="right">
            <h2>Tire Information</h2>
            
            <div class="row">
		<?php echo $form->labelEx($model,'ty_make'); ?>
		<?php echo $form->textField($model,'ty_make',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'ty_make'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ty_size'); ?>
		<?php echo $form->textField($model,'ty_size',array('size'=>30,'maxlength'=>16)); ?>
		<?php echo $form->error($model,'ty_size'); ?>
	</div>
            <div>
            <h3>Tread Depth (in 32nds):</h3>
            <div style="float:left;">
	<div class="row">
		<?php echo $form->labelEx($model,'ty_lf'); ?>
		<?php echo $form->textField($model,'ty_lf',array('size'=>15,'maxlength'=>2)); ?>
		<?php echo $form->error($model,'ty_lf'); ?>
	</div>
                <div class="row">
		<?php echo $form->labelEx($model,'ty_lr'); ?>
		<?php echo $form->textField($model,'ty_lr',array('size'=>15,'maxlength'=>2)); ?>
		<?php echo $form->error($model,'ty_lr'); ?>
	</div>
           
            </div>
            <div style="float: right;">
	
                 <div class="row">
		<?php echo $form->labelEx($model,'ty_rf'); ?>
		<?php echo $form->textField($model,'ty_rf',array('size'=>15,'maxlength'=>2)); ?>
		<?php echo $form->error($model,'ty_rf'); ?>
	</div>
	

	<div class="row">
		<?php echo $form->labelEx($model,'ty_rr'); ?>
		<?php echo $form->textField($model,'ty_rr',array('size'=>15,'maxlength'=>2)); ?>
		<?php echo $form->error($model,'ty_rr'); ?>
	</div>
            </div>
            <div style="clear: both;"></div>
            <div class="row">
                    <?php echo $form->labelEx($model,'ty_spare'); ?>
                    <?php echo $form->textField($model,'ty_spare',array('size'=>30,'maxlength'=>2)); ?>
                    <?php echo $form->error($model,'ty_spare'); ?>
            </div>
            </div>
            <h2>Repair Information</h2>
            <div class="row">
		<?php echo $form->labelEx($model,'rp_shop_name'); ?>
		<?php echo $form->textField($model,'rp_shop_name',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'rp_shop_name'); ?>
            </div>

            <div class="row">
		<?php echo $form->labelEx($model,'rp_address1'); ?>
		<?php echo $form->textArea($model,'rp_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'rp_address1'); ?>
            </div>

                <div class="row">
                        <?php echo $form->labelEx($model,'rpo_address2'); ?>
                        <?php echo $form->textArea($model,'rpo_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
                        <?php echo $form->error($model,'rpo_address2'); ?>
                </div>

                <div class="row">
                        <?php echo $form->labelEx($model,'rp_city'); ?>
                        <?php echo $form->textField($model,'rp_city',array('size'=>30,'maxlength'=>30)); ?>
                        <?php echo $form->error($model,'rp_city'); ?>
                </div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_state_id'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'rp_state_id',$ty,array('class'=>'span2','empty'=>'Select'));
                      ?>
		<?php echo $form->error($model,'rp_state_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_zip'); ?>
		<?php echo $form->textField($model,'rp_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'rp_zip'); ?>
            <div id="Claim_rp_zip_err" class="errorMessage"></div> 
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_phone'); ?>
		<?php echo $form->textField($model,'rp_phone',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'rp_phone'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_fax'); ?>
		<?php echo $form->textField($model,'rp_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'rp_fax'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_aggreed_price'); ?>
           
		<?php echo ZHtml::enumDropDownList($model, 'rp_aggreed_price',array('empty'=>'Select')); ?>
		<?php echo $form->error($model,'rp_aggreed_price'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_federal_tax_id'); ?>
		<?php echo $form->textField($model,'rp_federal_tax_id',array('size'=>30,'maxlength'=>20)); ?>
		<?php echo $form->error($model,'rp_federal_tax_id'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_ert_days'); ?>
		<?php echo $form->textField($model,'rp_ert_days',array('size'=>30)); ?>
		<?php echo $form->error($model,'rp_ert_days'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_posiible_supplement'); ?>
		<?php echo $form->textField($model,'rp_posiible_supplement',array('size'=>30,'maxlength'=>10)); ?>
		<?php echo $form->error($model,'rp_posiible_supplement'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_originalnet_loss'); ?>
		<?php echo $form->textField($model,'rp_originalnet_loss',array('size'=>30)); ?>
		<?php echo $form->error($model,'rp_originalnet_loss'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'rp_supplement_net_loss'); ?>
		<?php echo $form->textField($model,'rp_supplement_net_loss',array('size'=>30)); ?>
		<?php echo $form->error($model,'rp_supplement_net_loss'); ?>
	</div>

            
        </div>
    </div>
    <div style="clear: both;"></div>
    <div style="width: 100%">
        <h2>Accident and Damage Information:</h2>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_special_instruction'); ?>
		<?php echo $form->textArea($model,'adi_special_instruction',array('rows'=>6, 'cols'=>30)); ?>
		<?php echo $form->error($model,'adi_special_instruction'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_damage_description'); ?>
		<?php echo $form->textArea($model,'adi_damage_description',array('rows'=>6, 'cols'=>30)); ?>
		<?php echo $form->error($model,'adi_damage_description'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_prior_damage');
                $model->adi_prior_damage="Unknown";?>
	<?php echo $form->radioButtonList($model, 'adi_prior_damage', array(
                'Yes'=>"Yes","No"=>"No","Unknown"=>"Unknown",
                 
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline'),'class'=>'prior'));?>
           
		<?php echo $form->error($model,'adi_prior_damage'); ?>
	</div>
        <div id="damageloc" style="display: none;">
        <div class="row">
		<?php echo $form->labelEx($model,'adi_damage_location'); ?>
		<?php echo $form->textField($model,'adi_damage_location',array('size'=>30,'maxlength'=>500)); ?>
		<?php echo $form->error($model,'adi_damage_location'); ?>
	</div>
        </div>
        <div class="row">
		<?php echo $form->labelEx($model,'adi_accident_description'); ?>
		<?php echo $form->textField($model,'adi_accident_description',array('size'=>30,'maxlength'=>500)); ?>
		<?php echo $form->error($model,'adi_accident_description'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_claim_reported_by'); ?>
		<?php echo $form->textField($model,'adi_claim_reported_by',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_claim_reported_by'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_phone'); ?>
		<?php echo $form->textField($model,'adi_phone',array('size'=>30,'maxlength'=>20,'class'=>'phone')); ?>
		<?php echo $form->error($model,'adi_phone'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_driver_name'); ?>
		<?php echo $form->textField($model,'adi_driver_name',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'adi_driver_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_address1'); ?>
		<?php echo $form->textArea($model,'adi_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'adi_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_address2'); ?>
		<?php echo $form->textArea($model,'adi_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'adi_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_city'); ?>
		<?php echo $form->textField($model,'adi_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'adi_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_state'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'adi_state',$ty,array('class'=>'span2','empty'=>'Select'));
                      ?>
		<?php echo $form->error($model,'adi_state'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_country'); ?>
		<?php $ty=CHtml::listData($countries,'id','name');
                  echo $form->dropdownList($model,'adi_country',$ty,array('class'=>'span2','empty'=>'Select', 'options'=>array('1'=>array('selected'=>true)),
                      'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Country/getState'),
				  'update'=>'#Claim_adi_state', 
			)));
                       ?>
		<?php echo $form->error($model,'adi_country'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_zip'); ?>
		<?php echo $form->textField($model,'adi_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'adi_zip'); ?>
            <div id="Claim_adi_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_email'); ?>
		<?php echo $form->textField($model,'adi_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_email'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_driver_licence'); ?>
		<?php echo $form->textField($model,'adi_driver_licence',array('size'=>30,'maxlength'=>10)); ?>
		<?php echo $form->error($model,'adi_driver_licence'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_licence_state'); ?>
		<?php echo $form->textField($model,'adi_licence_state',array('size'=>30,'maxlength'=>20)); ?>
		<?php echo $form->error($model,'adi_licence_state'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_licence_country'); ?>
		<?php echo $form->textField($model,'adi_licence_country',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_licence_country'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_authority_contacted'); ?>
		<?php echo $form->textField($model,'adi_authority_contacted',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_authority_contacted'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_phone'); ?>
		<?php echo $form->textField($model,'adi_phone',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_phone'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_bywhom'); ?>
		<?php echo $form->textField($model,'adi_bywhom',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_bywhom'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_report_number'); ?>
		<?php echo $form->textField($model,'adi_report_number',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_report_number'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'adi_authority_contacted'); ?>
		<?php echo $form->textField($model,'adi_authority_contacted',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_authority_contacted'); ?>
	</div>
<div class="row">
		<?php echo $form->labelEx($model,'adi_phone_number'); ?>
		<?php echo $form->textField($model,'adi_phone_number',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'adi_phone_number'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_bywhom'); ?>
		<?php echo $form->textField($model,'adi_bywhom',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'adi_bywhom'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adi_report_number'); ?>
		<?php echo $form->textField($model,'adi_report_number',array('size'=>30,'maxlength'=>20)); ?>
		<?php echo $form->error($model,'adi_report_number'); ?>
	</div>
        <div class="row">
        </div>
<div class="row">
	<h2>Passengers and Witnesses:</h2>
            <input type="hidden" name="tabrows" id="tabrows"/>
            <table id="item_tab">
                <tr>
                    <td>Name</td>
                    <td>Type</td>
                    
                    <td>Relationship</td>
                    <td>Statement</td>
                </tr>
                <?php
               
                for($i=1;$i<=3;$i++)
                { $j=1;?>
                <tr >
                    <td><?php echo $form->textField($pass,'[]pw_name',array('size'=>10,'maxlength'=>60,'id'=>$i."-".$j,'name'=>'pw_name[]')); ?></td>
                    <td><?php $col=$j+1;
                    echo $form->textField($pass,'[]pw_phone',array('class'=>'intonly phone','size'=>10,'maxlength'=>12,'id'=>$i."-".$col,'name'=>'pw_phone[]')); ?></td>
                    <td><?php $col=$j+2;
                    echo  ZHtml::enumDropDownList($pass, '[]pw_type',array('id'=>$i."-".$col,'name'=>'pw_type[]','empty'=>'select')) ;?></td>
                     <td class="glCreditValue"><?php $col=$j+3;
                    echo ZHtml::enumDropDownList($pass, '[]pw_relationship',array('id'=>$i."-".$col,'name'=>'pw_relationship[]','empty'=>'select')); ?></td>
                     <td ><?php $col=$j+4;
                    echo $form->textField($pass,'[]pw_statement',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$col,'name'=>'pw_statement[]')); ?></td>
                   
                </tr>
                    
               <?php }
            ?>
            </table>
        </div>
	

	
        <h2>Appointment/Loss Information</h2>
	
	<div class="row">
		<?php echo $form->labelEx($model,'ali_vehicel_appointment_setup'); 
                $model->ali_vehicel_appointment_setup="No"?>
		<?php echo $form->radioButtonList($model, 'ali_vehicel_appointment_setup', array(
                'Yes'=>"Yes","No"=>"No",
                 
               ),
			   array('separator'=>'','labelOptions'=>array('style'=>'display:inline'),'class'=>'appsetup'));?>
           
	     	<?php echo $form->error($model,'ali_vehicel_appointment_setup'); ?>
	</div>

        <div id="appointment_datetime" style="display: none;">
            <div class="row">
				<?php echo $form->labelEx($model,'apl_appointment_datetime'); ?>
				<?php echo $form->textField($model,'apl_appointment_datetime',array('size'=>30)); ?>
				
				<?php //echo $form->textField($model,'dob',array('size'=>30),array(
      
?>
				<?php echo $form->error($model,'apl_appointment_datetime'); ?>
			</div>
        </div>
		<div class="row">
				<?php echo $form->labelEx($model,'apl_between'); ?>
				<?php echo $form->textField($model,'apl_between',array('size'=>30)); ?>
				<?php echo $form->error($model,'apl_between'); ?>
			</div>
		<div class="row">
				<?php echo $form->labelEx($model,'apl_and'); ?>
				<?php echo $form->textField($model,'apl_and',array('size'=>30)); ?>
				<?php echo $form->error($model,'apl_and'); ?>
		</div>
		
	<div class="row">
		<?php echo $form->labelEx($model,'ali_recommendation'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'ali_recommendation',array('empty'=>'Select')) ?>
		<?php echo $form->error($model,'ali_recommendation'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'ali_total_loss'); ?>
		
            <?php 
                $model->ali_total_loss="No";
            echo $form->radioButtonList($model, 'ali_total_loss', array(
                'Yes'=>"Yes","No"=>"No",
                 
               ),array('separator'=>'','labelOptions'=>array('style'=>'display:inline'),'class'=>'ali_total_loss'));?>
           
                  
		<?php echo $form->error($model,'ali_total_loss'); ?>
	</div>
        <div id="prefered_tl_evalutionclass" style="display: none;">
        <div class="row">
		<?php echo $form->labelEx($model,'prefered_tl_evalution'); ?>
		<?php echo ZHtml::enumDropDownList($model, 'prefered_tl_evalution',array('empty'=>'select','onchange'=>'showtable(this.id)'))?>
		<?php echo $form->error($model,'prefered_tl_evalution'); ?>
	</div>
        </div>
        
        <div id="lossinfo" style="display: none;">
            <div class="row">
            
            <table id="item_tab2">
                <tr>
                    <td>Name</td>
                    <td>Reference  Number</td>
                    <td>Location</td>
                    <td>Phone Number</td>
                    <td>Amount</td>
                </tr>
                <?php
               
                for($i=1;$i<=5;$i++)
                { $j=1;?>
                <tr>
                    <td><?php echo $form->textField($lossinfo,'[]loss_name',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$j,'name'=>'loss_name[]')); ?></td>
                    <td><?php $col=$j+1;
                    echo $form->textField($lossinfo,'[]loss_reference_num',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$col,'name'=>'loss_reference_num[]','class'=>'phone')); ?></td>
                    <td><?php $col=$j+2;
                    echo $form->textField($lossinfo,'[]loss_location',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$col,'name'=>'loss_location[]')); ?></td>
                    <td><?php $col=$j+3;
                    echo $form->textField($lossinfo,'[]loss_phone_number',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$col,'class'=>'phone','name'=>'loss_phone_number[]')); ?></td>
                    <td class="glCreditValue"><?php $col=$j+4;
                    echo $form->textField($lossinfo,'[]loss_amount',array('size'=>10,'maxlength'=>20,'id'=>$i."-".$col,'class'=>'deconly','name'=>'loss_amount[]')); ?></td>
                </tr>
                    
               <?php }
            ?>
            </table>
        </div>
        </div>
        <h2>Guidlines</h2>
 	<!--<div class="row">
		<?php //echo $form->labelEx($model,'gui_company_guidelines'); ?>
		<?php //echo $form->textArea($model,'gui_company_guidelines',array('rows'=>6, 'cols'=>50)); ?>
		<?php //echo $form->error($model,'gui_company_guidelines'); ?>
	</div>

	<div class="row">
		<?php //echo $form->labelEx($model,'gui_branch_guidelines'); ?>
		<?php //echo $form->textArea($model,'gui_branch_guidelines',array('rows'=>6, 'cols'=>50)); ?>
		<?php //echo $form->error($model,'gui_branch_guidelines'); ?>
	</div>
-->
<h2>Producer and Policy Information</h2>
	<!--<div class="row">
		<?php //echo $form->labelEx($model,'delivery_method'); ?>
		<?php //echo $form->textField($model,'delivery_method',array('size'=>30,'maxlength'=>20)); ?>
		<?php //echo $form->error($model,'delivery_method'); ?>
	</div>

	<div class="row">
		<?php //echo $form->labelEx($model,'status_interval'); ?>
		<?php //echo $form->textField($model,'status_interval',array('size'=>8,'maxlength'=>8)); ?>
		<?php //echo $form->error($model,'status_interval'); ?>
	</div>

	
	<div class="row">
		<?php //echo $form->labelEx($model,'apl_and'); ?>
		<?php //echo $form->textField($model,'apl_and',array('size'=>5,'maxlength'=>5)); ?>
		<?php //echo $form->error($model,'apl_and'); ?>
	</div>

	<div class="row">
		<?php //echo $form->labelEx($model,'apl_between'); ?>
		<?php //echo $form->textField($model,'apl_between',array('size'=>5,'maxlength'=>5)); ?>
		<?php //echo $form->error($model,'apl_between'); ?>
	</div>

	-->

	
	<div class="row">
		<?php echo $form->labelEx($model,'producer_company_name'); ?>
		<?php echo $form->textField($model,'producer_company_name',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'producer_company_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'agent_name'); ?>
		<?php echo $form->textField($model,'agent_name',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'agent_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_address1'); ?>
		<?php echo $form->textField($model,'producer_address1',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'producer_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_address2'); ?>
		<?php echo $form->textField($model,'producer_address2',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'producer_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_city'); ?>
		<?php echo $form->textField($model,'producer_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'producer_city'); ?>
	</div>
        <div class="row">
		<?php echo $form->labelEx($model,'producer_zip'); ?>
		<?php echo $form->textField($model,'producer_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'producer_zip'); ?>
            <div id="Claim_producer_zip_err"  class="errormessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_state'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'producer_state',$ty,array('class'=>'span2','empty'=>'Select'));
                 ?>
		<?php echo $form->error($model,'producer_state'); ?>
	</div>

	
	<div class="row">
		<?php echo $form->labelEx($model,'producer_country'); ?>
		<?php $ty=CHtml::listData($countries,'id','name');
                   echo $form->dropdownList($model,'producer_country',$ty,array('class'=>'span2','empty'=>'Select',
                        'options'=>array('1'=>array('selected'=>true)),
                      'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Country/getState'),
				  'update'=>'#Claim_producer_state', 
			)));?>
		<?php echo $form->error($model,'producer_country'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_phone'); ?>
		<?php echo $form->textField($model,'producer_phone',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'producer_phone'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'producer_email'); ?>
		<?php echo $form->textField($model,'producer_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'producer_email'); ?>
	</div>


	<div class="row">
		<?php echo $form->labelEx($model,'producer_webaddress'); ?>
		<?php echo $form->textField($model,'producer_webaddress',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'producer_webaddress'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_policy_number'); ?>
		<?php echo $form->textField($model,'producer_policy_number',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'producer_policy_number'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'producer_policy_effective_date'); ?>
		<?php echo $form->textField($model,'producer_policy_effective_date',array('class'=>'date-pick','size'=>30)); ?>
		<?php echo $form->error($model,'producer_policy_effective_date'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'policy_expiration_date'); ?>
		<?php echo $form->textField($model,'policy_expiration_date',array('class'=>'date-pick','size'=>30)); ?>
		<?php echo $form->error($model,'policy_expiration_date'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'bodiy_enjury_per_person'); ?>
		<?php echo $form->textField($model,'bodiy_enjury_per_person',array('size'=>30)); ?>
		<?php echo $form->error($model,'bodiy_enjury_per_person'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'bodily_enjury_per_accident'); ?>
		<?php echo $form->textField($model,'bodily_enjury_per_accident',array('size'=>30)); ?>
		<?php echo $form->error($model,'bodily_enjury_per_accident'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'property_damage'); ?>
		<?php echo $form->textField($model,'property_damage',array('size'=>30)); ?>
		<?php echo $form->error($model,'property_damage'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'single_limits'); ?>
		<?php echo $form->textField($model,'single_limits',array('size'=>30)); ?>
		<?php echo $form->error($model,'single_limits'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'medical_payment_limits'); ?>
		<?php echo $form->textField($model,'medical_payment_limits',array('size'=>30)); ?>
		<?php echo $form->error($model,'medical_payment_limits'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'otc_deductible'); ?>
		<?php echo $form->textField($model,'otc_deductible',array('size'=>30)); ?>
		<?php echo $form->error($model,'otc_deductible'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'collision_deductible'); ?>
		<?php echo $form->textField($model,'collision_deductible',array('size'=>30)); ?>
		<?php echo $form->error($model,'collision_deductible'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'unrelated_bodily_injury_per_person'); ?>
		<?php echo $form->textField($model,'unrelated_bodily_injury_per_person',array('size'=>30)); ?>
		<?php echo $form->error($model,'unrelated_bodily_injury_per_person'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'unrelated_bodily_injury_per_accident'); ?>
		<?php echo $form->textField($model,'unrelated_bodily_injury_per_accident',array('size'=>30)); ?>
		<?php echo $form->error($model,'unrelated_bodily_injury_per_accident'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'motorist_property_damage'); ?>
		<?php echo $form->textField($model,'motorist_property_damage',array('size'=>30)); ?>
		<?php echo $form->error($model,'motorist_property_damage'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'loss_payee'); ?>
		<?php echo $form->textField($model,'loss_payee',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'loss_payee'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_contact_name'); ?>
		<?php echo $form->textField($model,'pro_contact_name',array('size'=>30,'maxlength'=>60)); ?>
		<?php echo $form->error($model,'pro_contact_name'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_address1'); ?>
		<?php echo $form->textArea($model,'pro_address1',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'pro_address1'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_address2'); ?>
		<?php echo $form->textArea($model,'pro_address2',array('size'=>30,'maxlength'=>60,'rows'=>2,'cols'=>30)); ?>
		<?php echo $form->error($model,'pro_address2'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_city'); ?>
		<?php echo $form->textField($model,'pro_city',array('size'=>30,'maxlength'=>30)); ?>
		<?php echo $form->error($model,'pro_city'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_zip'); ?>
		<?php echo $form->textField($model,'pro_zip',array('class'=>'zip','size'=>30)); ?>
		<?php echo $form->error($model,'pro_zip'); ?>
            <div id="Claim_pro_zip_err" class="errorMessage"></div>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_state'); ?>
		<?php $ty=CHtml::listData($states,'id','name');
                  echo $form->dropdownList($model,'pro_state',$ty,array('class'=>'span2','empty'=>'Select'));
                 ?>
		<?php echo $form->error($model,'pro_state'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'pro_country'); ?>
		<?php $ty=CHtml::listData($countries,'id','name');
                   echo $form->dropdownList($model,'pro_country',$ty,array('class'=>'span2','empty'=>'Select',
                        'options'=>array('1'=>array('selected'=>true)),
                      'ajax'=>array(
				'type'=>'POST',
				 'url'=>CController::createUrl('Country/getState'),
				  'update'=>'#Claim_pro_state', 
			)));?>
		<?php echo $form->error($model,'pro_country'); ?>
	</div>

        <div class="row">
		<?php echo $form->labelEx($model,'pro_phone'); ?>
		<?php echo $form->textField($model,'pro_phone',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'pro_phone'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'pro_fax'); ?>
		<?php echo $form->textField($model,'pro_fax',array('maxlength'=>20,'size'=>30,'class'=>'phone')); ?>
		<?php echo $form->error($model,'pro_fax'); ?>
	</div>

	

	<div class="row">
		<?php echo $form->labelEx($model,'pro_email'); ?>
		<?php echo $form->textField($model,'pro_email',array('size'=>30,'maxlength'=>40)); ?>
		<?php echo $form->error($model,'pro_email'); ?>
	</div>
    </div>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
	</div>
 
<?php $this->endWidget(); ?>

</div><!-- form -->
<script>
$(function(){
   $('#Claim_apl_appointment_datetime').datetimepicker({
	startDate:'+1970/05/01',
        step:1
});
$('#Claim_apl_between').datetimepicker({
	datepicker:false,
	format:'H:i',
	step:1
});
$('#Claim_apl_and').datetimepicker({
	datepicker:false,
	format:'H:i',
	step:1
});
    $('#Claim_policy_no').blur(function(){
       var val=$(this).val();
       $('#Claim_producer_policy_number').val(val);
    });
    $('#differentloc').click(function(){
        if($('#differentloc').is(':checked'))
        {
            $('#v_diff').show();
        }
        else
        {  $('#v_diff').hide();
            $('#Claim_v_different_location').val('');
        }
    });
    $('.appsetup').click(function(){
         if($(this).val()=="Yes")
        {
            $('#appointment_datetime').show();
        }
        else
        {
            $('#appointment_datetime').hide();
            $('#Claim_apl_appointment_datetime').val('');
        }
    });
    $('.prior').click(function(){
        
        if($(this).val()=="Yes")
        {
            $('#damageloc').show();
        }
        else
        {
            $('#damageloc').hide();
            $('#Claim_adi_damage_location').val('');
        }
    });
    $('.ali_total_loss').click(function(){
         if($(this).val()=="Yes")
        {
            $('#prefered_tl_evalutionclass').show();
            showtable('Claim_prefered_tl_evalution');
        }
        else
        {
            $('#prefered_tl_evalutionclass').hide();
            $('#Claim_prefered_tl_evalution').val('');
         }
    })
    $('.isrental').click(function(){
        
        if($(this).val()=="Yes")
        {
            $('#rental').show();
        }
        else
        {
            $('#rental').hide();
            $('#Claim_ad_rental_max_days').val('');
            $('#Claim_ad_rental_max_aount').val('');
        }
    });
  $('#Claim_deducitible_waived').click(function(){
      if($("#Claim_deducitible_waived").is(':checked'))
      {  
          $('#Claim_deducitible').attr("disabled",true);
          $('#Claim_deducitible').val('');
      }
      else
         $('#Claim_deducitible').attr("disabled",false); 
  }) ;
  $('.cpyradio').click(function(){
      var id=this.id;
      var nm=this.name;
      //alert(nm);
      var sourceid=$('#'+id).val();
  $('#'+ sourceid+' input, #'+sourceid+' textarea, #'+sourceid+' select').each(
    function(index){  
        var input = $(this);
        var sid=input.attr('id');
        var disid='';
        if(nm=="insured")
        {
            
            if(sourceid=="claimant-tab")
                 disid=sid.replace("Claim_c","Claim_i");
            if(sourceid=="owner-tab")
                 disid=sid.replace("Claim_o","Claim_i");
            //alert(disid);
            $('#'+disid).val(input.val());
        }
        else if(nm=="claimant")
        {
            
            if(sourceid=="insured-tab")
                 disid=sid.replace("Claim_i","Claim_c");
            if(sourceid=="owner-tab")
                 disid=sid.replace("Claim_o","Claim_c");
            //alert(disid);
            $('#'+disid).val(input.val());
        }
        else if(nm=="vehicle")
        {
           if(sourceid=="insured-tab")
                 disid=sid.replace("Claim_i","Claim_v");
            if(sourceid=="owner-tab")
                 disid=sid.replace("Claim_o","Claim_v");
             if(sourceid=="claimant-tab")
                 disid=sid.replace("Claim_c","Claim_v");
            $('#'+disid).val(input.val());  
            
        }
       // alert('Type: ' + input.attr('type') + 'Name: ' + input.attr('name') + 'Value: ' + input.val());
    });
    });

    
});
function resetdropdown(id,otherid)
{
    var val=$("#"+id+" option:selected").text();
    val=$.trim(val);
   // alert(otherid);
   // if(val=="Other")
   //$("#"+otherid+" option").filter(function(){
   // var $this = $(this);
    $('#'+otherid).find('option[text=Other]').remove();// == "Other";
//}).remove();

        $('#'+otherid).append("<option value=0>Other</option>");
    //else
        
   /* var otr=$("#"+id+" option").filter(function(){
    var $this = $(this);
    return $this.text() == "Other";
}).val();


    $("#"+id+" option").filter(function(){
    var $this = $(this);
    return $this.text() == "Other";
}).remove();

//if(id=="tpacmp" || id=="Company_id")
    $("#"+id).append("<option value="+otr+">Other</option>");*/
}
function showother(id,otherid,boxid)
{
    var otr=$("#"+id+" option:selected").text();
  otr=  $.trim(otr);
    if(otr=="Other")
        $('#'+otherid).show();
    else
    {  
        $('#'+otherid).hide();
        $('#'+boxid).val('');
    }
    
}

    $(document).ready(function() {
  $('#Claim_v_make_id, #Claim_v_model_id, #Claim_rp_aggreed_price, #Claim_ali_vehicel_appointment_setup').autotab_filter({ format: 'custom', pattern: '[^0-9\.]' });
    $('#Claim_ob_state_id').append("<option value=0>Other</option>");
    $('#Claim_i_state_id').append("<option value=0>Other</option>");
    $('#Claim_c_state_id').append("<option value=0>Other</option>");
    $('#Claim_o_state_id').append("<option value=0>Other</option>");
    $('#Claim_v_state_id').append("<option value=0>Other</option>");
    $('#Claim_v_plate_state_id').append("<option value=0>Other</option>");
    $('#Claim_tpa_state').append("<option value=0>Other</option>");
    $('#Claim_adi_state').append("<option value=0>Other</option>");
    $('#Claim_rp_state_id').append("<option value=0>Other</option>");
    $('#Claim_adi_licence_state').append("<option value=0>Other</option>");
    $('#Claim_producer_state').append("<option value=0>Other</option>");
    $('#Claim_pro_state').append("<option value=0>Other</option>");
    $('#Claim_v_make_id').append("<option value=0>Other</option>");
    $('#Claim_v_model_id').append("<option value=0>Other</option>");
    $('#Claim_insurance_company').append("<option value=0>Other</option>");
    $('#Claim_tpa_company').append("<option value=0>Other</option>");
    $('#Claim_branch_id').append("<option value=0>Other</option>");
    $('#Claim_adjustor_id').append("<option value=0>Other</option>");
    $('#Claim_tpa_branch').append("<option value=0>Other</option>");
    $('#Claim_tpa_adjuster').append("<option value=0>Other</option>");
    //resetdropdown("Company_id");
    //resetdropdown("Claim_tpa_company");
    });
    
  // $(function() {
       function getbranchdetail(id)
       {
           var branchid=$('#'+id).val();
           if(branchid!="")
           {
            $.ajax({
                    type: "POST", 		//GET or POST or PUT or DELETE verb
                    url: 'index.php?r=Branch/Getdetail', 		// Location of the service
                    data:{branchid:branchid

                   },
                    //contentType: "",		// content type sent to server
                    //dataType: "json", 	//Expected data format from server
                    //processdata: true, 	//True or False
                    success: function (json) {//On Successful service call
                        //$('#claim-form').submit();
                        var data=JSON.parse(json);
                             //arr = [];

                        for(key in data){
                          // alert(key+"-"+data[key]);
                             if(id=="Claim_branch_id")
                             {
                                 $('#Claim_ob_address1').text(data['address1']);
                                  $('#Claim_ob_address2').text(data['address2']);
                                   $('#Claim_ob_city').val(data['city']);
                                    $('#Claim_ob_zip').val(data['zip']);
                                    $('#Claim_ob_state_id').val(data['state_id']);
                                }
                                else if(id=="Claim_tpa_branch")
                             {
                                  $('#Claim_tpa_address1').text(data['address1']);
                                  $('#Claim_tpa_address2').text(data['address2']);
                                   $('#Claim_tpa_city').val(data['city']);
                                    $('#Claim_tpa_zip').val(data['zip']);
                                    $('#Claim_tpa_state_id').val(data['state_id']);
                             }
                        }
                           if(id=="Claim_branch_id")
                             {
                                Getadjuster(branchid);
                                resetdropdown('Claim_branch_id','Claim_adjustor_id');
                                // $("#Claim_adjustor_id").append("<option value='74'>Other</option>");
                            }
                            else if(id=="Claim_tpa_branch")
                            {
                                GetTPAAdjuster(branchid);
                                resetdropdown('Claim_tpa_branch','Claim_tpa_adjuster');
                                //$("#Claim_tpa_adjuster").append("<option value='74'>Other</option>");
                            }
                        //alert(json[id]);
                        //window.location.reload(true);
                    },
                   // error: ServiceFailed	// When Service call fails
                });
           
       }
   }
   function GetTPAAdjuster(branchid)
   {
       
       $("#Claim_tpa_adjuster").empty();
             $("#Claim_tpa_adjuster").append("<option value=''>Select</option>");
           $.ajax({
                    type: "POST", 		//GET or POST or PUT or DELETE verb
                    url: 'index.php?r=Branch/Gettpaadjuster', 		// Location of the service
                    data:{branchid:branchid

                   },
                    //contentType: "",		// content type sent to server
                    //dataType: "json", 	//Expected data format from server
                    //processdata: true, 	//True or False
                    success: function (json) {//On Successful service call
                        //$('#claim-form').submit();
                        var data= $.parseJSON(json);
                             //arr = [];
                                var nam="";
                               
                        $.each(data, function(i, obj)
        {
                            console.log(obj.first_name);
                             nam=obj.first_name + " "+ obj.last_name;
                             // alert(nam);
                              $("#Claim_tpa_adjuster").append("<option value="+obj.id+"> "+nam+"</option>");
                           
        });
                          // alert(key+"-"+data[key]);
                         // if()
                              //  $('#Claim_adjustor_id').text(data['address1']);
                                  
                        
                            //Getadjuster(branchid);
                        //alert(json[id]);
                        //window.location.reload(true);
                    },
                   // error: ServiceFailed	// When Service call fails
                });
   }
       function Getadjuster(branchid)
       {
            $("#Claim_adjustor_id").empty();
             $("#Claim_adjustor_id").append("<option value=''>Select</option>");
           $.ajax({
                    type: "POST", 		//GET or POST or PUT or DELETE verb
                    url: 'index.php?r=Branch/Getadjuster', 		// Location of the service
                    data:{branchid:branchid

                   },
                    //contentType: "",		// content type sent to server
                    //dataType: "json", 	//Expected data format from server
                    //processdata: true, 	//True or False
                    success: function (json) {//On Successful service call
                        //$('#claim-form').submit();
                        var data= $.parseJSON(json);
                             //arr = [];
                                var nam="";
                               
                        $.each(data, function(i, obj)
        {
                            console.log(obj.first_name);
                             nam=obj.first_name + " "+ obj.last_name;
                             // alert(nam);
                              $("#Claim_adjustor_id").append("<option value="+obj.id+"> "+nam+"</option>");
                           
        });
                          // alert(key+"-"+data[key]);
                         // if()
                              //  $('#Claim_adjustor_id').text(data['address1']);
                                  
                        
                            //Getadjuster(branchid);
                        //alert(json[id]);
                        //window.location.reload(true);
                    },
                   // error: ServiceFailed	// When Service call fails
                });
           
       }
       function Getadjusterdetail(id)
       {
           var uid=$('#'+id).val();
          
           if(uid!="")
           {
            $.ajax({
                    type: "POST", 		//GET or POST or PUT or DELETE verb
                    url: 'index.php?r=Branch/Getadjusterdetail', 		// Location of the service
                    data:{uid:uid

                   },
                    //contentType: "",		// content type sent to server
                    //dataType: "json", 	//Expected data format from server
                    //processdata: true, 	//True or False
                    success: function (json) {//On Successful service call
                        //$('#claim-form').submit();
                        var data=JSON.parse(json);
                             //arr = [];

                        for(key in data){
                          // alert(key+"-"+data[key]);
                             if(id=="Claim_adjustor_id")
                             {   $('#Claim_ob_phone').val(data['workphone']);
                                 $('#Claim_ob_email').val(data['email']);
                             }
                             else if(id=="Claim_tpa_adjuster")
                              {   $('#Claim_tpa_phone').val(data['workphone']);
                                 $('#Claim_tpa_email').val(data['email']);
                             }
                                   
                        }
                            
                        //alert(json[id]);
                        //window.location.reload(true);
                    },
                   // error: ServiceFailed	// When Service call fails
                });
            }
       }
       
     function showtable(id)
     {
         var val=$('#'+id).val();
         val=$.trim(val);
         if(val=="Generic ACV with bids")
         {
             $('#lossinfo').show();
         }
         else
         {  $('#lossinfo').hide();
             $('#lossinfo input, #lossinfo textarea, #lossinfo select').each(
    function(index){  
        var input = $(this);
        var sid=input.attr('id');
        input.val('');
       // alert('Type: ' + input.attr('type') + 'Name: ' + input.attr('name') + 'Value: ' + input.val());
    });
        
        }
     }
      
     
   //});
    </script>