<?php



/**

 * This is the model base class for the table "user".

 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.

 * If any changes are necessary, you must set or override the required

 * property or method in class "User".

 *

 * Columns in table "user" available as properties of the model,

 * and there are no model relations.

 *

 * @property integer $id

 * @property string $email

 * @property string $username

 * @property string $password

 * @property integer $role_id

 * @property integer $status

 * @property integer $isSuperAdmin

 * @property string $created

 * @property string $modified

 *

 */

abstract class BaseUser extends GxActiveRecord {

        public $password2,$accept;

	public static function model($className=__CLASS__) {

		return parent::model($className);

	}

	public function behaviors(){

        return array('CSaveRelationsBehavior' => array('class' => 'application.components.CSaveRelationsBehavior'));

	}

	public function tableName() {

		return 'user';

	}



	public static function label($n = 1) {

		return Yii::t('app', 'User|Users', $n);

	}



	public static function representingColumn() {

		return 'username';

	}

        

        public function beforeSave()

    {

            // in this case, we will use the old hashed password.

        

        if(parent::beforeSave())

        {

            if($this->isNewRecord)

            {

                $this->salt =   utf8_encode( mcrypt_create_iv(30) );

                //$newPassword =  utf8_encode( crypt($this->password, $this->salt) );

                //$newPassword2 =  utf8_encode( crypt($this->password2, $this->salt) );

                //$this->password = $newPassword;

                //$this->password2 = $newPassword2;

            }

            return true;

        }

        else

            return false;

    }



        

        

	public function rules() {

		return array(

			array('username,password,email', 'required'),

			array('status, isSuperAdmin,firm_id', 'numerical', 'integerOnly'=>true),                        

			array('email', 'length', 'max'=>150),

                        array('email', 'email','message'=>"The email isn't correct"),

                        array('password2,accept', 'safe'),                        

                        //array('accept', 'required', 'requiredValue' => 1, 'message' => 'You should accept term to use our service'),

			array('username, password', 'length', 'max'=>100),                        

                        array('username', 'unique'),   

                        array('email', 'unique','message'=>"Email is already registered with us."),

                        array('password', 'compare', 'compareAttribute'=>'password2'), 

			array('email, username, password, status, isSuperAdmin', 'default', 'setOnEmpty' => true, 'value' => null),

			array('email, username, password, role_id, status, isSuperAdmin', 'safe', 'on'=>'search'),

                        array(

                                'modified','default',

                                'value'=>new CDbExpression('NOW()'),

                                'setOnEmpty'=>false,'on'=>'update'

                            ),

                        array(

                            'created,modified','default',

                            'value'=>new CDbExpression('NOW()'),

                            'setOnEmpty'=>false,'on'=>'insert'

                            ),

		);

	}





// model rules



	public function relations() {

		return array(

			'profile' => array(self::HAS_ONE,    'Profile', 'user_id'),
                    
                        'para' => array(self::HAS_ONE,    'ParalegalInfo', 'user_id'),
                    
                        'paraexp' => array(self::HAS_MANY,    'ParalegalExperience', 'user_id'),
                    
                        'attinfo' => array(self::HAS_ONE,    'AttorneyInfo', 'user_id'),

			'client' => array(self::HAS_ONE,    'Client', 'user_id'),

			//'role' => array(self::BELONGS_TO,  'Role', 'role_id'),

			'authassignment' => array(self::HAS_MANY,  'Authassignment', 'userid'),

			'document' => array(self::HAS_MANY,  'Document', 'created_by'),

			'calendarcreated' => array(self::HAS_MANY,  'Calendar', 'created_by'),

			'casecreated' => array(self::HAS_MANY,  'Cases', 'created_by'),

			'communicationcreated' => array(self::HAS_MANY,  'Communication', 'created_by'),

			'practice_area'=>array(self::MANY_MANY, 'Practice','user_practice_area(user_id, practice_area_id)'),

			'communication'=>array(self::MANY_MANY, 'Communication','communication_user(user_id, communication_id)'),

			'calendar'=>array(self::MANY_MANY, 'Calendar','calendar_user(user_id, calendar_id)'),

			'case'=>array(self::MANY_MANY, 'Cases','case_user(user_id, case_id)'),

			'address'=>array(self::MANY_MANY, 'Address','user_address(user_id, address_id)'),

		);

	}



	public function pivotModels() {

		return array(

		);

	}

	

	public function attributeLabels() {

		return array(

			'id' => Yii::t('app', 'ID'),

			'email' => Yii::t('app', 'Email'),

			'username' => Yii::t('app', 'Username'),

			'password' => Yii::t('app', 'Password'),

			'role_id' => Yii::t('app', 'Role'),

                        'firm_id' => Yii::t('app', 'Firm'),

			'status' => Yii::t('app', 'Status'),

			'isSuperAdmin' => Yii::t('app', 'Is Super Admin'),

			'created' => Yii::t('app', 'Created'),

			'modified' => Yii::t('app', 'Modified'),

		);

	}



	public function search() {

		$criteria = new CDbCriteria;



		$criteria->compare('id', $this->id);

		$criteria->compare('email', $this->email, true);

		$criteria->compare('username', $this->username, true);

		$criteria->compare('password', $this->password, true);

		$criteria->compare('role_id', $this->role_id);

		$criteria->compare('status', $this->status);

		$criteria->compare('isSuperAdmin', $this->isSuperAdmin);

		$criteria->compare('created', $this->created, true);

		$criteria->compare('modified', $this->modified, true);



		return new CActiveDataProvider($this, array(

			'criteria' => $criteria,

		));

	}
	public static function Viewcalandar()
		{
			 $uid=Yii::app()->user->id;
			 //,year(alert_date) as y,month(alert_date) as m, day(alert_date) as d
			  $sql= 'SELECT DATE_FORMAT(calendar.alert_date,"%Y-%m-%d") as start,calendar.description as title   FROM calendar left join calendar_user on calendar_user.calendar_id=calendar.id WHERE calendar_user.user_id ="'.$uid.'"';
        //$name = $uid;
        return Yii::app()->db->createCommand($sql)->queryAll();
 	
		}

}