<?php

/**
 * This is the model base class for the table "profile".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Profile".
 *
 * Columns in table "profile" available as properties of the model,
 * and there are no model relations.
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $first_name
 * @property string $last_name
 * @property string $state_bar_number
 * @property string $firm_business_name
 * @property string $address
 * @property string $city
 * @property integer $state_id
 * @property string $zip_code
 * @property string $phone_number
 * @property string $fax_number
 * @property string $website
 * @property string $law_school
 * @property string $practice_areas
 * @property string $created
 * @property string $modified
 *
 */
abstract class BaseProfile extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'profile';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Profile|Profiles', $n);
	}

	public static function representingColumn() {
		return 'user_id';
	}

	public function rules() {
		return array(
			array('user_id,first_name, last_name', 'required'),
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('first_name, last_name', 'length', 'max'=>100),
			//array('state_bar_number', 'length', 'max'=>50),
			//array('zip_code, phone_number, fax_number', 'length', 'max'=>20),
			//array('website', 'length', 'max'=>70),
			array('law_school', 'safe'),
			//array('state_bar_number, law_school', 'default', 'setOnEmpty' => true, 'value' => null),
			array('user_id', 'safe', 'on'=>'search'),
                        array(
                                'modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'update'
                            ),
                        array(
                            'created,modified','default',
                            'value'=>new CDbExpression('NOW()'),
                            'setOnEmpty'=>false,'on'=>'insert'
                            ),
		);
	}

	public function relations() {
		return array(
                    'user' => array(self::BELONGS_TO,  'User', 'user_id'),
                    'state' => array(self::BELONGS_TO,  'State', 'state_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'user_id' => Yii::t('app', 'User'),
			'first_name' => Yii::t('app', 'First Name'),
			'last_name' => Yii::t('app', 'Last Name'),
			'state_bar_number' => Yii::t('app', 'State Bar Number'),
			'firm_business_name' => Yii::t('app', 'Firm Business Name'),
			'address' => Yii::t('app', 'Address'),
			'city' => Yii::t('app', 'City'),
			'state_id' => Yii::t('app', 'State'),
			'zip_code' => Yii::t('app', 'Zip Code'),
			'phone_number' => Yii::t('app', 'Phone Number'),
			'fax_number' => Yii::t('app', 'Fax Number'),
			'website' => Yii::t('app', 'Website'),
			'law_school' => Yii::t('app', 'Law School'),
			'practice_areas' => Yii::t('app', 'Practice Areas'),
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('first_name', $this->first_name, true);
		$criteria->compare('last_name', $this->last_name, true);
		$criteria->compare('state_bar_number', $this->state_bar_number, true);
		$criteria->compare('firm_business_name', $this->firm_business_name, true);
		$criteria->compare('address', $this->address, true);
		$criteria->compare('city', $this->city, true);
		$criteria->compare('state_id', $this->state_id);
		$criteria->compare('zip_code', $this->zip_code, true);
		$criteria->compare('phone_number', $this->phone_number, true);
		$criteria->compare('fax_number', $this->fax_number, true);
		$criteria->compare('website', $this->website, true);
		$criteria->compare('law_school', $this->law_school, true);
		$criteria->compare('practice_areas', $this->practice_areas, true);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}