<?php

/**
 * This is the model class for table "salesinvoice".
 *
 * The followings are the available columns in table 'salesinvoice':
 * @property integer $id
 * @property integer $from
 * @property string $to_name
 * @property string $to_address1
 * @property string $to_address2
 * @property string $to_phone
 * @property string $invoice_no
 * @property string $invoice_date
 * @property string $terms
 * @property string $delivery_method
 * @property string $notes
 * @property double $extended_total
 * @property double $shipping
 * @property double $tax
 * @property double $invoice_total
 * @property integer $claim_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Saleinvoiceitem[] $saleinvoiceitems
 * @property Company $from0
 * @property Claim $claim
 */
class Salesinvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Salesinvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'salesinvoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('from, to_name, to_address1, to_phone, invoice_no, invoice_date, extended_total, shipping, tax, invoice_total', 'required'),
			array('from, claim_id', 'numerical', 'integerOnly'=>true),
			array('extended_total, shipping, tax, invoice_total', 'numerical'),
			array('to_name,  delivery_method', 'length', 'max'=>500),
			array('invoice_no', 'length', 'max'=>255),
			array('to_address2, terms, notes', 'safe'),
                    array('to_phone','length','max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, from, to_name, to_address1, to_address2, to_phone, invoice_no, invoice_date, terms, delivery_method, notes, extended_total, shipping, tax, invoice_total, claim_id, created, modified', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'saleinvoiceitems' => array(self::HAS_MANY, 'Saleinvoiceitem', 'saleinvoice_id'),
			'from0' => array(self::BELONGS_TO, 'Company', 'from'),
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'from' => 'From',
			'to_name' => 'To Name',
			'to_address1' => 'To Address1',
			'to_address2' => 'To Address2',
			'to_phone' => 'To Phone',
			'invoice_no' => 'Invoice No',
			'invoice_date' => 'Invoice Date',
			'terms' => 'Terms',
			'delivery_method' => 'Delivery Method',
			'notes' => 'Notes',
			'extended_total' => 'Extended Total',
			'shipping' => 'Shipping',
			'tax' => 'Tax',
			'invoice_total' => 'Invoice Total',
			'claim_id' => 'Claim',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('from',$this->from);
		$criteria->compare('to_name',$this->to_name,true);
		$criteria->compare('to_address1',$this->to_address1,true);
		$criteria->compare('to_address2',$this->to_address2,true);
		$criteria->compare('to_phone',$this->to_phone,true);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('terms',$this->terms,true);
		$criteria->compare('delivery_method',$this->delivery_method,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('extended_total',$this->extended_total);
		$criteria->compare('shipping',$this->shipping);
		$criteria->compare('tax',$this->tax);
		$criteria->compare('invoice_total',$this->invoice_total);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}