<?php

/**
 * This is the model class for table "passanger".
 *
 * The followings are the available columns in table 'passanger':
 * @property integer $id
 * @property string $pw_name
 * @property integer $pw_phone
 * @property string $pw_type
 * @property string $pw_statement
 * @property string $pw_relationship
 * @property integer $claim_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Claim $claim
 */
class Passanger extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Passanger the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'passanger';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, created, modified', 'required'),
			array('claim_id', 'numerical', 'integerOnly'=>true),
			array('pw_name', 'length', 'max'=>60),
			array('pw_type', 'length', 'max'=>9),
			array('pw_statement', 'length', 'max'=>200),
			array('pw_relationship', 'length', 'max'=>8),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, pw_name, pw_phone, pw_type, pw_statement, pw_relationship, claim_id, created, modified', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pw_name' => 'Pw Name',
			'pw_phone' => 'Pw Phone',
			'pw_type' => 'Pw Type',
			'pw_statement' => 'Pw Statement',
			'pw_relationship' => 'Pw Relationship',
			'claim_id' => 'Claim',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pw_name',$this->pw_name,true);
		$criteria->compare('pw_phone',$this->pw_phone);
		$criteria->compare('pw_type',$this->pw_type,true);
		$criteria->compare('pw_statement',$this->pw_statement,true);
		$criteria->compare('pw_relationship',$this->pw_relationship,true);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}