<?php

/**
 * This is the model class for table "company".
 *
 * The followings are the available columns in table 'company':
 * @property integer $id
 * @property string $name
 * @property integer $type_id
 * @property string $address_1
 * @property string $address_2
 * @property string $city
 * @property integer $state_id
 * @property integer $zip_code
 * @property string $phone_num
 * @property string $fax_num
 * @property integer $work_week
 * @property integer $status
 * @property string $file_name
 * @property string $file_extn
 * @property string $company_guidelines
 * @property integer $is_active
 * @property integer $is_body_shop_selection
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Branch[] $branches
 */
class Company extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Company the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'company';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		array('name,type_id','required'),
			array('type_id, state_id, zip_code, work_week, status, is_active, is_body_shop_selection', 'numerical', 'integerOnly'=>true),
			//array('name, address_1, address_2, city', 'length', 'max'=>50),
			array('phone_num, fax_num', 'length', 'max'=>20),
			//array('file_name', 'length', 'max'=>100),
            array('file_name', 'file', 'allowEmpty'=>true, 'types'=>'jpg, jpeg,png,gif', 'message'=>'Only jpg,jpeg,png,gif files are allowed'),			array('file_extn', 'length', 'max'=>255),
			array('company_guidelines, created, modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, type_id, address_1, address_2, city, state_id, zip_code, phone_num, fax_num, work_week, status, file_name, file_extn, company_guidelines, is_active, is_body_shop_selection, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'branches' => array(self::HAS_MANY, 'Branch', 'company_id'),
                        'companytypes' => array(self::BELONGS_TO, 'Companytype', 'type_id'),
                    'cmpstate' => array(self::BELONGS_TO, 'State', 'state_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Company Name',
			'type_id' => ' Company Type',
			'address_1' => 'Address Line 1',
			'address_2' => 'Address Line 2',
			'city' => 'City',
			'state_id' => 'State',
			'zip_code' => 'Zip Code',
			'phone_num' => 'Company Phone',
			'fax_num' => 'Company Fax',
			'work_week' => 'Work Week',
			'status' => 'Status',
			'file_name' => 'File Name',
			'file_extn' => 'File Extn',
			'company_guidelines' => 'Company Guidelines',
			'is_active' => 'Is Active',
			'is_body_shop_selection' => 'Is Body Shop Selection',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('address_1',$this->address_1,true);
		$criteria->compare('address_2',$this->address_2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('zip_code',$this->zip_code);
		$criteria->compare('phone_num',$this->phone_num,true);
		$criteria->compare('fax_num',$this->fax_num,true);
		$criteria->compare('work_week',$this->work_week);
		$criteria->compare('status',$this->status);
		$criteria->compare('file_name',$this->file_name,true);
		$criteria->compare('file_extn',$this->file_extn,true);
		$criteria->compare('company_guidelines',$this->company_guidelines,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('is_body_shop_selection',$this->is_body_shop_selection);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
//
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}