<?php

/**
 * This is the model class for table "branch".
 *
 * The followings are the available columns in table 'branch':
 * @property integer $id
 * @property string $branch_name
 * @property integer $company_id
 * @property string $address1
 * @property string $address2
 * @property string $city
 * @property integer $state_id
 * @property string $zip
 * @property string $phone
 * @property string $fax
 * @property double $inspectionfee
 * @property double $milagefee
 * @property double $aftermiles
 * @property double $photosonlyfee
 * @property double $totallossfee
 * @property double $fuelsurcharge
 * @property double $reinspectionfee
 * @property double $supplementfee
 * @property double $salestax
 * @property string $zipcodecoverage
 * @property string $requirements
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Company $company
 * @property State $state
 * @property Claim[] $claims
 * @property User[] $users
 */
class Branch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Branch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('branch_name, company_id', 'required'),
			array('company_id, state_id', 'numerical', 'integerOnly'=>true),
			array('inspectionfee, milagefee,  photosonlyfee, totallossfee, fuelsurcharge, reinspectionfee, supplementfee, salestax', 'numerical'),
			array('branch_name, zipcodecoverage', 'length', 'max'=>500),
                        array('zip','length', 'max'=>5),
			array('city, zip, phone, fax', 'length', 'max'=>255),
			array('address1, address2, requirements', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, branch_name, company_id, address1, address2, city, state_id, zip, phone, fax, inspectionfee, milagefee, aftermiles, photosonlyfee, totallossfee, fuelsurcharge, reinspectionfee, supplementfee, salestax, zipcodecoverage, requirements, created, modified', 'safe', 'on'=>'search'),
			array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
			'state' => array(self::BELONGS_TO, 'State', 'state_id'),
			'claims' => array(self::HAS_MANY, 'Claim', 'branch_id'),
			'users' => array(self::HAS_MANY, 'User', 'branch_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'branch_name' => 'Branch Name',
			'company_id' => 'Company',
			'address1' => 'Address Line 1',
			'address2' => 'Address Line 2',
			'city' => 'City',
			'state_id' => 'State',
			'zip' => 'Zip',
			'phone' => 'Branch Phone',
			'fax' => 'Branch Fax',
			'inspectionfee' => 'Inspection Fee',
			'milagefee' => 'Milage Fee',
			'aftermiles' => 'After',
			'photosonlyfee' => 'Photos Only Fee',
			'totallossfee' => 'Total Loss Fee',
			'fuelsurcharge' => 'Fuel Surcharge',
			'reinspectionfee' => 'Reinspection Fee',
			'supplementfee' => 'Supplement Fee',
			'salestax' => 'Sales Tax',
			'zipcodecoverage' => 'Zip Code Coverage',
			'requirements' => 'Branch Requirements',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('branch_name',$this->branch_name,true);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('zip',$this->zip,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('inspectionfee',$this->inspectionfee);
		$criteria->compare('milagefee',$this->milagefee);
		$criteria->compare('aftermiles',$this->aftermiles);
		$criteria->compare('photosonlyfee',$this->photosonlyfee);
		$criteria->compare('totallossfee',$this->totallossfee);
		$criteria->compare('fuelsurcharge',$this->fuelsurcharge);
		$criteria->compare('reinspectionfee',$this->reinspectionfee);
		$criteria->compare('supplementfee',$this->supplementfee);
		$criteria->compare('salestax',$this->salestax);
		$criteria->compare('zipcodecoverage',$this->zipcodecoverage,true);
		$criteria->compare('requirements',$this->requirements,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}