<?php

/**
 * This is the model class for table "adjstersupervising".
 *
 * The followings are the available columns in table 'adjstersupervising':
 * @property integer $id
 * @property integer $adjuster_id
 * @property integer $superwiser_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property User $superwiser
 * @property User $adjuster
 */
class Adjstersupervising extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Adjstersupervising the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'adjstersupervising';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('adjuster_id, superwiser_id,created_by', 'required'),
			array('adjuster_id, superwiser_id,created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, adjuster_id, superwiser_id, created, modified', 'safe', 'on'=>'search'),
                     array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'superwiser' => array(self::BELONGS_TO, 'User', 'superwiser_id'),
			'adjuster' => array(self::BELONGS_TO, 'User', 'adjuster_id'),
                        'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}
        
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'adjuster_id' => 'Adjuster',
			'superwiser_id' => 'Superwiser',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('adjuster_id',$this->adjuster_id);
		$criteria->compare('superwiser_id',$this->superwiser_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}