<?php

class BroadcastmessageController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Broadcastmessage;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                
		if(isset($_POST['Broadcastmessage']))
		{
			$model->attributes=$_POST['Broadcastmessage'];
                        $model->comany_id=$_POST['Company']['id'];
                        $model->company_type=$_POST['Company']['type_id'];
                        $model->created_by=Yii::app()->user->id;   
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
                $type=  UserController::getTypeid(Yii::app()->user->id);
                $ub=User::model()->findByPk(Yii::app()->user->id);
                $ctype=  Usertype::model()->findByPk($type);
                $utype=new Usertype();
                  $q=new CDbCriteria;
                  $q->compare('t.id',$ctype->companytype);
                  //$cmptypes=
                    $branch=new Branch;
                    
                        $branches=$branch->findAll('',array('id','branch_name'));
                     
                 $assign=new Authassignment;
                 $cmp=new Company;
                $cmptype=new Companytype;
                  if($type<=5)
                      $cmptypes=$cmptype->findAll(array('id','type'));
                  else                    
                        $cmptypes=$cmptype->findAll($q,array('id','type'));
                    $companies=$cmp->findAll('', array('id','name'));
                
		$this->render('create',array(
			'model'=>$model,
                        'branches'=>$branches,
                        'cmptypes'=>$cmptypes,
                        'companies'=>$companies,
                        'cmp'=>$cmp,
		));
	}
         public function actionGetcmp(){
            $ub=User::model()->findByPk(Yii::app()->user->id);
            $q=new CDbCriteria;
                  $q->compare('t.id',$ctype->companytype);
                $typ = new Company;
                $c = new CDbCriteria;
				$c->select='t.id,t.name';
                $c->join = 'left join companytype on companytype.id=t.type_id';
                $c->join='left join branch on branch.company_id.t.id';
                $
                $c->compare('t.type_id',$_REQUEST['Company']['type_id']); 
                $data = $typ->findAll($c);
				
                $data=CHtml::listData($data,'id','name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($_POST['Company']['type_id']!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Broadcastmessage']))
		{
			$model->attributes=$_POST['Broadcastmessage'];
                         $model->comany_id=$_POST['Company']['id'];
                        $model->company_type=$_POST['Company']['type_id'];
                        $model->created_by=Yii::app()->user->id; 
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}
                  $branch=new Branch;
		$branches=$branch->findAll('',array('id','branch_name'));
                 $assign=new Authassignment;
                 $cmp=new Company;
                $cmptype=new Companytype;
		$cmptypes=$cmptype->findAll('',array('id','type'));
		$companies=$cmp->findAll('', array('id','name'));
                
		$this->render('update',array(
			'model'=>$model,
                        'branches'=>$branches,
                        'cmptypes'=>$cmptypes,
                        'companies'=>$companies,
                        'cmp'=>$cmp,
		));
		 
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Broadcastmessage');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Broadcastmessage('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Broadcastmessage']))
			$model->attributes=$_GET['Broadcastmessage'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Broadcastmessage the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Broadcastmessage::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Broadcastmessage $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='broadcastmessage-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
