<?php

/**
 * This is the model class for table "useraddress".
 *
 * The followings are the available columns in table 'useraddress':
 * @property integer $id
 * @property integer $user_id
 * @property string $address1
 * @property string $address2
 * @property string $city
 * @property integer $state_id
 * @property string $county
 * @property string $zip
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property User $user
 * @property State $state
 */
class Useraddress extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Useraddress the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'useraddress';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id', 'required'),
			array('user_id, state_id,zip,country_id', 'numerical', 'integerOnly'=>true),
			array('city, county', 'length', 'max'=>255),
                        array('zip','length','min'=>5,'max'=>5),
                        array('city', 'length', 'max'=>30),
                        array('address1, address2', 'length', 'max'=>60),
			array('address1, address2', 'safe'),
                        array('home_fax,office_fax','length','max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_id,country_id, address1, address2, city, state_id, county, zip, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
			'state' => array(self::BELONGS_TO, 'State', 'state_id'),
                        'country'=>array(self::BELONGS_TO,'Country','country_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city' => 'City',
			'state_id' => 'State',
			'county' => 'County',
                        'counntry_id'=>'Country',
			'zip' => 'Zip',
                        'office_fax'=>'Office Fax',
                        'home_fax'=>'Home Fax',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('county',$this->county,true);
		$criteria->compare('zip',$this->zip,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}