<?php

/**
 * This is the model class for table "messagestatus".
 *
 * The followings are the available columns in table 'messagestatus':
 * @property integer $id
 * @property integer $by_user
 * @property integer $inbox_id
 * @property string $created
 * @property string $modified
 * @property integer $type_id
 * @property integer $active
 *
 * The followings are the available model relations:
 * @property Messagetype $type
 * @property User $byUser
 * @property User $inbox
 */
class Messagestatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Messagestatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'messagestatus';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('by_user, inbox_id,  type_id', 'required'),
			array('by_user, inbox_id, type_id, active', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, by_user, inbox_id, created, modified, type_id, active', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                                    ),
                            array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                                ),  
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'type' => array(self::BELONGS_TO, 'Messagetype', 'type_id'),
			'byUser' => array(self::BELONGS_TO, 'User', 'by_user'),
			'inbox' => array(self::BELONGS_TO, 'Messageinbox', 'inbox_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'by_user' => 'By User',
			'inbox_id' => 'Inbox',
			'created' => 'Created',
			'modified' => 'Modified',
			'type_id' => 'Type',
			'active' => 'Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('by_user',$this->by_user);
		$criteria->compare('inbox_id',$this->inbox_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('type_id',$this->type_id);
		$criteria->compare('active',$this->active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}