<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class ChangePasswordForm extends CFormModel
{
  public $currentPassword;
  public $newPassword;
  public $newPassword_repeat;
  private $_user;
  
  public function rules()
  {
    return array(
      array(
        'currentPassword', 'compareCurrentPassword'
      ),
          array('currentPassword,accept', 'safe'),                        
  array('newPassword,accept', 'safe'),                        
  array('newPassword_repeat,accept', 'safe'),                        

      array(
        'currentPassword, newPassword, newPassword_repeat', 'required',
        'message'=>'Introduzca su {attribute}.',
      ),
      array(
        'newPassword_repeat', 'compare',
        'compareAttribute'=>'newPassword',
        'message'=>'La contraseña nueva no coincide.',
      ),
      
    );
  }
 public function actionChangePassword()
  {
    $model = new ChangePasswordForm;
    if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
    {
      echo CActiveForm::validate($model);
      Yii::app()->end();
    }

    // collect user input data
    if(isset($_POST['ChangePasswordForm']))
    {
      $model->attributes=$_POST['ChangePasswordForm'];
      // Validar input del usuario y cambiar contraseña.
      if($model->validate() && $model->changePassword())
      {
       Yii::app()->user->setFlash('success', '<strong>Éxito!</strong> Su contraseña fue cambiada.');
       $this->redirect( $this->action->id );
      }
    }
    // Mostrar formulario de cambio de contraseña.
    $this->render('changePassword',array('model'=>$model));
  }

  public function compareCurrentPassword($attribute,$params)
  {
     $model=new User;
    $user = User::model()->findByPk(Yii::app()->user->id);
   
    if ($user->password != $_POST['User']['currentPassword'])
           $this->addError($attribute, 'Old password is incorrect.');
    
  }
  
  public function init()
  {
    $this->_user = User::model()->findByAttributes( array( 'username'=>Yii::app()->User->username ) );
  }
  
  public function attributeLabels()
  {
    return array(
      'currentPassword'=>'Contraseña actual',
      'newPassword'=>'Nueva contraseña',
      'newPassword_repeat'=>'Nueva contraseña (Repetir)',
    );
  }
  
  public function changePassword()
  {
    $this->_user->password = $this->newPassword;
    if( $this->_user->save() )
      return true;
    return false;
  }
}