<?php

/**
 * This is the model class for table "ability_permission".
 *
 * The followings are the available columns in table 'ability_permission':
 * @property integer $id
 * @property integer $menu_id
 * @property integer $ability_id
 * @property integer $claim_status
 * @property string $usertype
 */
class AbilityPermission extends MyActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ability_permission';
	}
        public function getDbConnection()
            {
                return self::getAdvertDbConnection();
            }
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('menu_id, ability_id, usertype', 'required'),
			array('menu_id, ability_id, claim_status', 'numerical', 'integerOnly'=>true),
			array('usertype', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, menu_id, ability_id, claim_status, usertype', 'safe', 'on'=>'search'),
		);
	}
        public function getability($claim_id)
                {
                     $controller= $menu=Yii::app()->controller->id;
                        $menu=$menu=Yii::app()->controller->action->id;
                        $m=$controller.".".$menu;
                        if($m=="cliam.basicsearch")
                            $m="claim.search";
                        elseif($m=="cliam.simplesearch")
                            $m="claim.search";
                        $md=new Menuitem;
                        $q=new CDbCriteria;
                        $q->select='t.item_id';
                        $q->compare('t.url',$m);
                        $mid=$md->findAll($q);
                       //var_dump($mid);
                      foreach($mid as $mt)
                      {
                         $menuid=$mt->item_id; 
                      }
                    /*  $cm=new ClaimStatus();
                       $q=new CDbCriteria;
                       $q->compare('t.claim_id',$claim_id);
                       $q->compare('t.active',1);
                       $q->order="t.created desc";
                       $claimstatu=$cm->findAll($q);
                       foreach($claimstatu as $st)
                       { 
                           $status=$st->status_id;
                       }*/
                      $utype=  UserController::getTypeid(Yii::app()->user->id);
                       $arule=new Action();
                       $act=new ActionApply();
                        $criteria=new CDbCriteria;
                  $criteria->select='t.by_utype,t.action,t.created,t.claim_id';
                 $criteria->condition = " t.active =1 and t.claim_id=".$claim_id;
                 $clist=$act->findAll($criteria);
                // var_dump($clist);
                 foreach($clist as $ct)
                 {
                   $cstatus= $arule->checkmoverule($ct->action,$ct->by_utype,$utype); 
                    foreach($cstatus as $sta)
                    {
                        $status=$sta->move_into_status;
                         
                    }
                 }
                       $uid=Yii::app()->user->id;
                        $tyoeid=  UserController::getTypeid($uid);
                     $db=$this->getDbConnection();
                        
                        $mode=new AbilityPermission();
                         $c = new CDbCriteria;
                        $c->compare('t.usertype',$tyoeid);
                        $c->compare('t.menu_id',$menuid);
                        $c->compare('t.claim_status',$status);
                        $results = $mode->findAll($c); 
                        $arr=array();
                        $i=0;
                        foreach($results as $res)
                        {
                           $abc=  Ability::model()->findbyPk($res->ability_id);
                           $tem=array($i=>array('id'=>$abc->id,'ability_name'=>$abc->ability_name));
                           $arr=array_merge($tem,$arr);
                           
                            $i++;
                        }
                        //var_dump($results);
                        /*$results = Yii::app()->getDb()->createCommand();
                    $results->select('assigned_to')->from('assignpermission');
                    $results->where('assigned_by='.$uid);*/
                    //$results->order('sort_order ASC, label ASC');
                //$arr=array();
               return $arr ;//= $results->queryAll();
                }
	/**
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'menu_id' => 'Menu',
			'ability_id' => 'Ability',
			'claim_status' => 'Claim Status',
			'usertype' => 'Usertype',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('menu_id',$this->menu_id);
		$criteria->compare('ability_id',$this->ability_id);
		$criteria->compare('claim_status',$this->claim_status);
		$criteria->compare('usertype',$this->usertype,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AbilityPermission the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
