<?php

class TimezoneController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                        'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
public function timezoneList()
		{
			$timezoneIdentifiers = DateTimeZone::listIdentifiers();
			$utcTime = new DateTime('now', new DateTimeZone('UTC'));

			$tempTimezones = array();
			foreach ($timezoneIdentifiers as $timezoneIdentifier) {
				$currentTimezone = new DateTimeZone($timezoneIdentifier);

				$tempTimezones[] = array(
					'offset' => (int)$currentTimezone->getOffset($utcTime),
					'identifier' => $timezoneIdentifier
				);
			}

			// Sort the array by offset,identifier ascending
			usort($tempTimezones, function($a, $b) {
				return ($a['offset'] == $b['offset'])
					? strcmp($a['identifier'], $b['identifier'])
					: $a['offset'] - $b['offset'];
			});

			$timezoneList = array();
			foreach ($tempTimezones as $tz) {
				$sign = ($tz['offset'] > 0) ? '+' : '-';
				$offset = gmdate('H:i', abs($tz['offset']));
				$timezoneList[$tz['identifier']] = '(UTC ' . $sign . $offset . ') ' .
					$tz['identifier'];
			}

			return $timezoneList;
		}
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Timezone;
                    $tz=$this->timezoneList();
                 $c = new CDbCriteria;
                 $c->compare('t.user_id',Yii::app()->user->id);
                 $rs=$model->find($c);
                 if($rs!='')
                      $this->redirect(array('update','id'=>$rs->id));
                  // var_dump($tz);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Timezone']))
		{
			$model->attributes=$_POST['Timezone'];
                        $model->user_id=Yii::app()->user->id;
			if($model->save())
			{	
                             Yii::app()->user->setFlash('success','TimeZone has been set successfully');
                         
                            $this->redirect(array('update','id'=>$model->id));
                        }
		}

		$this->render('create',array(
			'model'=>$model,
                        'tz'=>$tz,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                     $tz=$this->timezoneList();
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Timezone']))
		{
			$model->attributes=$_POST['Timezone'];
			if($model->save())
			{	
                            
                          

    Yii:app()->timeZone = $_POST['Timezone']['zone'];
                           date_default_timezone_set($_SESSION['time_zone']);
                             Yii::app()->user->setFlash('success','TimeZone has been set successfully');
                         
                            $this->redirect(array('update','id'=>$model->id));
                        }
		}

		$this->render('update',array(
			'model'=>$model,
                        'tz'=>$tz,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Timezone');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Timezone('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Timezone']))
			$model->attributes=$_GET['Timezone'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Timezone the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Timezone::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Timezone $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='timezone-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
