<?php

class MessageinboxController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
        public function allowedActions() {
           return 'GetUid,search,GetMessage,TrashMessage';
        }
        public function actionTrashMessage()
        {
            $id=$_REQUEST['id'];
            if($_REQUEST['type']=='trash')
            {  
                $typeid=3;
               // Yii::app()->user->setFlash('success','Message has been sent to Trash');
            }
            else if($_REQUEST['type']=='archive')
            { $typeid=4;
            
           // Yii::app()->user->setFlash('success','Message has been sent to Archive');
            }
            $uid=Yii::app()->user->id;
            $rs=Messageinbox::model()->findByPk($id);
             Messagestatus::model()->updateAll(array('active'=>0),
                                   'by_user='.$uid.' and inbox_id='.$id);
                          
             $mstatu=new Messagestatus;
            $mstatu->by_user=$uid;
            $mstatu->inbox_id=$rs->id;
            $mstatu->type_id=$typeid; //Sent
            $mstatu->active=1;
            $mstatu->save();
            
            return true;
        }
        public function actionGetMessage()
        {
            $id=$_REQUEST['id'];
           $model=new Messageinbox;
           $sql="select t.*,f.username as frm ,tm.username as trm from messageinbox t"
                   . " left join user f on f.id=t.frommsg left join user tm on tm.id=t.tomsg "
                   . " where t.id=:rid";
           $rid=$id;
               $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':rid'=>$rid));
 
            //$rs=Messageinbox::model()->findByPk($id);
           // var_dump($rs);
          
             echo CJSON::encode($data);
             //echo CJSON::encode($rs);
            Yii::app()->end();
        }
        public function actionGetUid()
        {
            $model=new User;
            $c=new CDbCriteria;
            $c->compare('t.username',$_POST['username']);
            $mode=$model->find($c);
            //echo $mode->id;
            if($mode!=null)
                echo $mode->id;
           else
               echo 0;
        }
        public function actionSearch()
        {
            
              $model=new Messageinbox('fullsearch');
		$model->unsetAttributes();  // clear any default values
		
            $this->render('create',array(
			'model'=>$model,
                       //$dataProvider=>''
		));
        }
	public function actionCreate()
	{
		$model=new Messageinbox;

		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);
                if(!isset($_POST['ajax']))
                {
		if(isset($_POST['Messageinbox']))
		{
			$model->attributes=$_POST['Messageinbox'];
                       // var_dump($_POST['Messageinbox']);
			if($model->save())
                        {
                            //Messagestatus::model()->updateAll(array('active'=>0),
                             //       'by_user='.$_POST['Messageinbox']['frommsg'].' and inbox_id='.$model->id);
                            $mstatu=new Messagestatus;
                            $mstatu->by_user=$_POST['Messageinbox']['frommsg'];
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=2; //Sent
                            $mstatu->active=1;
                            $mstatu->save();
                             $mstatu=new Messagestatus;
                            $mstatu->by_user=$_POST['Messageinbox']['tomsg'];
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=1; //Inbox
                            $mstatu->active=1;
                            $mstatu->save();
                            Yii::app()->user->setFlash('success','Message has been sent successfully');
                           //$this->redirect(array('view','id'=>$model->id));
                            
                        }
		}
                }
                $mod=new Messageinbox('fullsearch');
		$mod->unsetAttributes();  // clear any default values
		if(isset($_GET['Messageinbox']))
			$mod->attributes=$_GET['Messageinbox'];
                 
                    
		$this->render('create',array(
			'model'=>$model,
                        'mod'=>$mod,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
	$this->performAjaxValidation($model);

		if(isset($_POST['Messageinbox']))
		{
			$model->attributes=$_POST['Messageinbox'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Messageinbox');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Messageinbox('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Messageinbox']))
			$model->attributes=$_GET['Messageinbox'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Messageinbox the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Messageinbox::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Messageinbox $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='messageinbox-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
