<?php

if(!defined('__SWS__')) exit;

function getParaentidOfstatuslog($claim_id)
{
	  global $db;
	$s="select id from status_logs where type_id = '".$claim_id."' and type = 'claim' and new_status=1 order by date_created desc limit 1";

	 $rs = $db->get_results($s);

	 if(count($rs)>0)

	 	{

			foreach($rs as $val)

			{
				return $val->id;
			}
		}
}

function create_metadata() {

  global $db;

  $q = "select name  as title, keywords, meta_description as description from settings limit 1";

  $metadata = $db->get_row($q);

  

  return "<title>". trim(htmlentities($metadata->title)). "</title>\n".

         "<meta name=\"description\" content=\"". trim(htmlentities($metadata->description)) . "\" />\n".

         "<meta name=\"keywords\" content=\"". trim(htmlentities($metadata->keywords)) . "\" />\n";

}



function isAuth() {

  if(!isset($_SESSION['current_user_id']) || $_SESSION['current_user_id'] == '') {

    redirect('./?sws=static/page&slug=login&status='.base64_encode('expired'));

  }

}

//DeepakCreated Function to check, if a claim is in the Assigned to IA state for any user

function secondaryArchiveTest($user = null, $claim = null, $type = null,$company = null, $branch = null){
	global $db;	
	
	$q=" select count(*) as cnt from claim_assignment_user left join users ON users.id=claim_assignment_user.user_id where users.user_type='".$type."' and  users.company_id='".$company."' and users.branch_id='".$branch."' and (claim_assignment_user.type1 LIKE '%$claim%' or claim_assignment_user.type2 LIKE '%$claim%' or claim_assignment_user.type3 LIKE '%$claim%' or claim_assignment_user.type4 LIKE '%$claim%' or claim_assignment_user.type5 LIKE '%$claim%')";
	
	$rs=$db->get_results($q);
	if($rs[0]->cnt >= 1){		
		return true;
	}
	return false;
}

function checkForIA($user = null, $claim = null, $type = null,$company = null, $branch = null){
	global $db;	
	$q = "select distinct(claim_assignment_user.type3) from claim_assignment_user left join users ON users.id=claim_assignment_user.user_id where claim_assignment_user.type3 like %% and users.user_type='".$type."' and  users.company_id='".$company."' and users.branch_id='".$branch."'";
	
	$q = "select count(type3) as cnt from claim_assignment_user left join users ON users.id=claim_assignment_user.user_id where users.user_type='$type' and users.company_id='$company' and users.branch_id='$branch' and claim_assignment_user.type3 LIKE '%$claim%'";
	
	$rs=$db->get_results($q);	
	if($rs[0]->cnt >= 1){		
		return true;
	}
	return false;
}

function isAuthorized($return_url = null) {

  if(isset($return_url) && $return_url !='') {

    redirect($return_url.'&status='.base64_encode('unauthorized'));

  } else {

    redirect('./?sws=admin/settings&status='.base64_encode('unauthorized'));

  }

}



function getUserTypeName($user_type) {

  switch($user_type) {

    case'24':   return "Third Party Dispatcher"; // Third Party Company User

    case'23':   return "Third Party Adjuster"; // Third Party Company User

    case'22':   return "Third Party Adjuster Supervisor"; // Third Party Company User

    case'21':   return "Third Party Branch Admin"; // Third Party Company User

    case'20':   return "Third Party Company Admin"; // Third Party Company User

    

    case'19':   return "Body Shop Employee"; // Body Shop Company User

    case'18':   return "Body Shop Estimator"; // Body Shop Company User

    case'17':   return "Body Shop Branch Admin"; // Body Shop Company User

    case'16':   return "Body Shop Company Admin"; // Body Shop Company User

    

    case'15':   return "Call Center"; // Insurance Company User

    case'14':   return "Dispatcher"; // Insurance Company User

    case'13':   return "Reinspector"; // Insurance Company User

    case'12':   return "Desk Reviewer"; // Insurance Company User

    case'11':   return "Insurance Company Admin"; // Insurance Company User

    case'10':   return "Branch Admin"; // Insurance Company User

    case'9':    return "Adjuster Supervisor"; // Insurance Company User

    case'8':    return "Adjuster"; // Insurance Company User

    case'7':    return "In-House Appraiser"; // Insurance Company User

    

    case'26':   return "Call Center Branch Employee"; // Appraisal Call Center Branch Employee (New User)

    case'25':   return "Call Center Branch Admin"; // Appraisal Call Center Branch Admin (New User)

    case'6':    return "Desk Reviewer"; // Appraisal Company User

    case'5':    return "Appraisal Company Admin"; // Appraisal Company User

    case'4':    return "Branch Admin"; // Appraisal Company User

    case'3':    return "Employee";  // Appraisal Company User

    case'2':    return "Appraiser"; // Appraisal Company User

    

    case'1':    return "Global Admin";

    case'111':  return "Super Global Admin";

    default:    return "Non-valid";

  }

}



function getClaimStatus($status) {

  switch($status) {

    case '1':  return "Open";

    case '2':  return "Closed";

    case '3':  return "Canceled";

    case '4':  return "Completed";

    case '5':  return "Deleted";

    case '6':  return "Assigned";

    default:  return "Open";

  }

}



function getClaimInfoById($claim_id) {

  global $db;

  $q = "select * from claims where id = '".$claim_id."' limit 1";

  return $db->get_row($q);

}



function getWhoClaimCreatedByClaimId($claim_id) {

  global $db;

  $q = "select claim_created_by from claims where id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getCompanyIdByClaimId($claim_id) {

  global $db;

  $q = "select company_id from claims where id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}

function getbranchBycompanyid($comid,$is_other)

{
	 global $db;

  $q = "select id,name from  branches where cid = '".$comid."'  ";
$rs=$db->get_results($q);
  foreach($rs as $row) {

    $users_dom[$row->id] = stripslashes($row->name);

  }

  

  if($is_other == true) $users_dom['other'] = 'Other Branch';

  return $users_dom;
}
function getCompanyIdByBranchId($branch_id) {

  global $db;

  $q = "select cid from  branches where id = '".$branch_id."' limit 1";

  return $db->get_var($q);

}



function getClaimStateIdById($claim_id) {

  global $db;

  $q = "select vehicle_state from claims where id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getClaimStatusById($claim_id) {

  global $db;

  $q = "select status from claims where id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function setClaimStatusById($claim_id, $status) {

  global $db;

  $q = "update claims set status = '".$status."' where id = '".$claim_id."'";

  $db->query($q);

  return true;

}



function getUserDateTimeByTimeZone($user_time_zone) {

  if($user_time_zone !='') {

    $timezone_offset = $user_time_zone;

    $date = gmdate('Y-m-d H:i:s', time()+$timezone_offset*60*60);

    $currenttime = strtotime($date);

    return date("F, d, Y - h:i A", $currenttime);

  } else {

    return date('F, d, Y - h:i A', time());

  }

}



function getUserInfo($user_id, $fields = array()) {

  global $db;

  if(!empty($fields) && count($fields) > 0) {

    $column_names = implode(', ', $fields);

    $q = "select $column_names from users where id = '".$user_id."' limit 1";

  } else {

    $q = "select users.*, concat(firstname,' ',lastname) as fullname from users where id = '".$user_id."' limit 1";

  }

  

  $user_info = $db->get_row($q);

  return $user_info;

}



function getUserIdByUsername($user_name) {

  global $db;

  $q = "select id from users where username = '".$user_name."' limit 1";

  $user_id = $db->get_var($q);

  return $user_id;

}


function getAPPRAISERInvoiceByClaimId($claim_id)
{
	  global $db;

  $sql = "select * from appraisal_invoices where claim_id = '".$claim_id."' order by id desc";

  $invoice_info = $db->get_row($sql);

  return $invoice_info;

}

function getREVIEWERInvoiceByClaimId($claim_id)
{
	  global $db;

  $sql = "select * from reviewer_invoices where claim_id = '".$claim_id."' order by id desc";

  $invoice_info = $db->get_row($sql);

  return $invoice_info;

}

function getInvoiceByClaimId($claim_id) {

  global $db;

  $sql = "select * from invoices where claim_id = '".$claim_id."' order by id desc";

  $invoice_info = $db->get_row($sql);

  return $invoice_info;

}

function getInvoiceCMPByClaimId($claim_id) {

  global $db;

  $sql = "select * from appraisal_cmp_invoices where claim_id = '".$claim_id."' order by id desc";

  $invoice_info = $db->get_row($sql);

  return $invoice_info;

}

function getClaimSummaryInfobyId($claim_id) {

  global $db;

  $q = "select * from claim_summaries where claim_id = '".$claim_id."' limit 1";

  $summary_info = $db->get_row($q);

  return $summary_info;

}



function getSummaryIdByClaimId($claim_id) {

  global $db;

  $q = "select id from claim_summaries where claim_id = '".$claim_id."' limit 1";

  $summary_id = $db->get_var($q);

  return $summary_id;

}



function getUserNameById($user_id) {

  global $db;

  $q = "select concat(firstname,' ',lastname) as fullname from users where id = '".$user_id."' limit 1";

  $fullname = $db->get_var($q);

  return stripslashes($fullname);

}



function getUserTypeById($user_id) {

  global $db;

  $q = "select user_type from users where id = '".$user_id."' limit 1";

  $user_type = $db->get_var($q);

  return $user_type;

}



function getBroadCast() {

  global $db;

  

  if($_SESSION['current_usertype'] == '1') {

    $q = "SELECT * FROM broadcast WHERE type = 'global' order by date_created asc";

  } else {

    //Appraisal|BodyShop Company Admin OR Insurance Company Admin...

    if($_SESSION['current_usertype'] == '5' || $_SESSION['current_usertype'] == '11') {

      $sql = "select id from branches where cid = '".$_SESSION['current_company_id']."'";

      $broadcast_branches = $db->query($sql);

      $branch_where = '';

      if(count($broadcast_branches) > 0) {

        foreach($broadcast_branches as $broadcast_branch) {

          $cid = $_SESSION['current_company_id'];

          $bid = $broadcast_branch->id;

          $branch_where .= " or (type_id = '$bid')";

        }

      }

      $q = "SELECT * FROM broadcast WHERE (type_id = '$cid') $branch_where or type = 'global' order by date_created asc"; 

    

    } else {

      // Branch OR Branch Users...

      $cid = $_SESSION['current_company_id'];

      $bid = $_SESSION['current_branch_id'];

      $q = "SELECT * FROM broadcast WHERE (type_id = '$cid') or (type_id = '$bid') or type = 'global' order by date_created asc"; 

    }

  }

  

  $broad_casts = $db->get_results($q);

  return $broad_casts;

}



function getCountryList() {

  global $db;

  $q = "select * from countries order by name asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $country_dom[$row->id] = stripslashes($row->name);

  }

  return $country_dom;

}



function getCountryById($country_id) {

  global $db;

  $q = "select name from countries where id = '".$country_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}



function getStatesByCountryId($country_id, $is_other = false) {

  global $db;

  $q = "select * from country_states where country_id = '".$country_id."' order by name asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $states_dom[$row->id] = stripslashes($row->name);

  }

  if($is_other == true) $states_dom['other'] = 'Other';

  return $states_dom;

}



function getStateById($state_id) {

  global $db;

  $q = "select name from country_states where id = '".$state_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}



function setStateById($country_id, $state_name) {

  global $db;

  $new_state_id = create_guid();

  $q = "insert into country_states set id = '".$new_state_id."', country_id = '".$country_id."', name = '".addslashes($state_name)."'";

  $db->query($q);

  return $new_state_id;

}



function PickUsername($user_id, $pick_username) {

  global $db;

  if($user_id !='') $q = "select count(*) from users where username = '".$pick_username."' and id != '$user_id'";

  else $q = "select count(*) from users where username = '".$pick_username."'";

  $user_count = $db->get_var($q);

  if($user_count != '0') return false;

  else return true;

}



function getMakeNameById($make_id) {

  global $db;

  $q = "select make from makes where id = '".$make_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}



function getModelNameById($model_id) {

  global $db;

  $q = "select model from models where id = '".$model_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}



function getMakesDom($is_other = false) {

  global $db;

  $q = "select * from makes order by make asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $makes_dom[$row->id] = stripslashes($row->make);

  }

  if($is_other == true) $makes_dom['other'] = 'Other';

  return $makes_dom;

}



function getModelsDomByMakeId($make_id, $is_other = false) {

  global $db;

  $q = "select * from models where mid = '".$make_id."' order by model asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $models_dom[$row->id] = stripslashes($row->model);

  }

  if($is_other == true) $models_dom['other'] = 'Other';

  return $models_dom;

}



function getCompaniesDomByType($type, $is_other = false) {

  global $db;

  

  if($type == 'all') $q = "select id, name from companies where id != '1' order by name asc";

  else if($type == 'ins') $q = "select id, name from companies where id != '1' and (type = '1' or type = '4') order by name asc";

  else if($type == 'app') $q = "select id, name from companies where id != '1' and (type = '2' or type = '3') order by name asc";
else if($type=='insurance-company') $q="select id, name from companies where type = '1'  order by name asc";
else if($type=='appraisal-company') $q="select id, name from companies where type = '2'  order by name asc";
  else $q = "select id, name from companies where id != '1' and type = '".$type."' order by name asc";

  

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $companies_dom[$row->id] = stripslashes($row->name);

  }

  

  if($is_other == true) {

    $sql = "select id, name from companies where id = '1'";

    $other_rs = $db->get_row($sql);

    if(!empty($other_rs)) {

      $companies_dom[$other_rs->id] = stripslashes($other_rs->name); 

    }

  }

  

  return $companies_dom;

}



function getBranches($branch_types = false, $state_id = 0, $company_id = '') {

  global $db;

  

  if(is_array($branch_types) && count($branch_types) > 0) {

    $where = array();

    foreach($branch_types as $branch_type) {

       $where[] = "branch_type = '$branch_type'";

    }

    $where_clause = build_where_clause_in_or_condition($where);

  } else {

    if($branch_types !='') $where_clause = "branch_type = '$user_types'";

    else $where_clause = '1';

  }

  

  if($state_id != 0) {

    $where_clause .= "and state_id = '$state_id'";

  } 

  

  if($company_id != '') {

    $where_clause .= "and cid = '$company_id'";

  } 

  

  $q = "select * from branches where $where_clause order by name asc";

  $rs = $db->get_results($q);

  $branches_dom = array();

  foreach($rs as $row) {

    $branches_dom[$row->id] = stripslashes($row->name);

  }

  return $branches_dom;

}



function getBranchNameById($branch_id) {

  global $db;

  $q = "select name from branches where id = '".$branch_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}



function getBranchZipCode($branch_id) {

  global $db;

  $q = "select * from zip_code where bid = '".$branch_id."'";

  $zip_code = $db->get_row($q);

  return $zip_code;

}



function isBranchCovered($branch_id, $zip) { 

  global $db;

  $zip = trim($zip);

  $zip = intval($zip);

  $q = "select zip_code from zip_code where bid = '".$branch_id."'";

  $zip_codes = $db->get_var($q);

  $coverage = explode(';',$zip_codes);

  foreach($coverage as $zip_covered) {

    if(strstr($zip_covered, '-')) {

      $temp_ar  = explode('-', $zip_covered);

      $zip_low  = intval($temp_ar[0]);

      $zip_high = intval($temp_ar[1]);



      if($zip >= $zip_low && $zip <= $zip_high)

        return true;

        

    } else {

      $temp_zip = intval($zip_covered);

      if($zip == $temp_zip)

        return true;

    }

  }

  

  return false;

}



function getBranchesDomByCompanyId($company_id) {

  global $db;
if($company_id=="")
$q = "select branches.* from branches left join companies on companies.id=branches.cid where companies.type = 2 order by branches.name asc";
else

  $q = "select * from branches where cid = '".$company_id."' order by name asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $branches_dom[$row->id] = stripslashes($row->name);

  }

  return $branches_dom;

}



function getCompanyTypeById($company_id) {

  global $db;

  $q = "select type from companies where id = '".$company_id."' limit 1";

  $company_type = $db->get_var($q);

  return $company_type;

}



function getBranchIdByZipcodeId($zipcode_id) {

  global $db;

  $q = "select bid from zip_code where id = '".$zipcode_id."' limit 1";

  $branch_id = $db->get_var($q);

  return $branch_id;

}



function getCompaniesDom($is_active = false) {

  global $db;

  if($is_active) $q = "select id, name from companies where is_active = '".$is_active."' order by name asc";

  else $q = "select id, name from companies order by name asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $companies_dom[$row->id] = stripslashes($row->name);

  }

  return $companies_dom;

}



function getCompaniesDomById($company_id) {

  global $db;

  $q = "select id, name from companies where id = '".$company_id."' order by name asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $companies_dom[$row->id] = stripslashes($row->name);

  }

  return $companies_dom;

}



function getUsersDomByCompanyId($company_id, $fldType = Null) {

  global $db;

  $q = "select id, username, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' order by firstname asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    if($fldType == 'username') $users_dom[$row->id] = stripslashes($row->username);

    else $users_dom[$row->id] = stripslashes($row->fullname);

  }

  return $users_dom;

}



function getUsersDomByRole_CompanyId($company_id, $user_types, $is_other = false) {

  global $db;

  if(is_array($user_types) && count($user_types) > 0) {

    $where = array();

    foreach($user_types as $user_type) {

       $where[] = "user_type = '$user_type'";

    }

    $where_clause = build_where_clause_in_or_condition($where);

  } else {

    $where_clause = "user_type = '$user_types'";

  }

  

  $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and $where_clause order by firstname asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $users_dom[$row->id] = stripslashes($row->fullname);

  }

  

  if($is_other == true) $users_dom['other'] = 'Other Adjuster';

  return $users_dom;

}



function getUsersDomByRole_CompanyandBranchId($company_id, $branch_id, $user_types, $is_other = false) {

  global $db;

  if(is_array($user_types) && count($user_types) > 0) {

    $where = array();

    foreach($user_types as $user_type) {

       $where[] = "user_type = '$user_type'";

    }

    $where_clause = build_where_clause_in_or_condition($where);

  } else {

    if(!empty($user_types)) $where_clause = "user_type = '$user_types'";

    else $where_clause = '1';

  }

  

  if($company_id !='' && $branch_id !='') {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and branch_id = '".$branch_id."' and $where_clause order by firstname asc";

  } else {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and $where_clause order by firstname asc";

  }

  //echo $q;// die();

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $users_dom[$row->id] = stripslashes($row->fullname);

  }

  

  if($is_other == true) $users_dom['other'] = 'Other Adjuster';

  return $users_dom;

}



function getAdjusterTypeByCompanyId($company_id) {

  $company_type = getCompanyTypeById($company_id);

  if($company_type == '1') $adjuster_type = '8'; // Ins adjuster

  else if($company_type == '4') $adjuster_type = '23'; // TP adjuster

  return $adjuster_type;

}



function getUsersDomByRoleCompanyBranchId($company_id, $branch_id, $user_type, $is_other = false) {

  global $db;

   $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and branch_id = '".$branch_id."' and user_type = '".$user_type."' order by firstname asc";

  $rs = $db->get_results($q);

  foreach($rs as $row) {

    $users_dom[$row->id] = stripslashes($row->fullname);

  }

  

  if($is_other == true) $users_dom['other'] = 'Other Adjuster';

  return $users_dom;

}



function getNewFileNumber() {

  global $db;

  $today_date = date("Y-m-d", time());

  $sql = "select count(*) as cnt from claims where DATE_FORMAT(date_created, '%Y-%m-%d') = '".$today_date."' limit 1";

  $cnt = $db->get_var($sql);

  

  if($cnt == 0) {

    return date("mdY", time()).'-100001';

  } else {

    $q = "select claim_name from claims order by date_created desc limit 1";

    $claim_name = $db->get_var($q);

    $exploded_claim_name = explode("-", $claim_name);

    $last_claim_number = str_replace("10000", "", $exploded_claim_name[1]);

    $new_claim_number = $last_claim_number + 1;

    $final_new_claim_number = date("mdY", time()).'-10000'.$new_claim_number;

    

    return $final_new_claim_number;

  }

}



function getFileNumberById($claim_id) {

  global $db;

  $q = "select claim_name from claims where id = '".$claim_id."'";

  return $db->get_var($q);

}



function getCompanyAdminById($company_id) {

  global $db;

  $q = "select concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and (user_type = '11' OR user_type = '5' OR user_type = '16' OR user_type = '20')";

  $fullname = $db->get_var($q);

  return stripslashes($fullname);

}



function getCompanyNameById($company_id) {

  global $db;

   $q = "select name from companies where id = '".$company_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}


function getCompanyList($type_id) {

  global $db;

   $q = "select name from companies where type = '".$type_id."'";

  $name = $db->get_var($q);

  return stripslashes($name);

}


function getCompanyInfoById($company_id, $fields = array()) {

  global $db;

  if(!empty($fields) && count($fields) > 0) {

    $column_names = implode(', ', $fields);

    $q = "select $column_names from companies where id = '".$company_id."'";

  } else {

    $q = "select * from companies where id = '".$company_id."'";

  }

  $company_info = $db->get_row($q);

  return $company_info;

}



function getBranchInfoById($branch_id, $fields = array()) {

  global $db;

  if(!empty($fields) && count($fields) > 0) {

    $column_names = implode(', ', $fields);

    $q = "select $column_names from branches where id = '".$branch_id."'";

  } else {

    $q = "select * from branches where id = '".$branch_id."'";

  }

  $branch_info = $db->get_row($q);

  return $branch_info;

}



function getBranchIdByUserId($user_id) {

  global $db;

  $q = "select branch_id from users where id = '".$user_id."' limit 1";

  $branch_id = $db->get_var($q);

  return $branch_id;

}



function getClaimInOverDueById($user_id, $claim_id) {

  global $db;

  $q = "select id from claim_overdue_files where user_id = '".$user_id."' and claim_id = '".$claim_id."'  limit 1";

  $overdue_id = $db->get_var($q);

  return $overdue_id;

}



function updateClaimOverDueDate($claim_id) {

  global $db;

  $sql = "update claim_overdue_files set assigned_date = '".date('Y-m-d H:i:s')."' where claim_id = '".$claim_id."'";

  $db->query($sql);

}



function getAdjusterNameById($adjuster_id) {

  global $db;

  $q = "select concat(firstname,' ',lastname) as fullname from users where id = '".$adjuster_id."' limit 1";

  $fullname = $db->get_var($q);

  return $fullname;

}



function getAdjusterSupervisorNameById($branch_id, $user_type) {

  global $db;

  $q = "select concat(firstname,' ',lastname) as fullname from users where branch_id = '".$branch_id."' and user_type = '".$user_type."' limit 1";

  $fullname = $db->get_var($q);

  return $fullname;

}



function getAdjusterSupervisedNamesById($adjuster_id, $branch_id, $user_type) {

  global $db;

  $adj_supervisors = array();

  

  $sql = "select * from adjuster_adj_supervising where adjuster_id = '".$adjuster_id."'";

  $adj_supervised = $db->get_results($sql);

  if($adj_supervised) {

    foreach($adj_supervised as $adj_supervisor) {

      $q = "select id, concat(firstname,' ',lastname) as fullname from users where id = '".$adj_supervisor->id."'";

      $supervisor_info = $db->get_row($q);

      $adj_supervisors[$supervisor_info->id] = $supervisor_info->fullname;

    }

  }

  

  if(empty($adj_supervisors)) {

    $adj_supervisors[] = 'no supervisor(s)';

    //$adj_supervisors[] = getAdjusterSupervisorNameById($branch_id, $user_type);

  }

  

  return $adj_supervisors;

}



function getUsersByZipCodeAndType($zip_code, $user_types, $state_id = 0, $format = 'results', $company_id = '') {

  global $db;

  if(is_array($user_types) && count($user_types) > 0) {

    $where = array();

    foreach($user_types as $user_type) {

       $where[] = "users.user_type = '$user_type'";

    }

    $where_clause = build_where_clause_in_or_condition($where);

  } else {

    $where_clause = "users.user_type = '$user_types'";

  }

  

  if($zip_code != '') {

    $where_clause .= "and users.zip_code = '$zip_code'";

  }

  

  if($state_id != 0) {

    $where_clause .= "and users.state_id = '$state_id'";

  }

  

  if($company_id != '') {

    $where_clause .= "and users.company_id = '$company_id'";

  }

  

  $q = "select users.id, concat(users.firstname,' ',users.lastname) as fullname, companies.name as company_name from users, companies companies where companies.id = users.company_id and $where_clause order by users.firstname asc";

  $rs = $db->get_results($q);

  

  if($format == 'dom') {

    $users_dom = array();

    if(count($rs) > 0) {

      foreach($rs as $row) {

        $users_dom[$row->id] = stripslashes($row->company_name).' ('.stripslashes($row->fullname).')';

      }

    }

    

    return $users_dom;

  } else {

    return $rs;

  }

  

}



function getUsersByCmpandBraIdandType($company_id, $branch_id, $user_types) {

  global $db;

  if(is_array($user_types) && count($user_types) > 0) {

    $where = array();

    foreach($user_types as $user_type) {

       $where[] = "user_type = '$user_type'";

    }

    $where_clause = build_where_clause_in_or_condition($where);

  } else {

    $where_clause = "user_type = '$user_types'";

  }

  

  if($company_id !='' && $branch_id !='') {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and branch_id = '".$branch_id."' and $where_clause order by firstname asc";

  } else if($company_id !='' && $branch_id == '') {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where company_id = '".$company_id."' and $where_clause order by firstname asc";

  } else if($branch_id !='' && $company_id == '') {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where branch_id = '".$branch_id."' and $where_clause order by firstname asc";

  } else {

    $q = "select id, concat(firstname,' ',lastname) as fullname from users where $where_clause order by firstname asc";

  }

  

  $rs = $db->get_results($q);

  return $rs;

}
function calculateage($end_time,$start_time)
{
	//if(strlen($end_time)>1){
				$date1 = date_create($start_time);
				$date2 = date_create($end_time);
				$daysDifference = round(abs($date2->format('U') - $date1->format('U')) / (60*60*24));
				$hourdiff = round(abs($date2->format('U') - $date1->format('U')) %(60*60*24)/3600);
				$mindiff = abs($date2->format('U') - $date1->format('U')) %(60*60*24)/3600;
				$whole = floor($mindiff);
				$fraction = $mindiff - $whole;
				$diff=$daysDifference." days - ".$hourdiff." hours - ".floor($fraction * 60)." min";	
				//var_dump($start_time);
				//echo'<br/>';
				//var_dump($end_time);
				//echo'<br/>';
				return $diff;
			//}
}

	function newClaimAge($claim = null, $user = null, $user_type = null,$company = null,$branch = null){
		global $db;
		$start_time = '';
		$end_time='';
		
			$q = "select * from status_logs where type_id='$claim' and type='claim' order by date_created desc limit 0,1";
			$result = $db->get_row($q);			
			$latest_status= $result->new_status;
			//var_dump($latest_status);
			if($latest_status==1 || $latest_status==6)
			{
				 $end_time=date('Y-m-d H:i:s');
				if($user_type == '111' || $user_type == '1' || $user_type=='4' || $user_type=='3')
				{	
					$q = "select * from status_logs where type_id='$claim' and type='claim' and log like '%reated%' and new_status='1' order by date_created asc limit 0,1";
					$result = $db->get_row($q);			
					 $start_time = $result->date_created;
				}
				else{
					$q = "select * from status_logs where type_id='$claim' and (assigned_to = '$user' or assigner_name = '$user')  and type='claim' and (log like '%ssigned%' or new_status='6') order by date_created desc limit 0,1";
					$result = $db->get_row($q);			
					 $start_time = $result->date_created;			
				}
				$diff=calculateage($end_time,$start_time);
				return $diff;
			}
			else if($latest_status==2 || $latest_status==3 || $latest_status==5)
			{
				
				$q = "select * from status_logs where type_id='$claim' and type='claim' and log like '%created%' and new_status='1' order by date_created asc limit 0,1";
				$result = $db->get_row($q);			
				$start_time = $result->date_created;
				//echo "<br/>";
				 $q = "select * from status_logs where type_id='$claim' and ( log like '%has been closed%' or log like '%has been cancele%' or log like '%has been deleted%') order by date_created desc limit 0,1";
					$result = $db->get_row($q);			
					$end_time = $result->date_created;
					
					
				$diff=calculateage($end_time,$start_time);
					return $diff;
		   }
		   else if($latest_status==4)
		   {
			   $q = "select * from status_logs where type_id='$claim' and type='claim' and log like '%created%' and new_status='1' order by date_created asc limit 0,1";
					$result = $db->get_row($q);			
					$start_time = $result->date_created;
				
				$q = "select * from status_logs where type_id='$claim' and ( log like '%has been closed%' or log like '%has been cancele%' or log like '%has been deleted%' or log like '%Completed%') order by date_created desc limit 0,1";
					$result = $db->get_row($q);			
					$end_time = $result->date_created;
					
					if($user_type == '111' || $user_type == '1' )
						$end_time=date('Y-m-d H:i:s');
				$diff=calculateage($end_time,$start_time);
					return $diff;
			}
		
		
	}
	
	function newClaimSupAge($claim = null,$claim_name = null, $user = null, $user_type = null,$company = null,$branch = null){
		global $db;
		$q = "select * from claims where id='$claim'";
		$res = $db->get_row($q);
		if($res->is_supplement){
			$start_time = '';
			$end_time='';
		
			$q = "select * from status_logs where type_id='$claim' and type='Supplement' order by date_created desc limit 0,1";
			$result = $db->get_row($q);			
			$latest_status= $result->new_status;
			if($latest_status==1)
			{
				$end_time=date('Y-m-d H:i:s');
				if($user_type == '111' || $user_type == '1' || $user_type=='4' || $user_type=='3')
				{	
					 $q = "select * from status_logs where type_id='$claim' and type like '%upplement%' and (log like '%upplement has been created%' and log like '%$claim_name%') and new_status='1' order by date_created asc limit 0,1";
					$result = $db->get_row($q);			
					$start_time = $result->date_created;
				}
				else
				 {
					$q = "select * from status_logs where type_id='$claim' and assigned_to = '$user'  and (type like '%upplement%' or type like '%claim%') and ((log like '%ssigned%' or new_status='6') and log like '%$claim_name%') order by date_created desc limit 0,1";
					$result = $db->get_row($q);			
					$start_time = $result->date_created;
			
					}
					$diff=calculateage($end_time,$start_time);
					return $diff;
			}
			else if($latest_status==2 || $latest_status==3 || $latest_status==5)
			{
				
				$q = "select * from status_logs where type_id='$claim' and type='Supplement' and (log like '%created%' and log like '%$claim_name%') and new_status='1' order by date_created asc limit 0,1";
				$result = $db->get_row($q);			
				$start_time = $result->date_created;				
				$q = "select * from status_logs where type_id='$claim' and ( (log like '%has been closed%' or log like '%has been cancele%' or log like '%has been deleted%') and log like'%$claim_name%') order by date_created desc limit 0,1";
				$result = $db->get_row($q);			
				$end_time = $result->date_created;					
					
				$diff=calculateage($end_time,$start_time);
				return $diff;
		   }
		   else if($latest_status==4)
		   {
				$q = "select * from status_logs where type_id='$claim' and type='claim' and (log like '%created%' and log like '%$claim_name%') and new_status='1' order by date_created asc limit 0,1";
				$result = $db->get_row($q);			
				$start_time = $result->date_created;
				
				$q = "select * from status_logs where type_id='$claim' and (( log like '%has been closed%' or log like '%has been cancele%' or log like '%has been deleted%' or log like '%Completed%') and log like '%$claim_name%') order by date_created desc limit 0,1";
				$result = $db->get_row($q);			
				$end_time = $result->date_created;
					
				if($user_type == '111' || $user_type == '1' )
					$end_time=date('Y-m-d H:i:s');
				$diff=calculateage($end_time,$start_time);
				return $diff;
			}
		}
	}
	/*function newClaimAge($claim = null, $user = null, $user_type = null){
		global $db;
		$start_time = '';
		$end_time='';
		if($user_type == '111' || $user_type == '1'){
			$q = "select * from status_logs where type_id='$claim' and new_status='1' order by date_created asc limit 0,1";
			$result = $db->get_row($q);			
			$start_time = $result->date_created;
			
			$q = "select * from status_logs where type_id='$claim' order by date_created desc limit 0,1";
			$result = $db->get_row($q);			
			if($result->new_status == '2' || $result->new_status == '3' || $result->new_status == '5' || (strpos($result->log,'closed')!==false || strpos($result->log,'canceled')!==false)){
				$end_time = $result->date_created;
			}else{
				$end_time='';
			}			
			if(strlen($end_time)>1){
				$date1 = date_create($start_time);
				$date2 = date_create($end_time);
				$daysDifference = round(abs($date2->format('U') - $date1->format('U')) / (60*60*24));
				$hourdiff = round(abs($date2->format('U') - $date1->format('U')) %(60*60*24)/3600);
				$diff=$daysDifference." days - ".$hourdiff." hours";
				return $diff;
			}
		}
	}*/


	function retrunClaimAgeAfterClosing($creation_date,$closeDate){
		$date1 = date_create($closeDate);
		$date2 = date_create($creation_date);
		$daysDifference = round(abs($date2->format('U') - $date1->format('U')) / (60*60*24));
		$hourdiff = round(abs($date2->format('U') - $date1->format('U')) %(60*60*24)/3600);
		$diff=$daysDifference." days - ".$hourdiff." hours";
		return $diff;
	}



function returnHTMLClaimAge($creation_date) {

	 $dt=date('Y-m-d H:i:s');

	$date1 = date_create($dt);

	

$date2 = date_create($creation_date);

$daysDifference = round(abs($date2->format('U') - $date1->format('U')) / (60*60*24));

$hourdiff = round(abs($date2->format('U') - $date1->format('U')) %(60*60*24)/3600);



$diff=$daysDifference." days - ".$hourdiff." hours";

	return $diff; 

	//$str= $interval->format('%a days %h hours %i minutes ago').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

	

	//return true;

	

	

	

	

	

  $creation_date = explode(" ",$creation_date);

  $ymd = explode("-",$creation_date[0]);

  $y = intval($ymd[0]);

  $m = intval($ymd[1]);

  $d = intval($ymd[2]);

  $ymd = explode(":",$creation_date[1]);

  $h = intval($ymd[0]);

  $min=intval($ymd[1]);

  $diff = mktime($h,$min,0,$m,$d,$y);

  

  $num_days = intval((time()-$diff)/3600/24);

  $num_hours = intval(((time()-$diff)%(3600*24))/3600);

  

  $total_hours = ($num_days * 24) + $num_hours;

  if($total_hours <= 24) $claim_age_color = 'green';

  else if( $total_hours >= 25 && $total_hours <= 48) $claim_age_color = '#CCCC00';

  else if( $total_hours >= 49) $claim_age_color = 'red';

  

  $returnString  = '<font style="color:'.$claim_age_color.';">';

  $returnString .= strval($num_days). " days - ". strval($num_hours)." hours";

  $returnString .='</font>';

  

  return $returnString;

}



function saveStatusLog($created_by_id, $claim_id, $log, $type,$uid,$newstauts='',$loggedin='',$assignedto='',$parrentid='')
 {

  global $db;

  $q = "insert into status_logs set id = '".create_guid()."', created_by_id = '".$created_by_id."', type_id = '".$claim_id."', log = '".addslashes($log)."', type = '".$type."', date_created = '".date("Y-m-d H:i:s")."', date_modified = '".date("Y-m-d H:i:s")."', assigner_name='".$uid."',new_status='".$newstauts."',assigned_to='".$assignedto."',logged_in='".$loggedin."',parrent_id='".$parrentid."'";

  $db->query($q);

  

  // If taken any action with claim then update overdue date...

  if($claim_id !='') updateClaimOverDueDate( $claim_id );

}



function updateStatusLog($log_id, $log) {

  global $db;

  $q = "update status_logs set modified_by_id = '".$_SESSION['current_user_id']."', log = '".addslashes($log)."', date_modified = '".date("Y-m-d H:i:s")."' where id = '".$log_id."'";

  $db->query($q);

}



function getRecentStatusLog($type_id, $type) {

  global $db;

  $q = "select * from status_logs where type_id = '".$type_id."' and type = '".$type."' order by date_created desc limit 1";

  $log_info = $db->get_row($q);

  if($log_info) {

    return "<u>".getUserNameById($log_info->created_by_id)."</u><br />".$log_info->log.'.';

  } else {

    return 'Status not yet inputted.';

  }

}



function getClaimAssignedUsersByClaimId($claim_id) {

  global $db;

  $q = "select user_id from claim_assignments where claim_id = '$claim_id'";

  $claim_users = $db->get_var($q);

  $claim_user_ids = array_unique(explode(',', $claim_users));

  return $claim_user_ids;

}



function getClaimOwners($claim_id) {

  global $db;

  $q = "select user_id from claim_assignments where claim_id = '$claim_id'";

  $claim_users = $db->get_var($q);

  $claim_user_ids = array_unique(explode(',', $claim_users));

  return $claim_user_ids;

}



function getClaimCreatedByInfo($claim_id) {

  global $db;

  $q = "select claim_created_by, claim_created_by_company, claim_created_by_cmp_type, claim_created_by_branch from claims where id = '$claim_id'";

  $claim_created_byInfo = $db->get_row($q);

  return $claim_created_byInfo;

}



function getClaimAssignedTo($claim_id) {

  global $db;

  $claim_assigned_details = array();

  $assigned_to    = false;

  $inspected_by   = false;

  $reinspected_by = false;

  $reviewed_by    = false;

  

  $claim_user_ids = getClaimAssignmentUsersByClaimid($claim_id);

  if(count($claim_user_ids) > 0) {

    foreach($claim_user_ids as $user_id) {

      $user_info = getUserInfo($user_id);

      if(

        $user_info->user_type == '5' ||   // Appraisal Company Admin

        $user_info->user_type == '4' ||   // Appraisal Branch Admin

        $user_info->user_type == '3' ||   // Appraisal Branch Employee

        $user_info->user_type == '16' ||  // Body Shop Company Admin

        $user_info->user_type == '17' ||  // Body Shop Branch Admin

        $user_info->user_type == '19' ||  // Body Shop Branch Employee

        $user_info->user_type == '25' ||  // Call Center Branch Admin

        $user_info->user_type == '26' ||  // Call Center Branch Employee

        $user_info->user_type == '7'  ||  // In-House Appraiser

        $user_info->user_type == '20'     // Third Party Company Admin

      ) {

        $assigned_to = true;

        $assigned_to_info  = $user_info;

      }

    

      // Inspected by: ( App Co Appraiser, Body Shop Estimator, Ins in-house appraiser )

      if($user_info->user_type == '2' || $user_info->user_type == '18' || $user_info->user_type == '7') {

        $inspected_by = true;

        $inspected_by_info = $user_info;

      }

      

      // Reinspected by: ( Ins Reinspector )

      if($user_info->user_type == '13') {

        $reinspected_by = true;

        $reinspected_by_info = $user_info;

      }

      

      // Reviewed by: ( Ins Desk Reviewer, App Desk Reviewer )

      if($user_info->user_type == '12' || $user_info->user_type == '6') {

        $reviewed_by = true;

        $reviewed_by_info = $user_info;

      }

    }

  }

 //var_dump($assigned_to_info);

  $claim_created_byInfo = getClaimCreatedByInfo($claim_id);

  if($assigned_to) {

     $claim_assigned_details['claim_assigned_to']['company_id']   = $assigned_to_info->company_id; 

	

    $claim_assigned_details['claim_assigned_to']['company_name'] = getBranchNameById($assigned_to_info->branch_id); 

  } else {

    $claim_assigned_details['claim_assigned_to']['company_id']   = ''; 

    if($claim_created_byInfo->claim_created_by_cmp_type == 1) { // Insurance

      $claim_assigned_details['claim_assigned_to']['company_name'] = 'Not Assigned';

    } else {

      if($claim_created_byInfo->claim_created_by_branch !='') $claim_assigned_details['claim_assigned_to']['company_name'] = getBranchNameById($claim_created_byInfo->claim_created_by_branch);

      else $claim_assigned_details['claim_assigned_to']['company_name'] = 'Not Assigned';

    }

    

  }

  

  if($inspected_by) {

	   

    $claim_assigned_details['claim_inspected_by']['user_id'] = $inspected_by_info->id; 

    $claim_assigned_details['claim_inspected_by']['user_name'] = getUserNameById($inspected_by_info->id); 

  } else {

    $claim_assigned_details['claim_inspected_by']['user_id'] = ''; 

    $claim_assigned_details['claim_inspected_by']['user_name'] = 'Not Assigned';

  }

  

  if($reinspected_by) {

    $claim_assigned_details['claim_reinspected_by']['user_id'] = $reinspected_by_info->id;

    $claim_assigned_details['claim_reinspected_by']['user_name'] = getUserNameById($reinspected_by_info->id);

  } else {

    $claim_assigned_details['claim_reinspected_by']['user_id'] = '';

    $claim_assigned_details['claim_reinspected_by']['user_name'] = "Not Assigned";

  }

  

  if($reviewed_by) {

    $claim_assigned_details['claim_reviewed_by']['user_id'] = $reviewed_by_info->id;

    $claim_assigned_details['claim_reviewed_by']['user_name'] = getUserNameById($reviewed_by_info->id);

  } else {

    $claim_assigned_details['claim_reviewed_by']['user_id'] = '';

    $claim_assigned_details['claim_reviewed_by']['user_name'] = "Not Assigned";

  }

  

  return $claim_assigned_details;

}



function getClaimAssignedInfo($claim_id) {

  global $db;

  $claim_assigned_details = array();

  $found_appraiser        = false;

  $found_appraiser_branch = false;

  $found_reinspector      = false;

  

  $claim_user_ids = getClaimAssignedUsersByClaimId($claim_id);

  if(count($claim_user_ids) > 0) {

    foreach($claim_user_ids as $user_id) {

      $user_info = getUserInfo($user_id);

      //App Appraiser or BS Estimator

      if($user_info->user_type == '2' || $user_info->user_type == '18') {

        $found_appraiser = true;

        $appraiser_info  = $user_info;

      }

      

      // App company admin or App branch admin or BS company admin or BS branch admin

      if($user_info->user_type == '5' || $user_info->user_type == '4' || $user_info->user_type == '16' || $user_info->user_type == '17') {

        $found_appraiser_branch = true;

        $appraiser_info = $user_info;

      }

      

      //Ins Reinspector

      if($user_info->user_type == '13') {

        $found_reinspector = true;

        $reinspector_info  = $user_info;

      }

    }

  }

  

  if($found_appraiser_branch) $claim_assigned_details['claim_assigned_to'] = getCompanyNameById($user_info->company_id); 

  else $claim_assigned_details['claim_assigned_to'] = 'No appraisal company branch assigned.';

  

  if($found_appraiser) {

    $claim_assigned_details['claim_inspected_by'] = getUserNameById($appraiser_info->id);

  } else {

    if(getCompanyTypeById($user_info->company_id) == 3) $claim_assigned_details['claim_inspected_by'] = "No estimator assigned.";

    else $claim_assigned_details['claim_inspected_by'] = "No appraiser assigned.";

  }

  

  if($found_reinspector) $claim_assigned_details['claim_reinspected_by'] = getUserNameById($reinspector_info->id);

  else $claim_assigned_details['claim_reinspected_by'] = "No reinspector assigned.";

  

  return $claim_assigned_details;



}



function getClaimUserNames($claim_id) {

  global $db;

  $assignment_users = getClaimAssignedUsersByClaimId($claim_id);

  foreach($assignment_users as $user_id) {

    if(isset($user_id) && $user_id !='') {

      $user_info = getUserInfo($user_id);

      // echo "<pre>"; print_r($user_info->user_type);

      $temp = '<a title="'.$user_info->username.' ('.getUserTypeName($user_info->user_type).')">';

      if($user_info->user_type == '0') {

        $temp .= '<s>'.$user_info->lastname.', '.$user_info->firstname.'</s>';

      } else {

        if(!empty($user_info->firstname) || !empty($user_info->lastname)) {

          $temp .= $user_info->lastname.', '.$user_info->firstname;

        }

      }

      $temp.= '</a>';

      

      if(!empty($user_info->firstname) || !empty($user_info->lastname)) {

        $temp.= ' ('.getClaimOwnerLocFromDb($claim_id, $user_info->user_type, $user_info->id).')';

      }

      

      $accounts[] = $temp;

    }

  }

  return implode('<br>', $accounts);

}



function getClaimOwnerLoc($user_auth, $loc) {

  if($loc == 'archive') return 'Archive';

  switch ($user_auth) {

    case '4':

    case '3':

      switch ($loc) {

        case '1': return "New C. Inbox";

        case '2': return "Assigned To Dispatch";

        case '3': return "Assigned To IA";

        case '4': return "Pending Review / Completion";

      }

    case '7':

    case '6':

    case '2':

    case '12':

    case '13':

    case '15':

      switch ($loc) {

        case '1': return "New C. Inbox";

        case '2': return "In Process";

        case '3': return "Pending";

        case '4': return "Completion";

      }

    default:

      switch ($loc) {

        case '1': return "Unassigned";

        case '2': return "Assigned";

        case '3': return "Assigned";

        case '4': return "Assigned";

      }

  }

  return 'Archive';

}



function getClaimOwnerLocFromDb($claim_id, $user_auth, $user_id) {

  $a = getAssignmentClaimStatus($claim_id, $user_id);

  return getClaimOwnerLoc($user_auth, $a);

}



function getAssignmentClaimStatus($claim_id, $user_id) {

  global $db;

  $q = "select * from claim_assignment_user where user_id = '".$user_id."'";

  $info = $db->get_row($q); 

  

  $exploded_type1   = explode(",", $info->type1);

  $exploded_type2   = explode(",", $info->type2);

  $exploded_type3   = explode(",", $info->type3);

  $exploded_type4   = explode(",", $info->type4);

  $exploded_archive = explode(",", $info->archive);

  

  if(in_array($claim_id, $exploded_type1)) return '1';

  if(in_array($claim_id, $exploded_type2)) return '2';

  if(in_array($claim_id, $exploded_type3)) return '3';

  if(in_array($claim_id, $exploded_type4)) return '4';

  if(in_array($claim_id, $exploded_archive)) return 'archive';

  return "0";

}



function getExIm($explode_array, $values) {

  $exploded = explode(",", $explode_array);

  

  if(is_array($values) && count($values) > 0) {

    foreach($values as $value) {

      $exploded[] = $value;

    }

  } else {

    $exploded[] = $values;

  }

  $imploded = implode(",", array_filter($exploded) );

  return $imploded;

}

function setuserClaimAssignDate($user_id,$claim_id)

{

	global $db;

	$today=date('Y-m-d H:i:s');

	 $uid=explode(",",$user_id);

	 foreach($uid as $ud)

	  {

			$sql = "select claim_assigndate_touser.*, count(*) as cnt from claim_assigndate_touser where user_id = '$ud' and claim_id='$claim_id' ";

			  

		  $claim_assignments_info = $db->get_row($sql, ARRAY_A);

		  if($claim_assignments_info['cnt']==0){

			 		

			$sql = "select id from users  where user_type=1 or user_type=111 ";

			$obj = $db->get_results($sql);

			if(count($obj)>0)

			{

				foreach($obj as $val)	

				{

				$sql = "select claim_assigndate_touser.*, count(*) as cnt from claim_assigndate_touser where user_id = '".$val->id."' and claim_id='$claim_id' ";

			  

		  			$claim_assignments_info = $db->get_row($sql, ARRAY_A);

					  if($claim_assignments_info['cnt']==0)

					  {

						  if($_SESSION['current_user_id']!= $val->id)

						  { 

						  	$q = "insert into claim_assigndate_touser  set user_id='".$val->id."',claim_id='".$claim_id."',assign_date='".$today."' ";

							$db->query($q);

						  }

					   }

				}

			}

				 	

					

					$q = "insert into claim_assigndate_touser  set user_id='".$ud."',claim_id='".$claim_id."',assign_date='".$today."' ";

					$db->query($q);	

			

		  }

		  else

		  {	

		  	$type=getUserTypeById($ud);

		   if($type!=10 && $type!=111 && $type!=1)

		  	{

					$q="update claim_assigndate_touser set assign_date='".$today."' where user_id = '$ud' and claim_id='$claim_id'";

			  

				   $db->query($q);

		 	 }

		  

			}

	  }

}

function checkAppraiser($claim_id)

{ global $db;

	$ud="";
	$ud = array();

	$sql = "select claim_assigndate_touser.user_id,users.email from claim_assigndate_touser left join users on users.id=claim_assigndate_touser.user_id where claim_assigndate_touser.claim_id = '".$claim_id."' and users.user_type in (2,5,22,23)";

	$obj = $db->get_results($sql);

			if(count($obj)>0)

			{

				foreach($obj as $val)	

				{

					$type=getUserTypeById($val->user_id);

					array_push($ud,$val->email);

				}

				

				

			}

			if(count($ud)>0){
				return $ud;
			}
			
			return false;

}

function saveClaimAssignment($claim_id, $user_id, $change_adjuster = false) {

  global $db;

  $sql = "select user_id from claim_assignments where claim_id = '".$claim_id."'";

  $user_assigns = $db->get_var($sql);

  if($user_assigns !='') {

    if($change_adjuster) {

      $q = "update claim_assignments set user_id = '".$user_id."', date_modified = '".date("Y-m-d H:i:s")."' where claim_id = '".$claim_id."'";

	  $db->query($q);

	  setuserClaimAssignDate($user_id,$claim_id);

    } else {

      $user_ids = getExIm($user_assigns, $user_id);

	 

      $q = "update claim_assignments set user_id = '".$user_ids."', date_modified = '".date("Y-m-d H:i:s")."' where claim_id = '".$claim_id."'";

	  $db->query($q);

	  

	  setuserClaimAssignDate($user_ids,$claim_id);

	  

    }

  } else {

    if(is_array($user_id) && count($user_id) > 0) {

      $user_ids = implode(",", array_filter($user_id) );

    } else {

      $user_ids = $user_id;

    }

    $q = "insert into claim_assignments set id = '".create_guid()."', claim_id = '".$claim_id."', user_id = '".$user_ids."', date_created = '".date("Y-m-d H:i:s")."', date_modified = '".date("Y-m-d H:i:s")."'";

	$db->query($q);

	setuserClaimAssignDate($user_ids,$claim_id);

	

	

  }

  

  

  



  

}



function createNewAssignment($claim_id, $user_id) {

  global $db;

  // When multiple assigns are made, make a recursive call.

  if(strstr($user_id, ',')) {

    $temp_ar = clean_array(explode(',', $user_id));

    $temp_ar = array_unique($temp_ar);

    if(count($temp_ar) > 0) {

      foreach($temp_ar as $newOwner) {

        createNewAssignment($claim_id, $newOwner);

      }

    }

    return true;

  }

   $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where  type1 like '%".$claim_id."%'";

  $claim_assignment_user_info = $db->get_row($sql);

   //if($claim_assignment_user_info->cnt >0)

   		//saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',$user_id);

  $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where user_id = '$user_id'";

  $claim_assignment_user_info = $db->get_row($sql);

  if($claim_assignment_user_info->cnt == 0) { // Creating First Time Claim...

    $q = "insert into claim_assignment_user set user_id = '".$user_id."', type1 = '".strval($claim_id)."'";

    $db->query($q);

  } else { // Not First Time...

    //$type1 = $claim_assignment_user_info->type1.','.strval($claim_id);

    $type1 = getExIm($claim_assignment_user_info->type1, $claim_id);

    $q = "update claim_assignment_user set type1 = '".$type1."' where user_id = '".$user_id."'";

    $db->query($q);

	 

  }

  

  $q = "select claim_assignments.*, count(*) as cnt from claim_assignments where claim_id = '".$claim_id."'";

  $claim_assignment_info = $db->get_row($q);

  

  if($claim_assignment_info->cnt == 0) {

    $q = "insert into claim_assignments set id = '".create_guid()."', claim_id = '".$claim_id."', user_id = '".$user_id."', date_created = '".date("Y-m-d H:i:s")."', date_modified = '".date("Y-m-d H:i:s")."'";

    $db->query($q);

    

    /*$log1 = "File number: ".getFileNumberById($claim_id)." has been assigned to ".getUserNameById($user_id);

	

    saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',"NotAssigned");

    */

    return true;

  }

  

  

//  $user_info = getUserInfo($user_id);

 /* $log1 = "File number: ".getFileNumberById($claim_id)." has been assigned to ".getUserNameById($user_id)." (".getCompanyNameById($user_info->company_id).")";

  

  saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',"NotAssigned");

*/

  	 

		 $s="select place from reassignment where user_id='".$user_id."' and claim_id='".$claim_id."'  ";

		  $rs= $db->get_results($s);

		  if(count($rs)>0)

		  {

			foreach($rs as $val) 

			{

			   $q="update reassignment set place=1 where user_id='".$user_id."' and claim_id='".$claim_id."'";

			   $db->query($q);

			} 

		   }

		   else

		   {

				$q="insert into reassignment ( user_id,place,claim_id) values('".$user_id."',1,'".$claim_id."')"; 

				$db->query($q);  

			}

	

  

  

  return true;

}



function updateAssignment($claim_id, $value, $user_id, $no_log = 'log') {

  global $db;

  

  // When multiple assigns are made, make a recursive call.

  if(strstr($user_id, ',')) {

    $temp_ar = clean_array(explode(',', $user_id));

    $temp_ar = array_unique($temp_ar);

    if(count($temp_ar) > 0) {

      foreach($temp_ar as $newOwner) {

        updateAssignment($claim_id, $value, $newOwner);

      }

    }

    return true;

  }

  

  $account = getUserInfo($user_id);

  $userAuth = $account->user_type;

  

  $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where user_id = '$user_id' limit 1";

  $claim_assignment_user_info = $db->get_row($sql, ARRAY_A);

  

  $today=date("Y-m-d H:i:s");

  if($claim_assignment_user_info['cnt'] == 0) {

    $q = "insert into claim_assignment_user ( user_id) values( '".$user_id."')";

    $db->query($q);

	

  }

 

   $uid=explode(",",$user_id);

   foreach($uid as $ud)

	{

		setuserClaimAssignDate($ud,$claim_id);

		

		/*   $sql = "select claim_assigndate_touser.*, count(*) as cnt from claim_assigndate_touser where user_id = '$user_id' and claim_id='$claim_id' limit 1";

		  $claim_assignments_info = $db->get_row($sql, ARRAY_A);

		  if($claim_assignments_info['cnt']==0){

			 

				

					$q = "insert into claim_assigndate_touser set user_id='".$ud."',claim_id='".$claim_id."',assign_date='".$today."'";

					$db->query($q);

			

		  }

	  else

	  {	

	 

		if($type!=10 && $type!=111 && $type!=10)

		{

	  		$q="update claim_assigndate_touser set assign_date='".$today."' where user_id = '$ud' and claim_id='$claim_id'";

	  

		   	$db->query($q);

		}

		

		}*/

	}

  for ($i = 1; $i<=CLAIM_ASSIGNMENT_LEVEL; $i++) {

    $typeString = "type".strval($i);

    

    $exploded_array = explode(",", $claim_assignment_user_info[$typeString]);

    if(in_array($claim_id, $exploded_array)) {

      $fliped_array = array_flip($exploded_array);

      unset($fliped_array[$claim_id]);

      

      $real_array = array_flip($fliped_array);

      $claim_assignment_user_info[$typeString] = implode(",", $real_array);

    }

  }

  

  $exploded_archive_array = explode(",", $claim_assignment_user_info['archive']);

  if(in_array($claim_id, $exploded_archive_array)) {

    $fliped_archive_array = array_flip($exploded_archive_array);
	
    unset($fliped_archive_array[$claim_id]);
	
    

    $real_archive_array = array_flip($fliped_archive_array);

    $claim_assignment_user_info['archive'] = implode(",", $real_archive_array);

  }

  

  if($value == 'archive') $typeString = $value;

  else $typeString = "type".$value;

  $claim_assignment_user_info[$typeString] = getExIm($claim_assignment_user_info[$typeString], $claim_id);

  

 

  $sql = "update claim_assignment_user set 

            archive = '".$claim_assignment_user_info['archive']."', 

            type1 = '".$claim_assignment_user_info['type1']."',

            type2 = '".$claim_assignment_user_info['type2']."',

            type3 = '".$claim_assignment_user_info['type3']."',

            type4 = '".$claim_assignment_user_info['type4']."',

            type5 = '".$claim_assignment_user_info['type5']."'

			

          where user_id = '".$user_id."'";

  

  

  $db->query($sql);

  $rch=explode($claim_assignment_user_info['archive']);

  if (count($rch)>0)

  {

	for($r=0;$r<=count($rch)-1; $r++)

	{

		 $s="select place from reassignment where claim_id='".$rch[$r]."' and user_id='".$user_id."' ";

		  $rs= $db->get_results($s);

		  if(count($rs)>0)

		  {

			foreach($rs as $val) 

			{

			   $q="update reassignment set place=2 where claim_id='".$rch[$r]."' and user_id='".$user_id."'";

			   $db->query($q);

			} 

		   }

		   else

		   {

				$q="insert into reassignment ( user_id,place,claim_id) values('".$user_id."',2,'".$rch[$r]."')"; 

				$db->query($q);  

			}

	}  

}

  

 $r=0; 

  $typ=explode($claim_assignment_user_info['type1']);

  if (count($typ)>0)

  {

	for($r=0;$r<=count($typ)-1; $r++)

	{

		 $s="select place from reassignment where claim_id='".$rch[$r]."' and user_id='".$user_id."'  ";

		  $rs= $db->get_results($s);

		  if(count($rs)>0)

		  {

			foreach($rs as $val) 

			{

			   $q="update reassignment set place=1 where claim_id='".$rch[$r]."' and user_id='".$user_id."'";

			   $db->query($q);

			} 

		   }

		   else

		   {

				$q="insert into reassignment ( user_id,place,claim_id) values('".$user_id."',1,'".$rch[$r]."')"; 

				$db->query($q);  

			}

	}  

}

  

  if($no_log == 'log') {

    $log1 = "File number: ".getFileNumberById($claim_id)." owned by ".getUserNameById($user_id)." (".getCompanyNameById($account->company_id).") has an updated location: ".getClaimOwnerLoc($userAuth,$value).".";

   // saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',$user_id);

  }

  

  

  

  return true;

}



function addAssignmentsByLocation($claim_id, $user_id, $location = 'type1') {

  global $db;

  // When multiple assigns are made, make a recursive call.

  if(strstr($user_id, ',')) {

    $temp_ar = clean_array(explode(',', $user_id));

    $temp_ar = array_unique($temp_ar);

    if(count($temp_ar) > 0) {

      foreach($temp_ar as $newOwner) {

        addAssignmentsByLocation($claim_id, $newOwner, $location);

      }

    }

    return true;

  }

  

  $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where user_id = '$user_id'";

  $claim_assignment_user_info = $db->get_row($sql);

  

  // Creating First Time Claim...

  if($claim_assignment_user_info->cnt == 0) {

    $q = "insert into claim_assignment_user set user_id = '".$user_id."', $location = '".strval($claim_id)."'";

  } else { 

    $loca_type = getExIm($claim_assignment_user_info->$location, $claim_id);

    $q = "update claim_assignment_user set $location = '".$loca_type."' where user_id = '".$user_id."'";

  }

  $db->query($q);

  

  return true;

}



function isLastOwner($owner, $claim_id) {

  global $db;

  $rev_owners = array_reverse(getClaimAssignedUsersByClaimId($claim_id, $db));

  if(getUserTypeById($owner) == '4' || getUserTypeById($owner) == '3') {

    foreach($rev_owners as $temp_owner) {

      if($temp_owner == $owner) return true;

      if(!(getUserTypeById($temp_owner) == '4' || getUserTypeById($temp_owner) == '3'))

        return false;

    }

  } else

    return strval($owner)==strval($rev_owners[0]);

}



function getClaimOwner($claim_id) {

  global $db;

  $assignments_owners = getClaimAssignedUsersByClaimId($claim_id);

  

  if($_SESSION['current_usertype'] == '1') return array_pop($assignments_owners);

  if(in_array($_SESSION['current_user_id'], $assignments_owners)) return ($_SESSION['current_user_id']);

  

  // TODO

  $my_company = getUsersDomByCompanyId($_SESSION['current_company_id'], 'username');

  if(count($my_company) > 0) {

    foreach ($my_company as $key => $user_name) {

      if(in_array($key, $assignments_owners))

        return $key;

    }

  }

  

  if($assignments_owners[0] !='') return $assignments_owners[0];

  else return '0';

}



function moveClaimToSecondaryArchive($claim_id, $old_claim_assigned_info,$uid) {

  // Move claim in to Secondary Archive field for old assignee user...

global $db;



updateAssignment($_POST['claim_id'], 'archive', $old_claim_assigned_info['claim_inspected_by']['user_id']);

/*$archive=array();

$type1=array();

 /*$q = "select archive,type1 from claim_assignment_user where user_id = '".$_POST['user_id']."' and (type1 like '%".$claim_id."%' or type2 like '%".$claim_id."%' or type3 like '%".$claim_id."%' or type4 like '%".$claim_id."%' or type5 like '%".$claim_id."%' or archive like '%".$claim_id."%')";

 */

 /* $q = "select archive,type1,user_id from claim_assignment_user where archive like '%".$_POST['claim_id']."%'";

  $claim_assignment_ids = $db->get_results($q);

 if(count($claim_assignment_ids)>0)

 {

	foreach($claim_assignment_ids as $id)

	{

		$exploded_array = explode(",", $id->archive);

		if(in_array($claim_id, $exploded_array)) {

     		 $fliped_array = array_flip($exploded_array);

     		 unset($fliped_array[$claim_id]);

      

      		

    	}

		else

			 $fliped_array = array_flip($exploded_array);

		

			$real_array = array_flip($fliped_array);

     		 $archive2= implode(",", $real_array);

			 

		$exploded_array1 = explode(",", $id->type1);

		if(in_array($claim_id, $exploded_array1)) {

     		 $fliped_array1 = array_flip($exploded_array1);

     		 unset($fliped_array1[$claim_id]);

      

      		

    	}

		else

		 $fliped_array1 = array_flip($exploded_array1);

		 

		 $real_array1 = array_flip($fliped_array1);

     		 $type11= implode(",", $real_array1);

			 

		 	$archive=getExIm($archive2, $claim_id);

  			$type1=getExIm($type11, $claim_id);

			//echo $old_claim_assigned_info['claim_inspected_by']['user_id'];

   				//if($old_claim_assigned_info['claim_inspected_by']['user_id']!=$id->user_id)

				//{

					

				//}

		

	}	

	

}*/



 

   

  /*  $q = "select archive,type1 from claim_assignment_user where user_id = '".$old_claim_assigned_info['claim_inspected_by']['user_id']."' and (type1 like '%".$claim_id."%' or type2 like '%".$claim_id."%' or type3 like '%".$claim_id."%' or type4 like '%".$claim_id."%' or type5 like '%".$claim_id."%' or archive like '%".$claim_id."%')";

	*/

/*	 $q = "select archive,type1,user_id from claim_assignment_user where  type1 like '%".$_POST['claim_id']."%'";

  $claim_assignment_ids = $db->get_results($q);

 if(count($claim_assignment_ids)>0)

 {

	foreach($claim_assignment_ids as $id)

	{

		

		$exploded_array3 = explode(",", $id->archive);

		if(in_array($claim_id, $exploded_array3)) {

     		 $fliped_array3 = array_flip($exploded_array3);

     		 unset($fliped_array3[$claim_id]);

      

      		

    	}

		else

			$fliped_array3 = array_flip($exploded_array3);

			

			$real_array3 = array_flip($fliped_array3);

     		 $archive3= implode(",", $real_array3);

			 

		$exploded_array4 = explode(",", $id->type1);

		if(in_array($claim_id, $exploded_array4)) {

     		 $fliped_array4 = array_flip($exploded_array4);

		

     		 unset($fliped_array4[$claim_id]);

      	

      		

    	}

		else

			 $fliped_array4 = array_flip($exploded_array4);

			 

			 $real_array4 = array_flip($fliped_array4);

     		 $type4= implode(",", $real_array4);

		 $archive4=getExIm($archive3, $claim_id);

		  $type5=getExIm($type4, $claim_id);

		  

			

		  

		

	}	

	

}*/

/*echo $q="update claim_assignment_user set type1='".$type1."' ,archive='". $archive2."'  where archive like '%".$_POST['claim_id']."%' ";

					 echo "<br/>"; echo "<br/>";

					  echo "<br/>";

					   echo "<br/>";

					 $db->query($q);

  echo  $q="update claim_assignment_user set archive='".$archive4."',type1='".$type4."'  where type1 like '%".$_POST['claim_id']."%' ";

			 echo "<br/>";

			 $db->query($q);*/

   $q="update reassignment set place=2 where claim_id='".$_POST['claim_id']."' ";

	   $db->query($q);
	$arr=explode(",",$_POST['user_id']);
	foreach($arr as $ud)
	{
			  $s="select place from reassignment where claim_id='".$_POST['claim_id']."' and user_id='".$ud."' ";
			
			  $rs= $db->get_results($s);
			
			  if(count($rs)>0)
			
			  {
			
				
			
				   $q="update reassignment set place=1 where claim_id='".$_POST['claim_id']."' and user_id='".$ud."'";
			
				   $db->query($q);
			
				
			
			   }
			
			   else
			
			   {
			
					$q="insert into reassignment ( user_id,place,claim_id) values('".$ud."',1,'".$_POST['claim_id']."')"; 
			
					$db->query($q);  
			
				}

	}

    $s="select place from reassignment where user_id='".$old_claim_assigned_info['claim_inspected_by']['user_id']."' and claim_id='".$_POST['claim_id']."' ";

  $rs= $db->get_results($s);

  if(count($rs)>0)

  {

	foreach($rs as $val) 

	{

	   $q="update reassignment set place=2 where user_id='".$old_claim_assigned_info['claim_inspected_by']['user_id']."' and claim_id='".$_POST['claim_id']."'";

	   $db->query($q);

	} 

   }

    else

   {

		$q="insert into reassignment ( user_id,place,claim_id) values('".$old_claim_assigned_info['claim_inspected_by']['user_id']."',2,'".$_POST['claim_id']."')"; 

		$db->query($q);  

	}

	

	$log1 = "File number: ".getFileNumberById( $_POST['claim_id'] )." has Assigned To ".getUserNameById($_POST['user_id']);

  $q="update status_logs set assigner_name='".$_POST['user_id']."' ,log = '".addslashes($log1)."',  date_created = '".date("Y-m-d H:i:s")."', date_modified = '".date("Y-m-d H:i:s")."'  where type_id = '".$_POST['claim_id']."' and type = 'claim' order by date_created desc limit 1";

  $db->query($q);

}



function reassignClaim($claim_id, $fromAccount) {

  global $db;

  

  // First, clear assignments made after this one.

  deleteFutureAssignments($claim_id, $fromAccount);

  

  $log1 = "File number: ".getFileNumberById($claim_id)." is being reassigned by ".getUserNameById($fromAccount);

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim','NotAssigned');

}



function deleteFutureAssignments($claim_id, $fromAccount) {

  global $db;

  

  // If reassignment happens, archive each related claim in another's inbox.

  $there = false;

  $owners = getClaimAssignedUsersByClaimId($claim_id);

  $temp_string = array();

  

  $fromAccountAuth = getUserTypeById($fromAccount);

  

  $user_details = getUserInfo($fromAccount);

  $user_company_type = getCompanyTypeById($user_details->company_id);

  $claim_company_id = getCompanyIdByClaimId($claim_id);

  

  $claim_company_type = getCompanyTypeById($claim_company_id);

  if($claim_company_type == 1) $define_adjuster = '8'; // Ins Adjuster

  else if($claim_company_type == 4) $define_adjuster = '23'; // TP Adjuster



  // App Company...

  if($user_company_type == 2) {

    // App Branch Admin or App Branch Employee = Ins Adjuster

    $isEmployeeEquiv = ( $fromAccountAuth == '4' || $fromAccountAuth == '3' || $fromAccountAuth == '25' || $fromAccountAuth == '26' ); $prevAuth = $define_adjuster;

    foreach($owners as $owner) {

      // If Ins Adjuster

      if($isEmployeeEquiv) { 

        if(!$there) {

          $cur = getUserTypeById($owner);

          if( ($prevAuth == '4' || $prevAuth == '3' || $prevAuth == '25' || $prevAuth == '26' ) && ($cur == '4' || $cur == '3' || $cur == '25' || $cur == '26') )

            { $there = false; $temp_string[] = $owner; }

          elseif( !($prevAuth == '4' || $prevAuth == '3' || $prevAuth == '25' || $prevAuth == '26') && ( $cur == '4' || $cur == '3' || $cur == '25' || $cur == '26') )

            { $there = false; $temp_string[] = $owner; }

          elseif( ($prevAuth == '4' || $prevAuth == '3' || $prevAuth == '25' || $prevAuth == '26') && !($cur == '4' || $cur == '3' || $cur == '25' || $cur == '26') )

            { $there = true; }

          else

            { $there = false; $temp_string[] = $owner; }

          $prevAuth = getUserTypeById($owner);

        } else {

          deleteAssignment($claim_id, $owner);

        }

      } else {

        if($there) deleteAssignment($claim_id, $owner);

        else $temp_string[] = $owner;

        

        if(strval($owner) == strval($fromAccount)) $there = true;

      }

    }

  

  // BS Company...

  } else if($user_company_type == 3) {

    

    // BS Branch Admin or BS Branch Employee = TP Adjuster

    $isEmployeeEquiv = ( $fromAccountAuth == '17' || $fromAccountAuth == '19' ); $prevAuth = $define_adjuster;

    foreach($owners as $owner) {

      // If Ins Adjuster

      if($isEmployeeEquiv) {

        if(!$there) {

          $cur = getUserTypeById($owner);

          if( ($prevAuth == '17' || $prevAuth == '19') && ($cur == '17' || $cur == '19') )

            { $there = false; $temp_string[] = $owner; }

          elseif( !($prevAuth == '17' || $prevAuth == '19') && ( $cur == '17' || $cur == '19') )

            { $there = false; $temp_string[] = $owner; }

          elseif( ($prevAuth == '17' || $prevAuth == '19') && !($cur == '17' || $cur == '19') )

            { $there = true; }

          else

            { $there = false; $temp_string[] = $owner; }

          $prevAuth = getUserTypeById($owner);

        } else {

          deleteAssignment($claim_id, $owner);

        }

      } else {

        if($there) deleteAssignment($claim_id, $owner);

        else $temp_string[] = $owner;

        

        if(strval($owner) == strval($fromAccount)) $there = true;

      }

    }

    

  }

  

  $q = "update claim_assignments set user_id = '".implode(",", $temp_string)."' where id = '$claim_id'";

  $db->query($q);

}



function deleteAssignment($claim_id, $account, $logmsg = '') {

  global $db;

  

  // When multiple assigns are made, make a recursive call.

  if(strstr($account, ',')) {

    $temp_ar = clean_array(explode(',', $account));

    $temp_ar = array_unique($temp_ar);

    if(count($temp_ar) > 0) {

      foreach($temp_ar as $newOwner) {

        deleteAssignment($claim_id, $newOwner, $logmsg = '');

      }

    }

    return true;

  }

  

  if($claim_id !='' && $account !='') {

    $q = "select * from claim_assignment_user where user_id = '$account'";

    $claim_assignment_user_info = $db->get_row($q, ARRAY_A);

    

    for ($i = 1; $i<=CLAIM_ASSIGNMENT_LEVEL; $i++) {

      $typeString = "type".strval($i);

      

      $exploded_array = explode(",", $claim_assignment_user_info[$typeString]);

      if(in_array($claim_id, $exploded_array)) {

        $fliped_array = array_flip($exploded_array);

        unset($fliped_array[$claim_id]);

        

        $real_array = array_flip($fliped_array);

        $claim_assignment_user_info[$typeString] = implode(",", $real_array);

      }

    }

    

    $exploded_archive_array = explode(",", $claim_assignment_user_info['archive']);

    if(in_array($claim_id, $exploded_archive_array)) {

      $fliped_archive_array = array_flip($exploded_archive_array);

      unset($fliped_archive_array[$claim_id]);

      

      $real_archive_array = array_flip($fliped_archive_array);

      $claim_assignment_user_info['archive'] = implode(",", $real_archive_array);

    }

    

    $sql = "update claim_assignment_user set 

            archive = '".$claim_assignment_user_info['archive']."', 

            type1 = '".$claim_assignment_user_info['type1']."',

            type2 = '".$claim_assignment_user_info['type2']."',

            type3 = '".$claim_assignment_user_info['type3']."',

            type4 = '".$claim_assignment_user_info['type4']."',

            type5 = '".$claim_assignment_user_info['type5']."'

          where user_id = '".$account."'";

    $db->query($sql);

  

    if($logmsg !='') {

      if($logmsg != 'no-log') {

        $log1 = "File number: ".getFileNumberById($claim_id)." ".$logmsg." from ".getUserNameById($account);

      }

    } else {

      $log1 = "File number: ".getFileNumberById($claim_id)." has been removed from ".getUserNameById($account);

    }

    //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

  }

  

  return true;

}



function deleteAssignmentByType($claim_id, $user_id, $location = '', $logmsg = '') {

  global $db;

  // When multiple assigns are made, make a recursive call.

  if(strstr($user_id, ',')) {

    $temp_ar = clean_array(explode(',', $user_id));

    $temp_ar = array_unique($temp_ar);

    if(count($temp_ar) > 0) {

      foreach($temp_ar as $newOwner) {

        deleteAssignmentByType($claim_id, $newOwner, $location, $logmsg);

      }

    }

    return true;

  }

  

  $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where user_id = '$user_id'";

  $claim_assignment_user_info = $db->get_row($sql);

  

  $exploded_array = explode(",", $claim_assignment_user_info->$location);

  if(in_array($claim_id, $exploded_array)) {

    $fliped_array = array_flip($exploded_array);

    unset($fliped_array[$claim_id]);

    

    $real_array = array_flip($fliped_array);

    $loca_type = implode(",", $real_array);

  } else {

    $loca_type = $claim_assignment_user_info->$location;

  }

  

  $q = "update claim_assignment_user set $location = '".$loca_type."' where user_id = '".$user_id."'";

  $db->query($q);

  

  if($logmsg !='') {

    if($logmsg != 'no-log') {

      $log1 = "File number: ".getFileNumberById($claim_id)." ".$logmsg." from ".getUserNameById($account);

     // saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

    }

  } else {

    $log1 = "File number: ".getFileNumberById($claim_id)." has been removed from ".getUserNameById($account);

   // saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

  }

  

  return true;

}



function clean_array ($array) {

  foreach ($array as $key => $value) {

      if(is_array($value)) {

          $array[$key] = clean_array($value);

      } else {

          if ($value == NULL or $value == " " or $value == "") {

              unset($array[$key]);

          }

      }

  }

  return $array;

}



function displayClaimUploads($claim_id) {

  global $db;

  $q = "select * from uploads where claim_id = '".$claim_id."' order by id desc";

  $upload_info = $db->get_results($q);

  if(count($upload_info) == 0) return;

  

  $upload_status = array();

  $contains_images    = false;

  $contains_estimate  = false;

  $contains_addi      = false;

  $contains_invoice   = false;

  $contains_summary   = false;

  

  foreach($upload_info as $upload) {

    if($upload->type == 1)

      $contains_image = true;

    if($upload->type == 2)

      $contains_estimate = true;

    if($upload->type == 3)

      $contains_addi = true;

  }

  

  $sql1 = "select count(*) as cnt from appraisal_cmp_invoices where claim_id = '".$claim_id."' and deleted = '0'";

  $invoice_cnt1 = $db->get_var($sql1);

  $sql2 = "select count(*) as cnt from bodyshop_cmp_invoices where claim_id = '".$claim_id."' and deleted = '0'";

  $invoice_cnt2 = $db->get_var($sql2);

  $sql3 = "select count(*) as cnt from call_center_invoices where claim_id = '".$claim_id."' and deleted = '0'";

  $invoice_cnt3 = $db->get_var($sql3);

  $sql4 = "select count(*) as cnt from cfs_invoices where claim_id = '".$claim_id."' and deleted = '0'";

  $invoice_cnt4 = $db->get_var($sql4);

  if( $invoice_cnt1 > 0 || $invoice_cnt2 > 0 || $invoice_cnt3 > 0 || $invoice_cnt4 > 0 ) {

    $contains_invoice = true;

  }

  

  $sql_s = "select count(*) as cnt from claim_summaries where claim_id = '".$claim_id."' and deleted = '0'";

  $summaries_cnt = $db->get_var($sql_s);

  if( $summaries_cnt > 0) $contains_summary = true;

  

  $upload_status['image_upload']     = $contains_image;

  $upload_status['estimate_upload']  = $contains_estimate;

  $upload_status['additional_files'] = $contains_addi;

  $upload_status['claim_invoice']    = $contains_invoice;

  $upload_status['claim_summary']    = $contains_summary;

  

  return $upload_status;

}



function permanentlyDeleteClaim($claim_id) {

  global $db;

  $q = "delete from claims where id = '$claim_id'";

  $db->query($q);

  

  $q = "delete from claim_overdue_files where claim_id = '$claim_id'";

  $db->query($q);

  

  deleteDirectory(UPLOADED_FILES.$claim_id);

  

  //$sql = "select * from  claim_assignments where claim_id = '$claim_id'";

  //$claim_assign_info = $db->get_row($sql);

  //$owners = explode(',', $claim_assign_info->user_id);

  

  $db->query("delete from claim_assignments where claim_id = '$claim_id'");

  

  $owners = getClaimAssignmentUsersByClaimid($claim_id, $user_id = '');

  $owners = clean_array($owners);

  if(count($owners) > 0) {

    foreach ($owners as $owner) {

      removeAssignment($claim_id, $owner);

    }

  }

}

function getNamebyFile($imgpath = null){
	global $db;
	$ip=array();
	if(!is_null($imgpath)){
		$ip = explode('/',$imgpath);
	}
	$len = count($ip);
	$s="select name from uploads where file_name = '".$ip[$len-1]."' limit 0,1";
	$rs = $db->get_results($s);	
	if(count($rs)>0){
		return $rs[0]->name;
		// foreach($rs as $val){
			// $expldeuser=explode(',',$val->assigner_name);
			// $users=$val->assigner_name;
		// }
	}
	return false;
}

function deleteDirectory($dirname)  {

  if(is_dir($dirname)) $dir_handle = opendir($dirname);

  if(!$dir_handle) return  false;

  

  while($file = readdir($dir_handle))  {

    if($file !=  "."  && $file  != "..")  {

      if  (!is_dir($dirname."/".$file)) unlink($dirname."/".$file);

      else unlink($dirname.'/'.$file);

    }

  }

  closedir($dir_handle);

  rmdir($dirname);

  return  true;

}



function removeAssignment($claim_id, $uid) {

  global $db;

  

  $q = "select * from claim_assignment_user where user_id = '".$uid."'";

  $claim_assignment_user_info = $db->get_row($q, ARRAY_A);

  

  for ($i = 1; $i<=CLAIM_ASSIGNMENT_LEVEL; $i++) {

    $typeString = "type".strval($i);

    $exploded_array = explode(",", $claim_assignment_user_info[$typeString]);

    if(in_array($claim_id, $exploded_array)) {

      $fliped_array = array_flip($exploded_array);

      unset($fliped_array[$claim_id]);

      

      $real_array = array_flip($fliped_array);

      $claim_assignment_user_info[$typeString] = implode(",", $real_array);

    }

  }

  

  $exploded_archive_array = explode(",", $claim_assignment_user_info['archive']);

  if(in_array($claim_id, $exploded_archive_array)) {

    $fliped_archive_array = array_flip($exploded_archive_array);

    unset($fliped_archive_array[$claim_id]);

    

    $real_archive_array = array_flip($fliped_archive_array);

    $claim_assignment_user_info['archive'] = implode(",", $real_archive_array);

  }

  

  $sql = "update claim_assignment_user set 

          archive = '".$claim_assignment_user_info['archive']."', 

          type1 = '".$claim_assignment_user_info['type1']."',

          type2 = '".$claim_assignment_user_info['type2']."',

          type3 = '".$claim_assignment_user_info['type3']."',

          type4 = '".$claim_assignment_user_info['type4']."',

          type5 = '".$claim_assignment_user_info['type5']."'

        where user_id = '".$uid."'";

  $db->query($sql);

}



function getClaimAssignmentPermission($user_type) {

  switch($user_type) {

    case '111': return array(14,7,4,25,16,20);

    case '1': return array(14,7,4,25,16,20); 

    

    // Insurance Company

    case '11': return array(9,14,7,4,13,25,16,20);

    case '10': return array(9,14,7,4,13,25,16,20);

    case '9':  return array(14,7,4,13,25,16,20);

    case '8':  return array(14,7,4,13,25,16,20);

    case '14': return array(7,13,4,25,16,20);

    

    // Third Party Company

    case '20': return array(26,25,17,16,14,4,5);

    case '21': return array(26,25,17,16,14,4,5);

    case '22': return array(26,25,17,16,14,4,5);

    case '23': return array(26,25,17,16,14,4,5);

    case '24': return array(26,25,17,16,14,4,5);

    

    // Appraisal Company

    case '5': return array(4);

    case '4': return array(2,6);

    case '3': return array(2,6);

    case '2': return array(6);

    case '6': return array();

    case '25': return array(4);

    case '26': return array(4);

    

    // Body Shop Company

    case '16': return array(17);

    case '17': return array(38);

    case '18': return array(26,25,17,16,14,4,5);

    case '19': return array(38);

    

    // TODO Finish

    default: return array();

    break;

  }

}



function getClaimAssignmentLevel() {

  $claim_assignment_level_dom = array();

  for ($i = 1; $i <= CLAIM_ASSIGNMENT_LEVEL; $i++) {

    $claim_assignment_level_dom[] = "type".strval($i);

  }

  $claim_assignment_level_dom[] = "archive";

  return $claim_assignment_level_dom;

}



function getClaimBoxNameByClaimid($user_id, $claim_id, $locations = array()) {

  global $db;

  if(!empty($locations)) {

    foreach($locations as $location) {

      $q = "select count(*) as cnt from claim_assignment_user where user_id = '".$user_id."' and $location LIKE '%".$claim_id."%'";

      $claim_count = $db->get_var($q);

      if($claim_count == 0) continue;

      else return $location;

    }

  }

}



function displayClaimAbilities($claim_id, $claim_status, $user_id,$claim_created_company=null) {

  global $db;

  list($stub,$action) = explode("/", $_REQUEST['sws']);

  $claim_location_box = getClaimBoxNameByClaimid( $user_id, $claim_id, getClaimAssignmentLevel() );

  

  ### Super Global admin

  if($_SESSION['current_usertype'] == '111') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['status'] == '1') {

      $permissions = array(95, 1,2,3,49,4,6,7,8,9,10,11,12,15,16,33,32,34,35,36,37,28,29,30,31);

    } else if($stub == 'claim' && $action == 'claims' && ($_REQUEST['status'] == '2' || $_REQUEST['status'] == '3') ) {

      $permissions = array(95, 1,2,3,49,4,8,27,10,11,12,16,33,32,34,35,36,37,28,29,30,31);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(95, 1,3,49,4,8,10,11,12,16,33,32,34,35,36,37,28,29,30,31,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(95, 4,16,26,10,12);

      } else {

        $permissions = array(95, 1,2,3,49,4,6,7,8,9,10,11,12,15,16,33,32,34,35,36,37,28,29,30,31);

      }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['status'] == '5') {

      $permissions = array(95, 4,16,26,10,12);

    } else {

      $permissions = array(95, 1,2,3,4,49,6,7,8,9,10,11,12,15,16,33,32,34,35,36,37,28,29,30,31);

    }

    

  ### Global admin

  else if($_SESSION['current_usertype'] == '1') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['status'] == '1') {

      $permissions = array(94, 1,2,3,49,4,6,7,8,9,10,11,12,15,16,33,32,34,35,36,37,28,29,30,31);

    } else if($stub == 'claim' && $action == 'claims' && ($_REQUEST['status'] == '2' || $_REQUEST['status'] == '3') ) {

      $permissions = array(94, 1,2,3,49,4,8,27,10,11,12,16,33,32,34,35,36,37,28,29,30,31);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(94, 1,3,49,4,8,10,11,12,16,33,32,34,35,36,37,28,29,30,31,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(94, 4,16,26,10,12);

      } else {

        $permissions = array(94, 1,3,4,8,10,11,12,16,33,32,34,35,36,37,28,29,30,31);

      }

    } else if($stub == 'nclaim' && $action == 'claims' && $_REQUEST['status'] == '5') {

      $permissions = array(94, 4,16,49,26,10,12);

    } else {

      $permissions = array(94, 1,2,3,4,49,6,7,8,9,10,11,12,15,16,33,32,34,35,36,37,28,29,30,31);

    }

  

  ### Insurance Company Admin

  else if($_SESSION['current_usertype'] == '11')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(91,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(91,1,4,3,49,10,11,12,16,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(91, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(91,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(91,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(91,1,4,3,49,10,12,16);

    }

  

  ### Insurance Branch Admin

  else if($_SESSION['current_usertype'] == '10')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(92,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(92,1,4,3,49,10,11,12,16,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(92, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(92,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(92,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(92,1,4,3,49,10,12,16);

    }

    

  ### Insurance Branch Adjuster Supervisor

  else if($_SESSION['current_usertype'] == '9') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(93,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(93,1,4,3,49,10,11,12,16,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(93, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(93,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(93,1,3,49,4,10,12,16); 

      }

      

    } else {

      $permissions = array(93,1,4,3,49,10,12,16);

    }

  

  ### Insurance Branch Adjuster

  else if($_SESSION['current_usertype'] == '8') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(0,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,5,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  ### Insurance Branch Dispatcher

  else if($_SESSION['current_usertype'] == '14') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(0,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(0,2,4,3,49,12,17,5,1,5,11,6,7);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,17,5,1,5,11,6,7);

        else if($claim_location_box == 'type5') $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  ### Insurance Branch In-House Appraiser

  else if($_SESSION['current_usertype'] == '7') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27,33,32,45,34);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

  ### Insurance Branch Desk Reviewer

  else if($_SESSION['current_usertype'] == '12') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,19,1,15,16);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,9,10,23,1,15,16);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,19,1,15,16);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,9,10,23,1,15,16);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  ### Insurance Branch Re inspector

  else if($_SESSION['current_usertype'] == '13') 

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,20,1,15,16,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,10,23,1,15,16,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,20,1,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,10,23,1,15,16,11);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

    

  ### Third Party Company Admin

  else if($_SESSION['current_usertype'] == '20')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(91,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(91,1,4,3,49,10,11,12,16,27,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(91,4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(91,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(91,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(91,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(91,1,4,3,49,10,12,16);

    }

  

  ### Third Party Branch Admin

  else if($_SESSION['current_usertype'] == '21')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(92,2,4,3,49,12,1,15,16,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(92,1,4,3,49,10,11,12,16,27,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(92,4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(92,2,4,3,49,12,1,15,16,5,11);

        else if($claim_location_box == 'type2') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(92,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(92,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(92,1,4,3,49,10,12,16);

    }

    

  ### Third Party Dispatcher

  else if($_SESSION['current_usertype'] == '24')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(0,2,4,3,49,12,1,5,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

    } else if( $stub == 'claim' && $action == 'search-claims') {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0,4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,12,1,5,11);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

        else if($claim_location_box == 'type5') $permissions = array(0,2,4,3,49,12,17,5,1,11,6,7);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  ### Third Party Adjuster

  else if( $_SESSION['current_usertype'] == '23' )

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned' ) {

      $permissions = array(0,2,4,3,49,12,1,15,16,5,15,11);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned' ) {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,12,1,15,16,5,15,11);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

      

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

  ### Third Party Adjuster Supervisor

  else if($_SESSION['current_usertype'] == '22')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'unassigned') {

      $permissions = array(93,2,4,3,49,12,1,15,16,5,15,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending-appraiser-acceptance' ) {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'marked-completed-by-assignee' ) {

      $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(93,1,4,3,49,10,11,12,16,27,28,29,30,31,32);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(93,4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(93,2,4,3,49,12,1,15,16,5,15,11);

        else if($claim_location_box == 'type2') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type5') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        else if($claim_location_box == 'type4') $permissions = array(93,2,4,3,49,12,9,10,17,5,1,15,16,11,6,7,28,29,30,31,32);

        // Archive Abilities

        else $permissions = array(93,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(93,1,4,3,49,10,12,16);

    }

  

  

  ### Appraisal Company Admin

  else if($_SESSION['current_usertype'] == '5')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,33,32,45,34,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,33,32,45,34);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(91,2,4,3,49,39,12,1,15,16,11,9,10,33,32,45,34);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'overdue-files') {

      $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,33,32,45,34,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,33,32,45,34);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(91,2,4,3,49,39,12,1,15,16,11,9,10,33,32,45,34);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(91,1,3,49,4,10,12,16,33,32,34,45); 

      } else if($claim_status == 5) { // Deleted

        $permissions = array(91, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1' || $claim_location_box == 'type2') $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,33,32,45,34);

        // Archive Abilities

        else $permissions = array(91,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(91,1,4,3,49,10,12,16);

    }

    

    

  ### Appraisal Branch Admin

  else if($_SESSION['current_usertype'] == '4')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(92,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(92,2,4,3,49,24,12,1,6,7,21,15,16,11);
	  
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(92,2,4,3,49,24,12,1,6,7,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,24,12,1,21,15,16,11);
	  }
	  

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(92,2,4,3,49,50,12,1,6,7,21,15,16,11,9,10,33,32,45,34,100,101,102,103,104,105,106,107);
	  
      //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(92,2,4,3,49,50,12,1,6,7,21,15,16,11,9,10,33,32,45,34);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,50,12,1,21,15,16,11,9,10,33,32,45,34);
	  }	  
	  

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {
		
      $permissions = array(92,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type	  
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,50,12,1,15,16,11,9,10,33,32,45,34);
	  }
		if($claim_created_company==3){
			$permissions = array(92,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,34);
		}
    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(92,1,4,3,49,10,11,12,16,27,33,32,34);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(92, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(92,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(92,2,4,3,49,24,12,1,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(92,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,45,34,100,101,102,103,104,105,106,107);

        else if($claim_location_box == 'type4') $permissions = array(92,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,45,34,100,101,102,103,104,105,106,107);

        // Archive Abilities

        else $permissions = array(92,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(92,1,4,3,49,10,12,16);

    }

  

  ### Appraisal Branch Employee

  else if($_SESSION['current_usertype'] == '3')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,24,12,1,6,7,21,15,16,11);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(0,2,4,3,49,24,12,1,6,7,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,24,12,1,21,15,16,11);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {
	

      $permissions = array(0,2,4,3,49,50,12,1,6,7,21,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
      
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(0,2,4,3,49,21,50,12,1,6,7,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,50,12,1,21,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  }
	  

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      // $permissions = array(0,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,34);
	  $permissions = array(0,2,4,3,49,50,12,1,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==3){
		$permissions = array(0,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,50,12,1,15,16,11,9,10,33,32,34,45,100,101,102,103,104,105,106,107);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27,33,32,34);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,24,12,1,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,21,50,12,1,6,7,15,16,11,9,10,33,32,34);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,50,12,1,6,7,15,16,11,9,10,33,32,34);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

  ### Appraisal Branch Appraisal

  else if($_SESSION['current_usertype'] == '2')

  if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11,101);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,10,23,1,16,11,101);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0, 1,3,49,4,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

  ### Appraisal Branch Desk Reviewer

  else if($_SESSION['current_usertype'] == '6')

  if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,19,1,15,16,105);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,10,23,1,16,11,105);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        // New Claim Inbox

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        // In Progress

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,19,1,15,16);

        // Pending Review/Completion

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  

  ### Appraisal Call Center Branch Admin

  else if($_SESSION['current_usertype'] == '25')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(92,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(92,2,4,3,49,24,12,1,6,7,15,16,11);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==2){
		$permissions = array(92,2,4,3,49,24,12,1,6,7,21,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,24,12,1,21,15,16,11);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,108,45,21,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type,
	  if($claim_created_company==2){
		$permissions = array(92,2,4,3,49,5,12,1,6,7,21,15,16,11,9,10,33,32,34,46,47,48,108,45,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,5,12,1,15,16,11,9,10,33,32,34,46,47,48,21,108,45,100,101,102,103,104,105,106,107);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,108,45,21,100,101,102,103,104,105,106,107);
	  
	  if($claim_created_company==2){
		$permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,108,45,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,5,12,1,15,16,11,9,10,33,32,34,46,47,48,108,45,100,101,102,103,104,105,106,107);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(92,1,4,3,49,10,12,16,33,32,34,46,47,48,21); 

      } else if($claim_status == 5) { // Deleted

        $permissions = array(92, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(92,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(92,2,4,3,49,24,12,1,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,21);

        else if($claim_location_box == 'type4') $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,21);

        // Archive Abilities

        else $permissions = array(92,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(92,1,4,3,49,10,12,16);

    }

  

  ### Appraisal Call Center Branch Employee

  else if($_SESSION['current_usertype'] == '26')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,24,12,1,6,7,15,16,11);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==2){
		$permissions = array(0,2,4,3,49,24,12,1,6,7,21,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,24,12,1,21,15,16,11);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,46,47,21,48,45,108,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==2){
		$permissions = array(0,2,4,3,49,5,12,1,6,7,21,15,16,11,9,10,33,32,46,47,48,45,108,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,5,12,1,21,15,16,11,9,10,33,32,46,47,48,45,108,100,101,102,103,104,105,106,107);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,21,48,45,108,100,101,102,103,104,105,106,107);
	  //Deepak added for Issue Completed Status Type
	  if($claim_created_company==2){
		$permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,45,108,100,101,102,103,104,105,106,107);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,5,12,1,15,16,11,9,10,33,32,34,46,47,48,45,108,100,101,102,103,104,105,106,107);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,12,16,33,32,34,46,47,48,21); 

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,24,12,1,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,46,47,21);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,33,32,34,46,47,48,21);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  

  ### Body Shop Company Admin

  else if($_SESSION['current_usertype'] == '16')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'assigned') {

      $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,40,41,42,43);
	  if($claim_created_company==2){
		$permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,40,41,42,43);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(91,2,4,3,49,39,12,1,15,16,11,9,10,40,41,42,43);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'overdue-files') {

      $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,40,41,42,43);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27,40,41,44,42);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1' || $claim_location_box == 'type2') {

           $permissions = array(91,2,4,3,49,39,12,1,6,7,15,16,11,9,10,40,41,42,43);

        // Archive Abilities

        } else {

          $permissions = array(0,1,3,49,4,10,12,16); 

        }

      }

    } else {

      $permissions = array(91,1,4,3,49,10,12,16);

    }

  

  ### Body Shop Branch Admin

  else if($_SESSION['current_usertype'] == '17')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(92,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(92,2,4,3,49,38,1,12,6,7,15,16,11);
	  if($claim_created_company==3){
		$permissions = array(92,2,4,3,49,38,1,12,6,7,21,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,38,1,12,21,15,16,11);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,42,21);
	  if($claim_created_company==3){
		$permissions = array(92,2,4,3,49,5,12,1,6,7,21,15,16,11,9,10,40,41,42);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,5,12,1,21,15,16,11,9,10,40,41,42);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);
	  if($claim_created_company==2){
		$permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(92,2,4,3,49,5,12,1,15,16,11,9,10,40,41,44);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(92,1,4,3,49,10,11,12,16,27,40,41,44);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(92, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(92,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(92,2,4,3,49,38,1,12,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,42,21);

        else if($claim_location_box == 'type4') $permissions = array(92,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);

        // Archive Abilities

        else $permissions = array(92,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(92,1,4,3,49,10,12,16);

    }

  

  ### Body Shop Branch Employee

  else if($_SESSION['current_usertype'] == '19')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,38,1,12,6,7,15,16,11);
	  if($claim_created_company==3){
		$permissions = array(0,2,4,3,49,38,1,12,6,7,21,15,16,11);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,38,1,12,21,15,16,11);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,42,21);
	  if($claim_created_company==3){
		$permissions = array(0,2,4,3,49,5,12,1,6,7,21,15,16,11,9,10,40,41,42);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,5,12,1,21,15,16,11,9,10,40,41,42);
	  }

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'completed') {

      $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);
	  if($claim_created_company==2){
		$permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);
	  }
	  if($claim_created_company==4 || $claim_created_company==1){
		$permissions = array(0,2,4,3,49,5,12,1,15,16,11,9,10,40,41,44);
	  }

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27,40,41,44);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,38,1,12,6,7,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,42,21);

        else if($claim_location_box == 'type4') $permissions = array(0,2,4,3,49,5,12,1,6,7,15,16,11,9,10,40,41,44);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

  

  ### Body Shop Branch Estimator

  else if($_SESSION['current_usertype'] == '18')

    if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'new') {

      $permissions = array(0,2,4,3,49,18,12,1);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'inprocess') {

      $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11);

    } else if($stub == 'claim' && $action == 'claims' && $_REQUEST['type'] == 'pending') {

      $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

    } else if( $stub == 'claim' && $action == 'search-claims' ) {

      if($claim_status == 2 || $claim_status == 3) { // Closed or Cancled

        $permissions = array(0,1,4,3,49,10,11,12,16,27);

      } else if($claim_status == 5) { // Deleted

        $permissions = array(0, 4,16,26,10,12);

      } else {

        if($claim_location_box == 'type1') $permissions = array(0,2,4,3,49,18,12,1);

        else if($claim_location_box == 'type2') $permissions = array(0,2,4,3,49,12,9,10,21,1,15,16,11);

        else if($claim_location_box == 'type3') $permissions = array(0,2,4,3,49,12,10,23,1,16,11);

        // Archive Abilities

        else $permissions = array(0,1,3,49,4,10,12,16); 

      }

    } else {

      $permissions = array(0,1,4,3,49,10,12,16);

    }

    

  //if($stub == 'claim' && $action == 'claims' && $_REQUEST['status'] == 5) {

  //  $permissions = array_merge($permissions,array(26));

  //}

  

  $permissions_dom = array();

  if(count($permissions) > 0) {

    foreach($permissions as $permi) {

      $permissions_dom[$permi] = displayClaimAbility($permi);

    }

  }

  

  return $permissions_dom;

}



function displayClaimAbility($permission) { 

  global $db;

  $map = array( '0' => '--- Select ---'

  , '1'=> 'Edit Status'

  , '2'=> 'Edit Claim' // Edit Assignment

  , '3'=> 'Print Claim'

  , '4'=> 'View Claim'

  , '5'=> 'Re-Assign Claim'

  , '6'=> 'Cancel Claim'

  , '7'=> 'Close Claim'

  , '8'=> 'Delete Claim'

  , '9'=> 'Upload to Claim'

  , '10'=> 'View Uploads'

  , '11'=> 'Create Supplement'

  , '12'=> 'Email'

  , '13'=> 'Create / Edit Invoice'

  , '14'=> 'View Invoice'

  , '15'=> 'Create/Edit Claim Summary'

  , '16'=> 'View Claim Summary'

  , '17'=> 'Move back to Unassigned '

  , '18'=> 'Accept Claim'

  , '19'=> 'Mark Claim Reviewed '

  , '20'=> 'Mark Claim Reinspected'

  , '21'=> 'Mark Claim Completed '

  , '22'=> 'Delete Invoice'

  , '23'=> 'Move Back to In Process'

  , '24' => 'Dispatch Claim To IA'

  , '25' => 'Reassign to Branch / Franchise'

  , '26' => 'Permanently Delete Claim'

  , '27' => 'Reopen Claim'

  

  // New Actions in phase 2

  , '28' => 'Edit Claimant Payout Amount'

  , '29' => 'Mark Claimant Paid'

  , '30' => 'Edit Insured Payout Amount'

  , '31' => 'Mark Insured Paid'

  , '32' => 'View Appraisal Company Invoice' 

  , '33' => 'Create/Edit Appraisal Company Invoice' 

  , '34' => 'Mark Appraisal Company Invoice Paid' //

  , '35' => 'Create/Edit Claims Flow Solutions Invoice'

  , '36' => 'View Claims Flow Solutions Invoice'

  , '37' => 'Mark Claims Flow Solutions Invoice Paid'

  , '38' => 'Dispatch Claim to Estimator'

  , '39' => 'Re-Assign to Branch / Franchise'

  , '40' => 'Create/Edit Body Shop Invoice'

  , '41' => 'View Body Shop Invoice'

  , '42' => 'Delete Body Shop Invoice'

  , '43' => 'Mark Body Shop Invoice Paid'

  , '44' => 'Mark Appraisal Body Shop Paid'

  , '45' => 'Delete Appraisal Company Invoice'

  , '46' => 'Create/Edit Call Center Invoice'

  , '47' => 'View Call Center Invoice'

  , '48' => 'Mark Call Center Invoice Paid'

  , '49' => 'View/Print Assignment'

  , '50'=> 'Re-Assign Claim' // Re-assign claim for App Branch Admin from Pending Review/Completion tab...

  

  , '91'=> '--- Company admin abilities ---'

  , '92'=> '--- Branch admin abilities ---'

  , '93'=> '--- Supervisor  abilities ---'

  , '94'=> '--- Global admin abilities ---'

  , '95'=> '--- Super Global admin abilities ---'

  , '99'=> 'No assignments exist.'
 //Urgent: FIRST: Needed for Reports: Abilities to invoice appraisers, etc....
  , '100'=>'Create/Edit Appraiser Fee Invoice'
  
  ,'101'=>' View Appraiser Fee Invoice'
  
  ,'102'=>' Delete Appraiser Fee Invoice'
  
  ,'103'=>' Mark Appraiser Fee Invoice Paid'
  
  ,'104'=>' Create/Edit Reviewer Fee Invoice'
   
  ,'105'=>' View Reviewer Fee Invoice'
	
 ,'106'=>' Delete Reviewer Fee Invoice'

  ,'107'=>' Mark Reviewer Fee Invoice Paid'
  
  ,'108'=> ' Delete Call Center Invoice'
  //Urgent: FIRST: Needed for Reports: Abilities to invoice appraisers, etc....
  );

  

  return $map[$permission];

  //echo '<option value="'.$permission.'">'.$map[$permission].'</option>';

}



function getClaimActionPermission($claim_id) {

  global $db;

  $claim_owner = getClaimOwner($claim_id);

  

  if($claim_owner == 'None') return array('99');

  $user = getUserInfo($claim_owner);

  if($user->user_type == '1') return array(); //errorHandle("No assignments go to global admins");



  $loc = getClaimOwnerLocFromDb($claim_id, $user->user_type, $claim_owner);

  if($loc == 'Archive') {

    return array( 0

      ,2 /*View Assignment*/

      ,3 /* Print Assignment */

      ,10 /* View Uploads */

      ,11 /* Create Supplement */

      ,14 /* View Invoice */

      ,12 /* Email */

      ,27 /* Reopen claim*/

      );

  }

  switch ($user->user_type) {

    case '11':   //"Insurance Company Admin";

      switch($loc) {

        case 'Unassigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          );

        case 'Assigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,10 /* View Uploads */

          ,14 /* View Invoice */

          );

      }

    case '10':   //"Branch Admin";

      switch($loc) {

        case 'Unassigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          );

        case 'Assigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Ressign Claim */

          ,17 /* Move back to unassigned */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,11 /* Create Supplement */

          ,14 /* View Invoice */

          );

      }

    case '9':   //"Adjuster Supervisor";

      switch($loc) {

        case 'Unassigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Assign */

          );

        case 'Assigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Ressign Claim */

          ,17 /* Move back to unassigned */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,11 /* Create Supplement */

          ,14 /* View Invoice */

          );

      }

    case '8':   //"Adjuster";

      switch($loc) {

        case 'Unassigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Assign */

          );

        case 'Assigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Ressign Claim */

          ,17 /* Move back to unassigned */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,11 /* Create Supplement */

          ,14 /* View Invoice */

          );

      }

    case '12':   //"Desk Reviewer";

      switch($loc) {

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'In Process':

        return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,19 /* Mark claim reviewed */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,23 /* Send claim back to in process */

          );

      }

    case '5':   //"Appraisal Company Admin";

      switch($loc) {

        default: // Assigned to Branch

          return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,25 /* Reassign Branch*/

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,15 /* Create Claim Summary */

          ,10 /* View Uploads */

          ,13 /* Create / Edit Invoice */

          ,22 /* Delete Invoice */

          );

      }

    case '2':   //Appraiser;

      switch($loc) {

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'In Process':

        return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,21 /* Mark claim completed */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,15 /* Create Claim Summary */

          ,16 /* View Summary */

          ,11 /* Create Supplement */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          // ,5 /* Ressign Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,15 /* Create Claim Summary */

          ,16 /* View Summary */

          ,11 /* Create Supplement */

          ,23 /* Move back to in process*/

          ,9 /* Upload */

          ,10 /* View Uploads */

          );

          // * Search all claims within branch.

      }

      break;

    case '4':   //"Branch Admin";

    case '3':   //"Employee";

      switch($loc) {

        case 'New C. Inbox':

        return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case "Assigned To Dispatch":

        return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,24 /* Dispatch to IA*/

          ,12 /* Email */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,15 /* Create Claim Summary */

          ,11 /* Create Supplement */

          );

      case 'Assigned To IA': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,5 /* Ressign Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,15 /* Create Claim Summary */

          ,11 /* Create Supplement */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,13 /* Create / Edit Invoice */

          );

        case 'Pending Review / Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,5 /* Ressign Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,15 /* Create Claim Summary */

          ,11 /* Create Supplement */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,13 /* Create / Edit Invoice */

          );

          // * Search all claims within branch.

      }

    case '6':   //"Desk Reviewer";

      switch($loc){

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,15 /* Create Claim Summary */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,20 /* Mark claim reinspected */

          );

      }

    case '13':   //"Reinspector";

      switch($loc) {

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'In Process': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,9 /* Upload */

          ,10 /* View uploads */

          ,20 /* Mark claim reinspected*/

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,23 /* Move back to inprocess */

          ,10 /* View Uploads */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

      }

    case '14':   //"Dispatcher";

      switch($loc) {

        case 'Unassigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Assign */

          );

        case 'Assigned': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,5 /* Ressign Claim */

          ,17 /* Move back to unassigned */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,10 /* View Uploads */

          );

      }

    case '15':   //"Call Center";

      switch($loc) {

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept claim*/

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,5 /* Ressign Claim */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,6 /* Cancel Claim */

          ,7 /* Close Claim */

          ,15 /* Create Claim Summary */

          ,7 /* Close Claim */ // Mark Sent [ sends full claim including images and pdfs back to the adjuster ]

          );

      }

    case '7':   //"In-House Appraiser";

      switch($loc) {

        case 'New C. Inbox': return array( 0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,18 /* Accept claim*/

          ,12 /* Email */

          ,1 /* Edit Status */

          );

        case 'In Process': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,9 /* Upload */

          ,10 /* View Uploads */

          ,21 /* Mark Claim Completed */

          ,12 /* Email */

          ,1 /* Edit Status */

          ,15 /* Create Claim Summary */

          ,11 /* Create Supplement */

          );

        case 'Pending':

        case 'Completion': return array(0

          ,2,4 /*View / Edit Assignment*/

          ,3 /* Print Assignment */

          ,23 /* Move back to in process */

          ,10 /* View Uploads */

          ,12 /* Email */

          ,1 /* Edit Status */

          );

      }

  }

  return array(99);

}



function cancelClaim($claim_id) {

  global $db;

  $owners = getClaimAssignedUsersByClaimId($claim_id);

  foreach($owners as $owner) {

     archiveAssignment($claim_id, $owner, 'canceled');

  }

  $q = "update claims set status = '3', claim_closed_by_company = '".$_SESSION['current_company_type']."', date_end = '".returnTimestamp()."' where id = '".$claim_id."' limit 1";

  $db->query($q);

  $s="select assigner_name from status_logs where type_id = '".$claim_id."' and type = 'claim' order by date_created desc limit 1";

	 $rs = $db->get_results($s);

	 if(count($rs)>0)

	 	{

			foreach($rs as $val)

			{

				$expldeuser=explode(',',$val->assigner_name);
				$users=$val->assigner_name;
			}
		}

 /* $log1 = "File number: ".getFileNumberById($claim_id)." has been canceled by ".getUserNameById($_SESSION['current_user_id']);

  saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',$users);
*/
}



function closeClaim($claim_id) {

  global $db;

  $owners = getClaimAssignedUsersByClaimId($claim_id);

  foreach($owners as $owner) {

    archiveAssignment($claim_id, $owner, 'closed');

  }

  

  $q = "update claims set status = '2', claim_closed_by_company = '".$_SESSION['current_company_type']."', date_end = '".returnTimestamp()."' where id = '".$claim_id."' limit 1";

  $db->query($q);

  $s="select assigner_name from status_logs where type_id = '".$claim_id."' and type = 'claim' order by date_created desc limit 1";

	 $rs = $db->get_results($s);

	 if(count($rs)>0)

	 	{

			foreach($rs as $val)

			{

				$expldeuser=explode(',',$val->assigner_name);
				$users=$val->assigner_name;
			}
		}

 /* $log1 = "File number: ".getFileNumberById($claim_id)." has been closed by ".getUserNameById($_SESSION['current_user_id']);

  saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim',$users);
*/
}



function deleteClaim($claim_id) {

  global $db;

  $owners = getClaimAssignedUsersByClaimId($claim_id);

  foreach($owners as $owner) {

    archiveAssignment($claim_id, $owner, 'deleted');

  }

  $q = "update claims set status = '5', date_end = '".returnTimestamp()."' where id = '".$claim_id."' limit 1";

  $db->query($q);

  

  $log1 = "File number: ".getFileNumberById($claim_id)." has been deleted by ".getUserNameById($_SESSION['current_user_id']);

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

}



function archiveAssignment($claim_id, $account, $logmsg = 'archived') {

  global $db;

  

  /*

  $q = "select * from claim_assignment_user where user_id = '".$account."'";

  $claim_assignment_user_info = $db->get_row($q, ARRAY_A);

  

  for ($i = 1; $i<=CLAIM_ASSIGNMENT_LEVEL; $i++) {

    $typeString = "type".strval($i);

    $exploded_array = explode(",", $claim_assignment_user_info[$typeString]);

    if(in_array($claim_id, $exploded_array)) {

      $fliped_array = array_flip($exploded_array);

      unset($fliped_array[$claim_id]);

      

      $real_array = array_flip($fliped_array);

      $claim_assignment_user_info[$typeString] = implode(",", $real_array);

    }

  }

  

  $exploded_archive_array = explode(",", $claim_assignment_user_info['archive']);

  if(in_array($claim_id, $exploded_archive_array)) {

    $fliped_archive_array = array_flip($exploded_archive_array);

    unset($fliped_archive_array[$claim_id]);

    

    $real_archive_array = array_flip($fliped_archive_array);

    $claim_assignment_user_info['archive'] = implode(",", $real_archive_array);

  }

  

  $sql = "update claim_assignment_user set 

          archive = '".$claim_assignment_user_info['archive']."', 

          type1 = '".$claim_assignment_user_info['type1']."',

          type2 = '".$claim_assignment_user_info['type2']."',

          type3 = '".$claim_assignment_user_info['type3']."',

          type4 = '".$claim_assignment_user_info['type4']."',

          type5 = '".$claim_assignment_user_info['type5']."'

        where user_id = '".$account."'";

  $db->query($sql);

  */

  

  $claim_file_number = getFileNumberById($claim_id);

  $log = "File number: $claim_file_number has been ".$logmsg." for ".getUserNameById($account);

 // saveStatusLog($_SESSION['current_user_id'], $claim_id, $log, 'claim');

  return true;

}



function deleteInvoice($claim_id) {

  global $db;

  $claim_owner = getClaimAssignedUsersByClaimId($claim_id);

  $db->query("delete from invoices where id = '$claim_id'");

  

  $claim_file_number = getFileNumberById($claim_id);

  $log = "File number: $claim_file_number, owned by ".getUserNameById($claim_owner)." has had an invoice removed";

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log, 'claim');

}



function getUserWhoClaimCreatedByClaimid($claim_id) {

  global $db;

  $q = "select company_id, branch_id, claim_created_by from claims where id = '".$claim_id."' limit 1";

  $claim_created_by = $db->get_row($q);

  return $claim_created_by;

}



/*

@ Params Claim Id

@ Parma Claim Adjuster Id

*/

function acceptClaim($claim_id, $account) {

  global $db;

  $auth = getUserTypeById($account);

  $auth = intval($auth);

  

  $account_info = getUserInfo($account);

  switch ($auth) {

    case '12': // Ins Desk Reviewer

    case '6':  // App Desk Reviewer

    case '24': // TP Dispatcher

      updateAssignment($claim_id,'3',$account); // Assigned To IA / Pending

      ### Removing claims from Pending Acceptance box if Any one accept claim...

      $pending_app_acceptance_users = getClaimAssignmentUsersByClaimid($claim_id, '', 'type5');

      if(count($pending_app_acceptance_users) > 0) {

        deleteAssignmentByType($claim_id, implode(",", $pending_app_acceptance_users), 'type5', 'no-log');

      }

      break;

    case '3':  // App Branch Employee

    case '4':  // App Branch Admin

    case '25': // App Call Center Branch Admin

    case '26': // App Call Center Branch Employee

    case '17': // BS Branch Admin

    case '19': // BS Branch Employee

      $k = $account_info->branch_id; // Adujster or Employee Branch Id...

      $branch_company_id = getCompanyIdByBranchId($k); // getting Branch Company Id...

      

      // App Branch Admin OR App Branch Employee OR App Call Center Branch Admin OR App Call Center Branch Employee OR BS Branch Admin OR BS Branch Employee

      $q = "select id from users where branch_id = '$k' AND (user_type = '4' OR user_type = '3' OR user_type = '25' OR user_type = '26' OR user_type = '17' OR user_type = '19')";

      $temp = $db->get_results($q);

      

      if(count($temp) == 1) {

        $branch_string = $k;

      }

      

      if(count($temp) > 1) {

        unset($branchAdmins);

        

        foreach($temp as $temp_id) {

          $branchAdmins[] = $temp_id->id;

        }

        

        clean_array($branchAdmins);

        $branch_string = implode(',', $branchAdmins);

      }

      

      $temp_array = explode(',', $branch_string);

      

      // Appraisal Company Admin OR Body Shop Company Admin...

      $company_admins = getUsersByCmpandBraIdandType($branch_company_id, '', array(5,16));

      if(count($company_admins) > 0) {

        foreach($company_admins as $company_admin) {

          $temp_array[] = $company_admin->id;

        }

      }

      

      foreach($temp_array as $person) {

        updateAssignment($claim_id, '2', $person);

      }

      

      ### Removing claims from Pending Acceptance box if Any one accept claim...

      $pending_app_acceptance_users = getClaimAssignmentUsersByClaimid($claim_id, '', 'type5');

      if(count($pending_app_acceptance_users) > 0) {

        deleteAssignmentByType($claim_id, implode(",", $pending_app_acceptance_users), 'type5', 'no-log');

      }

    

      break;

    

    // If Claim Created By Appraisal OR Body Shop Company Users then call the  below cases...

    case '8':  // Insurance Adjuster

    case '23': // Third Party Adjuster

      $claim_created_by = getUserWhoClaimCreatedByClaimid($claim_id);

      $claim_created_by_info = getUserInfo($claim_created_by->claim_created_by);

      $k = $claim_created_by_info->branch_id; // Adujster or Employee Branch Id...

      $branch_company_id = getCompanyIdByBranchId($k); // getting Branch Company Id...

      

      // Accepting Claim by App Appraiser or App Desk Reviewer...

      if($_SESSION['current_usertype'] == 2 || $_SESSION['current_usertype'] == 6) {

        updateAssignment($claim_id, '2', $_SESSION['current_user_id']);

        ### Removing claims from Pending Acceptance box if Any one accept claim...

        $pending_app_acceptance_users = getClaimAssignmentUsersByClaimid($claim_id, '', 'type5');

        if(count($pending_app_acceptance_users) > 0) {

          deleteAssignmentByType($claim_id, implode(",", $pending_app_acceptance_users), 'type5', 'no-log');

        }

      } else {

        // Accepting Claim By App Branch Admin and App Branch Emp etc...

        // App Branch Admin OR App Branch Employee OR App Call Center Branch Admin OR App Call Center Branch Employee OR BS Branch Admin OR BS Branch Employee

        $claim_involved_users  = getClaimAssignmentUsersByClaimid($claim_id);

        

        // get App or BS Company Admin Users...

        $app_company_admin_users = getUsersByCmpandBraIdandType($claim_created_by_info->company_id, '', array(5,16));

        if(count($app_company_admin_users) > 0) {

          foreach($app_company_admin_users as $app_company_admin_user) {

            $claim_involved_users[] = $app_company_admin_user->id;

          }

        }

        

        if(count($claim_involved_users) > 0) {

          updateAssignment( $claim_id, '2', implode(",", $claim_involved_users) );

        }

        

        ### Removing claims from Pending Appraiser Acceptance box if App OR BS accept claim...

        $pending_app_acceptance_users = getClaimAssignmentUsersByClaimid($claim_id, '', 'type5');

        if(count($pending_app_acceptance_users) > 0) {

          deleteAssignmentByType($claim_id, implode(",", $pending_app_acceptance_users), 'type5', 'no-log');

        }

      }

      break;

    

    default:

      updateAssignment($claim_id, '2', $account);

      ### Removing claims from Pending Acceptance box if Any one accept claim...

      $pending_app_acceptance_users = getClaimAssignmentUsersByClaimid($claim_id, '', 'type5');

      if(count($pending_app_acceptance_users) > 0) {

        deleteAssignmentByType($claim_id, implode(",", $pending_app_acceptance_users), 'type5', 'no-log');

      }

      break;

  }

  

  // If taken any action with claim then udate overdue date...

  //if($claim_id !='') updateClaimOverDueDate( $claim_id );

}



function isSupplementClaim($claim_id) {

  $is_supplement = $db->get_var("select is_supplement from claims where id = '".$claim_id."'");

  if($is_supplement != 0) return true;

  else return false;

}



function createSupplement($claim_id) {

  global $db;

  $parent_claim_id = $claim_id;

  $claim_name = $db->get_var("select claim_name from claims where id = '".$claim_id."'");
	
  

  //$claim_name = '02282013-100001-S1';

  $new_claim_name = $claim_name.'-S1';

  if( strstr($claim_name, '-S') ) {

    $exploded_claim_name = explode("-S", $claim_name);

    $new_claim_number = $exploded_claim_name[1] + 1;

    $new_claim_name = $exploded_claim_name[0].'-S'.$new_claim_number;

  }

  

  $sql = "update claims set claim_name = '$new_claim_name', status = '1', is_supplement = '1' where id = '$claim_id'";

  $db->query($sql);


 $sql = "update reassignment set place = 1  where claim_id = '$claim_id'";

  $db->query($sql);


  /*

  // Create Clone of claim with S1 S2 file number...

  $db->query("insert into tempclaims (select * from claims where id = '$claim_id')");

  $claim_name = $db->get_var("select claim_name from tempclaims where id = '$claim_id'");

  $timestamp = returnTimestamp();

  

  $claim_count = $db->get_var("select count(*) from claims where claim_name = '$claim_name'");

  if($claim_count != 0) {

    $claim_name = getNewFileNumber();

  }

  

  // 02282013-100001-S1

  $new_claim_name = $claim_name.'-S1';

  $supplyment_count = getSupplementClaimCount($parent_claim_id);

  if( $supplyment_count != 0) {

    if( strstr($claim_name, '-S') ) {

      $exploded_claim_name = explode("-S", $claim_name);

      $new_claim_number = $supplyment_count + 1;

      $new_claim_name = $exploded_claim_name[0].'-S'.$new_claim_number;

    } else {

      $new_claim_number = $supplyment_count + 1;

      $new_claim_name = $claim_name.'-S'.$new_claim_number;

    }

  }

  

  $new_claim_id = create_guid();

  $db->query("update tempclaims set id = '".$new_claim_id."', claim_name = '$new_claim_name', status = '1', claim_created_by = '".$_SESSION['current_user_id']."', is_active = '1', date = '$timestamp' where id = '$claim_id'");

  $db->query("insert into claims (select * from tempclaims where id = '$new_claim_id')");

  

  $claim_users = getClaimAssignmentUsersByClaimid($claim_id);

  if( count($claim_users) > 0) {

    foreach($claim_users as $claim_user_id) {

      $type1_str = '';

      $type2_str = '';

      $type3_str = '';

      $type4_str = '';

      $type5_str = '';

      $archive_str = '';

      

      $q = "select * from claim_assignment_user where user_id = '".$claim_user_id."'";

      $user_claims = $db->get_row($q);

      

      $type1 = explode(',', $user_claims->type1);

      if($user_claims->type1 !='' && in_array($parent_claim_id, $type1 ) ) {

        $type1_str = getExIm( implode(",", $type1), $new_claim_id );

      }

      

      $type2 = explode(',', $user_claims->type2);

      if($user_claims->type2 !='' && in_array($parent_claim_id, $type2) ) {

        $type2_str = getExIm( implode(",", $type2), $new_claim_id );

      }

      

      $type3 = explode(',', $user_claims->type3);

      if ( $user_claims->type3 !='' && in_array($parent_claim_id, $type3) ) {

        $type3_str = getExIm( implode(",", $type3), $new_claim_id );

      }

      

      $type4 = explode(',', $user_claims->type4);

      if ( $user_claims->type4 !='' && in_array($parent_claim_id, $type4) ) {

        $type4_str = getExIm( implode(",", $type4), $new_claim_id );

      }

      

      $type5 = explode(',', $user_claims->type5);

      if ( $user_claims->type5 !='' && in_array($parent_claim_id, $type5) ) {

        $type5_str = getExIm( implode(",", $type5), $new_claim_id );

      }

      

      $archive = explode(',', $user_claims->archive);

      if ( $user_claims->archive !='' && in_array($parent_claim_id, $archive) ) {

        $archive_str = getExIm( implode(",", $archive), $new_claim_id );

      }

      

      $q = "update claim_assignment_user set 

              type1 = '".$type1_str."',

              type2 = '".$type2_str."',

              type3 = '".$type3_str."',

              type4 = '".$type4_str."',

              type5 = '".$type5_str."',

              archive = '".$archive_str."' 

            where user_id = '".$claim_user_id."'";

      $db->query($q);

    }

  }

  

  $claim_info = $db->get_row("select id, company_id, branch_id, adjuster from claims where id = '".$new_claim_id."' limit 1");

  

  $sql1 = "select user_id from claim_assignments where claim_id = '".$parent_claim_id."'";

  $who_involved_user_ids = $db->get_var($sql1);

  

  $sql2 = "insert into claim_assignments set id = '".create_guid()."', claim_id = '".$new_claim_id."', user_id = '".$who_involved_user_ids."', date_created = '".date("Y-m-d H:i:s")."', date_modified = '".date("Y-m-d H:i:s")."'";

  $db->query($sql2);

  */

  

  /*

  // Option: If New Fresh Claim with top level users...

  saveClaimAssignment($claim_info->id, $claim_info->adjuster); 

  

  $adjuster_and_supervisors = array();

  if($claim_info->adjuster != $_SESSION['current_user_id'] && $_SESSION['current_usertype'] != '1' && $_SESSION['current_usertype'] != '111') {

      $adjuster_and_supervisors[] = $_SESSION['current_user_id'];

  }

  $adjuster_and_supervisors[] = $claim_info->adjuster;

  

  // Fetch Company, Branch Admins and Adjuster Supervisor....

  if($claim_info->branch_id !='') {

    // Insurance Adjuster Supervisor or Insurance Branch Admin or Third Party Branch Admin or Third Party Adjuster Supervisor

    $user_details = getUsersByCmpandBraIdandType('', $claim_info->branch_id, array(9,10,21,22) ); 

    if(count($user_details) > 0) {

      foreach($user_details as $user_detail) {

        $adjuster_and_supervisors[] = $user_detail->id;

      }

    }

    

    // Insurance Company Admin or Third Party Company Admin

    $user_cmp_details = getUsersByCmpandBraIdandType($claim_info->company_id, '', array(11,20) );

    if(count($user_cmp_details) > 0) {

      foreach($user_cmp_details as $user_cmp_detail) {

        $adjuster_and_supervisors[] = $user_cmp_detail->id;

      }

    }

  }

  // Assign Claims to users....

  createNewAssignment($claim_info->id, implode(',', $adjuster_and_supervisors));

  */

  

  // Records in the log of claim supplements...

  //setClaimSupplementLog($parent_claim_id, $new_claim_id);

  //$db->query("delete from tempclaims where id = '$new_claim_id'");

  

  return $claim_id;

}



function setClaimSupplementLog($parent_claim_id, $new_claim_id) {

  global $db;

  $q = "insert into claim_supplements set id = '".create_guid()."', parent_id = '".$parent_claim_id."', claim_id = '".$new_claim_id."', date_created = '".date('Y-m-d H:i:s')."', date_modified = '".date('Y-m-d H:i:s')."', deleted = '0'";

  $db->query($q);

}



function getSupplementClaimCount($parent_claim_id) {

  global $db;

  $q = "select count(*) as cnt from claim_supplements where parent_id = '".$parent_claim_id."' and deleted = '0'";

  return $db->get_var($q);

}



function getClaimSupplementLog($claim_id) {

  global $db;

  $q = "select claim_id from claim_supplements where parent_id = '".$claim_id."' and deleted = '0'";

  $claim_supplements = $db->get_results($q);

  return $claim_supplements; 

}



function moveClaimUnassigned($claim_id, $user_id) {

  global $db;

  //$claim_assignment_users_array = getClaimAssignmentUsersByClaimid($claim_id, $user_id);

  $claim_assignment_users_array = getClaimAssignmentUsersNotArchiveByClaimid($claim_id, $user_id);

  $array_fliped = array_flip($claim_assignment_users_array);

  

  if(count($claim_assignment_users_array) > 0) {

    foreach($claim_assignment_users_array as $claim_assignment_users_arr) {

      if(in_array(getUserTypeById($claim_assignment_users_arr), array(11,10,9,8,20,21,22,23) ) ) {

        $non_archived_users[] = $claim_assignment_users_arr;

        //unset($array_fliped[$claim_assignment_users_arr]);

      } else {

        $archived_users[] = $claim_assignment_users_arr;

      }

    }

  }

  

  // Move claim in to Secondary Archive field for old assignee user...

  updateAssignment($claim_id, 'archive', implode(",", array_filter($archived_users)) );

  

  // Non Archived Users and claim move to Unassigned box i.e. Ins Adjuster, Ins bra admin, Ins cmp admin etc

  updateAssignment($claim_id, '1', implode(",", array_filter($non_archived_users)) );

  

  $log1 = "File number: ".getFileNumberById($claim_id)." has been moved back to unassigned.";

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

    

  //unset($array_fliped[getWhoClaimCreatedByClaimId($claim_id)]);

  //$array_unfliped = array_flip($array_fliped);

  //deleteAssignment($claim_id, implode(",", array_filter($array_unfliped)), 'has been moved back to unassigned');

}



function getClaimAssignmentUsersByClaimid($claim_id, $user_id = '', $location = '') {

  global $db;

  if($location !='') {

    $q = "select user_id from claim_assignment_user where $location LIKE '%".$claim_id."%'";

  } else {

    $q = "select user_id from claim_assignment_user where type1 LIKE '%".$claim_id."%' or type2 LIKE '%".$claim_id."%' or type3 LIKE '%".$claim_id."%' or type4 LIKE '%".$claim_id."%' or type5 LIKE '%".$claim_id."%' or archive LIKE '%".$claim_id."%'";

  }

 

  $claim_assignment_ids = $db->get_results($q);

  

  $claim_assignment_users = array();

  if($user_id !='') $claim_assignment_users[] = $user_id;

  

  if(count($claim_assignment_ids) > 0) {

    foreach($claim_assignment_ids as $claim_assignment_type) {

      if($claim_assignment_type->user_id !='') $claim_assignment_users[] = $claim_assignment_type->user_id;

    }

  }

  

  return array_unique($claim_assignment_users);

}



function getClaimAssignmentUsersByClaimidDATE($claim_id, $user_id ) {

  global $db;

 

    $q = "select 	assign_date from claim_assigndate_touser where  user_id='".$user_id."' and claim_id='".$claim_id."'";

 

 

  $claim_assignment_ids = $db->get_results($q);

  $claim_assignment_dates='';

   foreach($claim_assignment_ids as $claim_assignment_type) {

  if($claim_assignment_type ->assign_date !='0000-00-00 00:00:00') $claim_assignment_dates= $claim_assignment_type ->assign_date;

  }

  

  

  return $claim_assignment_dates;

} 

function getClaimAssignmentUsersNotArchiveByClaimid($claim_id, $user_id = '', $location = '') {

  global $db;

  if($location !='') {

    $q = "select * from claim_assignment_user where $location LIKE '%".$claim_id."%'";

  } else {

    $q = "select * from claim_assignment_user where type1 LIKE '%".$claim_id."%' or type2 LIKE '%".$claim_id."%' or type3 LIKE '%".$claim_id."%' or type4 LIKE '%".$claim_id."%' or type5 LIKE '%".$claim_id."%'";

  }

  $claim_assignment_ids = $db->get_results($q);

  

  $claim_assignment_users = array();

  if($user_id !='') $claim_assignment_users[] = $user_id;

  

  if(count($claim_assignment_ids) > 0) {

    foreach($claim_assignment_ids as $claim_assignment_type) {

      if($claim_assignment_type->user_id !='') $claim_assignment_users[] = $claim_assignment_type->user_id;

    }

  }

  

  return array_unique($claim_assignment_users);

}



function getClaimsByUserId($user_id, $user_type) {

  global $db;

  

  $sql = "select claim_assignment_user.*, count(*) as cnt from claim_assignment_user where user_id = '".$user_id."' limit 1";

  $claim_assignment_user_info = $db->get_row($sql, ARRAY_A);

  

  $claim_ids = array();

  if(count($claim_assignment_user_info) > 0) {

    for ($i = 1; $i<=CLAIM_ASSIGNMENT_LEVEL; $i++) {

      $typeString = "type".strval($i);

      

      $exploded_array = explode(",", $claim_assignment_user_info[$typeString]);

      if(count($exploded_array) > 0) {

        foreach($exploded_array as $exploded_value) {

          $claim_ids[] = $exploded_value;

        }

      }

    }

    

    $exploded_archive_array = explode(",", $claim_assignment_user_info['archive']);

    if(count($exploded_archive_array) > 0) {

      foreach($exploded_archive_array as $archive_value) {

        $claim_ids[] = $archive_value;

      }

    }

  }

  

  return array_filter(array_unique($claim_ids));

}



function markClaimReviewed($claim_id) {

  global $db;

  

  //$owners = getClaimAssignmentUsersByClaimid($claim_id);

  $owners = getClaimAssignmentUsersNotArchiveByClaimid($claim_id);

  if(count($owners) > 0) {

    foreach ($owners as $owner) {

      $u_info = getUserInfo($owner);

      if(

          $u_info->user_type == '4' || $u_info->user_type == '3' ||   # App Branch Admin OR App Branch Employee

          $u_info->user_type == '25' || $u_info->user_type == '26' || # App Call Center Branch Admin OR App Call Center Branch Employee

          $u_info->user_type == '17' || $u_info->user_type == '19' || # BS Branch Admin OR BS Branch Employee

          $u_info->user_type == '11' || $u_info->user_type == '20' || # Ins Company Admin OR TP Company Admin

          $u_info->user_type == '10' || $u_info->user_type == '21' || # Ins Branch Admin OR TP Branch Admin

          $u_info->user_type == '9' || $u_info->user_type == '22' ||  # Ins Branch Adjuster Supervisor OR TP Branch Adjuster Supervisor

          $u_info->user_type == '8' || $u_info->user_type == '23'     # Ins Branch Adjuster OR Branch TP Adjuster

        )

      {

        // Marked Completed by Assignee...

        updateAssignment($claim_id, '4', $u_info->id);

      }

      

      if($u_info->user_type == '2' || $u_info->user_type == '18') {

        updateAssignment($claim_id, '3', $u_info->id);

      }

      

      if($u_info->user_type == '7' ) {

        updateAssignment($claim_id, '3', $u_info->id);

      }

      

      // Ins Desk Reviewer or App Desk Reviewer

      if($u_info->user_type == '12' || $u_info->user_type == '6') {

        updateAssignment($claim_id, '3', $u_info->id);

      }

    }

  }

  

  $log1 = "This claim has been marked reviewed by ". getUserNameById( getClaimOwner($claim_id));

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

}



function markClaimReinspected($claim_id) {

  global $db;

  $log1 = "This claim has been marked reinspected by ".  getUserNameById( getClaimOwner($claim_id));

  //saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

  

  $owners = getClaimOwners($claim_id);

  foreach ($owners as $owner) {

    $u_info = getUserInfo($owner);

    if($u_info->user_type == '13') {

      updateAssignment($claim_id, '3', $u_info->id);

      foreach ($owners as $owner) {

        $u_info = getUserInfo($owner);

        if($u_info->user_type == '4' || $u_info->user_type == '3' || $u_info->user_type == '25' || $u_info->user_type == '26') {

          updateAssignment($claim_id, '4', $u_info->id);

        }

      }

    }

  }

}



function markClaimCompleted($claim_id) {

  global $db;

  

  //$owners = getClaimOwners($claim_id); // Previously using this method...

  //$owners = getClaimAssignmentUsersByClaimid($claim_id);

  $owners = getClaimAssignmentUsersNotArchiveByClaimid($claim_id);

  if(count($owners) > 0) {

    foreach ($owners as $owner) {

      $u_info = getUserInfo($owner);

      if(

          $u_info->user_type == '4' || $u_info->user_type == '3' ||   # App Branch Admin OR App Branch Employee

          $u_info->user_type == '25' || $u_info->user_type == '26' || # App Call Center Branch Admin OR App Call Center Branch Employee

          $u_info->user_type == '17' || $u_info->user_type == '19' || # BS Branch Admin OR BS Branch Employee

          $u_info->user_type == '11' || $u_info->user_type == '20' || # Ins Company Admin OR TP Company Admin

          $u_info->user_type == '10' || $u_info->user_type == '21' || # Ins Branch Admin OR TP Branch Admin

          $u_info->user_type == '9' || $u_info->user_type == '22' ||  # Ins Branch Adjuster Supervisor OR TP Branch Adjuster Supervisor

          $u_info->user_type == '8' || $u_info->user_type == '23'     # Ins Branch Adjuster OR Branch TP Adjuster

        )

      {

        // Marked Completed by Assignee...

        updateAssignment($claim_id, '4', $u_info->id);

      }

      

      if($u_info->user_type == '2' || $u_info->user_type == '18') {

        updateAssignment($claim_id, '3', $u_info->id);

      }

      if($u_info->user_type == '7' ) {

        updateAssignment($claim_id, '3', $u_info->id);

      }

    }

    

    // Update claim status as Completed...

    setClaimStatusById($claim_id, '4');

    

   /* $log1 = "This claim has been marked completed by ".  getUserNameById( getClaimOwner($claim_id));

    saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');
*/
  }

}



function moveClaimInProcess($claim_id, $account) {

  global $db;

  

  $claim_created_by = getUserWhoClaimCreatedByClaimid($claim_id);

  $claim_created_by_info = getUserInfo($claim_created_by->claim_created_by);

  $claim_company_type = getCompanyTypeById($claim_created_by_info->company_id);

  

  // If Claim not created by App or BS Company users...

  if( $claim_company_type != '2' && $claim_company_type != '3' ) {

    updateAssignment($claim_id, '2', $account);

  }

  

  // If Claim created by App or BS Company users...

  if( $claim_company_type == '2' || $claim_company_type == '3' ) {

    

    //$owners = getClaimAssignmentUsersByClaimid($claim_id);

    $owners = getClaimAssignmentUsersNotArchiveByClaimid($claim_id);

    

    // Appraiser Branch Appraiser Claim Move Back In Progress then unset...

    if(($key = array_search($_SESSION['current_user_id'], $owners)) !== false) {

      updateAssignment($claim_id, '2', $_SESSION['current_user_id']);

      unset($owners[$key]);

    }

    

    // get App or BS Company Admin Users...

    $app_company_admin_users = getUsersByCmpandBraIdandType($claim_created_by_info->company_id, '', array(5,16));

    if(count($app_company_admin_users) > 0) {

      foreach($app_company_admin_users as $app_company_admin_user) {

        // If Appraiser Company Admin user then no need to update. that's why unset...

        if(($key = array_search($app_company_admin_user->id, $owners)) !== false) {

          unset($owners[$key]);

        }

      }

    }

    

    // get App Branch Admin or App Branch Emp or Call Center Branch Admin or Call Center Branch Admin App Branch Admin Users...

    $app_bra_emp_admin_users = getUsersByCmpandBraIdandType($claim_created_by_info->company_id, '', array(4,3,25,26,17,19));

    if(count($app_bra_emp_admin_users) > 0) {

      foreach($app_bra_emp_admin_users as $app_bra_emp_admin_user) {

        // If App Company Admin user then no need to update. that's why unset...

        if(($key = array_search($app_bra_emp_admin_user->id, $owners)) !== false) {

          updateAssignment($claim_id, '3', $app_bra_emp_admin_user->id);

          unset($owners[$key]);

        }

      }

    }

    

    updateAssignment($claim_id, '2', implode(",", $owners));

  

  } else {

  

    $user_type = getUserTypeById($account);

    if($user_type == '2' || $user_type == '12' || $user_type == '18') {

      $owners = getClaimAssignmentUsersByClaimid($claim_id);

      foreach ($owners as $owner) {

        $u_info = getUserInfo($owner);

        

        if(

            $u_info->user_type == '4' || $u_info->user_type == '3' ||   # App Branch Admin OR App Branch Employee

            $u_info->user_type == '25' || $u_info->user_type == '26' ||   # App Call Center Branch Admin OR App Call Center Branch Employee

            $u_info->user_type == '17' || $u_info->user_type == '19' || # BS Branch Admin OR BS Branch Employee

            $u_info->user_type == '11' || $u_info->user_type == '20' || # Ins Company Admin OR TP Company Admin

            $u_info->user_type == '10' || $u_info->user_type == '21' || # Ins Branch Admin OR TP Branch Admin

            $u_info->user_type == '9' || $u_info->user_type == '22' ||  # Ins Branch Adjuster Supervisor OR TP Branch Adjuster Supervisor

            $u_info->user_type == '8' || $u_info->user_type == '23'     # Ins Branch Adjuster OR Branch TP Adjuster

          ) 

        {

          updateAssignment($claim_id, '3', $u_info->id);

        }

      }

    }

  }

  

  // Update claim status as Open...

  setClaimStatusById($claim_id, '1');

    

  // If taken any action with claim then udate overdue date...

  //if($claim_id !='') updateClaimOverDueDate( $claim_id );

}



function reopenClaim($claim_id, $claim_owner) {

  global $db;

  $temp = $db->get_row = ("select * from `claim_assignments` where `claim_id` = '$claim_id' ");

  

  $owners = $temp->user_id;

  $owners = explode(',', $owners);

  $owners = clean_array($owners);

  updateAssignment($claim_id, '2', $owners[0]);

  updateAssignment($claim_id, '1', $claim_owner);



  if(getUserTypeById($claim_owner) == '4' || getUserTypeById($claim_owner) == '3' || getUserTypeById($claim_owner) == '17' || getUserTypeById($claim_owner) == '19') {

    foreach($owners as $owner) {

      $u_info = getUserInfo($owner);

      if($u_info->user_type == '4' || $u_info->user_type == '3' || $u_info->user_type == '17' || $u_info->user_type == '19') {

        updateAssignment($claim_id, '1', $owner);

      }

    }

  }

  

  $sql = "update claims set status = '1', date_end = '".returnTimestamp()."' where id = '$claim_id'";

  $db->query($sql);

  

  $log1 = "File number: ".getFileNumberById($claim_id)." has been re-open by ".getUserNameById($_SESSION['current_user_id']);

 // saveStatusLog($_SESSION['current_user_id'], $claim_id, $log1, 'claim');

}



function getEstimateInfo($claim_id) {

  global $db;

  $q = "select * from estimates where claim_id = '$claim_id' limit 1";

  $estimates_info = $db->get_row($q);

  return $estimates_info;

}



function getClaimUploadById($claim_id, $upload_type) {

  global $db;

  $q = "select * from  uploads where claim_id = '$claim_id' and type = '".$upload_type."'";

  $uploads_info = $db->get_results($q);

  return $uploads_info;

}



function getMsgBoxCount() {

  global $db;

  $q = "select count(*) as msg_cnt from message_box where receiver_id  = '".$_SESSION['current_user_id']."' and is_read = '1'";

  $unread_count = $db->get_var($q);

  return $unread_count;

}



function writeJson($user_array) {

  global $db;

  // Global admin....

  if( $user_array['user_type'] == '1' || $user_array['user_type'] == '111') {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."'";

  } else {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."'";

  }

  

  /*

  //Insurance Company Admin or Appraisal Company Admin or Body Shop Company Admin or Third Party Company Admin....

  } else if( $user_array['user_type'] == '11' || $user_array['user_type'] == '5' || $user_array['user_type'] == '16' || $user_array['user_type'] == '20' ) {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where (id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."') or (user_type = '1')";

  

  //Insurance Branch Admin

  } else if( $user_array['user_type'] == '10') {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where (id != '".$user_array['id']."' and branch_id = '".$user_array['branch_id']."') or ( company_id = '".$user_array['company_id']."' and user_type = '11')";

  

  //Appraisal Branch Admin

  } else if( $user_array['user_type'] == '4') {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where (id != '".$user_array['id']."' and branch_id = '".$user_array['branch_id']."') or ( company_id = '".$user_array['company_id']."' and user_type = '5')";

  

  //Body Shop Branch Admin

  } else if( $user_array['user_type'] == '17') {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where (id != '".$user_array['id']."' and branch_id = '".$user_array['branch_id']."') or ( company_id = '".$user_array['company_id']."' and user_type = '16')";

    

    //Third Party Branch Admin

  } else if( $user_array['user_type'] == '21') {

    $q = "select username, concat(firstname,' ',lastname) as fullname from users where (id != '".$user_array['id']."' and branch_id = '".$user_array['branch_id']."') or ( company_id = '".$user_array['company_id']."' and user_type = '20')";

    

  //Branch users

  } else {

    $company_type = getCompanyTypeById($user_array['company_id']);

    if($company_type == '1') { // Insurance Company

      $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."' and branch_id = '".$user_array['branch_id']."' and user_type != '11'"; // Not access Insurance company admin

    } else if($company_type == '2') { // Appraisal Company

      $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."' and branch_id = '".$user_array['branch_id']."' and user_type != '5'";  // Not access Appraisal company admin

    } else if($company_type == '3') { // BodyShop Company

      $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."' and branch_id = '".$user_array['branch_id']."' and user_type != '16'";  // Not access BodyShop company admin

    } else if($company_type == '4') { // Third Party Company

      $q = "select username, concat(firstname,' ',lastname) as fullname from users where id != '".$user_array['id']."' and company_id = '".$user_array['company_id']."' and branch_id = '".$user_array['branch_id']."' and user_type != '20'";  // Not access Third Party company admin

    }

  }*/

  

  //echo $q; die();

  $rs = $db->get_results($q);

  $total_contacts = count($rs);

  

  $json_str = '';

  if( $total_contacts > 0 ) {

    $json_str .= '[';

    $counter = 0;

    foreach($rs as $user_info) {

      $counter++;

      if($counter != $total_contacts) {

        $json_str .= '"'.$user_info->fullname.' &lt;'.$user_info->username.'&gt;", ';

      } else {

        $json_str .= '"'.$user_info->fullname.' &lt;'.$user_info->username.'&gt;"';

      }

      //["krrish Kumar <hdfc.bra.admin>", "Kailsh Menaria <hdfc.bra.adj>"]

      //["19:Arturo Andres Roig", "20:Ricardo Rojas"]

    }

    $json_str .= ']';

  }

  

  

  $sql = "update users set contacts = '$json_str' where id = '".$user_array['id']."'";

  $db->query($sql);

}



function returnTimestamp() {

  return date("Y-m-d H:i:s",time()); 

}



function getInvoiceStatusById($invoice_id, $invoice_type) {

  global $db;

  if($invoice_type == 'app-cmp') $table_name = 'appraisal_cmp_invoices';

  else if($invoice_type == 'bs-cmp') $table_name = 'bodyshop_cmp_invoices';

  else if($invoice_type == 'app-cc-cmp') $table_name = 'call_center_invoices';

  else if($invoice_type == 'cfs-cmp') $table_name = 'cfs_invoices';
  
   else if($invoice_type == 'app-inv') $table_name = 'appraisal_invoices';
   
    else if($invoice_type == 'rew-inv') $table_name = 'reviewer_invoices';

  else $table_name = 'appraisal_cmp_invoices';



  $q = "select is_paid from $table_name where id = '".$invoice_id."' limit 1";

  return $db->get_var($q);

}



function getInvoiceStatusByClaimId($claim_id, $invoice_type) {

  global $db;

  if($invoice_type == 'app-cmp') $table_name = 'appraisal_cmp_invoices';

  else if($invoice_type == 'bs-cmp') $table_name = 'bodyshop_cmp_invoices';

  else if($invoice_type == 'app-cc-cmp') $table_name = 'call_center_invoices';

  else if($invoice_type == 'cfs-cmp') $table_name = 'cfs_invoices';

  else $table_name = 'appraisal_cmp_invoices';



  $q = "select is_paid from $table_name where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}
function getAppInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from appraisal_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}
function getRewInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from reviewer_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}

function getAppCmpInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from appraisal_cmp_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getBSCmpInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from bodyshop_cmp_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getCallCenterInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from call_center_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getCfsInvoiceIdByClaimId($claim_id) {

  global $db;

  $q = "select id from cfs_invoices where claim_id = '".$claim_id."' limit 1";

  return $db->get_var($q);

}



function getPayoutAmountIdByClaimId($claim_id, $type) {

  global $db;

  $q = "select id from payout_amounts where claim_id = '".$claim_id."' and type = '".$type."' limit 1";

  return $db->get_var($q);

}



function getPayoutStatusById($payout_id, $type) {

  global $db;

  $q = "select is_claim_settled from payout_amounts where id = '".$payout_id."' and type = '".$type."' limit 1";

  return $db->get_var($q);

}



function getPayoutStatusByClaimId($claim_id, $type) {

  global $db;

  $q = "select is_claim_settled from payout_amounts where claim_id = '".$claim_id."' and type = '".$type."' limit 1";

  return $db->get_var($q);

}



function getClaimEstDedBet($claim_id) {

  global $db;

  $ClaimEstDedBet = array();

  $q = "select deductible from claims where id = '".$claim_id."'";

  $deductible = $db->get_var($q);

  $ClaimEstDedBet['deductible'] = number_format($deductible, 2);

  

  $sql = "select estimate1_total, estimate2_total, estimate1_betterment, estimate2_betterment, supplement1_betterment, supplement2_betterment, supplement3_betterment, supplement4_betterment from claim_summaries where claim_id = '".$claim_id."' and deleted = '0'";

  $claim_summaries = $db->get_row($sql);

  

  $estimate = $claim_summaries->estimate1_total + $claim_summaries->estimate2_total + $claim_summaries->estimate1_betterment + $claim_summaries->estimate2_betterment;

  $betterment = $claim_summaries->supplement1_betterment + $claim_summaries->supplement2_betterment + $claim_summaries->supplement3_betterment + $claim_summaries->supplement4_betterment;

  $ClaimEstDedBet['estimate'] = number_format($estimate, 2);

  $ClaimEstDedBet['betterment'] = number_format($betterment, 2);

  

  return $ClaimEstDedBet;

}