<?php

/**
 * Description of ZipLocator
 *
 * @author Ricardo Obregón
 * @uses Yii 1.6 or above
 */
class ZipLocator {

    /**
     * Short description.
     * This method returns the distance in Miles between two zip codes
     * Detail description
     * This method returns the distance in Miles between two zip codes, if either of the zip code is not found and error is retruned
     * @param      zipOne - The first zip code
     * @param      zipTwo - The second zip code
     * @return     string
     */
    public function distance($zipOne, $zipTwo) {
	$zc1 = Yii::app()->db->createCommand()->select('*')->from('zipdata')->where('zipcode = :zip1', array(':zip1' => $zipOne))->queryRow();
	if (!$zc1) {
	    return "First Zip Code not found";
	} else {
	    $lat1 = $zc1['lat'];
	    $lon1 = $zc1['lon'];
	}

	$zc2 = Yii::app()->db->createCommand()->select('*')->from('zipdata')->where('zipcode = :zip2', array(':zip2' => $zipTwo))->queryRow();

	if (!$zc2) {
	    return "Second Zip Code not found";
	} else {
	    $lat2 = $zc2['lat'];
	    $lon2 = $zc2['lon'];
	}

	/* Convert all the degrees to radians */
	$lat1 = $this->deg_to_rad($lat1);
	$lon1 = $this->deg_to_rad($lon1);
	$lat2 = $this->deg_to_rad($lat2);
	$lon2 = $this->deg_to_rad($lon2);

	/* Find the deltas */
	$delta_lat = $lat2 - $lat1;
	$delta_lon = $lon2 - $lon1;

	/* Find the Great Circle distance */
	$temp = pow(sin($delta_lat / 2.0), 2) + cos($lat1) * cos($lat2) * pow(sin($delta_lon / 2.0), 2);

	$EARTH_RADIUS = 3956;
	$distance = $EARTH_RADIUS * 2 * atan2(sqrt($temp), sqrt(1 - $temp));

	return $distance;
    }

    /**
     * Short description.
     * Converts degrees to radians
     * @param      deg - degrees
     * @return     void
     */
    private function deg_to_rad($deg) {
	$radians = 0.0;
	$radians = $deg * M_PI / 180.0;
	return($radians);
    }

    /**
     * Short description.
     * This method retruns an array of zipcodes found with the radius supplied
     * Detail description
     * This method returns an array of zipcodes found with the radius supplied in miles, if the zip code is invalid an error string is returned
     * @param      zip - The zip code
     * @param      radius - The radius in miles
     * @return     array/string
     */
    function inradius($zip, $radius) {
	$zc = Yii::app()->db->createCommand()->select('*')->from('zipdata')->where('zipcode = :zip', array(':zip' => $zip))->queryRow();

	if ($zc) {
	    $lat = $zc->lat;
	    $lon = $zc->lon;
	    $query = "SELECT zipcode FROM zipdata WHERE (POW((69.1*(lon-\"$lon\")*cos($lat/57.3)),\"2\")+POW((69.1*(lat-\"$lat\")),\"2\"))<($radius*$radius) ";
	    if ($zips = Yii::app()->db->createCommand($query)->queryAll()) {
		foreach ($zip as $i => $val)
		    $zipArray[$i] = $val['zipcode'];
	    }
	} else {
	    return "Zip Code not found";
	}
	return $zipArray;
    }

}

?>