<?php
/* @var $this SummeryController */
/* @var $model Summery */

$this->breadcrumbs=array(
	'Summeries'=>array('index'),
	'Manage',
);

 

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#summery-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Summery</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'summery-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'estimate1',
		'estimate2',
		'estiment1betterment',
		'estiment2betterment',
		'supplement1',
		/*
		'supplement2',
		'supplement3',
		'supplement4',
		'supplementbetterment1',
		'supplementbetterment2',
		'supplementbetterment3',
		'supplementbetterment4',
		'subtotal',
		'deductible',
		'originalnetloss',
		'grosstotal',
		'supplementnetloss',
		'towingcharges',
		'storageperday',
		'days',
		'approximatetotal',
		'rentalvehicle',
		'totalrentalpotentialcost',
		'actualrentaldays',
		'actualrentalamount',
		'style',
		'remark',
		'claim_id',
		'created',
		'modified',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
