<?php
/* @var $this PrepurchasedclaimController */
/* @var $model Prepurchasedclaim */

$this->breadcrumbs=array(
	'Prepurchasedclaims'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Prepurchasedclaim', 'url'=>array('index')),
	array('label'=>'Create Prepurchasedclaim', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#prepurchasedclaim-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Prepurchasedclaims</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'prepurchasedclaim-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'company_id',
		'branch_id',
		'claim_price',
		'pre_discount',
		'free_claims',
		/*
		'paid_claim',
		'automatic_discount',
		'total_amount',
		'pay_date',
		'paid_amount',
		'invoice_no',
		'memo',
		'status',
		'created',
		'modified',
		'created_by',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
