<?php
/* @var $this ClaimuploadsController */
/* @var $model Claimuploads */

$this->breadcrumbs=array(
	'Claimuploads'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Claimuploads', 'url'=>array('index')),
	array('label'=>'Create Claimuploads', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#claimuploads-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Claimuploads</h1>

 
<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'claimuploads-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'claim_id',
		'estimate',
		'ems',
		'additional_files',
		'images',
		/*
		'created',
		'modified',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
