<?php

/**
 * This is the model class for table "vehicle_status".
 *
 * The followings are the available columns in table 'vehicle_status':
 * @property integer $id
 * @property integer $claim_id
 * @property string $status
 * @property integer $action_id
 * @property integer $created_by
 * @property integer $active
 * @property string $created
 * @property string $modified
 */
class Vehiclestatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_status';
	}
        public function Vehicle_status($claim_id)
        {
            $v=new Vehiclestatus;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id.' and active=1';
            $vs=$v->find($q);
            if($vs!=null)
                return $vs->status;
            return null;
        }

        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, status, action_id, created_by, active', 'required'),
			array('claim_id, action_id, created_by, active', 'numerical', 'integerOnly'=>true),
			array('status', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, status, action_id, created_by, active, created, modified', 'safe', 'on'=>'search'),
                        array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'Claim' => array(self::BELONGS_TO, 'claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'status' => 'Status',
			'action_id' => 'Action',
			'created_by' => 'Created By',
			'active' => 'Active',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('action_id',$this->action_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('active',$this->active);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Vehiclestatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
