<?php

/**
 * This is the model class for table "vehicle_owner".
 *
 * The followings are the available columns in table 'vehicle_owner':
 * @property integer $id
 * @property integer $claim_id
 * @property integer $user_id
 * @property integer $created_by
 */
class Vehicleowner extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vehicle_owner';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, user_id, created_by,email', 'required'),
			array('claim_id, user_id, created_by', 'numerical', 'integerOnly'=>true),
                     array('email', 'email','message'=>"The email isn't correct"),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, claim_id, user_id, created_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'user_id' => 'User',
			'created_by' => 'Created By',
                        'email'=>'Email',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Vehicleowner the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
