<?php

/**
 * This is the model class for table "state".
 *
 * The followings are the available columns in table 'state':
 * @property integer $id
 * @property integer $country_id
 * @property string $name
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Branch[] $branches
 * @property Claim[] $claims
 * @property Claim[] $claims1
 * @property Claim[] $claims2
 * @property Claim[] $claims3
 * @property Claim[] $claims4
 * @property Claim[] $claims5
 * @property Claim[] $claims6
 * @property Country $country
 * @property Useraddress[] $useraddresses
 */
class State extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return State the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'state';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_id, name', 'required'),
			array('country_id', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, country_id, name, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'branches' => array(self::HAS_MANY, 'Branch', 'state_id'),
			'claims' => array(self::HAS_MANY, 'Claim', 'c_state_id'),
			'claims1' => array(self::HAS_MANY, 'Claim', 'i_state_id'),
			'claims2' => array(self::HAS_MANY, 'Claim', 'ob_state_id'),
			'claims3' => array(self::HAS_MANY, 'Claim', 'o_state_id'),
			'claims4' => array(self::HAS_MANY, 'Claim', 'rp_state_id'),
			'claims5' => array(self::HAS_MANY, 'Claim', 'v_plate_state_id'),
			'claims6' => array(self::HAS_MANY, 'Claim', 'v_state_id'),
			'country' => array(self::BELONGS_TO, 'Country', 'country_id'),
			'useraddresses' => array(self::HAS_MANY, 'Useraddress', 'state_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'country_id' => 'Country',
			'name' => 'Name',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}