<?php

/**
 * This is the model class for table "saleinvoiceitem".
 *
 * The followings are the available columns in table 'saleinvoiceitem':
 * @property integer $id
 * @property string $item
 * @property string $description
 * @property integer $Quantity
 * @property double $price
 * @property integer $saleinvoice_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Salesinvoice $saleinvoice
 */
class Saleinvoiceitem extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Saleinvoiceitem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'saleinvoiceitem';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('item, description, Quantity, price, saleinvoice_id,extprice', 'required'),
			array('Quantity, saleinvoice_id', 'numerical', 'integerOnly'=>true),
			array('price,extprice', 'numerical'),
			array('item, description', 'length', 'max'=>500),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, item, description, Quantity, price,extprice, saleinvoice_id, created, modified', 'safe', 'on'=>'search'),
		 array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'saleinvoice' => array(self::BELONGS_TO, 'Salesinvoice', 'saleinvoice_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'item' => 'Item',
			'description' => 'Description',
			'Quantity' => 'Quantity',
			'price' => 'Price',
                        'extprice'=>'Ext. Price',
			'saleinvoice_id' => 'Saleinvoice',
                       
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('item',$this->item,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('Quantity',$this->Quantity);
		$criteria->compare('price',$this->price);
                $criteria->compare('extprice',$this->extprice);
		$criteria->compare('saleinvoice_id',$this->saleinvoice_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}