<?php

/**
 * This is the model class for table "referencenumber".
 *
 * The followings are the available columns in table 'referencenumber':
 * @property integer $id
 * @property string $created_for
 * @property integer $reference_number
 * @property string $reference_date
 * @property string $reference_by
 * @property integer $year
 * @property string $make
 * @property string $model
 * @property integer $claim_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Claim $claim
 * @property Referenceparts[] $referenceparts
 */
class Referencenumber extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Referencenumber the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'referencenumber';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('created_for, reference_number, reference_date, reference_by', 'required'),
			array('reference_number, year, claim_id', 'numerical', 'integerOnly'=>true),
			array('created_for, reference_by', 'length', 'max'=>500),
			array('make, model', 'length', 'max'=>40),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, created_for, reference_number, reference_date, reference_by, year, make, model, claim_id, created, modified', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
                   // 'vmake' => array(self::BELONGS_TO, 'Vehiclemake', 'make'),
                  //  'vmodel' => array(self::BELONGS_TO, 'Vehiclemodel', 'model'),
			'referenceparts' => array(self::HAS_MANY, 'Referenceparts', 'ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'created_for' => 'Created For',
			'reference_number' => 'Reference Number',
			'reference_date' => 'Reference Date',
			'reference_by' => 'Reference By',
			'year' => 'Year',
			'make' => 'Make',
			'model' => 'Model',
			'claim_id' => 'Claim',
			'created' => 'Created',
			'modified' => 'Modified',
                        'user_id'=>'User Id',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('created_for',$this->created_for,true);
		$criteria->compare('reference_number',$this->reference_number);
		$criteria->compare('reference_date',$this->reference_date,true);
		$criteria->compare('reference_by',$this->reference_by,true);
		$criteria->compare('year',$this->year);
		$criteria->compare('make',$this->make,true);
		$criteria->compare('model',$this->model,true);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}