<?php

/**
 * This is the model class for table "pre_purchased_claim".
 *
 * The followings are the available columns in table 'pre_purchased_claim':
 * @property integer $id
 * @property integer $company_id
 * @property integer $branch_id
 * @property double $claim_price
 * @property double $pre_discount
 * @property integer $free_claims
 * @property integer $paid_claim
 * @property string $automatic_discount
 * @property double $total_amount
 * @property string $pay_date
 * @property double $paid_amount
 * @property string $invoice_no
 * @property string $memo
 * @property string $status
 * @property string $created
 * @property string $modified
 * @property integer $created_by
 */
class Prepurchasedclaim extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'pre_purchased_claim';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_price,  paid_claim, total_amount, pay_date, paid_amount, invoice_no,  status', 'required'),
			array('company_id, branch_id, free_claims, paid_claim, created_by', 'numerical', 'integerOnly'=>true),
			array('claim_price, pre_discount, total_amount, paid_amount', 'numerical'),
			array('automatic_discount', 'length', 'max'=>3),
			array('invoice_no', 'length', 'max'=>500),
			array('status', 'length', 'max'=>5),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, branch_id, claim_price, pre_discount, free_claims, paid_claim, automatic_discount, total_amount, pay_date, paid_amount, invoice_no, memo, status, created, modified, created_by', 'safe', 'on'=>'search'),
                        array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'branch_id' => 'Branch',
			'claim_price' => 'Claim Price',
			'pre_discount' => 'Pre Discount',
			'free_claims' => 'Free Claims',
			'paid_claim' => 'Paid Claim',
			'automatic_discount' => 'Automatic Discount',
			'total_amount' => 'Total Amount',
			'pay_date' => 'Pay Date',
			'paid_amount' => 'Paid Amount',
			'invoice_no' => 'Invoice No',
			'memo' => 'Memo',
			'status' => 'Status',
			'created' => 'Created',
			'modified' => 'Modified',
			'created_by' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('claim_price',$this->claim_price);
		$criteria->compare('pre_discount',$this->pre_discount);
		$criteria->compare('free_claims',$this->free_claims);
		$criteria->compare('paid_claim',$this->paid_claim);
		$criteria->compare('automatic_discount',$this->automatic_discount,true);
		$criteria->compare('total_amount',$this->total_amount);
		$criteria->compare('pay_date',$this->pay_date,true);
		$criteria->compare('paid_amount',$this->paid_amount);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('memo',$this->memo,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Prepurchasedclaim the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
