<?php

/**
 * This is the model class for table "filenumber_generation".
 *
 * The followings are the available columns in table 'filenumber_generation':
 * @property integer $id
 * @property integer $company_id
 * @property integer $initial
 * @property integer $created_by
 * @property string $created
 * @property string $modified
 */
class Filenumbergeneration extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'filenumber_generation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, initial, created_by', 'required'),
			array('company_id, initial, created_by', 'numerical', 'integerOnly'=>true),
                        array('initial','unique','message'=>'File Number has already been used please enter a different file number'),
			array('initial','length','min'=>7,'message'=>'Enter minimum 7 digits, first 3 digit become the unique initial for your company'),
// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, initial, created_by, created, modified', 'safe', 'on'=>'search'),
		 array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'initial' => 'Initial',
			'created_by' => 'Created By',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('initial',$this->initial);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Filenumbergeneration the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
