<?php

/**
 * This is the model class for table "ems_setting".
 *
 * The followings are the available columns in table 'ems_setting':
 * @property integer $id
 * @property string $export_ems_path
 * @property string $export_asc_path
 * @property string $export_mie_path
 * @property string $import_ems_path
 * @property string $import_asc_path
 * @property string $import_mie_path
 * @property integer $created_by
 * @property string $created
 * @property string $modified
 */
class Emssetting extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ems_setting';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('created_by', 'required'),
			array('created_by', 'numerical', 'integerOnly'=>true),
			array('export_ems_path, export_asc_path, export_mie_path, import_ems_path, import_asc_path, import_mie_path', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, export_ems_path, export_asc_path, export_mie_path, import_ems_path, import_asc_path, import_mie_path, created_by, created, modified', 'safe', 'on'=>'search'),
                        array(
                                'modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                      
                    
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'export_ems_path' => 'Export Ems Path',
			'export_asc_path' => 'Export Asc Path',
			'export_mie_path' => 'Export Mie Path',
			'import_ems_path' => 'Import Ems Path',
			'import_asc_path' => 'Import Asc Path',
			'import_mie_path' => 'Import Mie Path',
			'created_by' => 'Created By',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('export_ems_path',$this->export_ems_path,true);
		$criteria->compare('export_asc_path',$this->export_asc_path,true);
		$criteria->compare('export_mie_path',$this->export_mie_path,true);
		$criteria->compare('import_ems_path',$this->import_ems_path,true);
		$criteria->compare('import_asc_path',$this->import_asc_path,true);
		$criteria->compare('import_mie_path',$this->import_mie_path,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Emssetting the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
