<?php

/**
 * This is the model class for table "company_forms_company_type".
 *
 * The followings are the available columns in table 'company_forms_company_type':
 * @property integer $id
 * @property integer $company_form_id
 * @property integer $company_type_id
 */
class Companyformscompanytype extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'company_forms_company_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_form_id, company_type_id', 'required'),
			array('company_form_id, company_type_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_form_id, company_type_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_form_id' => 'Company Form',
			'company_type_id' => 'Company Type',
		);
	}
         public static  function getFormcompaniestypes($fid)
        {
            $c=new Companytype;
            $q=new CDbCriteria;
            $q->select='t.id';
            $q->join=' left join company_forms_company_type on company_forms_company_type.company_type_id=t.id';
            $q->compare('company_forms_company_type.company_form_id',$fid);
            $cmp=$c->findAll($q);
            // var_dump($cmp);
            $selected=array();
            foreach ($cmp as $m)
            {
                $temp= array($m->id => array('selected' => 'selected'));
                $selected[$m->id]= array('selected' => 'selected'); //array_merge($temp,$selected);
            }
            
             return($selected);
        }
public static function listFormCompaniestypes($fid)
        {
            $c=new Companytype;
            $q=new CDbCriteria;
           // $q->select='t.id';
            $q->join=' left join company_forms_company_type on company_forms_company_type.company_type_id=t.id';
            $q->compare('company_forms_company_type.company_form_id',$fid);
            $cmp=$c->findAll($q);
            // var_dump($cmp);
            
            
             return($cmp);
        }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_form_id',$this->company_form_id);
		$criteria->compare('company_type_id',$this->company_type_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Companyformscompanytype the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
