<?php

/**
 * This is the model class for table "company_account".
 *
 * The followings are the available columns in table 'company_account':
 * @property integer $id
 * @property integer $company_id
 * @property integer $free_claims
 * @property integer $left_claims
 * @property string $terms
 * @property integer $notify_claim
 * @property string $notify
 * @property string $created
 * @property string $modified
 */
class Companyaccount extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'company_account';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id,  left_claims', 'required'),
			array('company_id, free_claims, left_claims, notify_claim', 'numerical', 'integerOnly'=>true),
			array('terms', 'length', 'max'=>6),
			array('notify', 'length', 'max'=>3),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id,responsible, free_claims, left_claims, terms, notify_claim, notify, created, modified', 'safe', 'on'=>'search'),
		 array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'free_claims' => 'Free Claims',
			'left_claims' => 'Left Claims',
			'terms' => 'Terms',
			'notify_claim' => 'Notify Claim',
			'notify' => 'Notify',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('free_claims',$this->free_claims);
		$criteria->compare('left_claims',$this->left_claims);
		$criteria->compare('terms',$this->terms,true);
		$criteria->compare('notify_claim',$this->notify_claim);
		$criteria->compare('notify',$this->notify,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Companyaccount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
