<?php

/**
 * This is the model class for table "claimperpage".
 *
 * The followings are the available columns in table 'claimperpage':
 * @property integer $id
 * @property integer $no_of_claim
 * @property integer $user_id
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property User $user
 */
class Claimperpage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Claimperpage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claimperpage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('no_of_claim, user_id', 'required'),
			array('no_of_claim, user_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, no_of_claim, user_id, created, modified', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'no_of_claim' => 'No Of Claim Per Page',
			'user_id' => 'User',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('no_of_claim',$this->no_of_claim);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function perpage()
        {
            $m=new Claimperpage;
                         $q=new CDbCriteria;
                         $q->compare('t.user_id',Yii::app()->user->id);
                         $h=$m->find($q);
                         if($h)
                            $p=$h->no_of_claim;
                        else {
                            $p=10;
                            }
                            return $p;
        }
}