<?php

/**
 * This is the model class for table "claim".
 *
 * The followings are the available columns in table 'claim':
 * @property integer $id
 * @property string $file_no
 * @property string $claim_no
 * @property integer $suppliment_exist
 * @property integer $created_by
 * @property string $close_date
 * @property integer $status
 * @property integer $reopened
 * @property string $policy_no
 * @property double $policy_limit
 * @property integer $deducitible_waived
 * @property double $deducitible
 * @property string $claim_creation_date
 * @property string $date_of_loss
 * @property string $assignment_type
 * @property string $other_assignment_type
 * @property string $loss_type
 * @property string $other_loss_type
 * @property string $claim_report_date
 * @property string $whoose_claim
 * @property integer $coverage_verified
 * @property string $type_of_coverage
 * @property integer $branch_id
 * @property string $other_branch
 * @property string $ob_address1
 * @property string $ob_address2
 * @property string $ob_city
 * @property integer $ob_state_id
 * @property integer $ob_zip
 * @property integer $adjustor_id
 * @property string $other_adjuster
 * @property integer $ob_phone
 * @property integer $ob_fax
 * @property string $ob_email
 * @property string $c_first_name
 * @property string $c_last_name
 * @property string $c_address1
 * @property string $c_address2
 * @property string $c_city
 * @property integer $c_state_id
 * @property integer $c_zip
 * @property integer $c_cell
 * @property integer $c_home
 * @property integer $c_work
 * @property integer $c_fax
 * @property string $c_email
 * @property string $i_first_name
 * @property string $i_last_name
 * @property string $i_address1
 * @property string $i_address2
 * @property string $i_city
 * @property integer $i_state_id
 * @property integer $i_zip
 * @property integer $i_home
 * @property integer $i_work
 * @property integer $i_cell
 * @property integer $i_fax
 * @property string $i_email
 * @property string $o_first_name
 * @property string $o_last_name
 * @property string $o_address1
 * @property string $o_address2
 * @property string $o_city
 * @property integer $o_state_id
 * @property integer $o_zip
 * @property integer $o_home
 * @property integer $o_work
 * @property integer $o_cell
 * @property integer $o_fax
 * @property string $o_email
 * @property string $v_location_name
 * @property string $v_address1
 * @property string $v_address2
 * @property string $v_city
 * @property integer $v_state_id
 * @property integer $v_zip
 * @property integer $v_phone
 * @property string $v_email
 * @property integer $v_year
 * @property integer $v_make_id
 * @property integer $v_model_id
 * @property string $v_submodel
 * @property string $v_lien_holder
 * @property string $v_color
 * @property string $v_plate_no
 * @property integer $v_plate_country
 * @property integer $v_plate_state_id
 * @property integer $v_milege
 * @property string $v_style
 * @property string $v_drivable
 * @property string $v_condition
 * @property string $v_different_location
 * @property string $v_vin
 * @property string $ty_make
 * @property string $ty_size
 * @property integer $ty_lf
 * @property integer $ty_lr
 * @property integer $ty_rf
 * @property integer $ty_rr
 * @property integer $ty_spare
 * @property string $ad_primary_poi
 * @property string $ad_secondary_poi
 * @property string $ad_vehicle_condition
 * @property string $ad_interior_condition
 * @property string $ad_paint_condition
 * @property string $ad_engine_condition
 * @property string $ad_pay_code
 * @property string $ad_rental_vehicle
 * @property string $ad_storage
 * @property string $ad_permission_to_move
 * @property integer $ad_rental_max_days
 * @property double $ad_rental_max_aount
 * @property string $rp_shop_name
 * @property string $rp_address1
 * @property string $rpo_address2
 * @property string $rp_city
 * @property integer $rp_state_id
 * @property integer $rp_zip
 * @property integer $rp_phone
 * @property integer $rp_fax
 * @property string $rp_aggreed_price
 * @property string $rp_federal_tax_id
 * @property integer $rp_ert_days
 * @property string $rp_posiible_supplement
 * @property double $rp_originalnet_loss
 * @property double $rp_supplement_net_loss
 * @property string $adi_special_instruction
 * @property string $adi_damage_description
 * @property string $adi_prior_damage
 * @property string $adi_accident_description
 * @property integer $ali_vehicel_appointment_setup
 * @property string $ali_recommendation
 * @property string $ali_total_loss
 * @property string $gui_company_guidelines
 * @property string $gui_branch_guidelines
 * @property integer $tpa_branch
 * @property string $tpa_address1
 * @property string $tpa_address2
 * @property string $tpa_city
 * @property integer $tpa_state
 * @property integer $tpa_zip
 * @property integer $tpa_adjuster
 * @property string $tpa_phone
 * @property string $tpa_fax
 * @property string $tpa_email
 * @property string $delivery_method
 * @property string $status_interval
 * @property string $created
 * @property string $modified
 * @property string $adi_damage_location
 * @property string $adi_claim_reported_by
 * @property string $adi_driver_name
 * @property string $adi_address1
 * @property string $adi_address2
 * @property string $adi_city
 * @property integer $adi_state
 * @property integer $adi_country
 * @property integer $adi_zip
 * @property string $adi_email
 * @property string $adi_driver_licence
 * @property string $adi_licence_state
 * @property string $adi_licence_country
 * @property string $adi_authority_contacted
 * @property integer $adi_phone
 * @property string $adi_bywhom
 * @property string $adi_report_number
 * @property integer $adi_phone_number
 * @property string $pw_name
 * @property integer $pw_phone
 * @property string $pw_type
 * @property string $pw_statement
 * @property string $pw_relationship
 * @property string $apl_appointment_datetime
 * @property string $apl_and
 * @property string $apl_between
 * @property string $prefered_tl_evalution
 * @property string $pw_reference_num
 * @property string $pw_location
 * @property integer $pw_phone_number
 * @property double $pw_amount
 * @property string $producer_company_name
 * @property string $agent_name
 * @property string $producer_address1
 * @property string $producer_address2
 * @property string $producer_city
 * @property integer $producer_state
 * @property integer $producer_zip
 * @property integer $producer_country
 * @property string $producer_email
 * @property integer $producer_phone
 * @property string $producer_webaddress
 * @property string $producer_policy_number
 * @property string $producer_policy_effective_date
 * @property string $policy_expiration_date
 * @property double $bodiy_enjury_per_person
 * @property double $bodily_enjury_per_accident
 * @property double $property_damage
 * @property double $single_limits
 * @property double $medical_payment_limits
 * @property double $otc_deductible
 * @property double $collision_deductible
 * @property double $unrelated_bodily_injury_per_person
 * @property double $unrelated_bodily_injury_per_accident
 * @property double $motorist_property_damage
 * @property string $loss_payee
 * @property string $pro_contact_name
 * @property string $pro_address1
 * @property string $pro_address2
 * @property string $pro_city
 * @property integer $pro_zip
 * @property integer $pro_state
 * @property integer $pro_country
 * @property integer $pro_fax
 * @property integer $pro_phone
 * @property string $pro_email
 *
 * The followings are the available model relations:
 * @property Appraisalcompanyinvoice[] $appraisalcompanyinvoices
 * @property Appraisalinvoice[] $appraisalinvoices
 * @property Bodyshopinvoice[] $bodyshopinvoices
 * @property Callcenterinvoice[] $callcenterinvoices
 * @property Cfsinvoice[] $cfsinvoices
 * @property Branch $tpaBranch
 * @property Country $adiCountry
 * @property State $adiState
 * @property Branch $branch
 * @property User $createdBy
 * @property State $cState
 * @property State $iState
 * @property State $obState
 * @property State $oState
 * @property Country $producerCountry
 * @property State $producerState
 * @property Country $proCountry
 * @property State $proState
 * @property State $rpState
 * @property State $tpaState
 * @property Country $vPlateCountry
 * @property State $vPlateState
 * @property State $vState
 * @property Deskreviewerinvoice[] $deskreviewerinvoices
 * @property Payout[] $payouts
 * @property Referencenumber[] $referencenumbers
 * @property Reopenclaim[] $reopenclaims
 * @property Salesinvoice[] $salesinvoices
 * @property Supplement[] $supplements
 */
class Claim extends CActiveRecord
{
    
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Claim the static model class
	 */
         public $message;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claim';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('delivery_method,insurance_company,file_no, claim_no, created_by, assignment_type, loss_type, whoose_claim, branch_id, adjustor_id, i_first_name, i_last_name, i_address1, i_city, v_address1, v_city, v_state_id, v_zip, v_year, v_make_id, v_model_id', 'required'),//,   pro_contact_name, pro_address1, pro_address2, pro_city, pro_zip, pro_country, pro_fax, pro_phone, pro_email
			//array('suppliment_exist, created_by, status, reopened, deducitible_waived, coverage_verified, branch_id, ob_state_id, ob_zip, adjustor_id, c_state_id, c_zip, i_state_id, i_zip, o_state_id, o_zip,  v_state_id, v_zip, v_year, v_make_id, v_model_id, v_plate_country, v_plate_state_id, v_milege, ty_lf, ty_lr, ty_rf, ty_rr, ty_spare, ad_rental_max_days, rp_state_id, rp_zip, rp_ert_days,  tpa_branch, tpa_state, tpa_zip, tpa_adjuster, adi_state, adi_country, adi_zip,   producer_state, producer_zip, producer_country, pro_zip, pro_state, pro_country,insurance_company,tpa_company', 'numerical', 'integerOnly'=>true),
		array('suppliment_exist, created_by, status, reopened, deducitible_waived, coverage_verified, ob_state_id, ob_zip,  c_state_id, c_zip, i_state_id, i_zip, o_state_id, o_zip,  v_state_id, v_zip, v_year, v_make_id, v_model_id, v_plate_country, v_plate_state_id, v_milege, ty_lf, ty_lr, ty_rf, ty_rr, ty_spare, ad_rental_max_days, rp_state_id, rp_zip, rp_ert_days,   tpa_state, tpa_zip,  adi_state, adi_country, adi_zip,   producer_state, producer_zip, producer_country, pro_zip, pro_state, pro_country', 'numerical', 'integerOnly'=>true),	
                    array('insurance_company,branch_id,adjustor_id,tpa_company,tpa_branch,tpa_adjuster','numerical', 'integerOnly'=>true,'message'=>"Should not be Blank"),
                    array('policy_limit, deducitible, ad_rental_max_aount, rp_originalnet_loss, rp_supplement_net_loss,  bodiy_enjury_per_person, bodily_enjury_per_accident, property_damage, single_limits, medical_payment_limits, otc_deductible, collision_deductible, unrelated_bodily_injury_per_person, unrelated_bodily_injury_per_accident, motorist_property_damage', 'numerical'),
			array('file_no', 'length', 'max'=>455),
			array('claim_no, policy_no, type_of_coverage, ob_city, c_city, i_city, o_city, v_city, rp_city, adi_city,  producer_city, producer_policy_number, pro_city', 'length', 'max'=>30),
			array('assignment_type', 'length', 'max'=>19),
			array('other_assignment_type, other_loss_type, other_branch, other_adjuster, adi_accident_description, tpa_city, tpa_phone, tpa_fax, tpa_email, adi_damage_location', 'length', 'max'=>500),
			array('loss_type', 'length', 'max'=>13),
			array('whoose_claim, status_interval', 'length', 'max'=>8),
			array('ob_address1, ob_address2, c_address1, c_address2, i_address1, i_address2, o_address1, o_address2, v_address1, v_address2, rp_address1, rpo_address2, adi_driver_name, adi_address1, adi_address2,  producer_company_name, agent_name, producer_address1, producer_address2, producer_webaddress, loss_payee, pro_contact_name, pro_address1, pro_address2', 'length', 'max'=>60),
			array('ob_email, c_email, i_email, o_email, v_email, v_lien_holder, v_style, v_condition, ty_make, ad_primary_poi, ad_secondary_poi, ad_interior_condition, ad_paint_condition, ad_engine_condition, rp_shop_name, adi_claim_reported_by, adi_email, adi_licence_country, adi_authority_contacted, adi_bywhom,  producer_email, pro_email', 'length', 'max'=>40),
			array('c_first_name, c_last_name, i_first_name, i_last_name, o_first_name, o_last_name', 'length', 'max'=>35),
			array('v_location_name, v_submodel', 'length', 'max'=>50),
			array('v_color', 'length', 'max'=>12),
			array('v_plate_no, v_different_location', 'length', 'max'=>9),
			array('v_drivable, ad_vehicle_condition, ad_rental_vehicle, ad_storage, ad_permission_to_move, adi_prior_damage, ali_total_loss', 'length', 'max'=>7),
			array('v_vin', 'length', 'max'=>26),
			array('ty_size', 'length', 'max'=>16),
			array('ad_pay_code, rp_federal_tax_id, delivery_method, adi_licence_state, adi_report_number', 'length', 'max'=>20),
			array('rp_aggreed_price', 'length', 'max'=>3),
			array('rp_posiible_supplement, adi_driver_licence', 'length', 'max'=>10),
			array('ali_recommendation, prefered_tl_evalution', 'length', 'max'=>50),
			//array('pw_statement', 'length', 'max'=>200),
			array('apl_and, apl_between,o_zip,ob_zip,c_zip,i_zip,v_zip,rp_zip,tpa_zip,adi_zip,producer_zip,pro_zip', 'length', 'max'=>5),
			array('close_date, claim_creation_date, date_of_loss, claim_report_date, adi_special_instruction, adi_damage_description, gui_company_guidelines, gui_branch_guidelines, tpa_address1, tpa_address2, apl_appointment_datetime, producer_policy_effective_date, policy_expiration_date', 'safe'),
			array('ob_email,c_email,i_email,o_email,v_email,tpa_email,adi_email,producer_email,pro_email', 'email', 'message'=>'Email is not valid'),
// The following rule is used by search().
                            array('message,accept','safe'),
                            array('v_make_id','either','other'=>'v_make_other'),
                            array('v_model_id','either','other'=>'v_model_other'),
// Please remove those attributes that should not be searched.
			array('insurance_company,tpa_company,id, file_no, claim_no, suppliment_exist, created_by, close_date, status, reopened, policy_no, policy_limit, deducitible_waived, deducitible, claim_creation_date, date_of_loss, assignment_type, other_assignment_type, loss_type, other_loss_type, claim_report_date, whoose_claim, coverage_verified, type_of_coverage, branch_id, other_branch, ob_address1, ob_address2, ob_city, ob_state_id, ob_zip, adjustor_id, other_adjuster, ob_phone, ob_fax, ob_email, c_first_name, c_last_name, c_address1, c_address2, c_city, c_state_id, c_zip, c_cell, c_home, c_work, c_fax, c_email, i_first_name, i_last_name, i_address1, i_address2, i_city, i_state_id, i_zip, i_home, i_work, i_cell, i_fax, i_email, o_first_name, o_last_name, o_address1, o_address2, o_city, o_state_id, o_zip, o_home, o_work, o_cell, o_fax, o_email, v_location_name, v_address1, v_address2, v_city, v_state_id, v_zip, v_phone, v_email, v_year, v_make_id, v_model_id, v_submodel, v_lien_holder, v_color, v_plate_no, v_plate_country, v_plate_state_id, v_milege, v_style, v_drivable, v_condition, v_different_location, v_vin, ty_make, ty_size, ty_lf, ty_lr, ty_rf, ty_rr, ty_spare, ad_primary_poi, ad_secondary_poi, ad_vehicle_condition, ad_interior_condition, ad_paint_condition, ad_engine_condition, ad_pay_code, ad_rental_vehicle, ad_storage, ad_permission_to_move, ad_rental_max_days, ad_rental_max_aount, rp_shop_name, rp_address1, rpo_address2, rp_city, rp_state_id, rp_zip, rp_phone, rp_fax, rp_aggreed_price, rp_federal_tax_id, rp_ert_days, rp_posiible_supplement, rp_originalnet_loss, rp_supplement_net_loss, adi_special_instruction, adi_damage_description, adi_prior_damage, adi_accident_description, ali_vehicel_appointment_setup, ali_recommendation, ali_total_loss, gui_company_guidelines, gui_branch_guidelines, tpa_branch, tpa_address1, tpa_address2, tpa_city, tpa_state, tpa_zip, tpa_adjuster, tpa_phone, tpa_fax, tpa_email, delivery_method, status_interval, created, modified, adi_damage_location, adi_claim_reported_by, adi_driver_name, adi_address1, adi_address2, adi_city, adi_state, adi_country, adi_zip, adi_email, adi_driver_licence, adi_licence_state, adi_licence_country, adi_authority_contacted, adi_phone, adi_bywhom, adi_report_number, adi_phone_number, apl_appointment_datetime, apl_and, apl_between, prefered_tl_evalution, producer_company_name, agent_name, producer_address1, producer_address2, producer_city, producer_state, producer_zip, producer_country, producer_email, producer_phone, producer_webaddress, producer_policy_number, producer_policy_effective_date, policy_expiration_date, bodiy_enjury_per_person, bodily_enjury_per_accident, property_damage, single_limits, medical_payment_limits, otc_deductible, collision_deductible, unrelated_bodily_injury_per_person, unrelated_bodily_injury_per_accident, motorist_property_damage, loss_payee, pro_contact_name, pro_address1, pro_address2, pro_city, pro_zip, pro_state, pro_country, pro_fax, pro_phone, pro_email', 'safe', 'on'=>'search'),
		/* array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    */
                    );
	}
           public function either($attribute_name, $params)
        {
    $field1 = $this->getAttributeLabel($attribute_name);
    $field2 = $this->getAttributeLabel($params['other']);
    if (empty($this->$attribute_name) && empty($this->$params['other'])) {
        $this->addError($attribute_name, Yii::t('claim', "either {$field1} or {$field2} is required."));
        return false;
    }
    return true;
        }
public function beforeSave()
	{
     date_default_timezone_set($_SESSION['time_zone']);
        if ($this->isNewRecord) 
		{
		$this->created =date('Y-m-d H:i:s'); //date('Y-m-d H:i:s');
                //$this->v_make_other=null;
                //$this->v_model_other=null;
		} 
                  $this->modified = date('Y-m-d H:i:s');
	return parent::beforeSave();	
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                        'child_adjustorid'=>array(self::BELONGS_TO,'Childaduster','adjustor_id'),
                        'child_tpaadjustorid'=>array(self::BELONGS_TO,'Childaduster','tpa_adjuster'),
                        'child_tpaBranch' => array(self::BELONGS_TO, 'Childbranch', 'tpa_branch'),
                        'child_branch' => array(self::BELONGS_TO, 'Childbranch', 'branch_id'),
                        'child_insurance'=>array(self::BELONGS_TO,'Childcompany','insurance_company'),
                        'child_tpacmp'=>array(self::BELONGS_TO,'Childcompany','tpa_company'),
                        
			'appraisalcompanyinvoices' => array(self::HAS_MANY, 'Appraisalcompanyinvoice', 'claim_id'),
			'appraisalinvoices' => array(self::HAS_MANY, 'Appraisalinvoice', 'claim_id'),
			'bodyshopinvoices' => array(self::HAS_MANY, 'Bodyshopinvoice', 'claim_id'),
			'callcenterinvoices' => array(self::HAS_MANY, 'Callcenterinvoice', 'claim_id'),
			'cfsinvoices' => array(self::HAS_MANY, 'Cfsinvoice', 'claim_id'),
			'tpaBranch' => array(self::BELONGS_TO, 'Branch', 'tpa_branch'),
			'adiCountry' => array(self::BELONGS_TO, 'Country', 'adi_country'),
			'adiState' => array(self::BELONGS_TO, 'State', 'adi_state'),
			'branch' => array(self::BELONGS_TO, 'Branch', 'branch_id'),
			'createdBy' => array(self::BELONGS_TO, 'User', 'created_by'),
            'adjustorid'=>array(self::BELONGS_TO,'User','adjustor_id'),
            'tpaadj'=>array(self::BELONGS_TO,'User','tpa_adjuster'),
			'cState' => array(self::BELONGS_TO, 'State', 'c_state_id'),
			'iState' => array(self::BELONGS_TO, 'State', 'i_state_id'),
			'obState' => array(self::BELONGS_TO, 'State', 'ob_state_id'),
			'oState' => array(self::BELONGS_TO, 'State', 'o_state_id'),
			'producerCountry' => array(self::BELONGS_TO, 'Country', 'producer_country'),
			'producerState' => array(self::BELONGS_TO, 'State', 'producer_state'),
			'proCountry' => array(self::BELONGS_TO, 'Country', 'pro_country'),
			'proState' => array(self::BELONGS_TO, 'State', 'pro_state'),
			'rpState' => array(self::BELONGS_TO, 'State', 'rp_state_id'),
			'tpaState' => array(self::BELONGS_TO, 'State', 'tpa_state'),
			'vPlateCountry' => array(self::BELONGS_TO, 'Country', 'v_plate_country'),
			'vPlateState' => array(self::BELONGS_TO, 'State', 'v_plate_state_id'),
			'vState' => array(self::BELONGS_TO, 'State', 'v_state_id'),
                        'deskreviewerinvoices' => array(self::HAS_MANY, 'Deskreviewerinvoice', 'claim_id'),
			'payouts' => array(self::HAS_MANY, 'Payout', 'claim_id'),
			'referencenumbers' => array(self::HAS_MANY, 'Referencenumber', 'claim_id'),
			'reopenclaims' => array(self::HAS_MANY, 'Reopenclaim', 'claim_id'),
			'salesinvoices' => array(self::HAS_MANY, 'Salesinvoice', 'claim_id'),
			'supplements' => array(self::HAS_MANY, 'Supplement', 'claim_id'),
                        'vmake' => array(self::BELONGS_TO, 'Vehiclemake', 'v_make_id'),
                        'vmodel' => array(self::BELONGS_TO, 'Vehiclemodel', 'v_model_id'),
                        'passangers' => array(self::HAS_MANY, 'Passanger', 'claim_id'),
                        'insurance'=>array(self::BELONGS_TO,'Company','insurance_company'),
                        'tpacmp'=>array(self::BELONGS_TO,'Company','tpa_company'),
                        'acionclaim' => array(self::HAS_MANY, 'ActionApply', 'claim_id'),
                        'byactionuid' => array(self::BELONGS_TO, 'ActionApply', 'by_userid'),
                        'byutype' => array(self::BELONGS_TO, 'ActionApply', 'by_utype'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
                        'insurance_company'=>'Insurance Company',
                        'tpa_company'=>'TPA Company',
			'id' => 'ID',
			'file_no' => 'File Number',
			'claim_no' => 'Claim Number',
			'suppliment_exist' => 'Suppliment Exist',
			'created_by' => 'Created By',
			'close_date' => 'Close Date',
			'status' => 'Status',
			'reopened' => 'Reopened',
			'policy_no' => 'Policy Number',
			'policy_limit' => 'Policy Limit',
			'deducitible_waived' => 'Deducitible Waived?',
			'deducitible' => 'Deducitible',
			'claim_creation_date' => 'Claim Creation Date',
			'date_of_loss' => 'Date Of Loss',
			'assignment_type' => 'Assignment Type',
			'other_assignment_type' => 'Other Assignment Type',
			'loss_type' => 'Loss Type',
			'other_loss_type' => 'Other Loss Type',
			'claim_report_date' => 'Claim Report Date',
			'whoose_claim' => 'Whose Claim',
			'coverage_verified' => 'Coverage Verified',
			'type_of_coverage' => 'Type Of Coverage',
			'branch_id' => 'Branch',
			'other_branch' => 'Other Branch',
			'ob_address1' => 'Address1',
			'ob_address2' => 'Address2',
			'ob_city' => 'City',
			'ob_state_id' => 'State',
			'ob_zip' => 'Zip',
			'adjustor_id' => 'Adjuster',
			'other_adjuster' => 'Other Adjuster',
			'ob_phone' => 'Phone',
			'ob_fax' => 'Fax',
			'ob_email' => 'Email',
			'c_first_name' => 'Claimant First Name',
			'c_last_name' => 'Claimant Last Name',
			'c_address1' => 'Address 1',
			'c_address2' => 'Address 2',
			'c_city' => 'City',
			'c_state_id' => 'State',
			'c_zip' => 'Zip',
			'c_cell' => 'Cell Number',
			'c_home' => 'Home Number',
			'c_work' => 'Work Number',
			'c_fax' => 'Fax Number',
			'c_email' => 'Email',
			'i_first_name' => 'Insured First Name',
			'i_last_name' => 'Insured Last Name',
			'i_address1' => 'Address1',
			'i_address2' => 'Address2',
			'i_city' => 'City',
			'i_state_id' => 'State',
			'i_zip' => 'Zip',
			'i_home' => 'Home Number',
			'i_work' => 'Work Number',
			'i_cell' => 'Cell Number',
			'i_fax' => 'Fax Number',
			'i_email' => 'Email',
			'o_first_name' => 'Owner First Name',
			'o_last_name' => 'Owner Last Name',
			'o_address1' => 'Address Line 1',
			'o_address2' => 'Address Line 2',
			'o_city' => 'City',
			'o_state_id' => 'State',
			'o_zip' => 'Zip',
			'o_home' => 'Home Number',
			'o_work' => 'Work Number',
			'o_cell' => 'Cell Number',
			'o_fax' => 'Fax',
			'o_email' => 'Email',
			'v_location_name' => 'Location Name',
			'v_address1' => 'Address1',
			'v_address2' => 'Address2',
			'v_city' => 'City',
			'v_state_id' => 'State',
			'v_zip' => 'Zip',
			'v_phone' => 'Phone Number',
			'v_email' => 'Email',
			'v_year' => 'Year',
			'v_make_id' => 'Vehicle Make',
                        'v_make_other'=>'Other Make',
                        'v_model_other'=>'Other Model',
			'v_model_id' => 'Vehicle Model',
			'v_submodel' => 'Sub-Model',
			'v_lien_holder' => 'Lien Holder',
			'v_color' => 'Vehicle Color',
			'v_plate_no' => 'Plate Number',
			'v_plate_country' => 'Country',
			'v_plate_state_id' => 'State',
			'v_milege' => 'Vehicle Milege',
			'v_style' => 'Vehicle Style',
			'v_drivable' => 'Drivable',
			'v_condition' => 'Condition',
			'v_different_location' => 'Different Location',
			'v_vin' => 'VIN',
			'ty_make' => 'Make',
			'ty_size' => 'Size',
			'ty_lf' => 'L/F',
			'ty_lr' => 'L/R',
			'ty_rf' => 'R/F',
			'ty_rr' => 'R/R',
			'ty_spare' => 'Spare',
			'ad_primary_poi' => 'Primary POI',
			'ad_secondary_poi' => 'Secondary POI',
			'ad_vehicle_condition' => 'Vehicle Condition',
			'ad_interior_condition' => 'Interior Condition',
			'ad_paint_condition' => 'Paint Condition',
			'ad_engine_condition' => 'Engine',
			'ad_pay_code' => 'Pay Code',
			'ad_rental_vehicle' => 'Rental Vehicle',
			'ad_storage' => 'Storage',
			'ad_permission_to_move' => 'Permission To Move',
			'ad_rental_max_days' => 'Rental Max Days',
			'ad_rental_max_aount' => 'Rental Max Aount',
			'rp_shop_name' => 'Shop Name',
			'rp_address1' => 'Address 1',
			'rpo_address2' => 'Address 2',
			'rp_city' => 'City',
			'rp_state_id' => 'State',
			'rp_zip' => 'Zip',
			'rp_phone' => 'Phone',
			'rp_fax' => 'Fax',
			'rp_aggreed_price' => 'Aggreed Price',
			'rp_federal_tax_id' => 'Federal Tax ID #',
			'rp_ert_days' => 'ERT (Days)',
			'rp_posiible_supplement' => 'Possible Supplement',
			'rp_originalnet_loss' => 'Original Net Loss',
			'rp_supplement_net_loss' => 'Supplement Net Loss',
			'adi_special_instruction' => 'Special Instruction',
			'adi_damage_description' => 'Damage Description',
			'adi_prior_damage' => 'Prior Damage',
			'adi_accident_description' => 'Accident Description',
			'ali_vehicel_appointment_setup' => 'Vehicel Appointment Setup',
			'ali_recommendation' => 'Recommendation',
			'ali_total_loss' => 'Total Loss',
			'gui_company_guidelines' => 'Company Guidelines',
			'gui_branch_guidelines' => 'Branch Guidelines',
			'tpa_branch' => 'TPA Company Branch',
			'tpa_address1' => 'Address 1',
			'tpa_address2' => 'Address 2',
			'tpa_city' => 'City',
			'tpa_state' => 'State',
			'tpa_zip' => 'Zip',
			'tpa_adjuster' => 'Adjuster',
			'tpa_phone' => 'Phone',
			'tpa_fax' => 'Fax',
			'tpa_email' => 'Email',
			'delivery_method' => 'Delivery Method',
			'status_interval' => 'Status Interval',
			'created' => 'Created',
			'modified' => 'Modified',
			'adi_damage_location' => 'Damage Location',
			'adi_claim_reported_by' => 'Claim Reported By',
			'adi_driver_name' => 'Driver Name',
			'adi_address1' => 'Address1',
			'adi_address2' => 'Address2',
			'adi_city' => 'City',
			'adi_state' => 'State',
			'adi_country' => 'Country',
			'adi_zip' => 'Zip',
			'adi_email' => 'Email',
			'adi_driver_licence' => 'Drivers Licence Number',
			'adi_licence_state' => 'Drivers Licence State',
			'adi_licence_country' => 'Drivers Licence Country',
			'adi_authority_contacted' => 'Authority Contacted',
			'adi_phone' => 'Phone Number',
			'adi_bywhom' => 'By Whom',
			'adi_report_number' => 'Report Number',
			'adi_phone_number' => 'Phone Number',
			/*'' => 'Pw Name',
			'pw_phone' => 'Pw Phone',
			'pw_type' => 'Pw Type',
			//'pw_statement' => 'Pw Statement',
			//'pw_relationship' => 'Pw Relationship',*/
			'apl_appointment_datetime' => 'Appointment Date/Time',
			'apl_and' => 'And',
			'apl_between' => 'Between',
			'prefered_tl_evalution' => 'Preferred TL Evaluation',
			/*'pw_reference_num' => 'Pw Reference Num',
			'pw_location' => 'Pw Location',
			'pw_phone_number' => 'Pw Phone Number',
			'pw_amount' => 'Pw Amount',*/
			'producer_company_name' => 'Company Name',
			'agent_name' => 'Agent Name',
			'producer_address1' => 'Producer Address1',
			'producer_address2' => 'Producer Address2',
			'producer_city' => 'City',
			'producer_state' => 'State',
			'producer_zip' => 'Zip',
			'producer_country' => 'Country',
			'producer_email' => 'Email',
			'producer_phone' => 'Phone',
			'producer_webaddress' => 'Web Address',
			'producer_policy_number' => 'Policy Number',
			'producer_policy_effective_date' => 'Policy Effective Date',
			'policy_expiration_date' => 'Policy Expiration Date',
			'bodiy_enjury_per_person' => 'Bodiy Injury-Per Person',
			'bodily_enjury_per_accident' => 'Bodily Injury-Per Accident',
			'property_damage' => 'Property Damage',
			'single_limits' => 'Single Limits',
			'medical_payment_limits' => 'Medical Payment Limits',
			'otc_deductible' => 'OTC Deductible',
			'collision_deductible' => 'Collision Deductible',
			'unrelated_bodily_injury_per_person' => 'Unrelated Bodily Injury - Per Person',
			'unrelated_bodily_injury_per_accident' => 'Unrelated Bodily Injury - Per Accident',
			'motorist_property_damage' => 'Uninsured Motorist Property Damage',
			'loss_payee' => 'Loss Payee',
			'pro_contact_name' => 'Contact Name',
			'pro_address1' => 'Address1',
			'pro_address2' => 'Address2',
			'pro_city' => 'City',
			'pro_zip' => 'Zip',
			'pro_state' => 'State',
			'pro_country' => 'Country',
			'pro_fax' => 'Fax',
			'pro_phone' => 'Phone',
			'pro_email' => 'Email',
			'rental_max_days'=>'Rental Max Days',
			'rental_max_amount'=>'Rental Max Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_no',$this->file_no,true);
		$criteria->compare('claim_no',$this->claim_no,true);
		$criteria->compare('suppliment_exist',$this->suppliment_exist);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('close_date',$this->close_date,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('reopened',$this->reopened);
		$criteria->compare('policy_no',$this->policy_no,true);
		$criteria->compare('policy_limit',$this->policy_limit);
		$criteria->compare('deducitible_waived',$this->deducitible_waived);
		$criteria->compare('deducitible',$this->deducitible);
		$criteria->compare('claim_creation_date',$this->claim_creation_date,true);
		$criteria->compare('date_of_loss',$this->date_of_loss,true);
		$criteria->compare('assignment_type',$this->assignment_type,true);
		$criteria->compare('other_assignment_type',$this->other_assignment_type,true);
		$criteria->compare('loss_type',$this->loss_type,true);
		$criteria->compare('other_loss_type',$this->other_loss_type,true);
		$criteria->compare('claim_report_date',$this->claim_report_date,true);
		$criteria->compare('whoose_claim',$this->whoose_claim,true);
		$criteria->compare('coverage_verified',$this->coverage_verified);
		$criteria->compare('type_of_coverage',$this->type_of_coverage,true);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('other_branch',$this->other_branch,true);
		$criteria->compare('ob_address1',$this->ob_address1,true);
		$criteria->compare('ob_address2',$this->ob_address2,true);
		$criteria->compare('ob_city',$this->ob_city,true);
		$criteria->compare('ob_state_id',$this->ob_state_id);
		$criteria->compare('ob_zip',$this->ob_zip);
		$criteria->compare('adjustor_id',$this->adjustor_id);
		$criteria->compare('other_adjuster',$this->other_adjuster,true);
		$criteria->compare('ob_phone',$this->ob_phone);
		$criteria->compare('ob_fax',$this->ob_fax);
		$criteria->compare('ob_email',$this->ob_email,true);
		$criteria->compare('c_first_name',$this->c_first_name,true);
		$criteria->compare('c_last_name',$this->c_last_name,true);
		$criteria->compare('c_address1',$this->c_address1,true);
		$criteria->compare('c_address2',$this->c_address2,true);
		$criteria->compare('c_city',$this->c_city,true);
		$criteria->compare('c_state_id',$this->c_state_id);
		$criteria->compare('c_zip',$this->c_zip);
		$criteria->compare('c_cell',$this->c_cell);
		$criteria->compare('c_home',$this->c_home);
		$criteria->compare('c_work',$this->c_work);
		$criteria->compare('c_fax',$this->c_fax);
		$criteria->compare('c_email',$this->c_email,true);
		$criteria->compare('i_first_name',$this->i_first_name,true);
		$criteria->compare('i_last_name',$this->i_last_name,true);
		$criteria->compare('i_address1',$this->i_address1,true);
		$criteria->compare('i_address2',$this->i_address2,true);
		$criteria->compare('i_city',$this->i_city,true);
		$criteria->compare('i_state_id',$this->i_state_id);
		$criteria->compare('i_zip',$this->i_zip);
		$criteria->compare('i_home',$this->i_home);
		$criteria->compare('i_work',$this->i_work);
		$criteria->compare('i_cell',$this->i_cell);
		$criteria->compare('i_fax',$this->i_fax);
		$criteria->compare('i_email',$this->i_email,true);
		$criteria->compare('o_first_name',$this->o_first_name,true);
		$criteria->compare('o_last_name',$this->o_last_name,true);
		$criteria->compare('o_address1',$this->o_address1,true);
		$criteria->compare('o_address2',$this->o_address2,true);
		$criteria->compare('o_city',$this->o_city,true);
		$criteria->compare('o_state_id',$this->o_state_id);
		$criteria->compare('o_zip',$this->o_zip);
		$criteria->compare('o_home',$this->o_home);
		$criteria->compare('o_work',$this->o_work);
		$criteria->compare('o_cell',$this->o_cell);
		$criteria->compare('o_fax',$this->o_fax);
		$criteria->compare('o_email',$this->o_email,true);
		$criteria->compare('v_location_name',$this->v_location_name,true);
		$criteria->compare('v_address1',$this->v_address1,true);
		$criteria->compare('v_address2',$this->v_address2,true);
		$criteria->compare('v_city',$this->v_city,true);
		$criteria->compare('v_state_id',$this->v_state_id);
		$criteria->compare('v_zip',$this->v_zip);
		$criteria->compare('v_phone',$this->v_phone);
		$criteria->compare('v_email',$this->v_email,true);
		$criteria->compare('v_year',$this->v_year);
		$criteria->compare('v_make_id',$this->v_make_id);
		$criteria->compare('v_model_id',$this->v_model_id);
		$criteria->compare('v_submodel',$this->v_submodel,true);
		$criteria->compare('v_lien_holder',$this->v_lien_holder,true);
		$criteria->compare('v_color',$this->v_color,true);
		$criteria->compare('v_plate_no',$this->v_plate_no,true);
		$criteria->compare('v_plate_country',$this->v_plate_country);
		$criteria->compare('v_plate_state_id',$this->v_plate_state_id);
		$criteria->compare('v_milege',$this->v_milege);
		$criteria->compare('v_style',$this->v_style,true);
		$criteria->compare('v_drivable',$this->v_drivable,true);
		$criteria->compare('v_condition',$this->v_condition,true);
		$criteria->compare('v_different_location',$this->v_different_location,true);
		$criteria->compare('v_vin',$this->v_vin,true);
		$criteria->compare('ty_make',$this->ty_make,true);
		$criteria->compare('ty_size',$this->ty_size,true);
		$criteria->compare('ty_lf',$this->ty_lf);
		$criteria->compare('ty_lr',$this->ty_lr);
		$criteria->compare('ty_rf',$this->ty_rf);
		$criteria->compare('ty_rr',$this->ty_rr);
		$criteria->compare('ty_spare',$this->ty_spare);
		$criteria->compare('ad_primary_poi',$this->ad_primary_poi,true);
		$criteria->compare('ad_secondary_poi',$this->ad_secondary_poi,true);
		$criteria->compare('ad_vehicle_condition',$this->ad_vehicle_condition,true);
		$criteria->compare('ad_interior_condition',$this->ad_interior_condition,true);
		$criteria->compare('ad_paint_condition',$this->ad_paint_condition,true);
		$criteria->compare('ad_engine_condition',$this->ad_engine_condition,true);
		$criteria->compare('ad_pay_code',$this->ad_pay_code,true);
		$criteria->compare('ad_rental_vehicle',$this->ad_rental_vehicle,true);
		$criteria->compare('ad_storage',$this->ad_storage,true);
		$criteria->compare('ad_permission_to_move',$this->ad_permission_to_move,true);
		$criteria->compare('ad_rental_max_days',$this->ad_rental_max_days);
		$criteria->compare('ad_rental_max_aount',$this->ad_rental_max_aount);
		$criteria->compare('rp_shop_name',$this->rp_shop_name,true);
		$criteria->compare('rp_address1',$this->rp_address1,true);
		$criteria->compare('rpo_address2',$this->rpo_address2,true);
		$criteria->compare('rp_city',$this->rp_city,true);
		$criteria->compare('rp_state_id',$this->rp_state_id);
		$criteria->compare('rp_zip',$this->rp_zip);
		$criteria->compare('rp_phone',$this->rp_phone);
		$criteria->compare('rp_fax',$this->rp_fax);
		$criteria->compare('rp_aggreed_price',$this->rp_aggreed_price,true);
		$criteria->compare('rp_federal_tax_id',$this->rp_federal_tax_id,true);
		$criteria->compare('rp_ert_days',$this->rp_ert_days);
		$criteria->compare('rp_posiible_supplement',$this->rp_posiible_supplement,true);
		$criteria->compare('rp_originalnet_loss',$this->rp_originalnet_loss);
		$criteria->compare('rp_supplement_net_loss',$this->rp_supplement_net_loss);
		$criteria->compare('adi_special_instruction',$this->adi_special_instruction,true);
		$criteria->compare('adi_damage_description',$this->adi_damage_description,true);
		$criteria->compare('adi_prior_damage',$this->adi_prior_damage,true);
		$criteria->compare('adi_accident_description',$this->adi_accident_description,true);
		$criteria->compare('ali_vehicel_appointment_setup',$this->ali_vehicel_appointment_setup);
		$criteria->compare('ali_recommendation',$this->ali_recommendation,true);
		$criteria->compare('ali_total_loss',$this->ali_total_loss,true);
		$criteria->compare('gui_company_guidelines',$this->gui_company_guidelines,true);
		$criteria->compare('gui_branch_guidelines',$this->gui_branch_guidelines,true);
		$criteria->compare('tpa_branch',$this->tpa_branch);
		$criteria->compare('tpa_address1',$this->tpa_address1,true);
		$criteria->compare('tpa_address2',$this->tpa_address2,true);
		$criteria->compare('tpa_city',$this->tpa_city,true);
		$criteria->compare('tpa_state',$this->tpa_state);
		$criteria->compare('tpa_zip',$this->tpa_zip);
		$criteria->compare('tpa_adjuster',$this->tpa_adjuster);
		$criteria->compare('tpa_phone',$this->tpa_phone,true);
		$criteria->compare('tpa_fax',$this->tpa_fax,true);
		$criteria->compare('tpa_email',$this->tpa_email,true);
		$criteria->compare('delivery_method',$this->delivery_method,true);
		$criteria->compare('status_interval',$this->status_interval,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('adi_damage_location',$this->adi_damage_location,true);
		$criteria->compare('adi_claim_reported_by',$this->adi_claim_reported_by,true);
		$criteria->compare('adi_driver_name',$this->adi_driver_name,true);
		$criteria->compare('adi_address1',$this->adi_address1,true);
		$criteria->compare('adi_address2',$this->adi_address2,true);
		$criteria->compare('adi_city',$this->adi_city,true);
		$criteria->compare('adi_state',$this->adi_state);
		$criteria->compare('adi_country',$this->adi_country);
		$criteria->compare('adi_zip',$this->adi_zip);
		$criteria->compare('adi_email',$this->adi_email,true);
		$criteria->compare('adi_driver_licence',$this->adi_driver_licence,true);
		$criteria->compare('adi_licence_state',$this->adi_licence_state,true);
		$criteria->compare('adi_licence_country',$this->adi_licence_country,true);
		$criteria->compare('adi_authority_contacted',$this->adi_authority_contacted,true);
		$criteria->compare('adi_phone',$this->adi_phone);
		$criteria->compare('adi_bywhom',$this->adi_bywhom,true);
		$criteria->compare('adi_report_number',$this->adi_report_number,true);
		$criteria->compare('adi_phone_number',$this->adi_phone_number);
		/*$criteria->compare('pw_name',$this->pw_name,true);
		$criteria->compare('pw_phone',$this->pw_phone);
		$criteria->compare('pw_type',$this->pw_type,true);
		$criteria->compare('pw_statement',$this->pw_statement,true);
		$criteria->compare('pw_relationship',$this->pw_relationship,true);*/
		$criteria->compare('apl_appointment_datetime',$this->apl_appointment_datetime,true);
		$criteria->compare('apl_and',$this->apl_and,true);
		$criteria->compare('apl_between',$this->apl_between,true);
		$criteria->compare('prefered_tl_evalution',$this->prefered_tl_evalution,true);
		/*$criteria->compare('pw_reference_num',$this->pw_reference_num,true);
		$criteria->compare('pw_location',$this->pw_location,true);
		$criteria->compare('pw_phone_number',$this->pw_phone_number);
		$criteria->compare('pw_amount',$this->pw_amount);*/
		$criteria->compare('producer_company_name',$this->producer_company_name,true);
		$criteria->compare('agent_name',$this->agent_name,true);
		$criteria->compare('producer_address1',$this->producer_address1,true);
		$criteria->compare('producer_address2',$this->producer_address2,true);
		$criteria->compare('producer_city',$this->producer_city,true);
		$criteria->compare('producer_state',$this->producer_state);
		$criteria->compare('producer_zip',$this->producer_zip);
		$criteria->compare('producer_country',$this->producer_country);
		$criteria->compare('producer_email',$this->producer_email,true);
		$criteria->compare('producer_phone',$this->producer_phone);
		$criteria->compare('producer_webaddress',$this->producer_webaddress,true);
		$criteria->compare('producer_policy_number',$this->producer_policy_number,true);
		$criteria->compare('producer_policy_effective_date',$this->producer_policy_effective_date,true);
		$criteria->compare('policy_expiration_date',$this->policy_expiration_date,true);
		$criteria->compare('bodiy_enjury_per_person',$this->bodiy_enjury_per_person);
		$criteria->compare('bodily_enjury_per_accident',$this->bodily_enjury_per_accident);
		$criteria->compare('property_damage',$this->property_damage);
		$criteria->compare('single_limits',$this->single_limits);
		$criteria->compare('medical_payment_limits',$this->medical_payment_limits);
		$criteria->compare('otc_deductible',$this->otc_deductible);
		$criteria->compare('collision_deductible',$this->collision_deductible);
		$criteria->compare('unrelated_bodily_injury_per_person',$this->unrelated_bodily_injury_per_person);
		$criteria->compare('unrelated_bodily_injury_per_accident',$this->unrelated_bodily_injury_per_accident);
		$criteria->compare('motorist_property_damage',$this->motorist_property_damage);
		$criteria->compare('loss_payee',$this->loss_payee,true);
		$criteria->compare('pro_contact_name',$this->pro_contact_name,true);
		$criteria->compare('pro_address1',$this->pro_address1,true);
		$criteria->compare('pro_address2',$this->pro_address2,true);
		$criteria->compare('pro_city',$this->pro_city,true);
		$criteria->compare('pro_zip',$this->pro_zip);
		$criteria->compare('pro_state',$this->pro_state);
		$criteria->compare('pro_country',$this->pro_country);
		$criteria->compare('pro_fax',$this->pro_fax);
		$criteria->compare('pro_phone',$this->pro_phone);
		$criteria->compare('pro_email',$this->pro_email,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public function assignTo($claim_id)
        {
            $ass=new Assignee;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id.' and active=1';
            $assn=$ass->find($q);
            $ctype=  UserController::getTypeid(Yii::app()->user->id);
            if($assn!=null)
            {
                /*if($assn->assign_to!=null)
                {
                    $usr=  User::model()->findByPk($assn->assign_to);
                    return $usr->first_name." ".$usr->last_name;
                }*/
                 if($assn->branch_id!=null)
                 {
                     $br=  Branch::model()->findByPk($assn->branch_id);
                     if($ctype>=7 && $ctype<=12)
                     {
                         if( $br->branch_type="Standard")
                                 return $br->branch_name;
                          else { return false;}
                     }
                      if($ctype>=12 && $ctype<=17)
                     {
                         if( $br->branch_type="Call Center")
                                 return $br->branch_name;
                          else { return false;}
                     }
                     return $br->branch_name;
                 }
            }
            else { return false;}
        }
         public function assignToType($claim_id,$typ)
        {
            
            $ass=new Authassignment;
            $q=new CDbCriteria;
            $q->join=" left join assignee on assignee.assign_to=t.userid";
            $q->condition='assignee.claim_id='.$claim_id.'  and assignee.assign_to!=0';
            $assn=$ass->findAll($q);
            if($assn!=null)
            { 
                foreach($assn as $aa)
                {
                    if($typ=="Appraiser")
                        {
                            if($aa->itemname==7 || $aa->itemname==50 || $aa->itemname==16 || $aa->itemname==18)
                              return true;
                        }
                    if($typ=="DeskReviewer")
                        {
                            if($aa->itemname==11 || $aa->itemname==17 || $aa->itemname==24 )
                              return true;
                        }
                    if($typ=="TPA")
                        {
                            if($aa->itemname>=27 || $aa->itemname<=32 )
                              return true;
                        }
                }
                 
            }
            return false;
        }
           public function inspectedBy($claim_id,$sh)
        {
            $ass=new Assignee;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id;
            $q->order="t.created DESC";
            $assn=$ass->findAll($q);
           //var_dump($assn);
            $ctype=  UserController::getTypeid(Yii::app()->user->id);
            if($assn!=null)
            {
                foreach ($assn as $a){
                if($a->assign_to!=null && $a->assign_to!=0)
                {
                    $usr=  User::model()->findByPk($a->assign_to);
                    $auth=new Authassignment;
                    $q=new CDbCriteria;
                    $q->compare('t.userid',$a->assign_to);
                    $at=$auth->find($q);
                   $type=$at->itemname;
                   if($ctype>=7 && $ctype<=12 && $sh=="inspect"){
                       if($type==7)
                         return $usr->first_name." ".$usr->last_name;
                   }
                   else if($ctype>=12 && $ctype<=17 && $sh=="inspect"){
                       if($type==16 )
                         return $usr->first_name." ".$usr->last_name;
                   }
                   else if($ctype>=7 && $ctype<=12 && $sh=="Reviewed"){
                       if($type==11 )
                         return $usr->first_name." ".$usr->last_name;
                   }
                   else if($ctype>=12 && $ctype<=17 && $sh=="Reviewed"){
                       if($type==17 )
                         return $usr->first_name." ".$usr->last_name;
                   }
                    
                   else {
                    if(($type==7 || $type==16 || $type==18 || $type==50) && $sh=="inspect")
                       return $usr->first_name." ".$usr->last_name;
                   if(($type==11 || $type==17 ) && $sh=="Reviewed")
                       return $usr->first_name." ".$usr->last_name;
                   else if($type==25 && $sh=="Reinspected")
                     return $usr->first_name." ".$usr->last_name;
                   }
                 }
                } //else { return null;}
            }
             return null;
        }
        public function checkPayout($claim_id,$ty)
        {
            if($ty=="Insured")
                $t=2;
            else {
                $t=1;
            }
            $p=new Payout;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id.' and type_id='.$t;
            $pay=$p->find($q);
            if($pay!=null)
                return "Yes";
            else
                return "No";
            
        }
        public function checkInvoceExist($invoice,$claimid)
        {
                                $mode=new $invoice;
                                $c = new CDbCriteria;
                                $c->compare('claim_id',$claimid);
                                $df = $mode->find($c);
                               // var_dump($df);
                                 if($df!=null)
                                 {return true;}
                                 return false;
        }

        public static function getNewFileNumber($branch_id=null,$cmp_id=null)
	{
		$uid=Yii::app()->user->id;
		 $today_date = date("Y-m-d", time());
                 $utype=  UserController::getTypeid(Yii::app()->user->id);
  
			 //,year(alert_date) as y,month(alert_date) as m, day(alert_date) as d
			  $sql= "SELECT  count(id) as cnt from claim where DATE_FORMAT(created, '%Y-%m-%d') = '".$today_date."'";
		 if($utype==12 || $utype==21 || $utype==29 || $utype==37 || $utype==46 || $utype<=5 || $utype==50)
                 {
                     
                          $sql="select file_no from claim left join user on user.id=claim.created_by "
                                  . "  left join company on company.id=user.company_id "
                                  . " where user.company_id=".$cmp_id."   order by claim.`created` desc limit 1";
                 }
                 else
                 {
                          $sql="select file_no from claim left join user on user.id=claim.created_by left"
                                  . " join branch on branch.id=user.branch_id "
                                  . " where branch.company_id=".$cmp_id."   order by claim.`created` desc limit 1";
                 }
        //$name = $uid;
       return $cnt=Yii::app()->db->createCommand($sql)->queryAll();
     // var_dump($cnt);
	}
        public static function getClaimNumber($format,$str=null)
        {
            if($format==1)//current year + random numbers
            {
                $year=date('Y');
                $rand=User::random_string('nozero',8);
                $claimnumber=$year.$rand;
                return $claimnumber;
            }
               if($format==2 )//current year + claimaint's name + 2 numbers
            {
                $year=date('Y');
                $rand=User::random_string('nozero',2);
                $claimnumber=$year.$str.$rand;
                return $claimnumber;
            }
            if($format==3)//current year + insured's name + 2 numbers
            {
                $year=date('Y');
                $rand=User::random_string('nozero',2);
                $claimnumber=$year.$str.$rand;
                return $claimnumber;
            }
            if($format==4)//current year + owner's name + 2 numbers
            {
                $year=date('Y');
                $rand=User::random_string('nozero',2);
                $claimnumber=$year.$str.$rand;
                return $claimnumber;
            }
            if($format==5)//numerical
            {
               // $year=date('Y');
                $rand=User::random_string('numeric',9);
                $claimnumber=$rand;
                return $claimnumber;
            }
            if($format==6)//alphabetical
            {
               // $year=date('Y');
                $rand=User::random_string('alphabetical',11);
                $claimnumber=$rand;
                return $claimnumber;
            }
            if($format==7)//numerical + alphabetical
            {
               // $year=date('Y');
                $rand=User::random_string('alnum',10);
                $claimnumber=$rand;
                return $claimnumber;
            }
              if($format==8)//first two letters of branch + numbers
            {
               // $year=date('Y');
                $rand=User::random_string('nozero',7);
                $claimnumber=$str.$rand;
                return $claimnumber;
            }
             if($format==9)//claim date + name
            {
               // $year=date('Y');
                //$rand=User::random_string('nozero',7);
                $claimnumber=$str;
                return $claimnumber;
            }
             if($format==10)//First five letters of VIN + Name
            {
               // $year=date('Y');
                //$rand=User::random_string('nozero',7);
                $claimnumber=$str;
                return $claimnumber;
            }
        }
}