<?php

/**
 * This is the model class for table "child_aduster".
 *
 * The followings are the available columns in table 'child_aduster':
 * @property integer $id
 * @property string $pwdslug
 * @property string $email
 * @property string $username
 * @property string $password
 * @property string $first_name
 * @property string $last_name
 * @property string $salt
 * @property integer $status
 * @property integer $user_type_id
 * @property integer $category_id
 * @property string $homephone
 * @property string $workphone
 * @property string $cellphone
 * @property string $search_type
 * @property integer $num_claims
 * @property string $contacts
 * @property double $repareblefee
 * @property double $totallossfee
 * @property double $desk_repairablefee
 * @property double $desk_totallossfee
 * @property integer $created_by
 * @property integer $branch_id
 * @property integer $is_superadmin
 * @property string $created
 * @property string $modified
 */
class Childaduster extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $password2;
	public function tableName()
	{
		return 'child_aduster';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('first_name, last_name, branch_id,created_by_comp,created_by,email', 'required'),
			array('status, user_type_id, category_id, num_claims, created_by, branch_id, is_superadmin', 'numerical', 'integerOnly'=>true),
			array('repareblefee, totallossfee, desk_repairablefee, desk_totallossfee', 'numerical'),
			array('pwdslug', 'length', 'max'=>99),
			array('email', 'length', 'max'=>150),
			array('username, first_name, last_name', 'length', 'max'=>100),
			array('password, salt', 'length', 'max'=>255),
			array('homephone, workphone', 'length', 'max'=>20),
			array('cellphone', 'length', 'max'=>500),
			array('search_type', 'length', 'max'=>8),
			array('contacts', 'safe'),
                     array('password2,accept', 'safe'),                        
                        
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, pwdslug, email, username,created_by_comp, password, first_name, last_name, salt, status, user_type_id, category_id, homephone, workphone, cellphone, search_type, num_claims, contacts, repareblefee, totallossfee, desk_repairablefee, desk_totallossfee, created_by, branch_id, is_superadmin, created, modified', 'safe', 'on'=>'search'),
		array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'childaddresses' => array(self::HAS_ONE, 'Childaddress', 'user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pwdslug' => 'Pwdslug',
			'email' => 'Email',
			'username' => 'Username',
			'password' => 'Password',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'salt' => 'Salt',
			'status' => 'Status',
			'user_type_id' => 'User Type',
			'category_id' => 'Category',
			'homephone' => 'Homephone',
			'workphone' => 'Workphone',
			'cellphone' => 'Cellphone',
			'search_type' => 'Search Type',
			'num_claims' => 'Num Claims',
			'contacts' => 'Contacts',
			'repareblefee' => 'Repareblefee',
			'totallossfee' => 'Totallossfee',
			'desk_repairablefee' => 'Desk Repairablefee',
			'desk_totallossfee' => 'Desk Totallossfee',
			'created_by' => 'Created By',
			'branch_id' => 'Branch',
			'is_superadmin' => 'Is Superadmin',
			'created' => 'Created',
			'modified' => 'Modified',
                       'created_by_comp'=>'Created By Company',
                     
		);
	}
public function getFullName()
   {
      return $this->first_name . " " . $this->last_name;
   }
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pwdslug',$this->pwdslug,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('salt',$this->salt,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('user_type_id',$this->user_type_id);
		$criteria->compare('category_id',$this->category_id);
		$criteria->compare('homephone',$this->homephone,true);
		$criteria->compare('workphone',$this->workphone,true);
		$criteria->compare('cellphone',$this->cellphone,true);
		$criteria->compare('search_type',$this->search_type,true);
		$criteria->compare('num_claims',$this->num_claims);
		$criteria->compare('contacts',$this->contacts,true);
		$criteria->compare('repareblefee',$this->repareblefee);
		$criteria->compare('totallossfee',$this->totallossfee);
		$criteria->compare('desk_repairablefee',$this->desk_repairablefee);
		$criteria->compare('desk_totallossfee',$this->desk_totallossfee);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('is_superadmin',$this->is_superadmin);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Childaduster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
