<?php

/**
 * This is the model class for table "cfssupport".
 *
 * The followings are the available columns in table 'cfssupport':
 * @property integer $id
 * @property string $contact_type
 * @property string $importance
 * @property string $name
 * @property string $contact_information
 * @property string $message
 * @property string $created
 * @property string $modified
 */
class Cfssupport extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Cfssupport the static model class
	 */
    public $dateofissue,$suggestions,$issue;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cfssupport';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('contact_type, importance, name, contact_information, message', 'required'),
			array('contact_type', 'length', 'max'=>20),
			array('importance', 'length', 'max'=>6),
			array('name, contact_information', 'length', 'max'=>500),
                    
                           // array('dateofissue,suggestions,issue','safe'),
                   // array('dateofissue,suggestions,issue','required'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, contact_type, importance, name, contact_information, message, created, modified', 'safe', 'on'=>'search'),
		
                    array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'contact_type' => 'Contact Type',
			'importance' => 'Importance',
			'name' => 'Name',
			'contact_information' => 'Contact Information',
			'message' => 'Message',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('contact_type',$this->contact_type,true);
		$criteria->compare('importance',$this->importance,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('contact_information',$this->contact_information,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}