<?php

/**
 * This is the model class for table "cfsinvoice".
 *
 * The followings are the available columns in table 'cfsinvoice':
 * @property integer $id
 * @property integer $claim_id
 * @property double $creation_fee
 * @property double $misc_fee
 * @property double $fee_subtotal
 * @property double $sales_tax_rate
 * @property double $sales_tax_amount
 * @property double $total
 * @property integer $is_paid
 * @property string $paid_date
 * @property string $check_number
 * @property string $check_amount
 * @property string $created
 * @property string $modified
 * @property integer $deleted
 *
 * The followings are the available model relations:
 * @property Claim $claim
 */
class Cfsinvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Cfsinvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cfsinvoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('claim_id, total, is_paid', 'required'),
			array('claim_id, is_paid, deleted', 'numerical', 'integerOnly'=>true),
			array('creation_fee, misc_fee, fee_subtotal, sales_tax_rate, sales_tax_amount, total', 'numerical'),
			array('check_number', 'length', 'max'=>255),
			array('check_amount', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, claim_id, creation_fee, misc_fee, fee_subtotal, sales_tax_rate, sales_tax_amount, total, is_paid, paid_date, check_number, check_amount, created, modified, deleted', 'safe', 'on'=>'search'),
		array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'claim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'claim_id' => 'Claim',
			'creation_fee' => 'Creation Fee',
			'misc_fee' => 'Misc Fee',
			'fee_subtotal' => 'Fee Subtotal',
			'sales_tax_rate' => 'Sales Tax Rate',
			'sales_tax_amount' => 'Sales Tax Amount',
			'total' => 'Total',
			'is_paid' => 'Is Paid',
			'paid_date' => 'Paid Date',
			'check_number' => 'Check Number',
			'check_amount' => 'Check Amount',
			'created' => 'Created',
			'modified' => 'Modified',
			'deleted' => 'Deleted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('claim_id',$this->claim_id);
		$criteria->compare('creation_fee',$this->creation_fee);
		$criteria->compare('misc_fee',$this->misc_fee);
		$criteria->compare('fee_subtotal',$this->fee_subtotal);
		$criteria->compare('sales_tax_rate',$this->sales_tax_rate);
		$criteria->compare('sales_tax_amount',$this->sales_tax_amount);
		$criteria->compare('total',$this->total);
		$criteria->compare('is_paid',$this->is_paid);
		$criteria->compare('paid_date',$this->paid_date,true);
		$criteria->compare('check_number',$this->check_number,true);
		$criteria->compare('check_amount',$this->check_amount,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('deleted',$this->deleted);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}