<?php

/**
 * This is the model class for table "action".
 *
 * The followings are the available columns in table 'action':
 * @property integer $id
 * @property integer $by_utype
 * @property integer $from_ability
 * @property integer $move_for_utype
 * @property integer $move_into_status
 * @property integer $current_assigne
 * @property integer $previous_assignee
 */
class CFS extends MyActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cfs';
	}
 public function getDbConnection()
            {
                return self::getAdvertDbConnection();
            }
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('by_utype, from_ability, move_for_utype, move_into_status,menu_id', 'required'),
			array('by_utype, from_ability, move_for_utype, move_into_status, current_assigne, previous_assignee', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, by_utype, from_ability, move_for_utype, move_into_status, menu_id,fun', 'safe', 'on'=>'search'),
		);
	}
         
        /**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'by_utype' => 'By Utype',
			'from_ability' => 'From Ability',
			'move_for_utype' => 'Move For Utype',
			'move_into_status' => 'Move Into Status',
			'menu_id' => 'Menu',
			'fun' => 'Function',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('by_utype',$this->by_utype);
		$criteria->compare('from_ability',$this->from_ability);
		$criteria->compare('move_for_utype',$this->move_for_utype);
		$criteria->compare('move_into_status',$this->move_into_status);
		$criteria->compare('menu_id',$this->menu_id);
		$criteria->compare('fun',$this->fun);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Action the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
