<?php

/**
 * This is the model class for table "broadcastmessage".
 *
 * The followings are the available columns in table 'broadcastmessage':
 * @property integer $id
 * @property integer $company_type
 * @property integer $comany_id
 * @property integer $branch_id
 * @property string $message
 * @property string $created
 * @property string $modified
 * @property integer $created_by
 *
 * The followings are the available model relations:
 * @property Companytype $companyType
 * @property Company $comany
 * @property Branch $branch
 * @property User $createdBy
 */
class Broadcastmessage extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
       
	public function tableName()
	{
		return 'broadcastmessage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_type, comany_id,  message,  created_by', 'required'),
			array('company_type, comany_id, branch_id, created_by', 'numerical', 'integerOnly'=>true),
			 
                        // The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_type, comany_id, branch_id, message, created, modified, created_by', 'safe', 'on'=>'search'),
		
                     array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    
                    );
	}
        public function getmessage()
        {
             $typeid=  UserController::getTypeid(Yii::app()->user->id);
                $user=User::model()->findByPk(Yii::app()->user->id);
                $q=new CDbCriteria;
                if($typeid!=12 && $typeid!=21 && $typeid!=29 && $typeid!=37 && $typeid!=46 && $typeid>5 && $typeid!=50)
                { 
                      $q->compare('t.branch_id',$user->branch_id);
                      $model=$this->find($q);
                      if($model!=null)
                          return $model->message;
                      
                }
                return null;
        }
        /**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'companyType' => array(self::BELONGS_TO, 'Companytype', 'company_type'),
			'comany' => array(self::BELONGS_TO, 'Company', 'comany_id'),
			'branch' => array(self::BELONGS_TO, 'Branch', 'branch_id'),
			'createdBy' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_type' => 'Company Type',
			'comany_id' => 'Company',
			'branch_id' => 'Branch',
			'message' => 'Message',
			'created' => 'Created',
			'modified' => 'Modified',
			'created_by' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_type',$this->company_type);
		$criteria->compare('comany_id',$this->comany_id);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Broadcastmessage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
