<?php

/**
 * This is the model class for table "automatic_payment".
 *
 * The followings are the available columns in table 'automatic_payment':
 * @property integer $id
 * @property integer $company_id
 * @property double $pay_amount
 * @property string $occurance
 * @property double $discount
 * @property string $card_no
 * @property string $pay_type
 * @property integer $created_by
 * @property string $created
 * @property string $modified
 */
class Automaticpayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'automatic_payment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, pay_amount, occurance, discount, card_no, pay_type, created_by', 'required'),
			array('company_id, created_by', 'numerical', 'integerOnly'=>true),
			array('pay_amount, discount', 'numerical'),
			array('occurance', 'length', 'max'=>10),
			array('card_no, pay_type', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, pay_amount, occurance, discount, card_no, pay_type, created_by, created, modified', 'safe', 'on'=>'search'),
                        array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'pay_amount' => 'Pay Amount',
			'occurance' => 'Occurance',
			'discount' => 'Discount',
			'card_no' => 'Card No',
			'pay_type' => 'Pay Type',
			'created_by' => 'Created By',
			'created' => 'Created',
			'modified' => 'Modified',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('pay_amount',$this->pay_amount);
		$criteria->compare('occurance',$this->occurance,true);
		$criteria->compare('discount',$this->discount);
		$criteria->compare('card_no',$this->card_no,true);
		$criteria->compare('pay_type',$this->pay_type,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Automaticpayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
