<?php

/**
 * This is the model class for table "authorization_item".
 *
 * The followings are the available columns in table 'authorization_item':
 * @property integer $id
 * @property string $item
 * @property double $part_price
 * @property double $labour
 * @property string $type
 * @property integer $auth_form_id
 */
class AuthorizationItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'authorization_item';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('item, part_price, labour, type, auth_form_id', 'required'),
			array('auth_form_id', 'numerical', 'integerOnly'=>true),
			array('part_price, labour', 'numerical'),
			array('item', 'length', 'max'=>500),
			array('type', 'length', 'max'=>16),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, item, part_price, labour, type, auth_form_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'item' => 'Item',
			'part_price' => 'Part Price',
			'labour' => 'Labour',
			'type' => 'Type',
			'auth_form_id' => 'Auth Form',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('item',$this->item,true);
		$criteria->compare('part_price',$this->part_price);
		$criteria->compare('labour',$this->labour);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('auth_form_id',$this->auth_form_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AuthorizationItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
