<?php

/**
 * This is the model class for table "ability".
 *
 * The followings are the available columns in table 'ability':
 * @property integer $id
 * @property string $ability_name
 * @property string $url
 */
class Assignpermission extends MyActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Ability the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	 public function getDbConnection()
    {
        return self::getAdvertDbConnection();
    }
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'assignpermission';
	}
	public function getassignee()
	{
             $db=$this->getDbConnection();
		$uid=Yii::app()->user->id;
                $tyoeid=  UserController::getTypeid($uid);
                $mode=new Assignpermission();
                 $c = new CDbCriteria;
                $c->compare('t.assigned_by',$tyoeid);
                $c->order="t.assigned_to";
                $results = $mode->findAll($c); 
                //var_dump($results);
		/*$results = Yii::app()->getDb()->createCommand();
            $results->select('assigned_to')->from('assignpermission');
            $results->where('assigned_by='.$uid);*/
            //$results->order('sort_order ASC, label ASC');
        $arr=array();
       return $results ;//= $results->queryAll();
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
//			array('assigned_by,assigned_to', 'required'),
			array('assigned_by, assigned_to,group_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, assigned_by, assigned_to,group_id,checkbox', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'group'=>array(self::BELONGS_TO,'GroupTable','group_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'assigned_by' => 'Assigned By',
			'assigned_to' => 'Assigned To',
                        'group_id'=>'Group Id',
			'claim_id'=>'Claim Id',
                        'checkbox'=>'checkbox',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('assigned_by',$this->assigned_by,true);
		$criteria->compare('assigned_to',$this->assigned_to,true);
                $criteria->compare('group_id',$this->group_id,true);
                $criteria->compare('checkbox',$this->checkbox,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}