<?php

/**
 * This is the model class for table "action_apply".
 *
 * The followings are the available columns in table 'action_apply':
 * @property integer $id
 * @property integer $by_utype
 * @property integer $action
 * @property integer $active
 * @property string $created
 * @property string $modified
 * @property integer $claim_id
 */
class ActionApply extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'action_apply';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('by_utype, action, active, claim_id,by_userid,menu_id', 'required'),
			array('by_utype, action, active, claim_id,by_userid,menu_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, by_utype, action, active, created, modified, claim_id,by_userid,menu_id', 'safe', 'on'=>'search'),
		
                       array(
                                        'modified','default',
                                        'value'=>date('Y-m-d H:i:s'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>date('Y-m-d H:i:s'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
                    );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                   'acionclaim' => array(self::BELONGS_TO, 'Claim', 'claim_id'),
                    'byuser' => array(self::BELONGS_TO, 'User', 'by_userid'),
		);
	}
        public function getActionDetail($claim_id)
        {
            $q=new CDbCriteria;
            
            $q->condition='t.claim_id='.$claim_id." and active=1";
             
         // die();
            $detail=$this->findAll($q);
            if($detail!=null)
                return $detail;
        }
        public function getMenu($claim_id)
        {
             
            $utype=  UserController::getTypeid(Yii::app()->user->id);
            $det=$this->getActionDetail($claim_id);
            
             $arule=new Action();
             $flow=new Flow;
           // var_dump($det);
             if($det!=null)
             {
            foreach ($det as $ct)
            {
                if($ct->action==37 && $utype<=5)
                    return 58;
                if($ct->action==7 && $utype<=5  )
                     return 60;
                if($ct->action==8 && $utype<=5  )
                    return 59;
                  if($ct->action==9 && $utype<=5  )
                    return 61;
                 if($ct->action==37 )
                        {
                             $condition=" t.active=0 and t.action!=7 and "
                                    . " t.action!=8 and t.action!=9 and t.claim_id=".$ct->claim_id;
                           $q=new CDbCriteria;
            
                            $q->condition=$condition;
                            $q->order="t.id DESC ";
                            $q->limit=" 1";
                            // die();
                            $ct=$this->find($q);
              
                        }
             $cstatus= $arule->checkmoverule($ct->action,$ct->by_utype,$utype,$ct->menu_id,'',true); 
             
            
           
            if($cstatus==null)
            {
                return null;
                /*if($utype<=5)
                    return 58;
                else
                    return 8;*/
            }
            //var_dump($cstatus); die();
            foreach ($cstatus as $s)
            {  
                if($s->fun!="")
                {  
                     foreach ($det as $ct){
                         $bool= $flow->assignment_check($s->fun,$ct->claim_id,$utype,$menuid,$ct->by_utype,$ct->by_userid);
                        if($bool)
                        { $m=$s->move_into_status;
                            if($s->move_into_status==8)// if move into multiple menu then get new inbox
                                $m=$s->move_into_status;
                        }
                            
                     }
                }
                
                else
                $m=$s->move_into_status;
                
            }
            return $m;
             }
			 }
             return null;
        }

        /**
	 * @return array customized attribute labels (name=>label)
	 */
        public function afterSave()
        {
            $q=new CDbCriteria;
            $q->limit=1;
            $q->order=' created DESC';
            $ac=$this->find($q);
             $db=$this->getDbConnection();
             $abc=  Ability::model()->findbyPk($ac->action);
             $st=$abc->status;
             $filenum=$ac->acionclaim->file_no;
             $str='';
             if($st!='')
             {
               if (strpos($st,'by') !== false) {
                 $str="File number: ".$filenum. " ".$st." ".$ac->byuser->first_name." ".$ac->byuser->last_name;
                }
               else {
                 //$filenum=$ac->acionclaim->file_no;
                   $ass=new Assignee;
                   $q=new CDbCriteria;
                   $q->condition='t.claim_id='.$ac->claim_id." and t.active=1";
                   $agn=$ass->find($q);
                   if($agn!=null)
                   {
                       if($agn->assign_to!=0)
                           $to=$agn->assignto->first_name." ".$agn->assignto->last_name;
                       else {
                           $to=$agn->ass_branch->branch_name;
                       }
                        $str="File number: ".$filenum. " ".$st." ".$to;
                   }
                }
                $status=new Status;
                $status->claim_id=$ac->claim_id;
                $status->status=$str;
                $status->createdby=Yii::app()->user->id;
                $status->save();
             }
        }


        public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'by_utype' => 'By Utype',
			'action' => 'Action',
			'active' => 'Active',
			'created' => 'Created',
			'modified' => 'Modified',
			'claim_id' => 'Claim',
                        'by_userid'=>'By User Id',
                        'menu_id'=>'Menu',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('by_utype',$this->by_utype);
		$criteria->compare('action',$this->action);
		$criteria->compare('active',$this->active);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('claim_id',$this->claim_id);
                $criteria->compare('menu_id',$this->menu_id);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ActionApply the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
