<?php

/**
 * This is the model class for table "abilitytab".
 *
 * The followings are the available columns in table 'abilitytab':
 * @property integer $id
 * @property integer $menu_id
 * @property integer $ability_id
 * @property integer $claim_status
 *
 * The followings are the available model relations:
 * @property Ability $ability
 * @property Menuitem $menu
 */
class Abilitytab extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Abilitytab the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'abilitytab';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('menu_id, ability_id, usertype', 'required'),
			array('menu_id, ability_id, claim_status', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, menu_id, ability_id, claim_status,usertype', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ability' => array(self::HAS_MANY, 'Ability', 'ability_id'),
			'menu' => array(self::HAS_MANY, 'Menuitem', 'menu_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'menu_id' => 'Tab',
			'ability_id' => 'Ability',
			'claim_status' => 'claim_status',
                        'usertype'=>'User Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('menu_id',$this->menu_id);
		$criteria->compare('ability_id',$this->ability_id);
		$criteria->compare('change_status',$this->change_status);
                $criteria->compare('usertype',$this->usertype);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}