<?php

class UserController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}
        public function allowedActions()
        {
            return 'admin,view,index,userchek,getusers,getgroupusers,getgroupbranch,getStateBranch';
        }
        public function actionGetgroupbranch()
        {
            $group_id=$_REQUEST['group_name'];
            $currentusertype=$this->getTypeid(Yii::app()->user->id);
            
            $claim_id=$_REQUEST['claim_id'];
            $q=new CDbCriteria();
            $cla=new Claim();
            $q->select='t.v_zip';
            $q->compare('t.id',$claim_id);
            $cmm=$cla->find($q);
            //var_dump($cmm);
            $branch_arr=array();
            if($cmm!=null)
            {
                        $br=new Branch();
                       $q=new CDbCriteria();
                       $q->select='t.id,t.branch_name,t.zip';
                       $q->join='left join company on company.id=t.company_id';
                       $ctype=0;
                       $bt="";
                       if($group_id=='Independent Appraisal Company Branch')
                       {
                           $ctype=7;
                           $bt="Standard";
                       }
                          if($group_id=='Independent Appraisal Company Call Center')
                       {
                           $ctype=7;
                           $bt="Call Center";
                       }
                       if($group_id=='Body Shop Branch')
                           $ctype=3;
                       if($group_id=='Third Party Administrator Branch')
                           $ctype=4;
                       if($currentusertype>=1 && $currentusertype<=5)
                            $q->compare('company.type_id',$ctype);
                       else
                       {
                           $usr=new User();
                           $c=new CDbCriteria();
                           $c->select='t.company_id';
                          
                            if($currentusertype==12 || $currentusertype==21 || $currentusertype==29 || $currentusertype==37 || $currentusertype==46 || $currentusertype<=5 || $currentusertype==50)
                            {       
                                $c->compare('t.id',Yii::app()->user->id);
                                 $bch=$usr->find($c);
                                 $currentusertype_company=Usertype::model()->findByPk($currentusertype);
                                 if($currentusertype_company->companytype==$ctype)
                                    $q->compare('t.company_id',$bch->company_id);
                            }
                            else
                            {       $c->join='left join user on user.branch_id=t.id';
                                    $c->compare('t.id',Yii::app()->user->id);
                                    $bch=$br->find($c);
                                      
                                    $q->compare('t.company_id',$bch->company_id);
                            }
                           $q->compare('company.type_id',$ctype);
                         if( $group_id=='Third Party Administrator Branch')
                         {
                             if($_POST['state']!="")
                                 $q->compare('t.state_id',$_POST['state']);
                         }
                           if($bt!="")
                           {  
                               if($bt=="Standard")
                               {
                                  $q->condition.=' and (t.branch_type="'.$bt.'" or t.branch_type="")';  
                               }
                               else
                               $q->compare('t.branch_type',$bt);
                           
                           }
                       }
                       $brch=$br->findAll($q);
                 //  var_dump($q);
               $vehicle_zip= $cmm->v_zip;
                 $zip = new ZipLocator();
                //
                 $app_way=new Assignappway;
                 $q=new CDbCriteria;
                 $q->compare('t.user_id',Yii::app()->user->id);
                 $way=$app_way->find($q);
                 if($way->way=="ALL" && $currentusertype==12)
                 {
                     if($brch!=null){
                         $i=0;
                      foreach($brch as $zipcode)
                       {
                          
                           $temp=array($i=>array('id'=>$zipcode->id,'name'=>$zipcode->branch_name));
                                    $branch_arr=  array_merge($temp,$branch_arr);
                                    
                                    $i++;
                                     
                       }
                     }
                 }else {
                if($brch!=null)
                {
                    if( $group_id=='Third Party Administrator Branch')
                    {
                        $i=0;
                       foreach($brch as $zipcode)
                       {
                           $temp=array($i=>array('id'=>$zipcode->id,'name'=>$zipcode->branch_name));
                                    $branch_arr=  array_merge($temp,$branch_arr);
                                    $i++;
                       }
                        
                    }
                    else
                    {
                    $i=0;
                    foreach($brch as $zipcode)
                    {
                       //$zips = $zip->inradius($vehicle_zip, 1,$zipcode->zip);
                       $zips=$zip->getzipcodes($zipcode->id);
                      // var_dump($zips);
                       if($zips!=null)
                     {
                           foreach($zips as $z)
                           {
                              // var_dump($z);
                              //  echo $z['id'];
                               if($z['fromzip']<$z['tozip'])
                               {
                                   $frm=$z['fromzip'];
                                   $to=$z['tozip'];
                               }
                                else {
                                    $frm=$z['tozip'];
                                    $to=$z['fromzip'];
                                }
                               // echo $z->fromzip."-".$to;
                               if($z['zipcode']==$vehicle_zip || ($frm<=$vehicle_zip && $to>=$vehicle_zip) )
                               {
                                    $temp=array($i=>array('id'=>$zipcode->id,'name'=>$zipcode->branch_name));
                                    $branch_arr=  array_merge($temp,$branch_arr);
                                    $i++;
                               }
                           } 
                     }
                    }
                }
                 }
                 
               }
               // var_dump($branch_arr);
                ///echo $zip->distance('92711', '92710');
                //var_export($zips);
            }
            /*
            {}*/
             echo CJSON::encode($branch_arr);
            Yii::app()->end();
            
        }
        public function actiongetStateBranch()
        {
            $br=new Branch;
            $q=new CDbCriteria;
            $q->join=" left join company on company.id=t.company_id";
            if($_POST['tstate']!="")
            $q->condition=" t.state_id=".$_POST['tstate']." and company.type_id=4";
            else
                $q->condition=" company.type_id=4";
            $data=$br->findAll($q);
            $data=CHtml::listData($data,'id','branch_name');                
                echo CHtml::tag('option',
                               array('value'=>''),'Select',true);
				if($data!="")
				{   
					foreach($data as $value=>$name)
					{
						echo CHtml::tag('option',
						array('value'=>$value),CHtml::encode($name),true);
					}
				}
        }

        public function actionGetgroupusers()
        {
           $group_id=$_REQUEST['group_name'];//GroupTable::model()->getGroupId($_REQUEST['group_name']);
              $currentusertype=$this->getTypeid(Yii::app()->user->id);
            $utypes=  GroupTable::model()->getGroupUsers($group_id,$currentusertype);
            $arr=array();
             $j=0;
             //var_dump($utypes);
            foreach($utypes as $ut)
            {
                $typeid=$ut->assigned_to;
           
            $rs=User::model()->findByPk(Yii::app()->user->id);
           $branch_id=$rs['branch_id'];
            $mode=new User();
            $q=new CDbCriteria();
            $q->select='t.id,t.first_name,t.last_name';
            $q->join=" left join authassignment on authassignment.userid=t.id";
            if($currentusertype>=1 && $currentusertype<=5)//Cfs Users
            {
                $q->compare('authassignment.itemname',$typeid);
            }
            else
            {
                $q->compare('authassignment.itemname',$typeid);
                $q->compare('t.branch_id',$branch_id);
            }
           //var_dump($q);
            $result=$mode->findAll($q);
            
            $j++;
                if($result!=null)
                {
                    foreach($result as $r)
                    {$temp=array();
                        $temp=array($j=>array('id'=>$r->id,'first_name'=>$r->first_name,'last_name'=>$r->last_name));
                      //  var_dump($temp);
                        $arr= array_merge($arr,$temp);
                      // var_dump($arr);
                        $j++;
                    }
                }
           }
            echo CJSON::encode($arr);
            Yii::app()->end();
        }

        public function actionGetusers()
        {
            $typeid=$_REQUEST['typeid'];
             $currentusertype=$this->getTypeid(Yii::app()->user->id);
            $rs=User::model()->findByPk(Yii::app()->user->id);
            if($currentusertype==12 || $currentusertype==21 || $currentusertype==29 || $currentusertype==37 || $currentusertype<=5 || $currentusertype==50)
                $cmp_id=$rs->company_id;
              if($currentusertype==21 && ($typeid==18 || $typeid==24))
                  $rs=Claim::model()->findByPk($_REQUEST['claim_id']);
                  
                $branch_id=$rs->branch_id;
           $claim_id=$_REQUEST['claim_id'];
            $q=new CDbCriteria();
            $cla=new Claim();
            $q->select='t.v_zip';
            $q->compare('t.id',$claim_id);
            $cmm=$cla->find($q);
            $mode=new User();
            $q=new CDbCriteria();
            $q->select='t.id,t.first_name,t.last_name,t.branch_id';
            $q->join=" left join authassignment on authassignment.userid=t.id";
            if( $currentusertype<=5 ||  $currentusertype==50)//Cfs Users
            {
                $q->compare('authassignment.itemname',$typeid);
            }
            else
            {
                
                $q->compare('authassignment.itemname',$typeid);
                if($currentusertype==12 || $currentusertype==21 || $currentusertype==29 || $currentusertype==37 )
                {   if($currentusertype==21 && ($typeid!=18 && $typeid!=24))
                    
                      $q->compare('t.company_id',$cmp_id);
                    else if($currentusertype==21 && ($typeid==18 || $typeid==24))
                    $q->compare('t.branch_id',$branch_id);
                    else 
                        $q->compare('t.company_id',$cmp_id);
                    
                }
                else
                    $q->compare('t.branch_id',$branch_id);
            }
                $result=$mode->findAll($q);
               // var_dump($q);
                $assp=new Assignappway;
                $q=new CDbCriteria;
                $q->compare('t.user_id',Yii::app()->user->id);
                $asp=$assp->find($q);
                $way="ALL";
               if($asp!=null)
                $way=$asp->way ;
                
           // var_dump($q);
           
            if(($typeid==50 || $typeid==7 || $typeid==16 || $typeid==18) && $way=="ZIP"  ) //|| ($currentusertype>=1 && $currentusertype<=5)  )//CFS APPRAISER and for global user according to zip code
            {
              
                $vehicle_zip= $cmm->v_zip;
                 $zip = new ZipLocator();
                  
                if($result!=null)
                { $arr=array();
                    $i=0;
                    foreach($result as $rs)
                    {
                        if($rs->branch_id!='')
                        {  
                            $zipcode=  Branch::model()->findByPk($rs->branch_id);
                           // var_dump($zipcode);
                            //echo "<br/>";
                           // echo $zipcode->zip;
                                $zips = $zip->getzipcodes($rs->branch_id);//($vehicle_zip, 1,$zipcode->zip);
                             //   var_dump($zips);
                                
                                if($zips!=null)
                                {
                                    foreach($zips as $z)
                                    {
                                        if($z->fromzip<$z->tozip)
                               {
                                   $frm=$z->fromzip;
                                   $to=$z->tozip;
                               }
                                else {
                                    $frm=$z->tozip;
                                    $to=$z->fromzip;
                                }
                                        if($z->zipcode==$vehicle_zip || ($frm<=$vehicle_zip && $to>=$vehicle_zip))
                                        
                                        {
                                                $temp=array($i=>array('id'=>$rs->id,'first_name'=>$rs->first_name,'last_name'=>$rs->last_name));
                                                $arr= array_merge($temp,$arr);
                                                $i++;
                                        }
                                    }
                                }
                        }
                    }
                }
                
            }
 else {
            $arr=array();
            $j=0;
            foreach($result as $r)
            {$temp=array();
                $temp=array($j=>array('id'=>$r->id,'first_name'=>$r->first_name,'last_name'=>$r->last_name));
               
                $arr= array_merge($temp,$arr);
                // var_dump($arr);
        $j++;
            }
 }
            echo CJSON::encode($arr);
            Yii::app()->end();
        }

        public function actionDashboard(){
            $this->layout ="";
           // echo date('Y-m-d');
           $this->render('dashboard');
        }
       
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
        function checkAuth($id){
            $by_user=$this->loadModel($id);
                 $cu_user=$this->loadModel(Yii::app()->user->id);
                $by_utype=UserController::getTypeid($id);
                $utype=UserController::getTypeid(Yii::app()->user->id);
                 
             if($utype!=12 && $utype!=21 && $utype!=29 && $utype!=37 )
                                 {
                                     if($by_utype!=12 && $by_utype!=21 && $by_utype!=29 && $by_utype!=37 )
                                     {
                                            if($by_user->branch_id==$cu_user->branch_id)
                                                  $bool=true;
                                            else 
                                                $bool=false;
                                     }
                                     else
                                         if($by_user->company_id==$cu_user->branch->company_id )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                 }
                                 else {
                                     if($by_utype!=12 && $by_utype!=21 && $by_utype!=29 && $by_utype!=37 )
                                     {
                                         if($by_user->branch->company_id==$cu_user->company_id  )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                     }
                                     else
                                     {
                                         if($by_user->branch->company_id==$cu_user->branch->company_id  )
                                              $bool=true;
                                         else 
                                                $bool=false;
                                     }
                                 }
                                 return $bool;
                    
        }
	public function actionView($id)
	{
                $model=$this->loadModel($id);
                
                $branch=Branch::model()->findbypk($model->branch_id);
                $by_utype=UserController::getTypeid($id);
                $utype=UserController::getTypeid(Yii::app()->user->id);
                $bool=true;
                if($utype>5 && $utype!=50)
                {
                    if($utype==$by_utype)
                        $bool=false;
                    else
                    {
                       $bool= $this->checkAuth($id);
                    }
                }
		$this->render('view',array(
			'model'=>$model,
                        'branch'=>$branch,
                        'type_id'=>$by_utype,
                        'bool'=> $bool,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
         public function actionBottomCreate()
        {
             $this->redirect(array('create'));
        }
         public function actionTopCreate()
        {
             $this->redirect(array('create'));
        }
        public function actionUserchek()
        {
            
            $model=new User;
             $c = new CDbCriteria;
             $c->compare('t.username',$_POST['username']);
             $m=$model->find($c);
            if($m==null)
                echo 'Yes';
            else
               echo 'No'; 
        }
	public function actionCreate()
	{
		$model=new User;
		$modeladd=new Useraddress;
                 $assign=new Authassignment;
                  
		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);
                // var_dump($_POST['ajax']);
                 
              if(!isset($_POST['ajax']))
              {  
		if(isset($_POST['User']))
		{
			$model->attributes=$_POST['User'];
                        $modeladd->attributes=$_POST['Useraddress'];
                                        
                        if($_POST['superadmin']==1)
                            $model->company_id=9;
                        
                        $model->is_superadmin =$_POST['superadmin'];
                        $utype=$_POST['Authassignment']['itemname'];
                         $valid_array=array('email, username, password, first_name, last_name,branch_id');
                                        if($utype==12 || $utype==21 || $utype==29 || $utype==37 || $utype==46)
                                        {     $model->company_id=$_POST['Company']['id'];
                                                 //$model->branch_id=0;
                                                /* $b=new Branch;
                                                 $q=new CDbCriteria;
                                                 $q->compare('t.company_id',$_POST['Company']['id']);
                                                 $q->limit="1";
                                                 $br=$b->find($q);
                                                 $model->branch_id=$br->id;*/
                                                 $valid_array=array('email, username, password, first_name, last_name');
                                        }
                            if($utype<=5 || $utype==50)
                                $model->company_id=9;
                            //$assign=new Authassignment;
                                        $assign->attributes=$_POST['Authassignment'];
                            $arr=array('itemname');
                            $valid=$model->validate() ;
                             $valid=$valid && $assign->validate($arr) ;
                          // var_dump($valid);
                            
                             
			if($valid )
			{ 
				if($model->save())
				{
					
					$modeladd->user_id=$model->id;
					
					$modeladd->save();
                                        
                                        if($_POST['superadmin']==1)
                                            $assign->itemname=2;//'CFS Super Global Admin';
                                        $assign->userid=$model->id;
                                        $assign->save();
					$this->redirect(array('view','id'=>$model->id));
				}
			}
		}
              }
             $type_id=  UserController::getTypeid(Yii::app()->user->id);
                $type=new Usertype;
                 $q=new CDbCriteria;
                  if($type_id>=18 && $type_id<=26)
                      $q->condition=" t.id>=18 and t.id<=26";
                  else if($type_id>=7 && $type_id<=17)
                      $q->condition=" t.id>=7 and t.id<=17";
                  if($type_id==8)
                      $q->condition=" t.id>=7 and t.id<=11";
                  if($type_id==13)
                      $q->condition=" t.id>=13 and t.id<=17";
                  if($type_id==29)
                       $q->condition=" t.id>=27 and t.id<=32";
                  if($type_id==30)
                       $q->condition=" t.id>=27 and t.id<=32 and t.id!=29";
                   if($type_id==35)
                       $q->condition=" t.id>=33 and t.id<=44 and t.id!=37";
                    if($type_id==37)
                       $q->condition=" t.id>=33 and t.id<=44";
                    if($type_id==47)
                       $q->condition=" t.id>=47 and t.id<=49";
                    if($type_id==46)
                       $q->condition=" t.id>=46 and t.id<=49";
               // $q->compare('t.type','2');
                if($type_id==22)
                    $q->condition.=" and t.id<>21";
                if($type_id>5 && $type_id!=50)
                    $q->condition.=" and t.id<>".$type_id;
                $q->order="t.type";
                $types=$type->findAll($q,array('id','type'));
		//$type=new Usertype;
		//$types=$type->findAll('',array('id','type'));
		$cat=new Usercategory;
		$categories=$cat->findAll('',array('id','category'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$branch=new Branch;
		$branches=$branch->findAll('',array('id','branch_name'));
                if($type_id==12 || $type_id==21 || $type_id==29 || $type_id==37 || $type_id==46)
                {
                    $q=new CDbCriteria;
                    $usrs=  $this->getUserDetail(Yii::app()->user->id);
                   // echo $usrs->company->id;
                    $q->compare('t.company_id',$usrs->company->id);
                    $branches=$branch->findAll($q,array('id','branch_name'));
                }
                
                 $cmp=new Company;
                $cmptype=new Companytype;
                $q=new CDbCriteria;
                $q->condition="t.id<=7 and t.id!=2 and t.id!=6 ";
                if($type_id<=5 || $type_id==50)
                      $q->condition="t.id<=7 and t.id!=2 ";
                $q->order="t.type";
                //var_dump($q);
		$cmptypes=$cmptype->findAll($q,array('id','type'));
		$companies=$cmp->findAll('', array('id','name'));
                 
		$this->render('create',array(
			'model'=>$model,
			'types'=>$types,
			'modeladd'=>$modeladd,
			'states'=>$states,
			'branches'=>$branches,
			'categories'=>$categories,
                        'assign'=>$assign,
                        'cmptypes'=>$cmptypes,
                        'companies'=>$companies,
                         'cmp'=>$cmp,
                         'branch'=>$branch,
		));
	}
        public function actionCreateGlobalAdmin()
	{
		$model=new User;
		$modeladd=new Useraddress;
		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);
              if(!isset($_POST['ajax']))
              {  
		if(isset($_POST['User']))
		{
			$model->attributes=$_POST['User'];
                         $model->branch_id=1;
                      //  if($_POST['User']['is_superadmin']==1)
                           
                        //$model->is_superadmin =$_POST['superadmin'];
			if($model->validate())
			{
				if($model->save())
				{
					$modeladd->attributes=$_POST['Useraddress'];
					$modeladd->user_id=$model->id;
					
					$modeladd->save();
                                        $assign=new Authassignment;
                                        $assign->attributes=$_POST['Authassignment'];
                                        if($_POST['User']['is_superadmin']==1)
                                            $assign->itemname=2;//'CFS Super Global Admin';
                                        $assign->userid=$model->id;
                                        $assign->save();
					$this->redirect(array('admin','id'=>$model->id));
				}
			}
		}
              }
                $type=new Usertype;
               // $q=new CDbCriteria;
               // $q->compare('t.type','2');
                $types=$type->findAll('',array('id','type'));
		//$type=new Usertype;
		//$types=$type->findAll('',array('id','type'));
		$cat=new Usercategory;
		$categories=$cat->findAll('',array('id','category'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$branch=new Branch;
		$branches=$branch->findAll('',array('id','branch_name'));
                 $assign=new Authassignment;
                 $cmp=new Company;
                $cmptype=new Companytype;
		$cmptypes=$cmptype->findAll('',array('id','type'));
		$companies=$cmp->findAll('', array('id','name'));
                 
		$this->render('create_global_admin',array(
			'model'=>$model,
			'types'=>$types,
			'modeladd'=>$modeladd,
			'states'=>$states,
			'branches'=>$branches,
			'categories'=>$categories,
                        'assign'=>$assign,
                        'cmptypes'=>$cmptypes,
                        'companies'=>$companies,
                         'cmp'=>$cmp,
		));
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
            if($id!=9)
            {
		$model=$this->loadModel($id);
                        $modeadd=new Useraddress;
                         $c = new CDbCriteria;
                         $c->compare('t.user_id',$id);
                        $modeladd=$modeadd->find($c);
		// Uncomment the following line if AJAX validation is needed
		 $this->performAjaxValidation($model);
                  if(!isset($_POST['ajax']))
              {
		if(isset($_POST['User']))
		{
			$model->attributes=$_POST['User'];
                         if($_POST['superadmin']==1)
                            $model->branch_id=1;
                        $model->is_superadmin =$_POST['superadmin'];
			if($model->save())
                        {
                            Useraddress::model()->updateAll(array
                            ('address1'=>$_POST['Useraddress']['address1'],
                             'address2'=>$_POST['Useraddress']['address2'],
                             'city'=>$_POST['Useraddress']['city'],
                              'state_id'=>$_POST['Useraddress']['state_id'],
                              
                                'zip'=>$_POST['Useraddress']['zip']), 'user_id='.$model->id) ;
            
                             if($_POST['superadmin']==1)
                                            $itemname=2;//'CFS Super Global Admin';
                                        else {
                                            $itemname=$_POST['Authassignment']['itemname'];
                                        }
                            Authassignment::model()->updateAll(array
                            ('itemname'=>$itemname
                             ), 'userid='.$model->id) ;
            
                                     
				$this->redirect(array('view','id'=>$model->id));
                        }
		}
              }
               $assgn=new Authassignment;
                  $c = new CDbCriteria;
                   $c->compare('t.userid',$id);
                   $assign=$assgn->find($c);
                 $type_id=  UserController::getTypeid(Yii::app()->user->id);
                  if($type_id<=5 || $type_id==50)
                    $type_id=$assign->itemname;
                $type=new Usertype;
                 $q=new CDbCriteria;
                  if($type_id>=18 && $type_id<=26)
                      $q->condition=" t.id>=18 and t.id<=26";
                  else if($type_id>=7 && $type_id<=17)
                      $q->condition=" t.id>=7 and t.id<=17";
                  if($type_id==8)
                      $q->condition=" t.id>=7 and t.id<=11";
                  if($type_id==13)
                      $q->condition=" t.id>=13 and t.id<=17";
                  if($type_id==29)
                       $q->condition=" t.id>=27 and t.id<=32";
                  if($type_id==30)
                       $q->condition=" t.id>=27 and t.id<=32 and t.id!=29";
                   if($type_id==35)
                       $q->condition=" t.id>=33 and t.id<=44 and t.id!=37";
                    if($type_id==37)
                       $q->condition=" t.id>=33 and t.id<=44";
                    if($type_id==47)
                       $q->condition=" t.id>=47 and t.id<=49";
                    if($type_id==46)
                       $q->condition=" t.id>=46 and t.id<=49";
               // $q->compare('t.type','2');
                if($type_id==22)
                    $q->condition.=" and t.id<>21";
               
                $q->order="t.type";
                
                $types=$type->findAll($q,array('id','type'));
		//$type=new Usertype;
		//$types=$type->findAll('',array('id','type'));
		$cat=new Usercategory;
		$categories=$cat->findAll('',array('id','category'));
		$state=new State;
		$states=$state->findAll('',array('id','name'));
		$branch=new Branch;
                 $c = new CDbCriteria;
				$c->select='t.id,t.branch_name';
                $c->join = ' left join company on company.id=t.company_id left join companytype on companytype.id=company.type_id ';
                $c->compare('company.type_id',$model->branch->company->companytypes->id); 
                $c->order="t.branch_name";
		$branches=$branch->findAll($c,array('id','branch_name'));
                
                 $cp=new Company;
                 $c = new CDbCriteria;
                 $c->join="left join branch on branch.company_id=t.id";
                 $c->compare('branch.id',$model->branch->company->id);
                 $cmp=$cp->find($c);
                 $companies=$cmp->findAll($c, array('id','name'));
                $cmptype=new Companytype;
                
		 $q=new CDbCriteria;
                $q->condition="t.id<=7 and t.id!=2 and t.id!=6 ";
                $q->order="t.type";
		$cmptypes=$cmptype->findAll($q,array('id','type'));
                
                 
                $by_utype=UserController::getTypeid($id);
                $utype=UserController::getTypeid(Yii::app()->user->id);
		$bool=true;
                if($utype>5 && $utype!=50)
                {
                    if($utype==$by_utype)
                        $bool=false;
                    else
                    {
                       $bool= $this->checkAuth($id);
                    }
                }
                 
		$this->render('update',array(
			'model'=>$model,
                    'types'=>$types,
			'modeladd'=>$modeladd,
			'states'=>$states,
			'branches'=>$branches,
			'categories'=>$categories,
                        'assign'=>$assign,
                        'cmptypes'=>$cmptypes,
                        'companies'=>$companies,
                         'cmp'=>$cmp,
                         'bool'=>$bool,
		));
            }
	}




        public function actionUserinfo()
        { 
            $id=Yii::app()->user->id;
            $model=$this->loadModel($id);
            $this->performAjaxValidation($model);
              $modeadd=new Useraddress;
                $c = new CDbCriteria;
                $c->compare('t.user_id',Yii::app()->user->id);
               $modeladd=$modeadd->find($c);
                 $state=new State;
                 $q=new CDbCriteria;
                 $q->order='name ASC';
		$states=$state->findAll($q,array('id','name'));
                $country=new Country;
                 $q=new CDbCriteria;
                 $q->order='name ASC';
		$countries=$country->findAll($q,array('id','name'));
           // echo "12";
           if(!isset($_POST['ajax']))
              {
                //
           if(isset($_POST['User']) && isset($_POST['ChangePassword']))
           {
               
                $validationParams = array('User[oldpassword]','User[password]', 'User[password2]');
                 
                    $user = User::model()->findByPk(Yii::app()->user->id);
 //  echo $_POST['User']['password'];
                if ($user->password != $_POST['User']['oldpassword'])
                        $model->addError('oldpassword', 'Old password is incorrect.');
                    else {
                          if ($model->validate($validationParams)  )
                          {
                            USer::model()->updateAll(array
                                          ('password'=>$_POST['User']['password']), 'id='.Yii::app()->user->id) ;
            
                          Yii::app()->user->setFlash('success','Password has been changed successfully');
                          }
                          }    
                    }
                    else if(isset($_POST['User']) && isset($_POST['edituser']))
                    {
                         $validationParams = array('User[first_name]','User[last_name]', 'User[username],User[email]');
                         if ($model->validate($validationParams)  )
                         {  
                              USer::model()->updateAll(array
                                          ('first_name'=>$_POST['User']['first_name'],
                                  
                                  'last_name'=>$_POST['User']['last_name'],
                                  'username'=>$_POST['User']['username'],
                                  'email'=>$_POST['User']['email'],
                                  'homephone'=>$_POST['User']['homephone'],
                                  'cellphone'=>$_POST['User']['cellphone'],
                                   'workphone'=>$_POST['User']['workphone'],
                                  
                                  ),
                                      
                                      'id='.Yii::app()->user->id) ;
            
                            Useraddress::model()->updateAll(array
                            ('address1'=>$_POST['Useraddress']['address1'],
                             'address2'=>$_POST['Useraddress']['address2'],
                             'city'=>$_POST['Useraddress']['city'],
                             'state_id'=>$_POST['Useraddress']['state_id'],
                             'country_id'=>$_POST['Useraddress']['country_id'],
                             'office_fax'=>$_POST['Useraddress']['office_fax'],
                              'home_fax'=>$_POST['Useraddress']['home_fax'],
                                'zip'=>$_POST['Useraddress']['zip']), 'user_id='.$id) ;
            
                             Yii::app()->user->setFlash('success','User Info has been changed successfully');
                         
                              $this->redirect(array('userinfo'));
            
                         }
                    }
              
              
           }
              
            $this->render('edituserinfo',array(
			'model'=>$model,
                        'states'=>$states,
                        'countries'=>$countries,
                        'modeladd'=>$modeladd,
                    ));
            
        }
        public static function getTypeid($id){
            $er = Rights::getAssignedRoles($id);
            $rt = '';
            foreach($er as $e){
               
               $m=  Usertype::model()->findByPK($e->name);
                $rt = $m->id;
            }
            return $rt;
        } 
        public static function getMe($id){
            $er = Rights::getAssignedRoles($id);
            $rt = '';
            foreach($er as $e){
               
               $m=  Usertype::model()->findByPK($e->name);
                $rt = $m->type;
            }
            return $rt;
        } 
        public static function getUserDetail($id)
        {
            
           $model=User::model()->findByPk($id);
            return $model;
        }
        public function actionTopAdministration()
        {
            $this->redirect(array('administration'));
        }
          public function actionBottomAdministration()
        {
            $this->redirect(array('administration'));
        }
       /* public function actionAdministration()
        {
            $id=Yii::app()->user->id;
            $er = Rights::getAssignedRoles($id);
             foreach($er as $e){
                $type= $e->name;
                //$rt = $m->type;
            }
            $model=new Administration;
            $c=new CDbCriteria;
            $c->join=" left join administrationpermission On administrationpermission.admin_linkid=t.id";
            $c->compare('administrationpermission.usertype_id',$type);
            $list=$model->findAll($c);
              //$this->redirect(Yii::app()->createUrl('/abilitytab/create'));
            $this->render('administration',array(
                'list'=>$list,
            )
		);
        }*/
               public function getlink($tid)
		{
		$id=Yii::app()->user->id;
            $er = Rights::getAssignedRoles($id);
             foreach($er as $e){
                $type= $e->name;
                //$rt = $m->type;
            }
              $model=new Administration;
            $c=new CDbCriteria;
            $c->join=" left join administrationpermission On administrationpermission.admin_linkid=t.id";
            $c->condition='administrationpermission.usertype_id='.$type." and t.title=".$tid;
			//$c->compare('title_relation.title_id',$tid);
			//var_dump($c);
			//die();
			$rs=$model->findAll($c);
			
			return $rs;
		}
        public function actionAdministration()
        {
            $id=Yii::app()->user->id;
            $er = Rights::getAssignedRoles($id);
             foreach($er as $e){
                $type= $e->name;
                //$rt = $m->type;
            }
            $model=new Administration;
            $c=new CDbCriteria;
            $c->join=" left join administrationpermission On administrationpermission.admin_linkid=t.id";
            $c->compare('administrationpermission.usertype_id',$type);
			
			$tit=new TitleRelation;
			$d= new CDbCriteria;
			$d->join=" left join admin_title On admin_title.id=t.title_id";
			$d->compare('t.usertype_id',$type);
            $f=$tit->findAll($d);
			//$f->title->title;
			
            $list=$model->findAll($c);
              //$this->redirect(Yii::app()->createUrl('/abilitytab/create'));
            $this->render('administration',array(
                'list'=>$list,'f'=>$f,
            )
		);
        } 
        /**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
            if($id!=9)
            {
		$this->loadModel($id)->delete();
                 Authassignment::model()->deleteAll('userid',$id);
		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
            }
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('User');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new User('search');
                $model->unsetAttributes();  // clear any default values
                
                 
		if(isset($_GET['User']))
                {	
                    $model->attributes=$_GET['User'];
                        
                }
              
                 $type=new Usertype;
                $q=new CDbCriteria;
               $q->condition='t.id<=50';
                $q->order="t.type ASC";
                $types=$type->findAll($q);
		$this->render('admin',array(
			'model'=>$model,
                        'types'=>$types,
                        
		));
	}
        
        public function actionGlobaladmin()
	{
		$model=new User('search');
                 $q=new CDbCriteria;
                 $q->join="left join authassignment on authassignment.userid=t.id";
                $q->compare('authassignment.itemname','=2',true,'or');
                 $q->compare('authassignment.itemname','=1',true,'OR');
               //  var_dump($q);
                $row=$model->findAll($q);
		//$model->unsetAttributes();  // clear any default values
                
                 
		if(isset($_GET['User']))
                {	
                    $model->attributes=$_GET['User'];
                        
                }
              
                 $type=new Authitem;
                $q=new CDbCriteria;
                $q->compare('t.type','2');
                $types=$type->findAll($q);
		$this->render('adminglobal',array(
			'model'=>$model,
                        'row'=>$row,
                        
		));
	}
         public function actionGlobalappraiser()
	{
		$model=new User('search');
                 $q=new CDbCriteria;
                 $q->join="left join authassignment on authassignment.userid=t.id ";
                $q->compare('authassignment.itemname','=50',true,'or');
                 $q->compare('authassignment.itemname','=7',true,'or');
                  $q->compare('authassignment.itemname','=16',true,'or');
                   $q->compare('authassignment.itemname','=18',true,'or');
                // $q->compare('authassignment.itemname','=1',true,'OR');
                // var_dump($q);
                $row=$model->findAll($q);
		//$model->unsetAttributes();  // clear any default values
                
                 
		if(isset($_GET['User']))
                {	
                    $model->attributes=$_GET['User'];
                        
                }
              
                 
		$this->render('appraiserlist',array(
			'model'=>$model,
                        'row'=>$row,
                        
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return User the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=User::model()->findByPk($id);
                
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param User $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='user-form')
		{      
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        
        public function actionEditBranchUsers()
        {
            $model=User::model()->findByPk(Yii::app()->user->id);
             $utype=$this->getTypeid(Yii::app()->user->id);
            
            $bu=new User;
             if($utype==12 || $utype==21 || $utype==29 || $utype==37 || $utype==46)
             {
                  $q=new CDbCriteria;
                  $q->join=" left join branch on branch.company_id=t.branch_id";
                  $q->compare('branch.company_id',$model->company_id);
             }
             else
             {
            $q=new CDbCriteria;
            $q->compare('t.branch_id',$model->branch_id);
             }
            /// var_dump($q);
              $buser=new CActiveDataProvider('User', array(
			'criteria'=>$q,
		));
               $zip = new ZipLocator();
               $red=new Setredius;
               $q=new CDbCriteria;
               $q->compare('t.user_id',Yii::app()->user->id);
               $r=$red->find($q);
               if($r!=null)
                   $redius=$r->redius;
               else
                   $redius=2;
                $zips=array();
               if($utype!=12 && $utype!=21 && $utype!=29 &&  $utype!=37 && $utype!=46)
                     $zips = $zip->getzipcodes($model->branch_id);
             // var_dump($zips);
            
            $this->render('edit_branch_user',array(
			  'model'=>$model,
                           'buser'=>$buser,
                            'zips'=>$zips,
		));
        }
                
}
