<?php

class SetrediusController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
        public function allowedActions() {
            return 'getzips';
        }

        /**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function actionGetzips()
        {
            $model=new ZipCoverage;
           
             $q=new CDbCriteria;
             $q->compare('t.branch_id', $_POST['ZipCoverage']['branch_id']);
             $zipcs=$model->findAll($q);
                if( count($zipcs)>0)
            { $i=1;
                foreach($zipcs as $z)
                {
                    
                   $j=1;
                   
             $tab.=  '<tr >';
                    $tab.= '<td><input type="hidden" name="id[]" value="'.$z->id.'" id="'.$i.'"-"'.$j.'" /></td>';
                     $j++;
                   $tab.='<td><input type="text" name="zip[]" id="'.$i.'"-"'.$j.'" size="10" maxlength="5" value="'.$z->zipcode.'" class="intonly" /> </td>';
                   $tab.=' <td>&nbsp;</td>';
                     $j++;
                    $tab.='<td><input type="text" name="fromzip[]" id="'.$i.'"-"'.$j.'" size="10" maxlength="5" value="'.$z->fromzip.'" class="intonly" /> </td>'; 
                   $tab.= '<td>-</td>  <td>&nbsp;</td>';
                     $j++;
                    $tab.='<td><input type="text" name="tozip[]" id="'.$i.'"-"'.$j.'" size="10" maxlength="5" value="'.$z->tozip.'" class="intonly tozip" /> '; 
                      $tab.='  <span id="error-"'.$i.'"-"'.$j.'class="errorMessage" style="display:none;"></span></td>';
                    $tab.='</td></tr>';
                    
                
                        $i++;
                 }
               $ii=$i; 
            }
            echo $tab;
        }

        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new ZipCoverage;
                $type_id=  UserController::getTypeid(Yii::app()->user->id);
                $zipcs=array();
                 if($type_id>5 && $type_id!=50)
                {
                   if($type_id!=12 && $type_id!=21 && $type_id!=29 && $type_id!=37 && $type_id!=46)
                   { 
                       $usrs= UserController::getUserDetail(Yii::app()->user->id);
                       $q=new CDbCriteria;
                       
                        $q->compare('t.branch_id',$usrs->branch_id);
                        $zipcs=$model->findAll($q);
                   }
                }
               
                 /*   $q=new CDbCriteria;
                    $q->compare('t.user_id',Yii::app()->user->id);
                    $m=$model->find($q);
                    if($m!=null)
                    {
                        $this->redirect(array('update','id'=>$m->id));
                    }
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Setredius']))
		{
			$model->attributes=$_POST['Setredius'];
                        $model->user_id=Yii::app()->user->id;
			if($model->save())
                        {
                             Yii::app()->user->setFlash('success','Geo Location Radius is Set');
                           
                        }
				//$this->redirect(array('view','id'=>$model->id));
		}*/
                 if(count($_POST['zip'])>0)
                                    {
                                         $i=0;
                                        foreach ($_POST['zip'] as $zc)
                                        {
                                            if($_POST['id'][$i]!="")
                                                $zp=  ZipCoverage::model ()->findByPk($_POST['id'][$i]);
                                            else
                                            $zp=new ZipCoverage;
                                            $zp->branch_id=$_POST['ZipCoverage']['branch_id'];
                                            $zp->zipcode=$zc;
                                             $zp->fromzip=$_POST['fromzip'][$i];
                                              $zp->tozip=$_POST['tozip'][$i];
                                            if($zp->validate())
                                            $zp->save();
                                            $i++;
                                        }
                                        Yii::app()->user->setFlash('success','Zip Coverage Set successfully.');
                                    }
                                     
                 
                 $cmp=new Company;
                $cmptype=new Companytype;
                $q=new CDbCriteria;
                $q->condition="t.id<=7 and t.id!=2 and t.id!=6 ";
                if($type_id<=5 || $type_id==50)
                      $q->condition="t.id<=7 and t.id!=2 ";
                $q->order="t.type";
                //var_dump($q);
		$cmptypes=$cmptype->findAll($q,array('id','type'));
		$companies=$cmp->findAll('', array('id','name'));
                 $branch=new Branch;
		$branches=$branch->findAll('',array('id','branch_name'));
                if($type_id==12 || $type_id==21 || $type_id==29 || $type_id==37 || $type_id==46)
                {
                    $q=new CDbCriteria;
                    $usrs= UserController::getUserDetail(Yii::app()->user->id);
                   // echo $usrs->company->id;
                    $q->compare('t.company_id',$usrs->company->id);
                    $branches=$branch->findAll($q,array('id','branch_name'));
                }
                 $zip=new ZipCoverage;
		$this->render('create',array(
			'model'=>$model,
                        'cmptypes'=>$cmptypes,
                        'cmp'=>$cmp,
                        'branches'=>$branches,
                        'branch'=>$branch,
                        'zip'=>$zip,
                        'zipcs'=>$zipcs,
                        //'companies'=>$companies,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                //var_dump($model);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                if($model->user_id==Yii::app()->user->id)
                {
                    if(isset($_POST['Setredius']))
                    {
                            $model->attributes=$_POST['Setredius'];
                            if($model->save())
                                    Yii::app()->user->setFlash('success','Geo Location Radius is Set');

                    }
                }
		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Setredius');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Setredius('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Setredius']))
			$model->attributes=$_GET['Setredius'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Setredius the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Setredius::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Setredius $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='setredius-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
