<?php

class SalesinvoiceController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
            $mi=new Saleinvoiceitem;
             $q=new CDbCriteria;
             $q->compare('t.saleinvoice_id',$id);
            $mitem=Saleinvoiceitem::model()->findAll($q);
           
             $uid=Yii::app()->user->id;
               $q=new CDbCriteria;
               $q->compare('user.id',$uid);
               $q->select='t.*';
               $q->join="left join branch on t.id=branch.company_id left join user on branch.id=user.branch_id ";
               $mode=new Company;
               $cmp=$mode->find($q);
            //   var_dump($mitem);
		$this->render('view',array(
			'model'=>$this->loadModel($id),
                        'dataProvider'=>$mitem,
                        'cmp'=>$cmp,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Salesinvoice;
                $uid=Yii::app()->user->id;
               $q=new CDbCriteria;
               $q->compare('user.id',$uid);
               $q->select='t.*';
               $q->join="left join branch on t.id=branch.company_id left join user on branch.id=user.branch_id ";
               $mode=new Company;
               $cmp=$mode->find($q);
              $items=new Saleinvoiceitem;
            
               
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Salesinvoice']))
		{
                    $maxInvoiceNumber = Yii::app()->db->createCommand()
                    ->select('max(invoice_no) as max')
                    ->from('salesinvoice')
                    ->queryScalar();
                  $model->invoice_no = $maxInvoiceNumber + 1;
                  if($maxInvoiceNumber==0)
                       $model->invoice_no=1001;
			$model->attributes=$_POST['Salesinvoice'];
			if($model->save())
                        {	
                                $sailsid = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('salesinvoice')
                                ->queryScalar();
                        $size=count($_POST['item']);
                          $i=0;
                          $today=date("Y-m-d H:i:s");
                       
                              
                               
                              
                            for($i=0;$i<$size;$i++)
                            { 
                            $meta=new Saleinvoiceitem; 
                                //echo $key."=".$val;
                                
                                $meta->saleinvoice_id=$sailsid;
                               $meta->item =$_POST['item'][$i];
                              $meta->description = $_POST['description'][$i];
                                    $meta->Quantity = $_POST['Quantity'][$i];
                                    $meta->price = $_POST['price'][$i];
                                    $meta->extprice = $_POST['extprice'][$i];
                                   $meta->created = $today;
                                   $meta->modified=$today;
                                 if($meta->validate())
                                   $meta->save();
                                   //
                                  }
                               $this->redirect(array('view','id'=>$model->id));
                              } 
                              
		}

		$this->render('create',array(
			'model'=>$model,
                        'cmp'=>$cmp,
                        'items'=>$items,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
                     $uid=Yii::app()->user->id;
               $q=new CDbCriteria;
               $q->compare('user.id',$uid);
               $q->select='t.*';
               $q->join="left join branch on t.id=branch.company_id left join user on branch.id=user.branch_id ";
               $mode=new Company;
               $cmp=$mode->find($q);
              $items=new Saleinvoiceitem;
             $q=new CDbCriteria;
                    $q->compare('t.saleinvoice_id',$id);
                   $items=  Saleinvoiceitem::model()->findAll($q);
                   $pp=array();
                  if($items==null)
                      $pp=new Saleinvoiceitem;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Salesinvoice']))
		{
			$model->attributes=$_POST['Salesinvoice'];
			if($model->save())
                        {
                             $size=count($_POST['item']);
                          $i=0;
                          $today=date("Y-m-d H:i:s");
                       
                              
                               
                              
                            for($i=0;$i<$size;$i++)
                            { 
                            $meta=new Saleinvoiceitem; 
                                //echo $key."=".$val;
                                
                                $meta->saleinvoice_id=$model->id;
                               $meta->item =$_POST['item'][$i];
                              $meta->description = $_POST['description'][$i];
                                    $meta->Quantity = $_POST['Quantity'][$i];
                                    $meta->price = $_POST['price'][$i];
                                    $meta->extprice = $_POST['extprice'][$i];
                                   $meta->created = $today;
                                   $meta->modified=$today;
                                 if($meta->validate())
                                 {
                                      if($_POST['id'][$i]!=null)
                                     {
                                        
                                         Saleinvoiceitem::model()->updateAll(array
                                          ('item'=>$_POST['item'][$i],
                                           'description'=>$_POST['description'][$i],
                                            'Quantity'=>$_POST['Quantity'][$i],
                                             'price'=>$_POST['price'][$i],
                                             'extprice'=>$_POST['extprice'][$i],
                                             
                                            'modified'=>$today), 'id='.$_POST['id'][$i]) ;
            
                                     }
                                     else
                                        $meta->save();
                                 }
                                   //
                                  }
				$this->redirect(array('view','id'=>$model->id));
                        }
		}

		$this->render('update',array(
			'model'=>$model,
                        'cmp'=>$cmp,
                        'items'=>$items,
                        'pp'=>$pp,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Salesinvoice');
                $model=new Salesinvoice;
                  $uid=Yii::app()->user->id;
               $q=new CDbCriteria;
               $q->compare('user.id',$uid);
               $q->select='t.*';
               $q->join="left join branch on t.id=branch.company_id left join user on branch.id=user.branch_id ";
               $mode=new Company;
               $cmp=$mode->find($q);
               $criteria=new CDbCriteria;
               $criteria->compare('t.from',$cmp->id);
              $items=new Saleinvoiceitem;
               $model=$model->find($criteria);
              // var_dump($criteria);
               if(count($model)>0)
               {
		$dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
		$this->render('index',array(
			  'dataProvider'=>$dataProvider,
               ));}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Salesinvoice('search');
              
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Salesinvoice']))
			$model->attributes=$_GET['Salesinvoice'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Salesinvoice the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Salesinvoice::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested Invoice does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Salesinvoice $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='salesinvoice-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
