<?php

class MessageinboxController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
        public function allowedActions() {
           return 'GetUid,search,GetMessage,TrashMessage,composemsg';
        }
        public function actionTrashMessage()
        {
            $ids=explode(",",$_REQUEST['id']);
            if($_REQUEST['type']=='trash')
            {  
                $typeid=3;
               // Yii::app()->user->setFlash('success','Message has been sent to Trash');
            }
            else if($_REQUEST['type']=='archive')
            { $typeid=4;
            
           // Yii::app()->user->setFlash('success','Message has been sent to Archive');
            }
            
            $uid=Yii::app()->user->id;
            foreach ($ids as $id) {
                if($id!=""){
                    $rs=Messageinbox::model()->findByPk($id);
                     Messagestatus::model()->updateAll(array('active'=>0),
                                           'by_user='.$uid.' and inbox_id='.$id);

                     $mstatu=new Messagestatus;
                    $mstatu->by_user=$uid;
                    $mstatu->inbox_id=$rs->id;
                    $mstatu->type_id=$typeid; //Sent
                    $mstatu->active=1;
                    $mstatu->save();
                }
            }
            return true;
        }
        public function actionGetMessage()
        {
            $id=$_REQUEST['id'];
           $model=new Messageinbox;
           $sql="select t.*,f.id as frm ,tm.id as trm from messageinbox t"
                   . " left join user f on f.id=t.frommsg left join user tm on tm.id=t.tomsg "
                   . " where t.id=:rid";
           $rid=$id;
               $data= Yii::app()->db->createCommand($sql)->queryAll(true,array(':rid'=>$rid));
 
            //$rs=Messageinbox::model()->findByPk($id);
           // var_dump($rs);
          
             echo CJSON::encode($data);
             //echo CJSON::encode($rs);
            Yii::app()->end();
        }
        public function actionGetUid()
        {
            $model=new User;
            $c=new CDbCriteria;
            $c->compare('t.username',$_POST['username']);
            $mode=$model->find($c);
            //echo $mode->id;
            if($mode!=null)
                echo $mode->id;
           else
               echo 0;
        }
        public function actionSearch()
        {
            
              $model=new Messageinbox('fullsearch');
		$model->unsetAttributes();  // clear any default values
		 $type_id=  UserController::getTypeid(Yii::app()->user->id);
                  $ud= UserController::getUserDetail(Yii::app()->user->id);
                 $ur=new User;
                 $q=new CDbCriteria;
                $q->select=" t.id,CONCAT(t.first_name,' ',t.last_name) as first_name";
                 $q->join=" left join authassignment on authassignment.userid=t.id";
                if($type_id==50 || $type_id==4 || $type_id==3 )
                {
                    $q->condition=" (authassignment.itemname=3 or authassignment.itemname=4)";
                }
                if($type_id>5 && $type_id!=50 && $type_id!=12 && $type_id!=21 && $type_id!=29 && $type_id!=37 && $type_id!=45 && $type_id!=46 )
                {
                    $q->condition=" (t.branch_id=".$ud->branch_id.")";
                    if($type_id==19 || $type_id==27)
                    {
                        $q->join.=" left join adjstersupervising on adjstersupervising.adjuster_id=t.id";
                        $q->condition.="  or	(adjstersupervising.adjuster_id=".Yii::app()->user->id.")";
                    }
                     if($type_id==20 || $type_id==28)
                    {
                        $q->join.=" left join adjstersupervising on adjstersupervising.superwiser_id=t.id";
                        $q->condition.="  or	(adjstersupervising.superwiser_id=".Yii::app()->user->id.")";
                    }
                    if($type_id==8 || $type_id==13 || $type_id==22 || $type_id==30 || $type_id==35 || $type_id==47)
                    {
                        $q->join.=" left join branch on branch.id=t.branch_id";
                         $q->condition.=" or (authassignment.itemname=".$type_id." and  branch.company_id=".$ud->branch->company_id.") or"
                                 . " (authassignment.itemname=12 or authassignment.itemname=21 or authassignment.itemname=29"
                                 . " or authassignment.itemname=37 or authassignment.itemname=46) ";
                    }
                }
                if(  $type_id==12 || $type_id==21 || $type_id==29 || $type_id==37 || $type_id==46)
                {
                      $q->join.=" left join branch on branch.id=t.branch_id";
                      $q->condition=" (branch.company_id=".$ud->company_id.")";
                }
                if($type_id==45)
                {
                     $q->join.=" left join assignee on assignee.assign_to=t.id left join vehicle_owner on vehicle_owner.claim_id=assignee.claim_id";
                     $q->condition=" (assignee.assignee_type=33 or assignee.assignee_type=34 or assignee.assignee_type=35) and "
                             . " (vehicle_owner.user_id= ".Yii::app()->user->id.")";
                             
                }
                //
                if($q->condition!="")
                 $q->condition.=" and t.id!=".Yii::app()->user->id;
                else
                     $q->condition="  t.id!=".Yii::app()->user->id;
                $q->order="t.first_name,t.last_name ASC";
                
		$tousers=$ur->findAll($q);
                 $mod=new Messageinbox('search');
		$mod->unsetAttributes();  // clear any default values
		if(isset($_GET['Messageinbox']))
			$mod->attributes=$_GET['Messageinbox'];
                 
            $this->render('create',array(
			'model'=>$model,
                       'tousers'=>$tousers,
                       'mod'=>$mod,
		));
        }
	public function actionCreate()
	{
		$model=new Messageinbox;
                  $type_id=  UserController::getTypeid(Yii::app()->user->id);
                  $ud= UserController::getUserDetail(Yii::app()->user->id);
                 $ur=new User;
                 $q=new CDbCriteria;
                $q->select=" t.id,CONCAT(t.first_name,' ',t.last_name) as first_name";
                 $q->join=" left join authassignment on authassignment.userid=t.id";
                if($type_id==50 || $type_id==4 || $type_id==3 )
                {
                    $q->condition=" (authassignment.itemname=3 or authassignment.itemname=4)";
                }
                if($type_id>5 && $type_id!=50 && $type_id!=12 && $type_id!=21 && $type_id!=29 && $type_id!=37 && $type_id!=45 && $type_id!=46 )
                {
                    $q->condition=" (t.branch_id=".$ud->branch_id.")";
                    if($type_id==19 || $type_id==27)
                    {
                        $q->join.=" left join adjstersupervising on adjstersupervising.adjuster_id=t.id";
                        $q->condition.="  or	(adjstersupervising.adjuster_id=".Yii::app()->user->id.")";
                    }
                     if($type_id==20 || $type_id==28)
                    {
                        $q->join.=" left join adjstersupervising on adjstersupervising.superwiser_id=t.id";
                        $q->condition.="  or	(adjstersupervising.superwiser_id=".Yii::app()->user->id.")";
                        
                    }
                    if($type_id==8 || $type_id==13 || $type_id==22 || $type_id==30 || $type_id==35 || $type_id==47)
                    {
                        $q->join.=" left join branch on branch.id=t.branch_id";
                         $q->condition.=" or (authassignment.itemname=".$type_id." and  branch.company_id=".$ud->branch->company_id.") or"
                                 . " (authassignment.itemname=12 or authassignment.itemname=21 or authassignment.itemname=29"
                                 . " or authassignment.itemname=37 or authassignment.itemname=46 )";
                    }
                }
                if(  $type_id==12 || $type_id==21 || $type_id==29 || $type_id==37 || $type_id==46)
                {
                      $q->join.=" left join branch on branch.id=t.branch_id";
                      $q->condition=" (branch.company_id=".$ud->company_id.")";
                }
                if($type_id==45)
                {
                     $q->join.=" left join assignee on assignee.assign_to=t.id left join vehicle_owner on vehicle_owner.claim_id=assignee.claim_id";
                     $q->condition=" (assignee.assignee_type=33 or assignee.assignee_type=34 or assignee.assignee_type=35) and "
                             . " (vehicle_owner.user_id= ".Yii::app()->user->id.")";
                             
                }
                if($q->condition!="")
                 $q->condition.=" and t.id!=".Yii::app()->user->id;
                else
                     $q->condition="  t.id!=".Yii::app()->user->id;
                $q->order="t.first_name,t.last_name ASC";
                //var_dump($q);
		$tousers=$ur->findAll($q);
                // Uncomment the following line if AJAX validation is needed
                
		 $this->performAjaxValidation($model);
                if(!isset($_POST['ajax']))
                {
		if(isset($_POST['Messageinbox']))
		{
                   // var_dump($tousers);
			$model->attributes=$_POST['Messageinbox'];
                        /*$mod=new User;
                       $c=new CDbCriteria;
                       $c->compare('t.username',$_POST['touser']);
                       $mode=$mod->find($c);*/
                       //echo $mode->id;
                      // if($mode!=null)
                         //   $model->tomsg= $mode->id;
           
                        $model->tomsg=$_POST['Messageinbox']['tomsg'];
                      // echo $_POST['Messageinbox']['tomsg'];
                       // var_dump($_POST['Messageinbox']);
			if($model->save())
                        {
                            //Messagestatus::model()->updateAll(array('active'=>0),
                             //       'by_user='.$_POST['Messageinbox']['frommsg'].' and inbox_id='.$model->id);
                            $mstatu=new Messagestatus;
                            $mstatu->by_user=$_POST['Messageinbox']['frommsg'];
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=2; //Sent
                            $mstatu->active=1;
                            $mstatu->save();
                            $mstatu=new Messagestatus;
                            $mstatu->by_user=$_POST['Messageinbox']['tomsg'];
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=1; //Inbox
                            $mstatu->active=1;
                            $mstatu->save();
                            Yii::app()->user->setFlash('success','Message has been sent successfully');
                           //$this->redirect(array('view','id'=>$model->id));
                            
                        }
		}
                }
                $mod=new Messageinbox('search');
		$mod->unsetAttributes();  // clear any default values
		if(isset($_GET['Messageinbox']))
			$mod->attributes=$_GET['Messageinbox'];
                 
                    
		$this->render('create',array(
			'model'=>$model,
                        'mod'=>$mod,
                        'tousers'=>$tousers,
		));
	}
        public function actionComposemsg()
        {
            $model=new Messageinbox;
           // var_dump($_POST['Messageinbox']);
            if(isset($_POST['Messageinbox']))
		{  $model=new Messageinbox;
			$model->attributes=$_POST['Messageinbox'];
                        /*$mod=new User;
                       $c=new CDbCriteria;
                       $c->compare('t.username',$_POST['touser']);
                       $mode=$mod->find($c);*/
                       //echo $mode->id;
                      // if($mode!=null)
                         //   $model->tomsg= $mode->id;
                        $model->msgdate=date('Y-m-d H:i:s');
                        $model->frommsg=Yii::app()->user->id;
                        $model->tomsg=$_POST['Messageinbox']['tomsg'];
                      // echo $_POST['Messageinbox']['tomsg'];
                    //    var_dump($model);
			if($model->save())
                        {
                            //Messagestatus::model()->updateAll(array('active'=>0),
                             //       'by_user='.$_POST['Messageinbox']['frommsg'].' and inbox_id='.$model->id);
                            $mstatu=new Messagestatus;
                            $mstatu->by_user=Yii::app()->user->id;;
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=2; //Sent
                            $mstatu->active=1;
                            $mstatu->save();
                            $mstatu=new Messagestatus;
                            $mstatu->by_user=$_POST['Messageinbox']['tomsg'];
                            $mstatu->inbox_id=$model->id;
                            $mstatu->type_id=1; //Inbox
                            $mstatu->active=1;
                            $mstatu->save();
                           // Yii::app()->user->setFlash('success','Message has been sent successfully');
                           //$this->redirect(array('view','id'=>$model->id));
                            
                        }
		}
                return true;
        }

        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
                $this->performAjaxValidation($model);

		if(isset($_POST['Messageinbox']))
		{
			$model->attributes=$_POST['Messageinbox'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Messageinbox');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Messageinbox('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Messageinbox']))
			$model->attributes=$_GET['Messageinbox'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Messageinbox the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Messageinbox::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Messageinbox $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='messageinbox-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
