<?php

class MenuitemController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Menuitem;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Menuitem']))
		{
			$model->attributes=$_POST['Menuitem'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->item_id));
		}
                  $menu=new Menu;
                  $menus=$menu->findAll('',array('menu_id','name'));
                  $item=new Menuitem;
                  $items=$item->findAll('',array('item_id','label'));
                  $auth=new Authitem;
                  $q=new CDbCriteria;
                  $q->compare('t.type',0);
                  $auths=$auth->findAll($q);
		$this->render('create',array(
			'model'=>$model,
                        'auths'=>$auths,
                        'items'=>$items,
                        'menus'=>$menus,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Menuitem']))
		{
			$model->attributes=$_POST['Menuitem'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->item_id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}
        public function actionSetpermission()
        {
            $child=new Authitemchild;
             Authitemchild::model()->deleteAll(array("condition"=>"parent='".$_POST['utype']."' and child='".$_POST['fun']."'"));
            if($_POST['permission']==1)
            {
               $child->parent=$_POST['utype'];
               $child->child=$_POST['fun'];
               $child->save();
               
            }
        }
        public function actionUpdateAjax()
        {
            
           // echo $_POST['Menuitem']['label'];
            $auth=new Authitem;
                  $q=new CDbCriteria;
                  $q->compare('t.type',2);
                  $auths=$auth->findAll($q);
                 
          $tbl=' <table border="2">
              
                    <tr>
                        <td>User Type</td>
                        <td>Permission</td>
                    </tr>';
                          
                        if(count($auths)>0)
                        {
                            $row=0;
                            foreach($auths as $ath)
                            {  
                                $row++;
                                $child=new Authitemchild;
                                 $q=new CDbCriteria;
                                 //$q->select=" count(t.parent) as tot";
                                 $q->condition ='t.parent="'.$ath->name.'" and t.child="'.$_POST['Menuitem']['label'].'"';
                                 $res=$child->findAll($q);
                                 if(count($res)>0)
                                 {
                                    $tot=1;
                                   $t='<option selected="selected"  value="1">Yes</option>';
                                 }
                                else {$t='<option value="1">Yes</option>';}
                            $tbl.='  <tr>
                                   <td>'.$ath->name.'</td>
                                   <td>
                                       <select name="permission" id="'.$row.'" onchange="setpermission(this,\''.$ath->name.'\')">
                                           <option value="0">No</option>';
                                        $tbl.=$t;
                                       $tbl.='<select>                                       
                                       
                                   </td>
                               </tr>';
                            }
                            
                        }
                   
              $tbl.='</table>';
              
              echo $tbl;
                
        }
        public function actionSetvisibility()
        {
           $model=new Menuitem; 
           $fns=$model->findAll('',array('url','label'));
            $auth=new Authitem;
                  $q=new CDbCriteria;
                  $q->compare('t.type',2);
                  $auths=$auth->findAll($q);
           
                  $this->render('setvisibility',array(
			'model'=>$model,
                      'fns'=>$fns,
                      'auths'=>$auths,
                      
		));
           
        }
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Menuitem');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Menuitem('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Menuitem']))
			$model->attributes=$_GET['Menuitem'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Menuitem the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Menuitem::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Menuitem $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='menuitem-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
