<?php

class CompanyformsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
        public function allowedActions() {
            return 'getcompany,getutype,download';
        }

        /**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
            $usertype=  UserController::getTypeid(Yii::app()->user->id);
		$model=new Companyforms;
                $q=new CDbCriteria;
                $q->condition='t.id<5';
                $comptype=  Companytype::model()->findAll($q);
                $q=new CDbCriteria;
                $q->condition='t.type_id<5';
                if($usertype==1 || $usertype==2)
                 $companies=Company::model()->findAll($q);
             else {
                 $cmp=new Company;
                 $c=new CDbCriteria;
                 $c->select='t.id,t.name,t.type_id';
                 $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                 $c->compare('user.id',Yii::app()->user->id);
                 //var_dump($c);
                 $companies=$cmp->findAll($c);
                 //var_dump($companies);
                  $q=new CDbCriteria;
                  $q->condition='t.id='.$companies[0]['type_id'];
                  $comptype=  Companytype::model()->findAll($q);
             }
             $Companyformscompany=new Companyformscompany;
             $cmpformcmptype=new Companyformscompanytype;
             $cmpusertype=new Companyformsusertype;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                   
		if(isset($_POST['Companyforms']))
		{
                    $model->attributes=$_POST['Companyforms'];
                     $formid  = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('company_forms')
                                ->queryScalar();
                         $formid=$formid+1;
                          $imageUploadFile = CUploadedFile::getInstance($model, 'form');
                        if($imageUploadFile !== null){ // only do if file is really uploaded
                          echo  $formFileName = $formid.$imageUploadFile->name;
                            $model->form = $formFileName;
                        } 
                       
			
                        $model->uploaded_by=Yii::app()->user->id;
                         $model->modified=date('Y-m-d H:i:s');
                       //  $model->save();
                         //var_dump($model);
                        if($model->save())
                        {
                            if($imageUploadFile !== null) // validate to save file
                            { $images_path = realpath(Yii::app()->basePath . '/../company_form');
                                   
                              $imageUploadFile->saveAs($images_path . '/' . $model->form);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
                            
                            if($_POST['company_type_id']!=null)
                            {
                                $size=count($_POST['company_type_id']);
                                //var_dump($_POST['company_type_id']);
                                for($i=0;$i<=$size;$i++)
                                {
                                   $cmpformcmptype=new Companyformscompanytype;
                                    $cmpformcmptype->company_form_id=$formid;
                                    $cmpformcmptype->company_type_id=$_POST['company_type_id'][$i];
                                    $cmpformcmptype->save();
                                }
                            }
                             if($_POST['company_id']!=null)
                            {
                                $size=count($_POST['company_id']);
                                foreach($_POST['company_id'] as $company_id)
                                {
                                    $Companyformscompany=new Companyformscompany;
                                    $Companyformscompany->company_form_id=$formid;
                                    $Companyformscompany->company_id=$company_id;
                                    $Companyformscompany->save();
                                }
                            }
                            if($_POST['company_usertype']!=null)
                            {
                                $size=count($_POST['company_usertype']);
                                foreach($_POST['company_usertype'] as $company_usertype)
                                {
                                    $cmpusertype=new Companyformsusertype;
                                    $cmpusertype->company_form_id=$formid;
                                    $cmpusertype->company_usertype=$company_usertype;
                                    $cmpusertype->save();
                                }
                            }
                        }
            // proceed if the images have been set
          
			
				//$this->redirect(array('view','id'=>$model->id));
		}
                 $q=new CDbCriteria;
                $q->condition='t.doc_type Is Null';
                 if($usertype==1 || $usertype==2)
                     $forms=  Companyforms::model()->findAll($q);
                 else {
                        $q=new CDbCriteria;
                        $q->join=' left join company_forms_company on company_forms_company.company_form_id=t.id ';
                        //$q->compare( 'company_forms_company.company_id',$companies[0]['id']);
                         $q->condition='t.doc_type Is Null and company_forms_company.company_id='.$companies[0]['id'];
                        $forms=$model->findAll($q);
                    }
              //  var_dump($q);
		$this->render('create',array(
			'model'=>$model,
                        'comptype'=>$comptype,
                        'companies'=>$companies,
                        'companyformscompany'=>$Companyformscompany,
                        'cmpformcmptype'=>$cmpformcmptype,
                        'cmpusertype'=>$cmpusertype,
                        'forms'=>$forms,
		));
	}
        public function actionEdithow()
	{
            $usertype=  UserController::getTypeid(Yii::app()->user->id);
		$model=new Companyforms;
                $q=new CDbCriteria;
                $q->condition='t.id<5';
                $comptype=  Companytype::model()->findAll($q);
                $q=new CDbCriteria;
                $q->condition='t.type_id<5';
                if($usertype==1 || $usertype==2)
                 $companies=Company::model()->findAll($q);
             else {
                 $cmp=new Company;
                 $c=new CDbCriteria;
                 $c->select='t.id,t.name,t.type_id';
                 $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                 $c->compare('user.id',Yii::app()->user->id);
                 //var_dump($c);
                 $companies=$cmp->findAll($c);
                 //var_dump($companies);
                  $q=new CDbCriteria;
                  $q->condition='t.id='.$companies[0]['type_id'];
                  $comptype=  Companytype::model()->findAll($q);
             }
             $Companyformscompany=new Companyformscompany;
             $cmpformcmptype=new Companyformscompanytype;
             $cmpusertype=new Companyformsusertype;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                   
		if(isset($_POST['Companyforms']))
		{
                    $model->attributes=$_POST['Companyforms'];
                     $formid  = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('company_forms')
                                ->queryScalar();
                         $formid=$formid+1;
                          $imageUploadFile = CUploadedFile::getInstance($model, 'form');
                        if($imageUploadFile !== null){ // only do if file is really uploaded
                          echo  $formFileName = $formid.$imageUploadFile->name;
                            $model->form = $formFileName;
                        } 
                       
			
                        $model->uploaded_by=Yii::app()->user->id;
                         $model->modified=date('Y-m-d H:i:s');
                         $model->doc_type="HowTo";
                         //$model->save();
                         //var_dump($model);
                        if($model->save())
                        {
                            if($imageUploadFile !== null) // validate to save file
                            { $images_path = realpath(Yii::app()->basePath . '/../company_form');
                                   
                              $imageUploadFile->saveAs($images_path . '/' . $model->form);
                               // $imageUploadFile->saveAs(Article::FOLDER_IMAGE.$imageFileName);
                            }
                            
                            if($_POST['company_type_id']!=null)
                            {
                                $size=count($_POST['company_type_id']);
                                //var_dump($_POST['company_type_id']);
                                for($i=0;$i<=$size;$i++)
                                {
                                   $cmpformcmptype=new Companyformscompanytype;
                                    $cmpformcmptype->company_form_id=$formid;
                                    $cmpformcmptype->company_type_id=$_POST['company_type_id'][$i];
                                    $cmpformcmptype->save();
                                }
                            }
                             if($_POST['company_id']!=null)
                            {
                                $size=count($_POST['company_id']);
                                foreach($_POST['company_id'] as $company_id)
                                {
                                    $Companyformscompany=new Companyformscompany;
                                    $Companyformscompany->company_form_id=$formid;
                                    $Companyformscompany->company_id=$company_id;
                                    $Companyformscompany->save();
                                }
                            }
                            if($_POST['company_usertype']!=null)
                            {
                                $size=count($_POST['company_usertype']);
                                foreach($_POST['company_usertype'] as $company_usertype)
                                {
                                    $cmpusertype=new Companyformsusertype;
                                    $cmpusertype->company_form_id=$formid;
                                    $cmpusertype->company_usertype=$company_usertype;
                                    $cmpusertype->save();
                                }
                            }
                        }
            // proceed if the images have been set
          
			
				//$this->redirect(array('view','id'=>$model->id));
		}
                $q=new CDbCriteria;
                $q->compare('t.doc_type','HowTo');
                 if($usertype==1 || $usertype==2)
                     $forms=  Companyforms::model()->findAll($q);
                 else {
                        $q=new CDbCriteria;
                        $q->join=' left join company_forms_company on company_forms_company.company_form_id=t.id ';
                        $q->compare( 'company_forms_company.company_id',$companies[0]['id']);
                        $q->compare('t.doc_type','HowTo');
                        $forms=$model->findAll($q);
                    }
                
		$this->render('edithowto',array(
			'model'=>$model,
                        'comptype'=>$comptype,
                        'companies'=>$companies,
                        'companyformscompany'=>$Companyformscompany,
                        'cmpformcmptype'=>$cmpformcmptype,
                        'cmpusertype'=>$cmpusertype,
                        'forms'=>$forms,
		));
	}
        public function actionGetcompany()
        {
            $types=substr($_POST['types'],0,-1);
            $arr=explode(",",$types);
            $ty=array();
              $usertype=  UserController::getTypeid(Yii::app()->user->id);
            foreach($arr as $t)
            {
                $typ = new Company;
                $c = new CDbCriteria;
		$c->select='t.id,t.name';
                
                if($usertype>2)
                {
                  $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                 $c->compare('user.id',Yii::app()->user->id);  
                }  
                else {
                   $c->join = 'left join companytype on companytype.id=t.type_id'; 
                   $c->compare('t.type_id',$t); 
                }
                
                $data = $typ->findAll($c);
		
                
               // $data=CHtml::listData($data,'id','name'); 
               // var_dump($data);
                $ty=  array_merge($ty,$data);
            }
               echo CJSON::encode($ty);
                    Yii::app()->end();
        }
        public function actionGetutype()
        {
           // echo $_POST['cid'];
           $cid=substr($_REQUEST['cid'],0,-1);
            $arr=explode(",",$cid);
            $ty=array();
            foreach($arr as $t)
            {
             $typ = new Company;
                $c = new CDbCriteria;
                $c->select='t.type_id';
               // $c->join = 'left join companytype on companytype.id=t.type_id left join company on company.type_id=companytype.id';
                $c->condition="t.id =:cid"; 
                $c->params = array ( 
':cid' => $t,
);
               //var_dump($c);
               // die();
             $data = $typ->find($c);
             $typeid.=$data->type_id.",";
        }
      //  var_dump($data);
              // echo $typeid;
               if($typeid!="")
                {
                    $typeid=substr($typeid,0,-1);
                    $a=explode(",",$typeid);
                    foreach($a as $y)
                    {
                    $uty=new Usertype;
                    $c=new CDbCriteria;
                    $c->select='t.id,t.type';
                    $c->condition=' t.companytype ='.$y;
                    $daa=$uty->findAll($c);

                   $ty=  array_merge($ty,$daa);
                    }
                }
               echo CJSON::encode($ty);
                    Yii::app()->end();
        }

        /**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
        
	public function actionUpdate()
	{
		$model=new Companyforms;
               // var_dump($_POST['cmp_id']);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
 $usertype=  UserController::getTypeid(Yii::app()->user->id);
		$model=new Companyforms;
                $q=new CDbCriteria;
                $q->condition='t.id<5';
                $comptype=  Companytype::model()->findAll($q);
                $q=new CDbCriteria;
                $q->condition='t.type_id<5';
                if($usertype==1 || $usertype==2)
                 $companies=Company::model()->findAll($q);
             else {
                 $cmp=new Company;
                 $c=new CDbCriteria;
                 $c->select='t.id,t.name,t.type_id';
                 $c->join=' left join branch on branch.company_id=t.id left join user on user.branch_id=branch.id';
                 $c->compare('user.id',Yii::app()->user->id);
                 //var_dump($c);
                 $companies=$cmp->findAll($c);
                 //var_dump($companies);
                  $q=new CDbCriteria;
                  $q->condition='t.id='.$companies[0]['type_id'];
                  $comptype=  Companytype::model()->findAll($q);
             }
             $Companyformscompany=new Companyformscompany;
             $cmpformcmptype=new Companyformscompanytype;
             $cmpusertype=new Companyformsusertype;
		if(isset($_POST['cmp_id']))
		{
                    // var_dump($_POST['utype_id']);
                    // var_dump($_POST['cmp_id']);
                   //  die();
                    $i=0;
			 foreach($_POST['cmp_id'] as $key=>$cid)
                         {
                             if($i==0)
                              Companyformscompany::model()->deleteAll(array("condition"=>"company_form_id='".$key."'"));
                             $i++;
                             foreach($_POST['cmp_id'][$key] as $fid=>$cid)
                             {
                                //echo $key."-".$cid."<br/>";
                   // var_dump($_POST['cmp_id']);
                                   
                                    $mc=new Companyformscompany;
                                    $mc->company_form_id=$key;
                                    $mc->company_id=$cid;
                                    $mc->save();
                                }
                             }
                             $i=0;
                            
                             
                              foreach($_POST['utype_id'] as $key=>$cid)
                         {
                                  if($i==0)
                                    Companyformsusertype::model()->deleteAll(array("condition"=>"company_form_id='".$key."'"));
                                  $i++;
                             foreach($_POST['utype_id'][$key] as $fid=>$uid)
                             {
                               // echo $key."-".$uid."<br/>";
                   // var_dump($_POST['cmp_id']);
                                    $mc=new Companyformsusertype;
                                    $mc->company_form_id=$key;
                                    $mc->company_usertype=$uid;
                                    $mc->save();
                                }
                             }
                         }
                         if(isset($_POST['pagenam']) && $_POST['pagenam']=="HOWTO")
                             $this->redirect(array('edithow'));
				$this->redirect(array('create'));
		
                    
		 if($usertype==1 || $usertype==2)
                     $forms=  Companyforms::model()->findAll();
                 else {
                        $q=new CDbCriteria;
                        $q->join=' left join company_forms_company on company_forms_company.company_form_id=t.id ';
                        $q->compare( 'company_forms_company.company_id',$companies[0]['id']);
                        $forms=$model->findAll($q);
                    }
                if(isset($_POST['pagenam']) && $_POST['pagenam']=="HOWTO")
                {
                    $this->render('edithowto',array(
			'model'=>$model,
                        'comptype'=>$comptype,
                        'companies'=>$companies,
                        'companyformscompany'=>$Companyformscompany,
                        'cmpformcmptype'=>$cmpformcmptype,
                        'cmpusertype'=>$cmpusertype,
                        'forms'=>$forms,
                    ));
                }
		$this->render('create',array(
			'model'=>$model,
                        'comptype'=>$comptype,
                        'companies'=>$companies,
                        'companyformscompany'=>$Companyformscompany,
                        'cmpformcmptype'=>$cmpformcmptype,
                        'cmpusertype'=>$cmpusertype,
                        'forms'=>$forms,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Companyforms');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Companyforms('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Companyforms']))
			$model->attributes=$_GET['Companyforms'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
        public function actionViewhowto()
	{
		$model=new Companyforms('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Companyforms']))
			$model->attributes=$_GET['Companyforms'];
                
		$this->render('admin',array(
			'model'=>$model,
		));
	}
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Companyforms the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Companyforms::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Companyforms $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='companyforms-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        

        public function actionDownload($slug){

		$criteria=new CDbCriteria;		

		$criteria->compare('id',$slug);

		$download = Companyforms::model()->find($criteria);
                $name=$download->form;
               // $this->writeLog = true;

               /// $this->logMessage = "Company Form Download : ".$download->form."(".$download->form.")";

               // $this->functionalArea = "General";

              //  $this->addLog();

		//$path = Yii::app()->request->hostInfo . Yii::app()->request->baseURL . '/company_form/' . $download->form;

		 $path = dirname(dirname(dirname(__FILE__))).'/company_form/' . $download->form;
		/*$ft = explode('.',$download->form);

		// $path1 = dirname(dirname(dirname(__FILE__))).'/documents/' . $download->display_name.'.'.$download->doc_type;
		$path1 = dirname(dirname(dirname(__FILE__))).'/company_form/' . $download->form.'.'.$ft[count($ft)-1];

		if(is_file($path)){

			return @Yii::app()->getRequest()->sendFile($download->form, @file_get_contents($path));			
*/
                $filecontent=file_get_contents($path);
  header("Content-Type: text/plain");
  header("Content-disposition: attachment; filename=$name");
  header("Pragma: no-cache");
  echo $filecontent;
  exit;
			// header('Content-Description: File Transfer');

			// header('Content-Type: application/octet-stream');

			//header('Content-Disposition: attachment; filename='.basename($path));

			// header('Content-Disposition: attachment; filename='.basename($path1));

			// header('Content-Transfer-Encoding: binary');

			// header('Expires: 0');

			// header('Cache-Control: must-revalidate');

			// header('Pragma: public');

			// header('Content-Length: ' . filesize($path));

			// ob_clean();

			// flush();

			// readfile($path);

			// exit;

		//}

	}

}
