<?php

class ClaimuploadsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	protected $options;
	
	protected $error_messages = array(
        1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
        2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
        3 => 'The uploaded file was only partially uploaded',
        4 => 'No file was uploaded',
        6 => 'Missing a temporary folder',
        7 => 'Failed to write file to disk',
        8 => 'A PHP extension stopped the file upload',
        'post_max_size' => 'The uploaded file exceeds the post_max_size directive in php.ini',
        'max_file_size' => 'File is too big',
        'min_file_size' => 'File is too small',
        'accept_file_types' => 'Filetype not allowed',
        'max_number_of_files' => 'Maximum number of files exceeded',
        'max_width' => 'Image exceeds maximum width',
        'min_width' => 'Image requires a minimum width',
        'max_height' => 'Image exceeds maximum height',
        'min_height' => 'Image requires a minimum height',
        'abort' => 'File upload aborted',
        'image_resize' => 'Failed to resize image'
		
    );

    protected $image_objects = array();
	
	 protected function initialize() {
        switch ($this->get_server_var('REQUEST_METHOD')) {
            case 'OPTIONS':
            case 'HEAD':
				// die('40');
                $this->head();
                break;
            case 'GET':
				// die('44');
                $this->get();
                break;
            case 'PATCH':
            case 'PUT':
            case 'POST':
				// die('50');
                $this->post();
                break;
            case 'DELETE':
				// die('54');
                $this->delete();
                break;
            default:{
				// die('asds');
				$this->header('HTTP/1.1 405 Method Not Allowed');
			}
                
        }
    }

    protected function get_full_url() {
        $https = !empty($_SERVER['HTTPS']) && strcasecmp($_SERVER['HTTPS'], 'on') === 0 ||
            !empty($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
                strcasecmp($_SERVER['HTTP_X_FORWARDED_PROTO'], 'https') === 0;
        return
            ($https ? 'https://' : 'http://').
            (!empty($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'].'@' : '').
            (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : ($_SERVER['SERVER_NAME'].
            ($https && $_SERVER['SERVER_PORT'] === 443 ||
            $_SERVER['SERVER_PORT'] === 80 ? '' : ':'.$_SERVER['SERVER_PORT']))).
            substr($_SERVER['SCRIPT_NAME'],0, strrpos($_SERVER['SCRIPT_NAME'], '/'));
    }

    protected function get_user_id() {
        @session_start();
        return session_id();
    }

    protected function get_user_path() {
        if ($this->options['user_dirs']) {
            return $this->get_user_id().'/';
        }
        return '';
    }

    protected function get_upload_path($file_name = null, $version = null) {
        $file_name = $file_name ? $file_name : '';
        if (empty($version)) {
            $version_path = '';
        } else {
            $version_dir = @$this->options['image_versions'][$version]['upload_dir'];
            if ($version_dir) {
                return $version_dir.$this->get_user_path().$file_name;
            }
            $version_path = $version.'/';
        }
        return $this->options['upload_dir'].$this->get_user_path()
            .$version_path.$file_name;
    }

    protected function get_query_separator($url) {
        return strpos($url, '?') === false ? '?' : '&';
    }

    protected function get_download_url($file_name, $version = null, $direct = false) {
        if (!$direct && $this->options['download_via_php']) {
            $url = $this->options['script_url']
                .$this->get_query_separator($this->options['script_url'])
                .$this->get_singular_param_name()
                .'='.rawurlencode($file_name);
            if ($version) {
                $url .= '&version='.rawurlencode($version);
            }
            return $url.'&download=1';
        }
        if (empty($version)) {
            $version_path = '';
        } else {
            $version_url = @$this->options['image_versions'][$version]['upload_url'];
            if ($version_url) {
                return $version_url.$this->get_user_path().rawurlencode($file_name);
            }
            $version_path = rawurlencode($version).'/';
        }
        return $this->options['upload_url'].$this->get_user_path()
            .$version_path.rawurlencode($file_name);
    }

    protected function set_additional_file_properties($file) {
        $file->deleteUrl = $this->options['delete_url']
            // .$this->get_query_separator($this->options['script_url'])
            .'&'
            .$this->get_singular_param_name()
            .'='.rawurlencode($file->name);
        $file->deleteType = $this->options['delete_type'];
        if ($file->deleteType !== 'DELETE') {
            $file->deleteUrl .= '&_method=DELETE';
        }
        if ($this->options['access_control_allow_credentials']) {
            $file->deleteWithCredentials = true;
        }
    }

    // Fix for overflowing signed 32 bit integers,
    // works for sizes up to 2^32-1 bytes (4 GiB - 1):
    protected function fix_integer_overflow($size) {
        if ($size < 0) {
            $size += 2.0 * (PHP_INT_MAX + 1);
        }
        return $size;
    }

    protected function get_file_size($file_path, $clear_stat_cache = false) {
        if ($clear_stat_cache) {
            if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
                clearstatcache(true, $file_path);
            } else {
                clearstatcache();
            }
        }
        return $this->fix_integer_overflow(filesize($file_path));
    }

    protected function is_valid_file_object($file_name) {
        $file_path = $this->get_upload_path($file_name);
        if (is_file($file_path) && $file_name[0] !== '.') {
            return true;
        }
        return false;
    }

    protected function get_file_object($file_name) {
        if ($this->is_valid_file_object($file_name)) {
            $file = new \stdClass();
            $file->name = $file_name;
            $file->size = $this->get_file_size(
                $this->get_upload_path($file_name)
            );
            $file->url = $this->get_download_url($file->name);
            foreach($this->options['image_versions'] as $version => $options) {
                if (!empty($version)) {
                    if (is_file($this->get_upload_path($file_name, $version))) {
                        $file->{$version.'Url'} = $this->get_download_url(
                            $file->name,
                            $version
                        );
                    }
                }
            }
            $this->set_additional_file_properties($file);
            return $file;
        }
        return null;
    }

    protected function get_file_objects($iteration_method = 'get_file_object') {
        $upload_dir = $this->get_upload_path();
        if (!is_dir($upload_dir)) {
            return array();
        }
        return array_values(array_filter(array_map(
            array($this, $iteration_method),
            scandir($upload_dir)
        )));
    }

    protected function count_file_objects() {
        return count($this->get_file_objects('is_valid_file_object'));
    }

    protected function get_error_message($error) {
        return array_key_exists($error, $this->error_messages) ?
            $this->error_messages[$error] : $error;
    }

    function get_config_bytes($val) {
        $val = trim($val);
        $last = strtolower($val[strlen($val)-1]);
        switch($last) {
            case 'g':
                $val *= 1024;
            case 'm':
                $val *= 1024;
            case 'k':
                $val *= 1024;
        }
        return $this->fix_integer_overflow($val);
    }

    protected function validate($uploaded_file, $file, $error, $index) {
        if ($error) {
            $file->error = $this->get_error_message($error);
            return false;
        }
        $content_length = $this->fix_integer_overflow(intval(
            $this->get_server_var('CONTENT_LENGTH')
        ));
        $post_max_size = $this->get_config_bytes(ini_get('post_max_size'));
        if ($post_max_size && ($content_length > $post_max_size)) {
            $file->error = $this->get_error_message('post_max_size');
            return false;
        }
        if (!preg_match($this->options['accept_file_types'], $file->name)) {
            $file->error = $this->get_error_message('accept_file_types');
            return false;
        }
        if ($uploaded_file && is_uploaded_file($uploaded_file)) {
            $file_size = $this->get_file_size($uploaded_file);
        } else {
            $file_size = $content_length;
        }
		 
        if ($this->options['max_file_size'] &&  $file_size > $this->options['max_file_size']  )
		{
            $file->error = $this->get_error_message('max_file_size');
            return false;
        }
        if ($this->options['min_file_size'] &&
            $file_size < $this->options['min_file_size']) {
            $file->error = $this->get_error_message('min_file_size');
            return false;
        }
        if (is_int($this->options['max_number_of_files']) &&
                ($this->count_file_objects() >= $this->options['max_number_of_files']) &&
                // Ignore additional chunks of existing files:
                !is_file($this->get_upload_path($file->name))) {
            $file->error = $this->get_error_message('max_number_of_files');
            return false;
        }
        $max_width = @$this->options['max_width'];
        $max_height = @$this->options['max_height'];
        $min_width = @$this->options['min_width'];
        $min_height = @$this->options['min_height'];
        if (($max_width || $max_height || $min_width || $min_height)
           && preg_match($this->options['image_file_types'], $file->name)) {
            list($img_width, $img_height) = $this->get_image_size($uploaded_file);
        }
        if (!empty($img_width)) {
            if ($max_width && $img_width > $max_width) {
                $file->error = $this->get_error_message('max_width');
                return false;
            }
            if ($max_height && $img_height > $max_height) {
                $file->error = $this->get_error_message('max_height');
                return false;
            }
            if ($min_width && $img_width < $min_width) {
                $file->error = $this->get_error_message('min_width');
                return false;
            }
            if ($min_height && $img_height < $min_height) {
                $file->error = $this->get_error_message('min_height');
                return false;
            }
        }
        return true;
    }

    protected function upcount_name_callback($matches) {
        $index = isset($matches[1]) ? intval($matches[1]) + 1 : 1;
        $ext = isset($matches[2]) ? $matches[2] : '';
        return ' ('.$index.')'.$ext;
    }

    protected function upcount_name($name) {
        return preg_replace_callback(
            '/(?:(?: \(([\d]+)\))?(\.[^.]+))?$/',
            array($this, 'upcount_name_callback'),
            $name,
            1
        );
    }

    protected function get_unique_filename($file_path, $name, $size, $type, $error,
            $index, $content_range) {
        while(is_dir($this->get_upload_path($name))) {
            $name = $this->upcount_name($name);
        }
        // Keep an existing filename if this is part of a chunked upload:
        $uploaded_bytes = $this->fix_integer_overflow(intval($content_range[1]));
        while(is_file($this->get_upload_path($name))) {
            if ($uploaded_bytes === $this->get_file_size(
                    $this->get_upload_path($name))) {
                break;
            }
            $name = $this->upcount_name($name);
        }
        return $name;
    }

    protected function fix_file_extension($file_path, $name, $size, $type, $error,
            $index, $content_range) {
        // Add missing file extension for known image types:
        if (strpos($name, '.') === false &&
                preg_match('/^image\/(gif|jpe?g|png)/', $type, $matches)) {
            $name .= '.'.$matches[1];
        }
        if ($this->options['correct_image_extensions'] &&
                function_exists('exif_imagetype')) {
            switch(@exif_imagetype($file_path)){
                case IMAGETYPE_JPEG:
                    $extensions = array('jpg', 'jpeg');
                    break;
                case IMAGETYPE_PNG:
                    $extensions = array('png');
                    break;
                case IMAGETYPE_GIF:
                    $extensions = array('gif');
                    break;
            }
            // Adjust incorrect image file extensions:
            if (!empty($extensions)) {
                $parts = explode('.', $name);
                $extIndex = count($parts) - 1;
                $ext = strtolower(@$parts[$extIndex]);
                if (!in_array($ext, $extensions)) {
                    $parts[$extIndex] = $extensions[0];
                    $name = implode('.', $parts);
                }
            }
        }
        return $name;
    }

    protected function trim_file_name($file_path, $name, $size, $type, $error,
            $index, $content_range) {
        // Remove path information and dots around the filename, to prevent uploading
        // into different directories or replacing hidden system files.
        // Also remove control characters and spaces (\x00..\x20) around the filename:
        $name = trim(basename(stripslashes($name)), ".\x00..\x20");
        // Use a timestamp for empty filenames:
        if (!$name) {
            $name = str_replace('.', '-', microtime(true));
        }
        return $name;
    }

    protected function get_file_name($file_path, $name, $size, $type, $error,
            $index, $content_range) {
        $name = $this->trim_file_name($file_path, $name, $size, $type, $error,
            $index, $content_range);
        return $this->get_unique_filename(
            $file_path,
            $this->fix_file_extension($file_path, $name, $size, $type, $error,
                $index, $content_range),
            $size,
            $type,
            $error,
            $index,
            $content_range
        );
    }

    protected function handle_form_data($file, $index) {
        // Handle form data, e.g. $_REQUEST['description'][$index]
    }

    protected function get_scaled_image_file_paths($file_name, $version) {
        $file_path = $this->get_upload_path($file_name);
        if (!empty($version)) {
            $version_dir = $this->get_upload_path(null, $version);
            if (!is_dir($version_dir)) {
                mkdir($version_dir, $this->options['mkdir_mode'], true);
            }
            $new_file_path = $version_dir.'/'.$file_name;
        } else {
            $new_file_path = $file_path;
        }
        return array($file_path, $new_file_path);
    }

    protected function gd_get_image_object($file_path, $func, $no_cache = false) {
        if (empty($this->image_objects[$file_path]) || $no_cache) {
            $this->gd_destroy_image_object($file_path);
            $this->image_objects[$file_path] = $func($file_path);
        }
        return $this->image_objects[$file_path];
    }

    protected function gd_set_image_object($file_path, $image) {
        $this->gd_destroy_image_object($file_path);
        $this->image_objects[$file_path] = $image;
    }

    protected function gd_destroy_image_object($file_path) {
        $image = (isset($this->image_objects[$file_path])) ? $this->image_objects[$file_path] : null ;
        return $image && imagedestroy($image);
    }

    protected function gd_imageflip($image, $mode) {
        if (function_exists('imageflip')) {
            return imageflip($image, $mode);
        }
        $new_width = $src_width = imagesx($image);
        $new_height = $src_height = imagesy($image);
        $new_img = imagecreatetruecolor($new_width, $new_height);
        $src_x = 0;
        $src_y = 0;
        switch ($mode) {
            case '1': // flip on the horizontal axis
                $src_y = $new_height - 1;
                $src_height = -$new_height;
                break;
            case '2': // flip on the vertical axis
                $src_x  = $new_width - 1;
                $src_width = -$new_width;
                break;
            case '3': // flip on both axes
                $src_y = $new_height - 1;
                $src_height = -$new_height;
                $src_x  = $new_width - 1;
                $src_width = -$new_width;
                break;
            default:
                return $image;
        }
        imagecopyresampled(
            $new_img,
            $image,
            0,
            0,
            $src_x,
            $src_y,
            $new_width,
            $new_height,
            $src_width,
            $src_height
        );
        return $new_img;
    }

    protected function gd_orient_image($file_path, $src_img) {
        if (!function_exists('exif_read_data')) {
            return false;
        }
        $exif = @exif_read_data($file_path);
        if ($exif === false) {
            return false;
        }
        $orientation = intval(@$exif['Orientation']);
        if ($orientation < 2 || $orientation > 8) {
            return false;
        }
        switch ($orientation) {
            case 2:
                $new_img = $this->gd_imageflip(
                    $src_img,
                    defined('IMG_FLIP_VERTICAL') ? IMG_FLIP_VERTICAL : 2
                );
                break;
            case 3:
                $new_img = imagerotate($src_img, 180, 0);
                break;
            case 4:
                $new_img = $this->gd_imageflip(
                    $src_img,
                    defined('IMG_FLIP_HORIZONTAL') ? IMG_FLIP_HORIZONTAL : 1
                );
                break;
            case 5:
                $tmp_img = $this->gd_imageflip(
                    $src_img,
                    defined('IMG_FLIP_HORIZONTAL') ? IMG_FLIP_HORIZONTAL : 1
                );
                $new_img = imagerotate($tmp_img, 270, 0);
                imagedestroy($tmp_img);
                break;
            case 6:
                $new_img = imagerotate($src_img, 270, 0);
                break;
            case 7:
                $tmp_img = $this->gd_imageflip(
                    $src_img,
                    defined('IMG_FLIP_VERTICAL') ? IMG_FLIP_VERTICAL : 2
                );
                $new_img = imagerotate($tmp_img, 270, 0);
                imagedestroy($tmp_img);
                break;
            case 8:
                $new_img = imagerotate($src_img, 90, 0);
                break;
            default:
                return false;
        }
        $this->gd_set_image_object($file_path, $new_img);
        return true;
    }

    protected function gd_create_scaled_image($file_name, $version, $options) {
        if (!function_exists('imagecreatetruecolor')) {
            error_log('Function not found: imagecreatetruecolor');
            return false;
        }
        list($file_path, $new_file_path) =
            $this->get_scaled_image_file_paths($file_name, $version);
        $type = strtolower(substr(strrchr($file_name, '.'), 1));
        switch ($type) {
            case 'jpg':
            case 'jpeg':
                $src_func = 'imagecreatefromjpeg';
                $write_func = 'imagejpeg';
                $image_quality = isset($options['jpeg_quality']) ?
                    $options['jpeg_quality'] : 75;
                break;
            case 'gif':
                $src_func = 'imagecreatefromgif';
                $write_func = 'imagegif';
                $image_quality = null;
                break;
            case 'png':
                $src_func = 'imagecreatefrompng';
                $write_func = 'imagepng';
                $image_quality = isset($options['png_quality']) ?
                    $options['png_quality'] : 9;
                break;
            default:
                return false;
        }
        $src_img = $this->gd_get_image_object(
            $file_path,
            $src_func,
            !empty($options['no_cache'])
        );
        $image_oriented = false;
        if (!empty($options['auto_orient']) && $this->gd_orient_image(
                $file_path,
                $src_img
            )) {
            $image_oriented = true;
            $src_img = $this->gd_get_image_object(
                $file_path,
                $src_func
            );
        }
        $max_width = $img_width = imagesx($src_img);
        $max_height = $img_height = imagesy($src_img);
        if (!empty($options['max_width'])) {
            $max_width = $options['max_width'];
        }
        if (!empty($options['max_height'])) {
            $max_height = $options['max_height'];
        }
        $scale = min(
            $max_width / $img_width,
            $max_height / $img_height
        );
        if ($scale >= 1) {
            if ($image_oriented) {
                return $write_func($src_img, $new_file_path, $image_quality);
            }
            if ($file_path !== $new_file_path) {
                return copy($file_path, $new_file_path);
            }
            return true;
        }
        if (empty($options['crop'])) {
            $new_width = $img_width * $scale;
            $new_height = $img_height * $scale;
            $dst_x = 0;
            $dst_y = 0;
            $new_img = imagecreatetruecolor($new_width, $new_height);
        } else {
            if (($img_width / $img_height) >= ($max_width / $max_height)) {
                $new_width = $img_width / ($img_height / $max_height);
                $new_height = $max_height;
            } else {
                $new_width = $max_width;
                $new_height = $img_height / ($img_width / $max_width);
            }
            $dst_x = 0 - ($new_width - $max_width) / 2;
            $dst_y = 0 - ($new_height - $max_height) / 2;
            $new_img = imagecreatetruecolor($max_width, $max_height);
        }
        // Handle transparency in GIF and PNG images:
        switch ($type) {
            case 'gif':
            case 'png':
                imagecolortransparent($new_img, imagecolorallocate($new_img, 0, 0, 0));
            case 'png':
                imagealphablending($new_img, false);
                imagesavealpha($new_img, true);
                break;
        }
        $success = imagecopyresampled(
            $new_img,
            $src_img,
            $dst_x,
            $dst_y,
            0,
            0,
            $new_width,
            $new_height,
            $img_width,
            $img_height
        ) && $write_func($new_img, $new_file_path, $image_quality);
        $this->gd_set_image_object($file_path, $new_img);
        return $success;
    }

    protected function imagick_get_image_object($file_path, $no_cache = false) {
        if (empty($this->image_objects[$file_path]) || $no_cache) {
            $this->imagick_destroy_image_object($file_path);
            $image = new \Imagick();
            if (!empty($this->options['imagick_resource_limits'])) {
                foreach ($this->options['imagick_resource_limits'] as $type => $limit) {
                    $image->setResourceLimit($type, $limit);
                }
            }
            $image->readImage($file_path);
            $this->image_objects[$file_path] = $image;
        }
        return $this->image_objects[$file_path];
    }

    protected function imagick_set_image_object($file_path, $image) {
        $this->imagick_destroy_image_object($file_path);
        $this->image_objects[$file_path] = $image;
    }

    protected function imagick_destroy_image_object($file_path) {
        $image = (isset($this->image_objects[$file_path])) ? $this->image_objects[$file_path] : null ;
        return $image && $image->destroy();
    }

    protected function imagick_orient_image($image) {
        $orientation = $image->getImageOrientation();
        $background = new \ImagickPixel('none');
        switch ($orientation) {
            case \imagick::ORIENTATION_TOPRIGHT: // 2
                $image->flopImage(); // horizontal flop around y-axis
                break;
            case \imagick::ORIENTATION_BOTTOMRIGHT: // 3
                $image->rotateImage($background, 180);
                break;
            case \imagick::ORIENTATION_BOTTOMLEFT: // 4
                $image->flipImage(); // vertical flip around x-axis
                break;
            case \imagick::ORIENTATION_LEFTTOP: // 5
                $image->flopImage(); // horizontal flop around y-axis
                $image->rotateImage($background, 270);
                break;
            case \imagick::ORIENTATION_RIGHTTOP: // 6
                $image->rotateImage($background, 90);
                break;
            case \imagick::ORIENTATION_RIGHTBOTTOM: // 7
                $image->flipImage(); // vertical flip around x-axis
                $image->rotateImage($background, 270);
                break;
            case \imagick::ORIENTATION_LEFTBOTTOM: // 8
                $image->rotateImage($background, 270);
                break;
            default:
                return false;
        }
        $image->setImageOrientation(\imagick::ORIENTATION_TOPLEFT); // 1
        return true;
    }

    protected function imagick_create_scaled_image($file_name, $version, $options) {
        list($file_path, $new_file_path) =
            $this->get_scaled_image_file_paths($file_name, $version);
        $image = $this->imagick_get_image_object(
            $file_path,
            !empty($options['no_cache'])
        );
        if ($image->getImageFormat() === 'GIF') {
            // Handle animated GIFs:
            $images = $image->coalesceImages();
            foreach ($images as $frame) {
                $image = $frame;
                $this->imagick_set_image_object($file_name, $image);
                break;
            }
        }
        $image_oriented = false;
        if (!empty($options['auto_orient'])) {
            $image_oriented = $this->imagick_orient_image($image);
        }
        $new_width = $max_width = $img_width = $image->getImageWidth();
        $new_height = $max_height = $img_height = $image->getImageHeight();
        if (!empty($options['max_width'])) {
            $new_width = $max_width = $options['max_width'];
        }
        if (!empty($options['max_height'])) {
            $new_height = $max_height = $options['max_height'];
        }
        if (!($image_oriented || $max_width < $img_width || $max_height < $img_height)) {
            if ($file_path !== $new_file_path) {
                return copy($file_path, $new_file_path);
            }
            return true;
        }
        $crop = !empty($options['crop']);
        if ($crop) {
            $x = 0;
            $y = 0;
            if (($img_width / $img_height) >= ($max_width / $max_height)) {
                $new_width = 0; // Enables proportional scaling based on max_height
                $x = ($img_width / ($img_height / $max_height) - $max_width) / 2;
            } else {
                $new_height = 0; // Enables proportional scaling based on max_width
                $y = ($img_height / ($img_width / $max_width) - $max_height) / 2;
            }
        }
        $success = $image->resizeImage(
            $new_width,
            $new_height,
            isset($options['filter']) ? $options['filter'] : \imagick::FILTER_LANCZOS,
            isset($options['blur']) ? $options['blur'] : 1,
            $new_width && $new_height // fit image into constraints if not to be cropped
        );
        if ($success && $crop) {
            $success = $image->cropImage(
                $max_width,
                $max_height,
                $x,
                $y
            );
            if ($success) {
                $success = $image->setImagePage($max_width, $max_height, 0, 0);
            }
        }
        $type = strtolower(substr(strrchr($file_name, '.'), 1));
        switch ($type) {
            case 'jpg':
            case 'jpeg':
                if (!empty($options['jpeg_quality'])) {
                    $image->setImageCompression(\imagick::COMPRESSION_JPEG);
                    $image->setImageCompressionQuality($options['jpeg_quality']);
                }
                break;
        }
        if (!empty($options['strip'])) {
            $image->stripImage();
        }
        return $success && $image->writeImage($new_file_path);
    }

    protected function imagemagick_create_scaled_image($file_name, $version, $options) {
        list($file_path, $new_file_path) =
            $this->get_scaled_image_file_paths($file_name, $version);
        $resize = @$options['max_width']
            .(empty($options['max_height']) ? '' : 'X'.$options['max_height']);
        if (!$resize && empty($options['auto_orient'])) {
            if ($file_path !== $new_file_path) {
                return copy($file_path, $new_file_path);
            }
            return true;
        }
        $cmd = $this->options['convert_bin'];
        if (!empty($this->options['convert_params'])) {
            $cmd .= ' '.$this->options['convert_params'];
        }
        $cmd .= ' '.escapeshellarg($file_path);
        if (!empty($options['auto_orient'])) {
            $cmd .= ' -auto-orient';
        }
        if ($resize) {
            // Handle animated GIFs:
            $cmd .= ' -coalesce';
            if (empty($options['crop'])) {
                $cmd .= ' -resize '.escapeshellarg($resize.'>');
            } else {
                $cmd .= ' -resize '.escapeshellarg($resize.'^');
                $cmd .= ' -gravity center';
                $cmd .= ' -crop '.escapeshellarg($resize.'+0+0');
            }
            // Make sure the page dimensions are correct (fixes offsets of animated GIFs):
            $cmd .= ' +repage';
        }
        if (!empty($options['convert_params'])) {
            $cmd .= ' '.$options['convert_params'];
        }
        $cmd .= ' '.escapeshellarg($new_file_path);
        exec($cmd, $output, $error);
        if ($error) {
            error_log(implode('\n', $output));
            return false;
        }
        return true;
    }

    protected function get_image_size($file_path) {
        if ($this->options['image_library']) {
            if (extension_loaded('imagick')) {
                $image = new \Imagick();
                try {
                    if (@$image->pingImage($file_path)) {
                        $dimensions = array($image->getImageWidth(), $image->getImageHeight());
                        $image->destroy();
                        return $dimensions;
                    }
                    return false;
                } catch (Exception $e) {
                    error_log($e->getMessage());
                }
            }
            if ($this->options['image_library'] === 2) {
                $cmd = $this->options['identify_bin'];
                $cmd .= ' -ping '.escapeshellarg($file_path);
                exec($cmd, $output, $error);
                if (!$error && !empty($output)) {
                    // image.jpg JPEG 1920x1080 1920x1080+0+0 8-bit sRGB 465KB 0.000u 0:00.000
                    $infos = preg_split('/\s+/', $output[0]);
                    $dimensions = preg_split('/x/', $infos[2]);
                    return $dimensions;
                }
                return false;
            }
        }
        if (!function_exists('getimagesize')) {
            error_log('Function not found: getimagesize');
            return false;
        }
        return @getimagesize($file_path);
    }

    protected function create_scaled_image($file_name, $version, $options) {
        if ($this->options['image_library'] === 2) {
            return $this->imagemagick_create_scaled_image($file_name, $version, $options);
        }
        if ($this->options['image_library'] && extension_loaded('imagick')) {
            return $this->imagick_create_scaled_image($file_name, $version, $options);
        }
        return $this->gd_create_scaled_image($file_name, $version, $options);
    }

    protected function destroy_image_object($file_path) {
        if ($this->options['image_library'] && extension_loaded('imagick')) {
            return $this->imagick_destroy_image_object($file_path);
        }
    }

    protected function is_valid_image_file($file_path) {
        if (!preg_match($this->options['image_file_types'], $file_path)) {
            return false;
        }
        if (function_exists('exif_imagetype')) {
            return @exif_imagetype($file_path);
        }
        $image_info = $this->get_image_size($file_path);
        return $image_info && $image_info[0] && $image_info[1];
    }

    protected function handle_image_file($file_path, $file) {
        $failed_versions = array();
		// var_dump($file_path);
		// var_dump($file);
		// die();
        foreach($this->options['image_versions'] as $version => $options) {
            if ($this->create_scaled_image($file->name, $version, $options)) {
                if (!empty($version)) {
                    $file->{$version.'Url'} = $this->get_download_url(
                        $file->name,
                        $version
                    );
                } else {
                    $file->size = $this->get_file_size($file_path, true);
                }
            } else {
                $failed_versions[] = $version ? $version : 'original';
            }
        }
        if (count($failed_versions)) {
            $file->error = $this->get_error_message('image_resize')
                    .' ('.implode($failed_versions,', ').')';
        }
        // Free memory:
        $this->destroy_image_object($file_path);
    }

    protected function handle_file_upload($uploaded_file, $name, $size, $type, $error, $index = null, $content_range = null) {
        $file = new \stdClass();
        $file->name = $this->get_file_name($uploaded_file, $name, $size, $type, $error,
            $index, $content_range);
        $file->size = $this->fix_integer_overflow(intval($size));
        $file->type = $type;
		// var_dump($this->validate($uploaded_file, $file, $error, $index));
        if ($this->validate($uploaded_file, $file, $error, $index)) {
            $this->handle_form_data($file, $index);
            $upload_dir = $this->get_upload_path();
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, $this->options['mkdir_mode'], true);
            }
            $file_path = $this->get_upload_path($file->name);
            $append_file = $content_range && is_file($file_path) &&
                $file->size > $this->get_file_size($file_path);
            if ($uploaded_file && is_uploaded_file($uploaded_file)) {
                // multipart/formdata uploads (POST method uploads)
                if ($append_file) {
                    file_put_contents(
                        $file_path,
                        fopen($uploaded_file, 'r'),
                        FILE_APPEND
                    );
                } else {
                    move_uploaded_file($uploaded_file, $file_path);
					// var_dump(move_uploaded_file($uploaded_file, $file_path));
                }
            } else {
                // Non-multipart uploads (PUT method support)
                file_put_contents(
                    $file_path,
                    fopen('php://input', 'r'),
                    $append_file ? FILE_APPEND : 0
                );
            }
            $file_size = $this->get_file_size($file_path, $append_file);
            if ($file_size === $file->size) {
                $file->url = $this->get_download_url($file->name);
                if ($this->is_valid_image_file($file_path)) {
                    $this->handle_image_file($file_path, $file);
                }
            } else {
                $file->size = $file_size;
                if (!$content_range && $this->options['discard_aborted_uploads']) {
                    unlink($file_path);
                    // $file->error = $this->get_error_message('abort');
                }
            }
            $this->set_additional_file_properties($file);
        }
        return $file;
    }

    protected function readfile($file_path) {
        $file_size = $this->get_file_size($file_path);
        $chunk_size = $this->options['readfile_chunk_size'];
        if ($chunk_size && $file_size > $chunk_size) {
            $handle = fopen($file_path, 'rb');
            while (!feof($handle)) {
                echo fread($handle, $chunk_size);
                @ob_flush();
                @flush();
            }
            fclose($handle);
            return $file_size;
        }
        return readfile($file_path);
    }

    protected function body($str) {
        echo $str;
    }
    
    protected function header($str) {
        header($str);
    }

    protected function get_server_var($id) {
        return isset($_SERVER[$id]) ? $_SERVER[$id] : '';
    }

    protected function generate_response($content, $print_response = true) {
        if ($print_response) {
            $json = json_encode($content);
            $redirect = isset($_REQUEST['redirect']) ?
                stripslashes($_REQUEST['redirect']) : null;
            if ($redirect) {
                $this->header('Location: '.sprintf($redirect, rawurlencode($json)));
                return;
            }
            $this->head();
            if ($this->get_server_var('HTTP_CONTENT_RANGE')) {
                $files = isset($content[$this->options['param_name']]) ?
                    $content[$this->options['param_name']] : null;
                if ($files && is_array($files) && is_object($files[0]) && $files[0]->size) {
                    $this->header('Range: 0-'.(
                        $this->fix_integer_overflow(intval($files[0]->size)) - 1
                    ));
                }
            }
            $this->body($json);
        }
        return $content;
    }

    protected function get_version_param() {
        return isset($_GET['version']) ? basename(stripslashes($_GET['version'])) : null;
    }

    protected function get_singular_param_name() {
        return substr($this->options['param_name'], 0, -1);
    }

    protected function get_file_name_param() {
        $name = $this->get_singular_param_name();
        return isset($_REQUEST[$name]) ? basename(stripslashes($_REQUEST[$name])) : null;
    }

    protected function get_file_names_params() {
        $params = isset($_REQUEST[$this->options['param_name']]) ?
            $_REQUEST[$this->options['param_name']] : array();
        foreach ($params as $key => $value) {
            $params[$key] = basename(stripslashes($value));
        }
        return $params;
    }

    protected function get_file_type($file_path) {
        switch (strtolower(pathinfo($file_path, PATHINFO_EXTENSION))) {
            case 'jpeg':
            case 'jpg':
                return 'image/jpeg';
            case 'png':
                return 'image/png';
            case 'gif':
                return 'image/gif';
            default:
                return '';
        }
    }

    protected function download() {
        switch ($this->options['download_via_php']) {
            case 1:
                $redirect_header = null;
                break;
            case 2:
                $redirect_header = 'X-Sendfile';
                break;
            case 3:
                $redirect_header = 'X-Accel-Redirect';
                break;
            default:
                return $this->header('HTTP/1.1 403 Forbidden');
        }
        $file_name = $this->get_file_name_param();
        if (!$this->is_valid_file_object($file_name)) {
            return $this->header('HTTP/1.1 404 Not Found');
        }
        if ($redirect_header) {
            return $this->header(
                $redirect_header.': '.$this->get_download_url(
                    $file_name,
                    $this->get_version_param(),
                    true
                )
            );
        }
        $file_path = $this->get_upload_path($file_name, $this->get_version_param());
        // Prevent browsers from MIME-sniffing the content-type:
        $this->header('X-Content-Type-Options: nosniff');
        if (!preg_match($this->options['inline_file_types'], $file_name)) {
            $this->header('Content-Type: application/octet-stream');
            $this->header('Content-Disposition: attachment; filename="'.$file_name.'"');
        } else {
            $this->header('Content-Type: '.$this->get_file_type($file_path));
            $this->header('Content-Disposition: inline; filename="'.$file_name.'"');
        }
        $this->header('Content-Length: '.$this->get_file_size($file_path));
        $this->header('Last-Modified: '.gmdate('D, d M Y H:i:s T', filemtime($file_path)));
        $this->readfile($file_path);
    }

    protected function send_content_type_header() {
        $this->header('Vary: Accept');
        if (strpos($this->get_server_var('HTTP_ACCEPT'), 'application/json') !== false) {
            $this->header('Content-type: application/json');
        } else {
            $this->header('Content-type: text/plain');
        }
    }

    protected function send_access_control_headers() {
        $this->header('Access-Control-Allow-Origin: '.$this->options['access_control_allow_origin']);
        $this->header('Access-Control-Allow-Credentials: '
            .($this->options['access_control_allow_credentials'] ? 'true' : 'false'));
        $this->header('Access-Control-Allow-Methods: '
            .implode(', ', $this->options['access_control_allow_methods']));
        $this->header('Access-Control-Allow-Headers: '
            .implode(', ', $this->options['access_control_allow_headers']));
    }

    public function head() {
        $this->header('Pragma: no-cache');
        $this->header('Cache-Control: no-store, no-cache, must-revalidate');
        $this->header('Content-Disposition: inline; filename="files.json"');
        // Prevent Internet Explorer from MIME-sniffing the content-type:
        $this->header('X-Content-Type-Options: nosniff');
        if ($this->options['access_control_allow_origin']) {
            $this->send_access_control_headers();
        }
        $this->send_content_type_header();
    }

    public function get($print_response = false) {
        if ($print_response && isset($_GET['download'])) {
            // return $this->download();
            return '';
        }
        $file_name = $this->get_file_name_param();
		
        if ($file_name) {
            $response = array(
                $this->get_singular_param_name() => $this->get_file_object($file_name)
            );
        } else {
            $response = array(
                $this->options['param_name'] => $this->get_file_objects()
            );
			// var_dump($response);
        }
		
        return $this->generate_response($response, $print_response);
    }

    public function post($print_response = true) {
        if (isset($_REQUEST['_method']) && $_REQUEST['_method'] === 'DELETE') {
            return $this->delete($print_response);
        }
        $upload = isset($_FILES[$this->options['param_name']]) ? $_FILES[$this->options['param_name']] : null;
        $upload1 = isset($_FILES[$this->options['param_name1']]) ? $_FILES[$this->options['param_name1']] : null;
        $upload2 = isset($_FILES[$this->options['param_name2']]) ? $_FILES[$this->options['param_name2']] : null;
        $upload3 = isset($_FILES[$this->options['param_name3']]) ? $_FILES[$this->options['param_name3']] : null;
		
		
		
		// if(isset($_FILES[$this->options['param_name1']])){
			// if(!is_null($upload)){
				// array_push($upload,$_FILES[$this->options['param_name1']]);
			// }else{
				// $upload = $_FILES[$this->options['param_name1']];
			// }			
		// }
		// if(isset($_FILES[$this->options['param_name2']])){			
			// if(!is_null($upload)){
				// array_push($upload,$_FILES[$this->options['param_name2']]);
			// }else{
				// $upload = $_FILES[$this->options['param_name2']];
			// }
		// }
		// if(isset($_FILES[$this->options['param_name3']])){			
			// if(!is_null($upload)){
				// array_push($upload,$_FILES[$this->options['param_name3']]);
			// }else{
				// $upload = $_FILES[$this->options['param_name3']];
			// }
		// }
        // Parse the Content-Disposition header, if available:
        $file_name = $this->get_server_var('HTTP_CONTENT_DISPOSITION') ?
            rawurldecode(preg_replace(
                '/(^[^"]+")|("$)/',
                '',
                $this->get_server_var('HTTP_CONTENT_DISPOSITION')
            )) : null;
        // Parse the Content-Range header, which has the following form:
        // Content-Range: bytes 0-524287/2000000
        $content_range = $this->get_server_var('HTTP_CONTENT_RANGE') ?
            preg_split('/[^0-9]+/', $this->get_server_var('HTTP_CONTENT_RANGE')) : null;
        $size =  $content_range ? $content_range[3] : null;
        $files = array();
		
        if ($upload && is_array($upload['tmp_name'])) {
            // param_name is an array identifier like "files[]",
            // $_FILES is a multi-dimensional array:
            foreach ($upload['tmp_name'] as $index => $value) {
				
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate =$file_name ? $file_name : $upload['name'][$index];
				$mode->ems='';
				$mode->images='';
				$mode->additional_files='';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload['name'][$index];
				 $aslist.="<div>Estimate File :".$file_name."</div>";
				 // Claimuploads::model()->updateAll(array('estimate'=>$file_name), 'id='.$mode->id) ;
       
                $files[] = $this->handle_file_upload(
                    $upload['tmp_name'][$index],
                    $file_name  ,
                    $size ? $size : $upload['size'][$index],
                    $upload['type'][$index],
                    $upload['error'][$index],
                    $index,
                    $content_range
                );
            }
        } else {
            // param_name is a single object identifier like "file",
            // $_FILES is a one-dimensional array:
			if(isset($upload['tmp_name']) && !empty($upload['tmp_name']))
			{
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = $file_name ? $file_name : (isset($upload['name']) ? $upload['name'] : null);
				
				$mode->ems='';
				$mode->images='';
				$mode->additional_files='';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload['name'] ;
				// Claimuploads::model()->updateAll(array('estimate'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Estimate File :".$file_name."</div>";
				$files[] = $this->handle_file_upload(
					isset($upload['tmp_name']) ? $upload['tmp_name'] : null,
					$file_name ,
					$size ? $size : (isset($upload['size']) ?
							$upload['size'] : $this->get_server_var('CONTENT_LENGTH')),
					isset($upload['type']) ?
							$upload['type'] : $this->get_server_var('CONTENT_TYPE'),
					isset($upload['error']) ? $upload['error'] : null,
					null,
					$content_range
				);
			}
        }
		//upload1
		 if ($upload1 && is_array($upload1['tmp_name'])) {
            foreach ($upload1['tmp_name'] as $index => $value) {
			
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems=$file_name ? $file_name : $upload1['name'][$index];
				$mode->images='';
				$mode->additional_files='';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload1['name'][$index];
				  //Claimuploads::model()->updateAll(array('ems'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Ems File :".$file_name."</div>";
                $files[] = $this->handle_file_upload(
                    $upload1['tmp_name'][$index],
                    $file_name ,
                    $size ? $size : $upload1['size'][$index],
                    $upload1['type'][$index],
                    $upload1['error'][$index],
                    $index,
                    $content_range
                );
            }
        } else {
			if(isset($upload1['tmp_name']) && !empty($upload1['tmp_name'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems= $file_name ? $file_name : (isset($upload1['name']) ? $upload1['name'] : null);
				$mode->images='';
				$mode->additional_files='';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload1['name'];
				  //Claimuploads::model()->updateAll(array('ems'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Ems File :".$file_name."</div>";
				$files[] = $this->handle_file_upload(
					isset($upload1['tmp_name']) ? $upload1['tmp_name'] : null,
					$file_name ,
					$size ? $size : (isset($upload1['size']) ?
							$upload1['size'] : $this->get_server_var('CONTENT_LENGTH')),
					isset($upload1['type']) ?
							$upload1['type'] : $this->get_server_var('CONTENT_TYPE'),
					isset($upload1['error']) ? $upload1['error'] : null,
					null,
					$content_range
				);
			}
            
        }
		//upload2
		if ($upload2 && is_array($upload2['tmp_name'])) {
            foreach ($upload2['tmp_name'] as $index => $value) {
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems= '';
				$mode->images='';
				$mode->additional_files= $file_name ? $file_name : $upload2['name'][$index];
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload2['name'][$index];
				 // Claimuploads::model()->updateAll(array('additional_files'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Additional File :".$file_name."</div>";
                $files[] = $this->handle_file_upload(
                    $upload2['tmp_name'][$index],
                    $file_name ,
                    $size ? $size : $upload2['size'][$index],
                    $upload2['type'][$index],
                    $upload2['error'][$index],
                    $index,
                    $content_range
                );
            }
        } else {
			if(isset($upload2['tmp_name']) && !empty($upload2['tmp_name'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems= '';
				$mode->images='';
				$mode->additional_files= $file_name ? $file_name : (isset($upload2['name']) ? $upload2['name'] : null);
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload2['name'];
				 // Claimuploads::model()->updateAll(array('additional_files'=>$file_name), 'id='.$mode->id) ;
					$aslist.="<div>Additional File :".$file_name."</div>";
				$files[] = $this->handle_file_upload(
                isset($upload2['tmp_name']) ? $upload2['tmp_name'] : null,
					$file_name ,
					$size ? $size : (isset($upload2['size']) ?
							$upload2['size'] : $this->get_server_var('CONTENT_LENGTH')),
					isset($upload2['type']) ?
							$upload2['type'] : $this->get_server_var('CONTENT_TYPE'),
					isset($upload2['error']) ? $upload2['error'] : null,
					null,
					$content_range
				);
			}            
        }
		//upload3
		if ($upload3 && is_array($upload3['tmp_name'])) {
            foreach ($upload3['tmp_name'] as $index => $value) {
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems= '';
				$mode->images= $file_name ? $file_name : $upload3['name'][$index];
				$mode->additional_files= '';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload3['name'][$index];
				 // Claimuploads::model()->updateAll(array('images'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Image File :".$file_name."</div>";
                $files[] = $this->handle_file_upload(
                    $upload3['tmp_name'][$index],
                    $file_name ,
                    $size ? $size : $upload3['size'][$index],
                    $upload3['type'][$index],
                    $upload3['error'][$index],
                    $index,
                    $content_range
                );
            }
        } else {
			if(isset($upload3['tmp_name']) && !empty($upload3['tmp_name'])){
			
				$mode = new Claimuploads;
				$mode->claim_id = $_REQUEST['Claim_id'];
				$mode->estimate = '';
				$mode->ems= '';
				$mode->images= $file_name ? $file_name : (isset($upload3['name']) ? $upload3['name'] : null);
				$mode->additional_files= '';
				$mode->createdby=Yii::app()->user->id;
				$mode->save();
				 $file_name=$mode->id.$upload3['name'];
				 // Claimuploads::model()->updateAll(array('images'=>$file_name), 'id='.$mode->id) ;
				$aslist.="<div>Image File :".$file_name."</div>";
				$files[] = $this->handle_file_upload(
					isset($upload3['tmp_name']) ? $upload3['tmp_name'] : null,
					$file_name ,
					$size ? $size : (isset($upload3['size']) ?
							$upload3['size'] : $this->get_server_var('CONTENT_LENGTH')),
					isset($upload3['type']) ?
							$upload3['type'] : $this->get_server_var('CONTENT_TYPE'),
					isset($upload3['error']) ? $upload3['error'] : null,
					null,
					$content_range
				);
			}            
        }
		//CallcenterinvoiceController::setautostatus(11,$_REQUEST['Claim_id']);
							$ab=new AbilityPermission;
                
                            $results =$ab->get_abt(11); //$results->queryAll();
                
                            
                            $us=  UserController::getMe(Yii::app()->user->id);
            
                            
                         $sta=new Statusofclaim;
                         $sta->claim_id=$mode->claim_id;
                
                             $status=$us." ".$results->status.":".$mode->clm->claim_no;
							 $status.=$aslist;
							 $status.="<div>S111</div>";
						$sta->status=$status;	 
                         $sta->status_num="S111";
                         $sta->created_by=Yii::app()->user->id;
                         $sta->save();
        return $this->generate_response(
            array($this->options['param_name'] => $files),
            $print_response
        );
    }

    public function delete($print_response = true) {
        $file_names = $this->get_file_names_params();
        if (empty($file_names)) {
            $file_names = array($this->get_file_name_param());
        }
        $response = array();
        foreach($file_names as $file_name) {
            $file_path = $this->get_upload_path($file_name);
            $success = is_file($file_path) && $file_name[0] !== '.' && unlink($file_path);
            if ($success) {
                foreach($this->options['image_versions'] as $version => $options) {
                    if (!empty($version)) {
                        $file = $this->get_upload_path($file_name, $version);
                        if (is_file($file)) {
                            unlink($file);
                        }
                    }
                }
            }
            $response[$file_name] = $success;
        }
        return $this->generate_response($response, $print_response);
    }
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
        function checkfile($filename)
        {echo Yii::app()->request->baseUrl.$filename;
            if(file_exists(Yii::app()->request->baseUrl.$filename))
                return true;
            else {
                return false;
            }
        }
        public function allowedActions() {
            return 'download,makezip,downloadzip,joinpdf,deletefile,zendpdf,zendpdf1,create1';
        }
		
		public function actionZendpdf1(){
			ini_set('display_errors','1'); 			
			require_once('Zend/Pdf.php');
			// LOAD PDF DOCUMENTS
			$pdf1 = Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/one.pdf');
			$pdf2 =  Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/three.pdf');
			// WE WILL MERGE OUR TWO PDF FILES INTO A NEW ZEND_PDF OBJECT
			$pdfMerged = new Zend_Pdf();
			// ADD ALL PAGES FROM THE FIRST PDF TO OUR NEW DOCUMENT
			
			$pagee = new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4);
			$image = Zend_Pdf_Image::imageWithPath(dirname(dirname(dirname(__FILE__))).'/files/fruitbox.png');
			$pagee->drawImage($image, 0, 0, 400, 400);					
			$pdfMerged->pages[]  = $pagee; 
			
			$pagee = new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4);
			$image = Zend_Pdf_Image::imageWithPath(dirname(dirname(dirname(__FILE__))).'/files/iphone_3.jpg');
			$pagee->drawImage($image, 40, 764, 400, 400);					
			$pdfMerged->pages[]  = $pagee;
			  
			foreach($pdf1->pages as $page){
			  $clonedPage = clone $page;
			  $pdfMerged->pages[] = $clonedPage;
			}
			// foreach($pdf2->pages as $page){
			  // $clonedPage = clone $page;
			  // $pdfMerged->pages[] = $clonedPage;
			// }
			
			unset($clonedPage);
			// SEND THE MERGED PDF DOCUMENT TO BROWSER
			// header('Content-type: application/pdf');
			 // $pdfMerged->render();
			// $today=date('ymdhis');
			// save to a file
			 $pdfMerged->save(dirname(dirname(dirname(__FILE__))).'/files/deepak.pdf');
			 // $jn=new UploadJoinFiles;
			 // $jn->claim_id=$claimid;
			 // $jn->file_name=$today.'.pdf';
			 // $jn->created_by=Yii::app()->user->id;
			 // $jn->save();
		
			Yii::app()->end();
		}
		
		public function zendpdf($files,$claimid){
			ini_set('display_errors','1'); 			
			require_once('Zend/Pdf.php');
			// LOAD PDF DOCUMENTS
			//$pdf1 = Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/one.pdf');
			$pdf2 =  Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/three.pdf');
			// WE WILL MERGE OUR TWO PDF FILES INTO A NEW ZEND_PDF OBJECT
			$pdfMerged = new Zend_Pdf();
			// ADD ALL PAGES FROM THE FIRST PDF TO OUR NEW DOCUMENT
			foreach($files as $file)
			{
				$file_type= $this->typefile($file);
				if($file_type=="pdf")
				{
				$pdf1 = Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).$file);
				foreach($pdf1->pages as $page){
				  $clonedPage = clone $page;
				  $pdfMerged->pages[] = $clonedPage;
				}
				}
				/*if($file_type=="image"){
					$pagee = new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4);
					echo $file;
					// define image resource
					$image = Zend_Pdf_Image::imageWithPath(dirname(dirname(dirname(__FILE__))).'/files/'.$file);
					// write image to page
					$pagee->drawImage($image, 50, 50, 400, 400);
					// $pdf1 = Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/files/3.pdf');
					// add page to document
					 $pdfMerged->pages[]  = $pagee;
				}*/
			}
			 
			
			// SEND THE MERGED PDF DOCUMENT TO BROWSER
			
			$today=date('ymdhis');
			$today=$claimid."-".$today;
			//save to a file
			 //$pdfMerged->save(dirname(dirname(dirname(__FILE__))).'/files/'.$today.'.pdf');
			 foreach($files as $file)
			{
				$file_type= $this->typefile($file);
				if($file_type=="image")
				{
					 
						  $pagee = new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4);
					 $image = Zend_Pdf_Image::imageWithPath(dirname(dirname(dirname(__FILE__))).$file);
						 
					$pagee->drawImage($image, 0, 0, 400, 400);					
					$pdfMerged->pages[]  = $pagee; 
			
			  }
			  }
			  unset($clonedPage);
			  header('Content-type: application/pdf');
			 $pdfMerged->render();
			   $pdfMerged->save(dirname(dirname(dirname(__FILE__))).'/files/'.$today.'.pdf');
			  $jn=new UploadJoinFiles;
			 $jn->claim_id=$claimid;
			 $jn->file_name=$today.'.pdf';
			 $jn->created_by=Yii::app()->user->id;
			 $jn->save();
			 var_dump($jn->getErrors());
			Yii::app()->end();
		}

        /**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id=null)
	{
            $mode=new Claimuploads;//('search');
            $id=$_REQUEST['Claim_id'];
            $cu=new Claimuploads;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.estimate!='null'";
            $model=$cu->findAll($q);
           if($model==null)
               $model=array();
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.ems!='null'";
            $ems=$cu->findAll($q);
            
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.additional_files!='null'";
            $add=$cu->findAll($q);
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.images!='null'";
            $photo=$cu->findAll($q);
            
            $sum=new Summery;
            $c = new CDbCriteria;
            $c->compare('t.claim_id',$id);
            $sumarry = $sum->find($c);
            $smry=FALSE;
            if(file_exists(dirname(dirname(dirname(__FILE__))).'/summary/'.$_REQUEST['Claim_id'].'summary-.pdf'))
              $smry=true;
	//echo $_REQUEST['Claim_id'];
            $appcmp=FALSE;
            if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/appraisal-company/'.$_REQUEST['Claim_id'].'appraisal-company-invoice-.pdf'))
              $appcmp=true;
            $appraisal=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/appraisal/'.$_REQUEST['Claim_id'].'appraisal-invoice-.pdf'))
              $appraisal=true;
             $bodyshop=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/bodyshop/'.$_REQUEST['Claim_id'].'bodyshop-invoice-.pdf'))
              $bodyshop=true;
             $callcenter=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/callcenter/'.$_REQUEST['Claim_id'].'callcenter-invoice-.pdf'))
              $callcenter=true;
             $cfs=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/cfs/'.$_REQUEST['Claim_id'].'cfs-invoice-.pdf'))
              $cfs=true;
             $deskreviewer=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/deskreviewer/'.$_REQUEST['Claim_id'].'deskreviewer-invoice-.pdf'))
              $deskreviewer=true;
			   $jn=new UploadJoinFiles;
			  $q=new CDbCriteria;
			  $q->compare('t.claim_id',$_REQUEST['Claim_id']);
			  $joins=$jn->findAll($q);
		$this->render('view',array(
			'model'=>$model,
                        'mode'=>$mode,
                        'ems'=>$ems,
                        'add'=>$add,
                        'photo'=>$photo,
                        'sumarry'=>$sumarry,
                        'smry'=>$smry,
                        'appcmp'=>$appcmp,
                        'appraisal'=>$appraisal,
                        'bodyshop'=>$bodyshop,
                        'callcenter'=>$callcenter,
                        'cfs'=>$cfs,
                        'deskreviewer'=>$deskreviewer,
						'joins'=>$joins,
		));
	}
 
 
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
        public function actionInprocess()
        {
            $vh=new Vehicleowner;
            $q=new CDbCriteria;
            $q->compare('t.user_id',Yii::app()->user->id);
            $vo=$vh->find($q);
            $model=new Claimuploads;
            $photo=array();
            if($vo!=null)
            {
                $claim_id=$vo->claim_id;
                $model=new Claimuploads;
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.images!=""';
                $photo=$model->findAll($q);
               // var_dump($photo);
                
            }
            $this->render('photo',array(
			'model'=>$model,
                        'photo'=>$photo,
		));
        }
         public function actionRepairstatus()
        {
            $vh=new Vehicleowner;
            $q=new CDbCriteria;
            $q->compare('t.user_id',Yii::app()->user->id);
            $vo=$vh->find($q);
            $model=new Claimuploads;
            $photo=array();
            if($vo!=null)
            {
                $claim_id=$vo->claim_id;
                $model=new Claimuploads;
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.images!=""';
                $photo=$model->findAll($q);
               // var_dump($photo);
                
            }
            $c=new Claim;
            $q=new CDbCriteria;
            $q->select='t.id,t.insurance_company,t.adjustor_id,t.other_adjuster';
            $q->compare('t.id',$claim_id);
            $claim=$c->find($q);
            $ass=new Assignee;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id.' and active=1';
            $assn=$ass->find($q);
            $bodyshop=array();
            if($assn!=null)
            {
                /*if($assn->assign_to!=null)
                {
                    $usr=  User::model()->findByPk($assn->assign_to);
                    return $usr->first_name." ".$usr->last_name;
                }*/
                 if($assn->assign_to!=null)
                 {
                     $usr=User::model()->findByPk($ass->assign_to);
                     $type=  UserController::getTypeid($ass->assign_to);
                    // $br=  Branch::model()->findByPk($assn->branch_id);
                     if($type>=33 && $type<=44)
                      $bodyshop=$usr;
                 }
            }
            $this->render('repair_status',array(
			'model'=>$model,
                        'photo'=>$photo,
                        'bodyshop'=>$bodyshop,
                        'claim'=>$claim,
		));
        }
        public function actionCreate()
	{
		$model=new Claimuploads;
		$model=new Claimuploads;
		$mode=new Claimuploads;
		$c = new CDbCriteria;
		$c->compare('claim_id',$_REQUEST['Claim_id']);
		$df = $mode->find($c);
		$size=5*1024*1024;
		// Uncomment the following line if AJAX validation is needed
		/* $this->performAjaxValidation($model);
		Yii::log("actionCreate actionCreate "  
		isset($_POST['Claimuploads']));  */
		// var_dump($_POST);
		// var_dump($_FILES);				 
		$upp =  false;
		if(isset($_REQUEST['ajax'])){
			
		}
		if(isset($_POST['claimS'])){
			// var_dump($imageUploadFile);						
			/***						
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/estimate');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/images');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/ems');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/additional');
			**/
                        $formid  = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('claimuploads')
                                ->queryScalar();
                         $formid=$formid+1;
                        $mode = new Claimuploads;
                        $mode->claim_id = $_POST['claimS'];
			if(isset($_FILES['files'])){
                               
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                            $name=  str_replace("  ", " ", $_FILES['files']['name']['0']);
                             $name=$formid."-". str_replace("-", " ", $name);
				$mode->estimate =$name;// $_FILES['files']['name']['0'];
                                $path=dirname(dirname(dirname(__FILE__))).'/uploadtoclaim/estimate/';
				move_uploaded_file($_FILES["files"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/estimate/'. $name);
				//rename($path.$_FILES['files']['name']['0'],$path.$name);
                                /*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['efiles'])){
                           
				 $name=  str_replace("  ", " ", $_FILES['efiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->ems = $name;//$_FILES['efiles']['name']['0'];
				move_uploaded_file($_FILES["efiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/ems/'. $name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['ifiles'])){
                            
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                                $name=  str_replace("  ", " ", $_FILES['ifiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->images = $name;//$_FILES['ifiles']['name']['0'];
				move_uploaded_file($_FILES["ifiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/images/'. $name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['sfiles'])){
                             
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                                $name=  str_replace("  ", " ", $_FILES['sfiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->additional_files = $name;//$_FILES['sfiles']['name']['0'];
				move_uploaded_file($_FILES["sfiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/additional/'.$name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
                        $mode->createdby=Yii::app()->user->id;
                        if($mode->save()){
					$upp = $upp || true;
				};
			if($upp){
				Yii::app()->user->setFlash('success','File Uploaded Successfully');                         
				//echo 'success';
				// $this->redirect(array('claimuploads/create'));
			}
		}
		$claimid=$_REQUEST['Claim_id'];
		$claim=new Claim;        
		$q=new CDbCriteria;
		$q->compare("t.id",$claimid);                       
		$claims=$claim->find($q);
		$this->render('create',array('model'=>$model,'claim'=>$claims,));
	}

	
	public function actionCreate1(){
		ini_set('display_errors','1');
		$this->options = array(
            'script_url' => $this->get_full_url().'/',
            'delete_url' => $this->get_full_url().'/index.php?r=claimuploads/delete',
            'upload_dir' => dirname($this->get_server_var('SCRIPT_FILENAME')).'/files/',
            'upload_url' => $this->get_full_url().'/files/',
            'user_dirs' => false,
            'mkdir_mode' => 0755,
            'param_name' => 'files',
            'param_name1' => 'efiles',
            'param_name2' => 'sfiles',
            'param_name3' => 'ifiles',
            // Set the following option to 'POST', if your server does not support
            // DELETE requests. This is a parameter sent to the client:
            'delete_type' => 'DELETE',
            'access_control_allow_origin' => '*',
            'access_control_allow_credentials' => false,
            'access_control_allow_methods' => array(
                'OPTIONS',
                'HEAD',
                'GET',
                'POST',
                'PUT',
                'PATCH',
                'DELETE'
            ),
            'access_control_allow_headers' => array(
                'Content-Type',
                'Content-Range',
                'Content-Disposition'
            ),
            // Enable to provide file downloads via GET requests to the PHP script:
            //     1. Set to 1 to download files via readfile method through PHP
            //     2. Set to 2 to send a X-Sendfile header for lighttpd/Apache
            //     3. Set to 3 to send a X-Accel-Redirect header for nginx
            // If set to 2 or 3, adjust the upload_url option to the base path of
            // the redirect parameter, e.g. '/files/'.
            'download_via_php' => false,
            // Read files in chunks to avoid memory limits when download_via_php
            // is enabled, set to 0 to disable chunked reading of files:
            'readfile_chunk_size' => 10 * 1024 * 1024, // 10 MiB
            // Defines which files can be displayed inline when downloaded:
            'inline_file_types' => '/\.(gif|jpe?g|png)$/i',
            // Defines which files (based on their names) are accepted for upload:
            'accept_file_types' => '/.+$/i',
            // The php.ini settings upload_max_filesize and post_max_size
            // take precedence over the following max_file_size setting:
            'max_file_size' => 15 * 1024 * 1024,
            'min_file_size' => 1,
            // The maximum number of files for the upload directory:
            'max_number_of_files' => null,
            // Defines which files are handled as image files:
            'image_file_types' => '/\.(gif|jpe?g|png)$/i',
            // Use exif_imagetype on all files to correct file extensions:
            'correct_image_extensions' => false,
            // Image resolution restrictions:
            'max_width' => null,
            'max_height' => null,
            'min_width' => 1,
            'min_height' => 1,
            // Set the following option to false to enable resumable uploads:
            'discard_aborted_uploads' => true,
            // Set to 0 to use the GD library to scale and orient images,
            // set to 1 to use imagick (if installed, falls back to GD),
            // set to 2 to use the ImageMagick convert binary directly:
            'image_library' => 1,
            // Uncomment the following to define an array of resource limits
            // for imagick:
            /*
            'imagick_resource_limits' => array(
                imagick::RESOURCETYPE_MAP => 32,
                imagick::RESOURCETYPE_MEMORY => 32
            ),
            */
            // Command or path for to the ImageMagick convert binary:
            'convert_bin' => 'convert',
            // Uncomment the following to add parameters in front of each
            // ImageMagick convert call (the limit constraints seem only
            // to have an effect if put in front):
            /*
            'convert_params' => '-limit memory 32MiB -limit map 32MiB',
            */
            // Command or path for to the ImageMagick identify binary:
            'identify_bin' => 'identify',
            'image_versions' => array(
                // The empty image version key defines options for the original image:
                '' => array(
                    // Automatically rotate images based on EXIF meta data:
                    'auto_orient' => true
                ),
                // Uncomment the following to create medium sized images:
                /*
                'medium' => array(
                    'max_width' => 800,
                    'max_height' => 600
                ),
                */
                'thumbnail' => array(
                    // Uncomment the following to use a defined directory for the thumbnails
                    // instead of a subdirectory based on the version identifier.
                    // Make sure that this directory doesn't allow execution of files if you
                    // don't pose any restrictions on the type of uploaded files, e.g. by
                    // copying the .htaccess file from the files directory for Apache:
                    //'upload_dir' => dirname($this->get_server_var('SCRIPT_FILENAME')).'/thumb/',
                    //'upload_url' => $this->get_full_url().'/thumb/',
                    // Uncomment the following to force the max
                    // dimensions and e.g. create square thumbnails:
                    //'crop' => true,
                    'max_width' => 80,
                    'max_height' => 80
                )
            )
        );
		
        if ($options) {
            $this->options = $options + $this->options;
        }
        if ($error_messages) {
            $this->error_messages = $error_messages + $this->error_messages;
        }
		
        if (true) {
			// die('asds');
            $this->initialize();
        }
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
          public function getUsername($id)
        {
            $model=  User::model()->findByPk($id);
            return $model->first_name." ".$model->last_name;
        }
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimuploads']))
		{
			$model->attributes=$_POST['Claimuploads'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimuploads');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimuploads('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimuploads']))
			$model->attributes=$_GET['Claimuploads'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
        public function actionDeletefile()
        {
            $type=$_REQUEST['type'];
                $id=$_REQUEST['id'];
                $claimid=$_REQUEST['Claim_id'];
                $criteria=new CDbCriteria;
                if($type=='estimate')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->estimate;
                    $path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
                        $name=str_replace(" ","_",$name);
                        $newname=$id.$name;
                        if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
                                rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
                        $path='/files/'.$newname;
                    $download->delete();
                }
                if($type=='ems')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->ems;
                    $path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
                        $name=str_replace(" ","_",$name);
                        $newname=$name;
                        if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
                                rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
                        $path='/files/'.$newname;
                    $download->delete();
                }
                if($type=='additional')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->additional_files;
                   $path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
                        $name=str_replace(" ","_",$name);
                        $newname=$name;
                        if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
                                rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
                        $path='/files/'.$newname;
                   $download->delete();
                }
		if($type=='images')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->images;
                    $path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
                        $name=str_replace(" ","_",$name);
                        $newname=$name;
                        if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
                                rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
                        $path='/files/'.$newname;
                    $download->delete();
                }
				if($type=="join")
				{    $criteria->compare('id',$id);
                    $download = UploadJoinFiles::model()->find($criteria);
                    $name=$download->file_name;
					$path='/files/'.$name;
					$download->delete();
				}
                unlink(dirname(dirname(dirname(__FILE__))).$path);
				
        }
		
        public function actionDownload(){
                $type=$_REQUEST['type'];
                $id=$_REQUEST['id'];
                $claimid=$_REQUEST['Claim_id'];
                $criteria=new CDbCriteria;
                if($type=='estimate')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->estimate;
					$path='/files/'.$name;
					$name=str_replace("  "," ",$name);
					$name=str_replace(" ","_",$name);
					$newname=$id.$name;
                    //'/uploadtoclaim/estimate/'.$name;
                     if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                }
                if($type=='ems')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->ems;
					 $path='/files/'.$name;
					$name=str_replace("  "," ",$name);
					$name=str_replace(" ","_",$name);
					$newname=$id.$name;
                   //
                   if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
					$path='/files/'.$newname;
                }
                if($type=='additional')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->additional_files;
					 $path='/files/'.$name;
					$name=str_replace("  "," ",$name);
					$name=str_replace(" ","_",$name);
					$newname=$id.$name;
                  // $path='/uploadtoclaim/additional/'.$name;
				   if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
					$path='/files/'.$newname;
                }
		if($type=='images')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->images;
					$path='/files/'.$name;
					$name=str_replace("  "," ",$name);
					$name=str_replace(" ","_",$name);
					$newname=$id.$name;
                    //
                    if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                }
				if($type=="join")
				{
					$criteria->compare('id',$id);
                    $download = UploadJoinFiles::model()->find($criteria);
                    $name=$download->file_name;
					$newname=$name;
					$path='/files/'.$name;
				}
		if($type=="summary")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/summary/'.$claimid.'summary-.pdf';
                }
                if($type=="appcmp")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/appraisal-company/'.$claimid.'appraisal-company-invoice-.pdf';
                }
                 if($type=="appraisal")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/appraisal/'.$claimid.'appraisal-invoice-.pdf';
                }
                 if($type=="bodyshop")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/bodyshop/'.$claimid.'bodyshop-invoice-.pdf';
                }
                 if($type=="callcenter")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/callcenter/'.$claimid.'callcenter-invoice-.pdf';
                }
                   if($type=="cfs")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/cfs/'.$claimid.'cfs-invoice-.pdf';
                }
                 if($type=="deskreviewer")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/deskreviewer/'.$claimid.'deskreviewer-invoice-.pdf';
                }
				 $known_mime_types=array(
    "htm" => "text/html",
    "exe" => "application/octet-stream",
    "zip" => "application/zip",
    "doc" => "application/msword",
    "jpg" => "image/jpg",
    "php" => "text/plain",
    "xls" => "application/vnd.ms-excel",
    "xlsx" => "application/vnd.ms-excel",
    "csv" => "text/csv",
    "ppt" => "application/vnd.ms-powerpoint",
    "gif" => "image/gif",
    "pdf" => "application/pdf",
    "txt" => "text/plain",
    "html"=> "text/html",
    "png" => "image/png",
    "jpeg"=> "image/jpg"
 );
                //echo "<br/>";
				$file_extension = strtolower(substr(strrchr($path,"."),1));
				if(array_key_exists($file_extension, $known_mime_types)){
        $mime_type=$known_mime_types[$file_extension];
     } else {
        $mime_type="application/force-download";
     };
	 
				//echo Yii::app()->request->baseUrl.$path;
		       /// $name = '/files/'.$newname;
				$this->downloadS(dirname(dirname(dirname(__FILE__))).$path);
				
                      /*   // $filecontent=file_get_contents(dirname(dirname(dirname(__FILE__))).$name);
                          header("Content-Type: ".$mime_type);
                          header("Content-disposition: attachment; filename=$name");
                          header("Pragma: no-cache");
                         //echo $filecontent;
                          exit;*/
			 

	}
	function downloadS($filePath) 
{     
    if(!empty($filePath)) 
    { 
	 //echo $filePath;
        $fileInfo = pathinfo($filePath); 
        $fileName  = $fileInfo['basename']; 
        $fileExtnesion   = $fileInfo['extension']; 
        $default_contentType = "application/octet-stream"; 
        $content_types_list = array(
    "htm" => "text/html",
    "exe" => "application/octet-stream",
    "zip" => "application/zip",
    "doc" => "application/msword",
    "jpg" => "image/jpg",
    "php" => "text/plain",
    "xls" => "application/vnd.ms-excel",
    "xlsx" => "application/vnd.ms-excel",
    "csv" => "text/csv",
    "ppt" => "application/vnd.ms-powerpoint",
    "gif" => "image/gif",
    "pdf" => "application/pdf",
    "txt" => "text/plain",
    "html"=> "text/html",
    "png" => "image/png",
    "jpeg"=> "image/jpg"
 ); 
        // to find and use specific content type, check out this IANA page : http://www.iana.org/assignments/media-types/media-types.xhtml 
        if (array_key_exists($fileExtnesion, $content_types_list))  
        { 
            $contentType = $content_types_list[$fileExtnesion]; 
        } 
        else 
        { 
            $contentType =  $default_contentType; 
        } 
        if(file_exists($filePath)) 
        { 
            $size = filesize($filePath); 
            $offset = 0; 
            $length = $size; 
            //HEADERS FOR PARTIAL DOWNLOAD FACILITY BEGINS 
            if(isset($_SERVER['HTTP_RANGE'])) 
            { 
                preg_match('/bytes=(\d+)-(\d+)?/', $_SERVER['HTTP_RANGE'], $matches); 
                $offset = intval($matches[1]); 
                $length = intval($matches[2]) - $offset; 
                $fhandle = fopen($filePath, 'r'); 
                fseek($fhandle, $offset); // seek to the requested offset, this is 0 if it's not a partial content request 
                $data = fread($fhandle, $length); 
                fclose($fhandle); 
                header('HTTP/1.1 206 Partial Content'); 
                header('Content-Range: bytes ' . $offset . '-' . ($offset + $length) . '/' . $size); 
            }//HEADERS FOR PARTIAL DOWNLOAD FACILITY BEGINS 
            //USUAL HEADERS FOR DOWNLOAD 
            header("Content-Disposition: attachment;filename=".$fileName); 
            header('Content-Type: '.$contentType); 
            header("Accept-Ranges: bytes"); 
            header("Pragma: public"); 
            header("Expires: -1"); 
            header("Cache-Control: no-cache"); 
            header("Cache-Control: public, must-revalidate, post-check=0, pre-check=0"); 
            header("Content-Length: ".filesize($filePath)); 
            $chunksize = 8000 * (1024 * 1024); //8MB (highest possible fread length) 
            if ($size > $chunksize) 
            { 
              $handle = fopen($_FILES["file"]["tmp_name"], 'rb'); 
              $buffer = ''; 
              while (!feof($handle) && (connection_status() === CONNECTION_NORMAL))  
              { 
                $buffer = fread($handle, $chunksize); 
                print $buffer; 
                ob_flush(); 
                flush(); 
              } 
              if(connection_status() !== CONNECTION_NORMAL) 
              { 
                echo "Connection aborted"; 
              } 
              fclose($handle); 
            } 
            else  
            { 
              ob_clean(); 
              flush(); 
              readfile($filePath); 
            } 
         } 
         else 
         { 
           echo 'File does not exist!'; 
         } 
    } 
    else 
    { 
        echo 'There is no file to download!'; 
    } 
}     
     
        public function actionDownloadzip()
        {
                       /* $filecontent=file_get_contents($_POST['zip']);
                          header("Content-Type: text/plain");
                          header("Content-disposition: attachment; filename=$name");
                          header("Pragma: no-cache");
                          echo $filecontent;
                          exit;*/
						  
                           $zipname =dirname(dirname(dirname(__FILE__))).'/files/file.zip';
						   $this->downloadS($zipname);
                            /*  header('Content-Type: application/zip');
            header('Content-disposition: attachment; filename='.$zipname);
            header('Content-Length: ' . filesize($zipname));
          // readfile($_REQUEST['zip']); */
        }

        public function actionMakezip()
        {$strRequest = file_get_contents('php://input');
            $nf = json_decode($strRequest);//$_POST['data'];
            $files=array();
            
            foreach ($nf as $a)
            {    $arr=explode(",",$a);
                $id=$arr[0];
                $brr=explode("-",$arr[1]);
                $type=$brr[0];
           
                $criteria=new CDbCriteria;
                    
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    if($type=='estimate')
                    {
                        $name=$download->estimate;
							 
							$path='/files/'.$name;
							$name=str_replace("  "," ",$name);
							$name=str_replace(" ","_",$name);
							$newname=$name;
                    //
                    if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$id.$newname;
                      //  $path='/uploadtoclaim/estimate/'.$name;
                    }
                    if($type=='ems')
                    {
                        $name=$download->ems;
						$path='/files/'.$name;
						$name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
                    //
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
							rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
                    if($type=='additional')
                    {
                        $name=$download->additional_files;
						 $path='/files/'.$name;
						$name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
                    //
                    if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
                    if($type=='images')
                    {
                        $name=$download->images;
						 $path='/files/'.$name;
						$name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
                    //
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path) )
						rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
					if($type=="join")
					{
						$criteria->compare('id',$id);
						$download = UploadJoinFiles::model()->find($criteria);
						$name=$download->file_name;
						$name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						 
						$path='/files/'.$name;
					}
                    if($type=='summary')
                    {
                        $path='/summary/'.$id.'summary-.pdf';
                    }
                    if($type=='appcmp')
                    {
                        $path='/invoice/appraisal-company/'.$id.'appraisal-company-invoice-.pdf';
                    }
                    if($type=='appraisal')
                    {
                        $path='/invoice/appraisal/'.$id.'appraisal-invoice-.pdf';
                    }
                    if($type=='bodyshop')
                    {
                        $path='/invoice/bodyshop/'.$id.'bodyshop-invoice-.pdf';
                    }
                    if($type=='callcenter')
                    {
                        $path='/invoice/callcenter/'.$id.'callcenter-invoice-.pdf';
                    }
                    if($type=='cfs')
                    {
                        $path='/invoice/cfs/'.$id.'cfs-invoice-.pdf';
                    }
                    $temp=array($path);
                    $files=  array_merge($temp,$files);
            }
			//var_dump($files);
             $t=date('His');
            $zipname =dirname(dirname(dirname(__FILE__))).'/files/file.zip';
            if(file_exists($zipname))
                unlink ($zipname);
				$result = $this->create_zip($files,$zipname);
				  
            
        }
		/* creates a compressed zip file */
function create_zip($files = array(),$destination = '',$overwrite = false) {
	//if the zip file already exists and overwrite is false, return false
	if(file_exists($destination) && !$overwrite) { return false; }
	//vars
	 
	$valid_files = array();
	//if files were passed in...
	if(is_array($files)) {
		//cycle through each file
		foreach($files as $file) {
			//make sure the file exists
			if(file_exists(dirname(dirname(dirname(__FILE__))).$file)) {
				$valid_files[] = dirname(dirname(dirname(__FILE__))).$file;
				//$temp=array($path);
                    //$valid_files=  array_merge($temp,$valid_files);
			}
		}
	}//die();
	//var_dump($valid_files);
	//if we have good files...
	if(count($valid_files)) {
		//create the archive
		$zip = new ZipArchive();
		if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
			return false;
		}
		//add the files
		foreach($valid_files as $file) {
			//$zip->addFile($file);
			$new_filename = substr($file,strrpos($file,'/') + 1);
			$zip->addFile($file,$new_filename);
		}
		//debug
		//echo 'The zip archive contains ',$zip->numFiles,' files with a status of ',$zip->status;
		
		//close the zip -- done!
		$zip->close();
		
		//check to make sure the file exists
		return file_exists($destination);
	}
	else
	{
		return false;
	}
}
	public function actionJoinpdf(){
		$strRequest = file_get_contents('php://input');
            $nf = json_decode($strRequest);//$_POST['data'];
            $files=array();
           // var_dump($nf);
            // die();
            $cu=new Claimuploads;
            foreach ($nf as $a)
            {    $arr=explode(",",$a);
                $id=$arr[0];
                $brr=explode("-",$arr[1]);
                $type=$brr[0];
           
                $criteria=new CDbCriteria;
                    
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    if($type=='estimate')
                    {
                        
                        $name=$download->estimate;
						$path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
							rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                      //  $path='/uploadtoclaim/estimate/'.$name;
                    }
                    if($type=='ems')
                    {
                        $name=$download->ems;
						 $path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
							rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
                    if($type=='additional')
                    {
                        $name=$download->additional_files;
						$path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
							rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
                    if($type=='images')
                    {
                        $name=$download->images;
						$path='/files/'.$name;
                        $name=str_replace("  "," ",$name);
						$name=str_replace(" ","_",$name);
						$newname=$id.$name;
						if(file_exists(dirname(dirname(dirname(__FILE__))).$path))
							rename(dirname(dirname(dirname(__FILE__))).$path,dirname(dirname(dirname(__FILE__))).'/files/'.$newname);
						$path='/files/'.$newname;
                    }
                    if($type=='summary')
                    {
                        $name=$id.'summary-.pdf';
                        $path='/summary/'.$id.'summary-.pdf';
                    }
                    if($type=='appcmp')
                    {
                        $name=$id.'appraisal-company-invoice-.pdf';
                        $path='/invoice/appraisal-company/'.$id.'appraisal-company-invoice-.pdf';
                    }
                    if($type=='appraisal')
                    {
                        $name=$id.'appraisal-invoice-.pdf';
                        $path='/invoice/appraisal/'.$id.'appraisal-invoice-.pdf';
                    }
                    if($type=='bodyshop')
                    {
                        $name=$id.'bodyshop-invoice-.pdf';
                        $path='/invoice/bodyshop/'.$id.'bodyshop-invoice-.pdf';
                    }
                    if($type=='callcenter')
                    {
                         $name=$id.'callcenter-invoice-.pdf';
                        $path='/invoice/callcenter/'.$id.'callcenter-invoice-.pdf';
                    }
                    if($type=='cfs')
                    {
                        $name=$id.'cfs-invoice-.pdf';
                        $path='/invoice/cfs/'.$id.'cfs-invoice-.pdf';
                    }
                    $file_type= $this->typefile($path);
                    //$joins="";
                   /* if($file_type=='image')
                    {
                        $joins.=$name.",";
                        $output=$this->renderPartial('image',array('image'=>$path),true);
                        if(file_exists(dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/'.$name.'.pdf'))
                    unlink (dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/'.$name.'.pdf');
              
                 $html2pdf = Yii::app()->ePdf->HTML2PDF();
                 $html2pdf = Yii::app()->ePdf->HTML2PDF('P', 'A2');
                    $html2pdf->WriteHTML($output);
                  //  $html2pdf->Output();
                    $html2pdf->Output(dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/im'.'.pdf', EYiiPdf::OUTPUT_TO_FILE);
                   $pathimg='/samplepdfs/image/im'.'.pdf';
                    $temp=array($pathimg);
                        $files=  array_merge($temp,$files);
                    }*/
                     
                    {if($file_type=='pdf' )//|| $file_type=="image"
                         $joins.=$name.",";
                        $temp=array($path);
                        $files=  array_merge($temp,$files);
                    }
                    $joins=substr($joins,0,-1);
            }
           // var_dump($files);
		   $this->zendpdf($files,$id);
          //  die();
			
			 
              
    }
    function count_pages($pdfname) {
   $pdftext = file_get_contents($pdfname);
   $num = preg_match_all("/\/Page\W/", $pdftext, $dummy);
  return $num;
}
 public static function  typefile($filename) {

        $mime_types = array(

            'txt' => 'text/plain',
            'htm' => 'text/html',
            'html' => 'text/html',
            'php' => 'text/html',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'json' => 'application/json',
            'xml' => 'application/xml',
            'swf' => 'application/x-shockwave-flash',
            'flv' => 'video/x-flv',

            // images
            'png' => 'image',//image/png',
            'jpe' => 'image',//jpeg',
            'jpeg' => 'image',//jpeg',
            'jpg' => 'image',//jpeg',
            'gif' => 'image',//gif',
            'bmp' => 'image',//bmp',
            'ico' => 'image',//vnd.microsoft.icon',
            'tiff' => 'image',//tiff',
            'tif' => 'image',//tiff',
            'svg' => 'image',//svg+xml',
            'svgz' => 'image',//svg+xml',

            // archives
            'zip' => 'application/zip',
            'rar' => 'application/x-rar-compressed',
            'exe' => 'application/x-msdownload',
            'msi' => 'application/x-msdownload',
            'cab' => 'application/vnd.ms-cab-compressed',

            // audio/video
            'mp3' => 'audio/mpeg',
            'qt' => 'video/quicktime',
            'mov' => 'video/quicktime',

            // adobe
            'pdf' => 'pdf',//application/pdf',
            'psd' => 'vnd.adobe.photoshop',//'image',,
            'ai' => 'application/postscript',
            'eps' => 'application/postscript',
            'ps' => 'application/postscript',

            // ms office
            'doc' => 'application/msword',
			 'docx' => 'application/msword',
            'rtf' => 'application/rtf',
            'xls' => 'application/vnd.ms-excel',
			'xlsx' => 'application/vnd.ms-excel',
            'ppt' => 'application/vnd.ms-powerpoint',

            // open office
            'odt' => 'application/vnd.oasis.opendocument.text',
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        );

       $ext=substr(strrchr($filename,'.'),1);//$ext = strtolower(array_pop(explode('.',$filename)));
    // die();
        if (array_key_exists($ext, $mime_types)) {
		//return $ext;
           return $mime_types[$ext];
        }
        elseif (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME);
            $mimetype = finfo_file($finfo, $filename);
            finfo_close($finfo);
            return $mimetype;
        }
        else {
            return 'application/octet-stream';
        }
    }
        /**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimuploads the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimuploads::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimuploads $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimuploads-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
