<?php

class ClaimuploadsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
                    'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
        function checkfile($filename)
        {echo Yii::app()->request->baseUrl.$filename;
            if(file_exists(Yii::app()->request->baseUrl.$filename))
                return true;
            else {
                return false;
            }
        }
        public function allowedActions() {
            return 'download,makezip,downloadzip,joinpdf,deletefile,zendpdf';
        }
		
		public function actionZendpdf(){
			ini_set('display_errors','1'); 			
			require_once('Zend/Pdf.php');
			// LOAD PDF DOCUMENTS
			$pdf1 = Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/one.pdf');
			$pdf2 =  Zend_Pdf::load(dirname(dirname(dirname(__FILE__))).'/samplepdfs/three.pdf');
			// WE WILL MERGE OUR TWO PDF FILES INTO A NEW ZEND_PDF OBJECT
			$pdfMerged = new Zend_Pdf();
			// ADD ALL PAGES FROM THE FIRST PDF TO OUR NEW DOCUMENT
			foreach($pdf1->pages as $page){
			  $clonedPage = clone $page;
			  $pdfMerged->pages[] = $clonedPage;
			}
			// ADD ALL PAGES FROM THE SECOND PDF TO OUR NEW DOCUMENT
			foreach($pdf2->pages as $page){
			  $clonedPage = clone $page;
			  $pdfMerged->pages[] = $clonedPage;
			}
			unset($clonedPage);

			// SEND THE MERGED PDF DOCUMENT TO BROWSER
			header('Content-type: application/pdf');
			echo $pdfMerged->render();

			//save to a file
			// $pdfMerged->save('out/3.pdf');
			Yii::app()->end();
		}

        /**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id=null)
	{
            $mode=new Claimuploads;//('search');
            $id=$_REQUEST['Claim_id'];
            $cu=new Claimuploads;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.estimate!='null'";
            $model=$cu->findAll($q);
           if($model==null)
               $model=array();
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.ems!='null'";
            $ems=$cu->findAll($q);
            
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.additional_files!='null'";
            $add=$cu->findAll($q);
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$id. " and t.images!='null'";
            $photo=$cu->findAll($q);
            
            $sum=new Summery;
            $c = new CDbCriteria;
            $c->compare('t.claim_id',$id);
            $sumarry = $sum->find($c);
            $smry=FALSE;
            if(file_exists(dirname(dirname(dirname(__FILE__))).'/summary/'.$_REQUEST['Claim_id'].'summary-.pdf'))
              $smry=true;
	//echo $_REQUEST['Claim_id'];
            $appcmp=FALSE;
            if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/appraisal-company/'.$_REQUEST['Claim_id'].'appraisal-company-invoice-.pdf'))
              $appcmp=true;
            $appraisal=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/appraisal/'.$_REQUEST['Claim_id'].'appraisal-invoice-.pdf'))
              $appraisal=true;
             $bodyshop=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/bodyshop/'.$_REQUEST['Claim_id'].'bodyshop-invoice-.pdf'))
              $bodyshop=true;
             $callcenter=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/callcenter/'.$_REQUEST['Claim_id'].'callcenter-invoice-.pdf'))
              $callcenter=true;
             $cfs=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/cfs/'.$_REQUEST['Claim_id'].'cfs-invoice-.pdf'))
              $cfs=true;
             $deskreviewer=FALSE;
             if(file_exists(dirname(dirname(dirname(__FILE__))).'/invoice/deskreviewer/'.$_REQUEST['Claim_id'].'deskreviewer-invoice-.pdf'))
              $deskreviewer=true;
		$this->render('view',array(
			'model'=>$model,
                        'mode'=>$mode,
                        'ems'=>$ems,
                        'add'=>$add,
                        'photo'=>$photo,
                        'sumarry'=>$sumarry,
                        'smry'=>$smry,
                        'appcmp'=>$appcmp,
                        'appraisal'=>$appraisal,
                        'bodyshop'=>$bodyshop,
                        'callcenter'=>$callcenter,
                        'cfs'=>$cfs,
                        'deskreviewer'=>$deskreviewer,
		));
	}
 
 
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
        public function actionInprocess()
        {
            $vh=new Vehicleowner;
            $q=new CDbCriteria;
            $q->compare('t.user_id',Yii::app()->user->id);
            $vo=$vh->find($q);
            $model=new Claimuploads;
            $photo=array();
            if($vo!=null)
            {
                $claim_id=$vo->claim_id;
                $model=new Claimuploads;
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.images!=""';
                $photo=$model->findAll($q);
               // var_dump($photo);
                
            }
            $this->render('photo',array(
			'model'=>$model,
                        'photo'=>$photo,
		));
        }
         public function actionRepairstatus()
        {
            $vh=new Vehicleowner;
            $q=new CDbCriteria;
            $q->compare('t.user_id',Yii::app()->user->id);
            $vo=$vh->find($q);
            $model=new Claimuploads;
            $photo=array();
            if($vo!=null)
            {
                $claim_id=$vo->claim_id;
                $model=new Claimuploads;
                $q=new CDbCriteria;
                $q->condition='t.claim_id='.$claim_id.' and t.images!=""';
                $photo=$model->findAll($q);
               // var_dump($photo);
                
            }
            $c=new Claim;
            $q=new CDbCriteria;
            $q->select='t.id,t.insurance_company,t.adjustor_id,t.other_adjuster';
            $q->compare('t.id',$claim_id);
            $claim=$c->find($q);
            $ass=new Assignee;
            $q=new CDbCriteria;
            $q->condition='t.claim_id='.$claim_id.' and active=1';
            $assn=$ass->find($q);
            $bodyshop=array();
            if($assn!=null)
            {
                /*if($assn->assign_to!=null)
                {
                    $usr=  User::model()->findByPk($assn->assign_to);
                    return $usr->first_name." ".$usr->last_name;
                }*/
                 if($assn->assign_to!=null)
                 {
                     $usr=User::model()->findByPk($ass->assign_to);
                     $type=  UserController::getTypeid($ass->assign_to);
                    // $br=  Branch::model()->findByPk($assn->branch_id);
                     if($type>=33 && $type<=44)
                      $bodyshop=$usr;
                 }
            }
            $this->render('repair_status',array(
			'model'=>$model,
                        'photo'=>$photo,
                        'bodyshop'=>$bodyshop,
                        'claim'=>$claim,
		));
        }
        public function actionCreate()
	{
		$model=new Claimuploads;
		$model=new Claimuploads;
		$mode=new Claimuploads;
		$c = new CDbCriteria;
		$c->compare('claim_id',$_REQUEST['Claim_id']);
		$df = $mode->find($c);
		$size=5*1024*1024;
		// Uncomment the following line if AJAX validation is needed
		/* $this->performAjaxValidation($model);
		Yii::log("actionCreate actionCreate "  
		isset($_POST['Claimuploads']));  */
		// var_dump($_POST);
		// var_dump($_FILES);				 
		$upp =  false;
		if(isset($_REQUEST['ajax'])){
			
		}
		if(isset($_POST['claimS'])){
			// var_dump($imageUploadFile);						
			/***						
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/estimate');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/images');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/ems');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/additional');
			**/
                        $formid  = Yii::app()->db->createCommand()
                                ->select('max(id) as max')
                                ->from('claimuploads')
                                ->queryScalar();
                         $formid=$formid+1;
                        $mode = new Claimuploads;
                        $mode->claim_id = $_POST['claimS'];
			if(isset($_FILES['files'])){
                               
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                            $name=  str_replace("  ", " ", $_FILES['files']['name']['0']);
                             $name=$formid."-". str_replace("-", " ", $name);
				$mode->estimate =$name;// $_FILES['files']['name']['0'];
                                $path=dirname(dirname(dirname(__FILE__))).'/uploadtoclaim/estimate/';
				move_uploaded_file($_FILES["files"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/estimate/'. $name);
				//rename($path.$_FILES['files']['name']['0'],$path.$name);
                                /*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['efiles'])){
                           
				 $name=  str_replace("  ", " ", $_FILES['efiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->ems = $name;//$_FILES['efiles']['name']['0'];
				move_uploaded_file($_FILES["efiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/ems/'. $name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['ifiles'])){
                            
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                                $name=  str_replace("  ", " ", $_FILES['ifiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->images = $name;//$_FILES['ifiles']['name']['0'];
				move_uploaded_file($_FILES["ifiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/images/'. $name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
			if(isset($_FILES['sfiles'])){
                             
				//$mode = new Claimuploads;
				//$mode->claim_id = $_POST['claimS'];
                                $name=  str_replace("  ", " ", $_FILES['sfiles']['name']['0']);
                                $name=$formid."-". str_replace("-", " ", $name);
				 
				$mode->additional_files = $name;//$_FILES['sfiles']['name']['0'];
				move_uploaded_file($_FILES["sfiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/additional/'.$name);
				/*if($mode->save()){
					$upp = $upp || true;
				};*/
			}
                        $mode->createdby=Yii::app()->user->id;
                        if($mode->save()){
					$upp = $upp || true;
				};
			if($upp){
				Yii::app()->user->setFlash('success','File Uploaded Successfully');                         
				//echo 'success';
				// $this->redirect(array('claimuploads/create'));
			}
		}
		$claimid=$_REQUEST['Claim_id'];
		$claim=new Claim;        
		$q=new CDbCriteria;
		$q->compare("t.id",$claimid);                       
		$claims=$claim->find($q);
		$this->render('create',array('model'=>$model,'claim'=>$claims,));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
          public function getUsername($id)
        {
            $model=  User::model()->findByPk($id);
            return $model->first_name." ".$model->last_name;
        }
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimuploads']))
		{
			$model->attributes=$_POST['Claimuploads'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimuploads');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimuploads('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimuploads']))
			$model->attributes=$_GET['Claimuploads'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
        public function actionDeletefile()
        {
            $type=$_REQUEST['type'];
                $id=$_REQUEST['id'];
                $claimid=$_REQUEST['Claim_id'];
                $criteria=new CDbCriteria;
                if($type=='estimate')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->estimate;
                    $path='/uploadtoclaim/estimate/'.$name;
                    $download->delete();
                }
                if($type=='ems')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->ems;
                    $path='/uploadtoclaim/ems/'.$name;
                    $download->delete();
                }
                if($type=='additional')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->additional_files;
                   $path='/uploadtoclaim/additional/'.$name;
                   $download->delete();
                }
		if($type=='images')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->images;
                    $path='/uploadtoclaim/images/'.$name;
                    $download->delete();
                }
                unlink(dirname(dirname(dirname(__FILE__))).$path);
        }

        public function actionDownload(){
                $type=$_REQUEST['type'];
                $id=$_REQUEST['id'];
                $claimid=$_REQUEST['Claim_id'];
                $criteria=new CDbCriteria;
                if($type=='estimate')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->estimate;
                    $path='/uploadtoclaim/estimate/'.$name;
                     
                }
                if($type=='ems')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->ems;
                    $path='/uploadtoclaim/ems/'.$name;
                }
                if($type=='additional')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->additional_files;
                   $path='/uploadtoclaim/additional/'.$name;
                }
		if($type=='images')
                {   
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    $name=$download->images;
                    $path='/uploadtoclaim/images/'.$name;
                }

		if($type=="summary")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/summary/'.$claimid.'summary-.pdf';
                }
                if($type=="appcmp")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/appraisal-company/'.$claimid.'appraisal-company-invoice-.pdf';
                }
                 if($type=="appraisal")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/appraisal/'.$claimid.'appraisal-invoice-.pdf';
                }
                 if($type=="bodyshop")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/bodyshop/'.$claimid.'bodyshop-invoice-.pdf';
                }
                 if($type=="callcenter")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/callcenter/'.$claimid.'callcenter-invoice-.pdf';
                }
                   if($type=="cfs")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/cfs/'.$claimid.'cfs-invoice-.pdf';
                }
                 if($type=="deskreviewer")
                {
                    /*$criteria->compare('t.claim_id',$claimid);
                    $download = Summery::model()->find($criteria);
                    $name=$download->images;*/
                    $path='/invoice/deskreviewer/'.$claimid.'deskreviewer-invoice-.pdf';
                }
                //echo "<br/>";
                $name = dirname(dirname(dirname(__FILE__))).$path;
                          $filecontent=file_get_contents($name);
                          header("Content-Type: text/plain");
                          header("Content-disposition: attachment; filename=$name");
                          header("Pragma: no-cache");
                          echo $filecontent;
                          exit;
			 

	}
        public function actionDownloadzip()
        {
                       /* $filecontent=file_get_contents($_POST['zip']);
                          header("Content-Type: text/plain");
                          header("Content-disposition: attachment; filename=$name");
                          header("Pragma: no-cache");
                          echo $filecontent;
                          exit;*/
                          $zipname=dirname(dirname(dirname(__FILE__))).'/uploadtoclaim/'.$_REQUEST['zip'];
                              header('Content-Type: application/zip');
            header('Content-disposition: attachment; filename='.$zipname);
            header('Content-Length: ' . filesize($zipname));
           readfile($_REQUEST['zip']);
        }

        public function actionMakezip()
        {$strRequest = file_get_contents('php://input');
            $nf = json_decode($strRequest);//$_POST['data'];
            $files=array();
           // var_dump($nf);
             
            
            foreach ($nf as $a)
            {    $arr=explode(",",$a);
                $id=$arr[0];
                $brr=explode("-",$arr[1]);
                $type=$brr[0];
           
                $criteria=new CDbCriteria;
                    
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    if($type=='estimate')
                    {
                        $name=$download->estimate;
                        $path='/uploadtoclaim/estimate/'.$name;
                    }
                    if($type=='ems')
                    {
                        $name=$download->ems;
                        $path='/uploadtoclaim/ems/'.$name;
                    }
                    if($type=='additional')
                    {
                        $name=$download->additional_files;
                        $path='/uploadtoclaim/additional/'.$name;
                    }
                    if($type=='images')
                    {
                        $name=$download->images;
                        $path='/uploadtoclaim/images/'.$name;
                    }
                    if($type=='summary')
                    {
                        $path='/summary/'.$id.'summary-.pdf';
                    }
                    if($type=='appcmp')
                    {
                        $path='/invoice/appraisal-company/'.$id.'appraisal-company-invoice-.pdf';
                    }
                    if($type=='appraisal')
                    {
                        $path='/invoice/appraisal/'.$id.'appraisal-invoice-.pdf';
                    }
                    if($type=='bodyshop')
                    {
                        $path='/invoice/bodyshop/'.$id.'bodyshop-invoice-.pdf';
                    }
                    if($type=='callcenter')
                    {
                        $path='/invoice/callcenter/'.$id.'callcenter-invoice-.pdf';
                    }
                    if($type=='cfs')
                    {
                        $path='/invoice/cfs/'.$id.'cfs-invoice-.pdf';
                    }
                    $temp=array($path);
                    $files=  array_merge($temp,$files);
            }
             $t=date('His');
            $zipname =dirname(dirname(dirname(__FILE__))).'/uploadtoclaim/file.zip';
            if(file_exists($zipname))
                unlink ($zipname);
            $zip = new ZipArchive;
            $res=$zip->open($zipname, ZipArchive::CREATE);
            $zip->addFile('/invoice/cfs/14cfs-invoice-.pdf','/invoice/appraisal/14appraisal-invoice-.pdf');
           // $result = create_zip($files,dirname(dirname(dirname(__FILE__))).'/uploadtoclaim/my-archive.zip');
            if ($res === TRUE) {
                foreach ($files as $file) {
             // $zip->addFromString($file);
                     
                    
              
            }
    
    //$zip->addFile('data.txt', 'entryname.txt');
    $zip->close();
    echo 'ok';
} else {
    echo 'failed';
}
            
            //$zip->close();
           //echo $zipname;
        }
	public function actionJoinpdf(){
		$strRequest = file_get_contents('php://input');
            $nf = json_decode($strRequest);//$_POST['data'];
            $files=array();
           // var_dump($nf);
            // die();
            $cu=new Claimuploads;
            foreach ($nf as $a)
            {    $arr=explode(",",$a);
                $id=$arr[0];
                $brr=explode("-",$arr[1]);
                $type=$brr[0];
           
                $criteria=new CDbCriteria;
                    
                    $criteria->compare('id',$id);
                    $download = Claimuploads::model()->find($criteria);
                    if($type=='estimate')
                    {
                        
                        $name=$download->estimate;
                        
                        $path='/uploadtoclaim/estimate/'.$name;
                    }
                    if($type=='ems')
                    {
                        $name=$download->ems;
                        $path='/uploadtoclaim/ems/'.$name;
                    }
                    if($type=='additional')
                    {
                        $name=$download->additional_files;
                        $path='/uploadtoclaim/additional/'.$name;
                    }
                    if($type=='images')
                    {
                        $name=$download->images;
                        $path='/uploadtoclaim/images/'.$name;
                    }
                    if($type=='summary')
                    {
                        $name=$id.'summary-.pdf';
                        $path='/summary/'.$id.'summary-.pdf';
                    }
                    if($type=='appcmp')
                    {
                        $name=$id.'appraisal-company-invoice-.pdf';
                        $path='/invoice/appraisal-company/'.$id.'appraisal-company-invoice-.pdf';
                    }
                    if($type=='appraisal')
                    {
                        $name=$id.'appraisal-invoice-.pdf';
                        $path='/invoice/appraisal/'.$id.'appraisal-invoice-.pdf';
                    }
                    if($type=='bodyshop')
                    {
                        $name=$id.'bodyshop-invoice-.pdf';
                        $path='/invoice/bodyshop/'.$id.'bodyshop-invoice-.pdf';
                    }
                    if($type=='callcenter')
                    {
                         $name=$id.'callcenter-invoice-.pdf';
                        $path='/invoice/callcenter/'.$id.'callcenter-invoice-.pdf';
                    }
                    if($type=='cfs')
                    {
                        $name=$id.'cfs-invoice-.pdf';
                        $path='/invoice/cfs/'.$id.'cfs-invoice-.pdf';
                    }
                    $file_type= $this->typefile($path);
                    //$joins="";
                    if($file_type=='image')
                    {
                        $joins.=$name.",";
                        $output=$this->renderPartial('image',array('image'=>$path),true);
                        if(file_exists(dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/'.$name.'.pdf'))
                    unlink (dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/'.$name.'.pdf');
              
                 $html2pdf = Yii::app()->ePdf->HTML2PDF();
                 $html2pdf = Yii::app()->ePdf->HTML2PDF('P', 'A2');
                    $html2pdf->WriteHTML($output);
                  //  $html2pdf->Output();
                    $html2pdf->Output(dirname(dirname(dirname(__FILE__))).'/samplepdfs/image/'.$name.'.pdf', EYiiPdf::OUTPUT_TO_FILE);
                   $pathimg='/samplepdfs/image/'.$name.'.pdf';
                    $temp=array($pathimg);
                        $files=  array_merge($temp,$files);
                    }
                     
                    {if($file_type=='pdf' )
                         $joins.=$name.",";
                        $temp=array($path);
                        $files=  array_merge($temp,$files);
                    }
                    $joins=substr($joins,0,-1);
            }
           // var_dump($files);
          //  die();
			$fg = implode(':',$files);
			$fg = urlencode($fg);
			$ff = urlencode(dirname(dirname(dirname(__FILE__))));
			// $homepage = file_get_contents('http://claimsflowsolutions.us/PDFMerger/sample.php?fs='.$fg);
			
			// echo 
			$service_url = 'http://claimsflowsolutions.us/PDFMerger/sample.php?fs='.$fg.'&f='.$ff;
			$curl = curl_init($service_url);
			curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			curl_setopt($curl, CURLOPT_USERPWD, "cfsdev:8B}N[c&IyVG@"); //Your credentials goes here
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			//curl_setopt($curl, CURLOPT_POST, true);
			//curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_post_data);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); //IMP if the url has https and you don't want to verify source certificate

			$curl_response = curl_exec($curl);
			$response = ($curl_response);
			curl_close($curl);
                       
			echo  json_encode( $response);	
			//echo $joins.=",".$n;	 
			//die();
			// echo $homepage;
			
			//not to call`
			/*
    spl_autoload_unregister(array('YiiBase','autoload'));
	spl_autoload_register(array('YiiBase','autoload')); 
		include dirname(dirname(dirname(__FILE__))).'/PDFMerger/PDFMerger.php';
		$pdf = new PDFMerger;
                foreach ($files as $pd)
                {
                    echo dirname(dirname(dirname(__FILE__))).$pd."<br/>";
                    //echo $n= $this->count_pages(dirname(dirname(dirname(__FILE__))).$pd);

                    $pdf->addPDF(dirname(dirname(dirname(__FILE__))).$pd,'1');
                }
               if(file_exists(dirname(dirname(dirname(__FILE__))).'/PDFMerger/samplepdfs/join2.pdf'))
                       unlink(dirname(dirname(dirname(__FILE__))).'/PDFMerger/samplepdfs/join2.pdf');
				
				$pdf->merge('file', dirname(dirname(dirname(__FILE__))).'/PDFMerger/samplepdfs/'.time().'.pdf');
                echo dirname(dirname(dirname(__FILE__))).'/PDFMerger/samplepdfs/'.time().'.pdf';
				spl_autoload_register(array('YiiBase','autoload')); */
              
    }
    function count_pages($pdfname) {
   $pdftext = file_get_contents($pdfname);
   $num = preg_match_all("/\/Page\W/", $pdftext, $dummy);
  return $num;
}
 public static function  typefile($filename) {

        $mime_types = array(

            'txt' => 'text/plain',
            'htm' => 'text/html',
            'html' => 'text/html',
            'php' => 'text/html',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'json' => 'application/json',
            'xml' => 'application/xml',
            'swf' => 'application/x-shockwave-flash',
            'flv' => 'video/x-flv',

            // images
            'png' => 'image',//image/png',
            'jpe' => 'image',//jpeg',
            'jpeg' => 'image',//jpeg',
            'jpg' => 'image',//jpeg',
            'gif' => 'image',//gif',
            'bmp' => 'image',//bmp',
            'ico' => 'image',//vnd.microsoft.icon',
            'tiff' => 'image',//tiff',
            'tif' => 'image',//tiff',
            'svg' => 'image',//svg+xml',
            'svgz' => 'image',//svg+xml',

            // archives
            'zip' => 'application/zip',
            'rar' => 'application/x-rar-compressed',
            'exe' => 'application/x-msdownload',
            'msi' => 'application/x-msdownload',
            'cab' => 'application/vnd.ms-cab-compressed',

            // audio/video
            'mp3' => 'audio/mpeg',
            'qt' => 'video/quicktime',
            'mov' => 'video/quicktime',

            // adobe
            'pdf' => 'pdf',//application/pdf',
            'psd' => 'vnd.adobe.photoshop',//'image',,
            'ai' => 'application/postscript',
            'eps' => 'application/postscript',
            'ps' => 'application/postscript',

            // ms office
            'doc' => 'application/msword',
			 'docx' => 'application/msword',
            'rtf' => 'application/rtf',
            'xls' => 'application/vnd.ms-excel',
			'xlsx' => 'application/vnd.ms-excel',
            'ppt' => 'application/vnd.ms-powerpoint',

            // open office
            'odt' => 'application/vnd.oasis.opendocument.text',
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        );

       $ext=substr(strrchr($filename,'.'),1);//$ext = strtolower(array_pop(explode('.',$filename)));
    // die();
        if (array_key_exists($ext, $mime_types)) {
		//return $ext;
           return $mime_types[$ext];
        }
        elseif (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME);
            $mimetype = finfo_file($finfo, $filename);
            finfo_close($finfo);
            return $mimetype;
        }
        else {
            return 'application/octet-stream';
        }
    }
        /**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimuploads the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimuploads::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimuploads $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimuploads-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
